/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.backups;

import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.backups.AutoOneOf_BackupSchedule_Frequency;
import com.google.cloud.datastore.core.rep.backups.AutoValue_BackupSchedule;
import com.google.cloud.datastore.core.rep.backups.AutoValue_BackupSchedule_Frequency_Daily;
import com.google.cloud.datastore.core.rep.backups.AutoValue_BackupSchedule_Frequency_Monthly;
import com.google.cloud.datastore.core.rep.backups.AutoValue_BackupSchedule_Frequency_Weekly;
import com.google.cloud.datastore.core.rep.backups.BackupScheduleRef;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;

@Immutable
@AutoValue
public abstract class BackupSchedule {
    public abstract BackupScheduleRef ref();

    public abstract String description();

    public abstract Instant createTime();

    public abstract Duration duration();

    public abstract Frequency frequency();

    public static Builder builder() {
        return new AutoValue_BackupSchedule.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder ref(BackupScheduleRef var1);

        public abstract Builder description(String var1);

        public abstract Builder createTime(Instant var1);

        public abstract Builder duration(Duration var1);

        public abstract Builder frequency(Frequency var1);

        public abstract BackupSchedule build();
    }

    @Immutable
    @AutoOneOf(value=Type.class)
    public static abstract class Frequency {
        public abstract Type typeOf();

        public abstract Daily daily();

        public abstract Weekly weekly();

        public abstract Monthly monthly();

        public static Frequency ofDaily(LocalTime utcTime) {
            return AutoOneOf_BackupSchedule_Frequency.daily(Daily.create(utcTime));
        }

        public static Frequency ofWeekly(DayOfWeek dayOfWeek, LocalTime utcTime) {
            return AutoOneOf_BackupSchedule_Frequency.weekly(Weekly.create(dayOfWeek, utcTime));
        }

        public static Frequency ofMonthly(int day, LocalTime utcTime) {
            return AutoOneOf_BackupSchedule_Frequency.monthly(Monthly.create(day, utcTime));
        }

        public static enum Type {
            DAILY,
            WEEKLY,
            MONTHLY;

        }

        @Immutable
        @AutoValue
        public static abstract class Monthly {
            public abstract int day();

            public abstract LocalTime utcTime();

            static Monthly create(int day, LocalTime localTime) {
                return new AutoValue_BackupSchedule_Frequency_Monthly(day, localTime);
            }
        }

        @Immutable
        @AutoValue
        public static abstract class Weekly {
            public abstract DayOfWeek dayOfWeek();

            public abstract LocalTime utcTime();

            static Weekly create(DayOfWeek dayOfWeek, LocalTime localTime) {
                return new AutoValue_BackupSchedule_Frequency_Weekly(dayOfWeek, localTime);
            }
        }

        @Immutable
        @AutoValue
        public static abstract class Daily {
            public abstract LocalTime utcTime();

            static Daily create(LocalTime localTime) {
                return new AutoValue_BackupSchedule_Frequency_Daily(localTime);
            }
        }
    }
}

