/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.rep.$AutoValue_WriteResult;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.OriginalMutationInfo;
import com.google.cloud.datastore.core.rep.WriteStats;
import java.time.Instant;

@AutoValue
public abstract class WriteResult {
    public static final WriteResult EMPTY = WriteResult.builder().build();

    public abstract Instant commitTimestamp();

    public abstract ImmutableList<MutationResult> collapsedMutationResults();

    public abstract ImmutableList<OriginalMutationInfo> originalMutationInfos();

    @Memoized
    public ImmutableList<MutationResult> mutationResults() {
        if (this.originalMutationInfos().isEmpty()) {
            return this.collapsedMutationResults();
        }
        ImmutableList.Builder inOrder = ImmutableList.builder();
        for (OriginalMutationInfo originalMutationInfo : this.originalMutationInfos()) {
            inOrder.add((Object)((MutationResult)this.collapsedMutationResults().get(originalMutationInfo.collapsedMutationIndex())));
        }
        return inOrder.build();
    }

    public abstract WriteStats stats();

    public static Builder builder() {
        return new $AutoValue_WriteResult.Builder().commitTimestamp(Instant.EPOCH).stats(WriteStats.EMPTY).collapsedMutationResults((Iterable<MutationResult>)ImmutableList.of()).originalMutationInfos((ImmutableList<OriginalMutationInfo>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder commitTimestamp(Instant var1);

        public abstract Builder collapsedMutationResults(Iterable<MutationResult> var1);

        public abstract Builder originalMutationInfos(ImmutableList<OriginalMutationInfo> var1);

        public abstract Builder stats(WriteStats var1);

        public abstract WriteResult build();
    }
}

