/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_ShardQueryRequest;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Query;
import javax.annotation.Nullable;

@AutoValue
public abstract class ShardQueryRequest {
    public static ShardQueryRequest create(Query query, int maxShardCount, int currentRequestShardCount) {
        return ShardQueryRequest.builder().query(query).maxShardCount(maxShardCount).remainingShardCount(maxShardCount).currentRequestShardCount(currentRequestShardCount).build();
    }

    public abstract Query query();

    public abstract int maxShardCount();

    public abstract int remainingShardCount();

    public abstract int currentRequestShardCount();

    @Nullable
    public abstract Cursor resumeCursor();

    public static Builder builder() {
        return new AutoValue_ShardQueryRequest.Builder();
    }

    public abstract Builder toBuilder();

    public ShardQueryRequest withResumeState(int remainingCount, Cursor resumeCursor) {
        return this.toBuilder().remainingShardCount(remainingCount).resumeCursor(resumeCursor).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder query(Query var1);

        public abstract Builder maxShardCount(int var1);

        public abstract Builder remainingShardCount(int var1);

        public abstract Builder currentRequestShardCount(int var1);

        public abstract Builder resumeCursor(@Nullable Cursor var1);

        public abstract ShardQueryRequest build();
    }
}

