/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoOneOf_ExternalDatabaseRef_Project;
import com.google.cloud.datastore.core.rep.AutoValue_ExternalDatabaseRef;

@Immutable
@AutoValue
public abstract class ExternalDatabaseRef {
    public abstract Project project();

    public abstract String databaseId();

    public static ExternalDatabaseRef create(String projectId, String databaseId) {
        return new AutoValue_ExternalDatabaseRef(Project.ofId(projectId), databaseId);
    }

    public static ExternalDatabaseRef create(long projectNumber, String databaseId) {
        return new AutoValue_ExternalDatabaseRef(Project.ofNumber(projectNumber), databaseId);
    }

    @Immutable
    @AutoOneOf(value=Type.class)
    public static abstract class Project {
        public abstract Type type();

        public abstract String id();

        public abstract long number();

        public static Project ofId(String projectId) {
            return AutoOneOf_ExternalDatabaseRef_Project.id(projectId);
        }

        public static Project ofNumber(long projectNumber) {
            return AutoOneOf_ExternalDatabaseRef_Project.number(projectNumber);
        }

        public static enum Type {
            ID,
            NUMBER;

        }
    }
}

