/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.$AutoValue_DatabaseRef;
import com.google.cloud.datastore.core.rep.AutoValue_DatabaseRef_Directory;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Objects;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class DatabaseRef
implements ResourceRef {
    public static final String DEFAULT_DATABASE = "";
    public static final DatabaseRef EMPTY = DatabaseRef.builder().partitionId("").rawProjectId("").databaseId("").directory(Directory.USER).build();

    public static DatabaseRef createWithUnknownPartitionIdAndValidate(String projectId, String databaseId) throws DatastoreException {
        DatabaseRef result = DatabaseRef.createWithUnknownPartitionId(projectId, databaseId);
        if (!ProjectIds.isValidProjectId(result.projectId())) {
            throw DatastoreExceptionHelper.badRequest("Invalid project id %s", result.projectId());
        }
        if (!ProjectIds.isValidDatabaseId(result.databaseId())) {
            throw DatastoreExceptionHelper.badRequest("Invalid database id %s", result.databaseId());
        }
        return result;
    }

    public static Builder builder() {
        return new $AutoValue_DatabaseRef.Builder();
    }

    public static DatabaseRef createForProject(String partitionId, String projectId, String databaseId) {
        if (partitionId.isEmpty() && projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Preconditions.checkArgument((boolean)ProjectIds.isValidProjectId(projectId), (Object)"Not a project id");
        return DatabaseRef.builder().directory(Directory.USER).partitionId(partitionId).rawProjectId(projectId).databaseId(databaseId).build();
    }

    public static DatabaseRef createWithUnknownPartitionId(String projectId, String databaseId) {
        if (projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        return DatabaseRef.builder().rawProjectId(projectId).databaseId(databaseId).directory(Directory.USER).build();
    }

    public static DatabaseRef createForApp(String appId, String databaseId) {
        Directory directory;
        if (appId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        ProjectIds.ParsedAppId parsedAppId = ProjectIds.parseAppId(appId);
        if (parsedAppId.metadata() == null) {
            directory = Directory.USER;
        } else {
            Preconditions.checkArgument((parsedAppId.metadata() < Directory.NUM_METADATA_REPLICAS ? 1 : 0) != 0);
            directory = Directory.replicated(parsedAppId.metadata());
        }
        return DatabaseRef.builder().directory(directory).partitionId(parsedAppId.partitionId()).rawProjectId(parsedAppId.projectId()).databaseId(databaseId).build();
    }

    public static DatabaseRef createForDefaultDatabase(String appId) {
        return DatabaseRef.createForApp(appId, DEFAULT_DATABASE);
    }

    public abstract Directory directory();

    @Nullable
    protected abstract String autoPartitionId();

    public abstract String rawProjectId();

    public abstract String databaseId();

    public boolean equalsIgnoringDirectory(DatabaseRef other) {
        return Objects.equals(this.autoPartitionId(), other.autoPartitionId()) && this.rawProjectId().equals(other.rawProjectId()) && this.databaseId().equals(other.databaseId());
    }

    public String projectId() {
        if (this.isMetadata()) {
            String string = String.valueOf(this.directory().replicaId());
            String string2 = this.rawProjectId();
            return new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append("__metadata-").append(string).append("_").append(string2).append("__").toString();
        }
        return this.rawProjectId();
    }

    @Memoized
    public String appId() {
        return ProjectIds.projectIdToApp(this.partitionId(), this.projectId());
    }

    public String partitionId() {
        if (this.autoPartitionId() == null) {
            throw new Error("Unknown partitionId.");
        }
        return this.autoPartitionId();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public final String toString() {
        String string;
        String partitionId = this.autoPartitionId() == null ? "<unknown!>" : this.autoPartitionId();
        String appId = ProjectIds.projectIdToApp(partitionId, this.projectId());
        if (this.databaseId().isEmpty()) {
            string = appId;
        } else {
            String string2 = this.databaseId();
            string = new StringBuilder(1 + String.valueOf(appId).length() + String.valueOf(string2).length()).append(appId).append("#").append(string2).toString();
        }
        return string;
    }

    public abstract Builder toBuilder();

    public DatabaseRef withDirectory(Directory directory) {
        return this.toBuilder().directory(directory).build();
    }

    public DatabaseRef withUserDirectory() {
        if (this.isMetadata()) {
            return this.withDirectory(Directory.USER);
        }
        return this;
    }

    public DatabaseRef withAppPartition(String partitionId) {
        return this.toBuilder().partitionId(partitionId).build();
    }

    public DatabaseRef withoutAppPartition() {
        if (this.autoPartitionId() == null) {
            return this;
        }
        return this.toBuilder().partitionId(null).build();
    }

    public boolean hasAppPartition() {
        return this.autoPartitionId() != null && !this.autoPartitionId().isEmpty();
    }

    public OnestoreEntity.Reference toPathlessKey(String namespace) {
        Preconditions.checkArgument((!this.appId().isEmpty() ? 1 : 0) != 0, (Object)"Application name must be supplied");
        OnestoreEntity.Reference k = new OnestoreEntity.Reference();
        k.setApp(this.appId());
        if (!this.databaseId().isEmpty()) {
            k.setDatabaseId(this.databaseId());
        }
        if (namespace != null && !namespace.isEmpty()) {
            k.setNameSpace(namespace);
        }
        return k;
    }

    public boolean isMetadata() {
        return this.directory().isMetadata();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder directory(Directory var1);

        public Builder partitionId(@Nullable String partitionId) {
            return this.autoPartitionId(partitionId);
        }

        protected abstract Builder autoPartitionId(@Nullable String var1);

        public abstract Builder rawProjectId(String var1);

        public abstract Builder databaseId(String var1);

        public abstract DatabaseRef build();
    }

    @Immutable
    @AutoValue
    public static abstract class Directory {
        public static final ImmutableList<Directory> METADATA_REPLICAS = ImmutableList.of((Object)Directory.replicated(0), (Object)Directory.replicated(1), (Object)Directory.replicated(2));
        public static final int NUM_METADATA_REPLICAS = METADATA_REPLICAS.size();
        public static final Directory USER = new AutoValue_DatabaseRef_Directory(false, null);
        public static final Directory ALL_REPLICAS = new AutoValue_DatabaseRef_Directory(true, null);

        public abstract boolean isMetadata();

        @Nullable
        public abstract Integer replicaId();

        public static Directory replicated(int replica) {
            return new AutoValue_DatabaseRef_Directory(true, replica);
        }
    }
}

