/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.time.Instant;
import javax.annotation.Nullable;

final class AutoValue_ReadResult
extends ReadResult {
    private final EntityRef entityRef;
    private final OnestoreEntity.EntityProto sideChannelEntityProto;
    private final Entity repEntity;
    private final ReadResult.MissingEntityReason missingEntityReason;
    private final long createVersion;
    private final long updateVersion;
    private final Instant readTime;
    private final Cursor cursor;

    private AutoValue_ReadResult(@Nullable EntityRef entityRef, @Nullable OnestoreEntity.EntityProto sideChannelEntityProto, @Nullable Entity repEntity, @Nullable ReadResult.MissingEntityReason missingEntityReason, long createVersion, long updateVersion, @Nullable Instant readTime, @Nullable Cursor cursor) {
        this.entityRef = entityRef;
        this.sideChannelEntityProto = sideChannelEntityProto;
        this.repEntity = repEntity;
        this.missingEntityReason = missingEntityReason;
        this.createVersion = createVersion;
        this.updateVersion = updateVersion;
        this.readTime = readTime;
        this.cursor = cursor;
    }

    @Override
    @Nullable
    public EntityRef entityRef() {
        return this.entityRef;
    }

    @Override
    @Nullable
    public OnestoreEntity.EntityProto sideChannelEntityProto() {
        return this.sideChannelEntityProto;
    }

    @Override
    @Nullable
    public Entity repEntity() {
        return this.repEntity;
    }

    @Override
    @Nullable
    public ReadResult.MissingEntityReason missingEntityReason() {
        return this.missingEntityReason;
    }

    @Override
    public long createVersion() {
        return this.createVersion;
    }

    @Override
    public long updateVersion() {
        return this.updateVersion;
    }

    @Override
    @Nullable
    public Instant readTime() {
        return this.readTime;
    }

    @Override
    @Nullable
    public Cursor cursor() {
        return this.cursor;
    }

    public String toString() {
        String string = String.valueOf(this.entityRef);
        String string2 = String.valueOf(this.sideChannelEntityProto);
        String string3 = String.valueOf(this.repEntity);
        String string4 = String.valueOf((Object)this.missingEntityReason);
        long l = this.createVersion;
        long l2 = this.updateVersion;
        String string5 = String.valueOf(this.readTime);
        String string6 = String.valueOf(this.cursor);
        return new StringBuilder(173 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("ReadResult{entityRef=").append(string).append(", sideChannelEntityProto=").append(string2).append(", repEntity=").append(string3).append(", missingEntityReason=").append(string4).append(", createVersion=").append(l).append(", updateVersion=").append(l2).append(", readTime=").append(string5).append(", cursor=").append(string6).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReadResult) {
            ReadResult that = (ReadResult)o;
            return (this.entityRef == null ? that.entityRef() == null : this.entityRef.equals(that.entityRef())) && (this.sideChannelEntityProto == null ? that.sideChannelEntityProto() == null : this.sideChannelEntityProto.equals(that.sideChannelEntityProto())) && (this.repEntity == null ? that.repEntity() == null : this.repEntity.equals(that.repEntity())) && (this.missingEntityReason == null ? that.missingEntityReason() == null : this.missingEntityReason.equals((Object)that.missingEntityReason())) && this.createVersion == that.createVersion() && this.updateVersion == that.updateVersion() && (this.readTime == null ? that.readTime() == null : this.readTime.equals(that.readTime())) && (this.cursor == null ? that.cursor() == null : this.cursor.equals(that.cursor()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.entityRef == null ? 0 : this.entityRef.hashCode();
        h$ *= 1000003;
        h$ ^= this.sideChannelEntityProto == null ? 0 : this.sideChannelEntityProto.hashCode();
        h$ *= 1000003;
        h$ ^= this.repEntity == null ? 0 : this.repEntity.hashCode();
        h$ *= 1000003;
        h$ ^= this.missingEntityReason == null ? 0 : this.missingEntityReason.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.createVersion >>> 32 ^ this.createVersion);
        h$ *= 1000003;
        h$ ^= (int)(this.updateVersion >>> 32 ^ this.updateVersion);
        h$ *= 1000003;
        h$ ^= this.readTime == null ? 0 : this.readTime.hashCode();
        h$ *= 1000003;
        return h$ ^= this.cursor == null ? 0 : this.cursor.hashCode();
    }

    @Override
    ReadResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ReadResult.Builder {
        private EntityRef entityRef;
        private OnestoreEntity.EntityProto sideChannelEntityProto;
        private Entity repEntity;
        private ReadResult.MissingEntityReason missingEntityReason;
        private Long createVersion;
        private Long updateVersion;
        private Instant readTime;
        private Cursor cursor;

        Builder() {
        }

        private Builder(ReadResult source) {
            this.entityRef = source.entityRef();
            this.sideChannelEntityProto = source.sideChannelEntityProto();
            this.repEntity = source.repEntity();
            this.missingEntityReason = source.missingEntityReason();
            this.createVersion = source.createVersion();
            this.updateVersion = source.updateVersion();
            this.readTime = source.readTime();
            this.cursor = source.cursor();
        }

        @Override
        public ReadResult.Builder entityRef(@Nullable EntityRef entityRef) {
            this.entityRef = entityRef;
            return this;
        }

        @Override
        public ReadResult.Builder sideChannelEntityProto(@Nullable OnestoreEntity.EntityProto sideChannelEntityProto) {
            this.sideChannelEntityProto = sideChannelEntityProto;
            return this;
        }

        @Override
        public ReadResult.Builder repEntity(@Nullable Entity repEntity) {
            this.repEntity = repEntity;
            return this;
        }

        @Override
        public ReadResult.Builder missingEntityReason(@Nullable ReadResult.MissingEntityReason missingEntityReason) {
            this.missingEntityReason = missingEntityReason;
            return this;
        }

        @Override
        public ReadResult.Builder createVersion(long createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        @Override
        public ReadResult.Builder updateVersion(long updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        @Override
        public ReadResult.Builder readTime(@Nullable Instant readTime) {
            this.readTime = readTime;
            return this;
        }

        @Override
        public ReadResult.Builder cursor(@Nullable Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public ReadResult build() {
            String missing = "";
            if (this.createVersion == null) {
                missing = String.valueOf(missing).concat(" createVersion");
            }
            if (this.updateVersion == null) {
                missing = String.valueOf(missing).concat(" updateVersion");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_ReadResult(this.entityRef, this.sideChannelEntityProto, this.repEntity, this.missingEntityReason, this.createVersion, this.updateVersion, this.readTime, this.cursor);
        }
    }
}

