/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.config.DatastoreCustomizableConfigUtils;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.SuppressedValidationFailures;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.logs.ProblemCode;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class AppEngV3ResourceRefToRepConverter {
    private static final AppEngV3ResourceRefToRepConverter LIBERAL_CONFIG_INSTANCE = AppEngV3ResourceRefToRepConverter.createLiberalConfigInstance();
    private final Config.DatastoreConfig config;

    private static AppEngV3ResourceRefToRepConverter createLiberalConfigInstance() {
        Config.DatastoreConfig config = Config.DatastoreConfig.newBuilder().setCustomizableConfig(DatastoreCustomizableConfigPb.DatastoreCustomizableConfig.newBuilder().setEnableAppEngV3ValidateKeyNameUtf8(false)).build();
        return new AppEngV3ResourceRefToRepConverter(config);
    }

    public static EntityRef convertValidEntityRef(OnestoreEntity.Reference v3EntityRef, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        try {
            return LIBERAL_CONFIG_INSTANCE.convertEntityRef(v3EntityRef, true, suppressedFailures, configOverrides);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public AppEngV3ResourceRefToRepConverter(Config.DatastoreConfig config) {
        this.config = (Config.DatastoreConfig)Preconditions.checkNotNull((Object)config);
    }

    public EntityRef convertEntityRef(OnestoreEntity.Reference v3EntityRef, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        return this.convertEntityRef(v3EntityRef, false, suppressedFailures, configOverrides);
    }

    public EntityRef convertEntityRef(OnestoreEntity.Reference v3EntityRef, boolean allowEmptyPath, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        if (v3EntityRef.hasNameSpace()) {
            InvalidConversionException.checkConversion(!v3EntityRef.getNameSpace().isEmpty(), "The namespace is the empty string.");
        }
        PartitionRef partitionRef = this.convertPartition("OnestoreEntity.Reference", v3EntityRef.getAppAsBytes(), v3EntityRef.getDatabaseIdAsBytes(), v3EntityRef.getNameSpaceAsBytes());
        List v3PathElements = v3EntityRef.getPath().elements();
        InvalidConversionException.checkConversion(!v3PathElements.isEmpty() || allowEmptyPath, ProblemCode.EMPTY_KEY_PATH, "A OnestoreEntity.Path must have at least one Element.", new Object[0]);
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        EntityRef.PathElement previousPathElement = null;
        for (OnestoreEntity.Path.Element v3PathElement : v3PathElements) {
            if (previousPathElement != null) {
                InvalidConversionException.checkConversion(previousPathElement.resourceId() != null, "A OnestoreEntity.Path.Element must set either id or name unless it is the last element (in certain contexts).");
            }
            byte[] collectionIdAsBytes = v3PathElement.getTypeAsBytes();
            InvalidConversionException.checkConversionIf(Utf8.isWellFormed((byte[])collectionIdAsBytes), ProblemCode.KIND_NOT_UTF8, DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateKindUtf8(), suppressedFailures, "OnestoreEntity.Path.Element.kind is not valid UTF-8.", new Object[0]);
            String collectionId = ConverterHelper.convertBytesToString("OnestoreEntity.Path.Element.kind", collectionIdAsBytes);
            EntityRef.ResourceId resourceId = this.convertResourceId("OnestoreEntity.Path.Element", v3PathElement.hasName(), v3PathElement.getNameAsBytes(), v3PathElement.hasId(), v3PathElement.getId(), suppressedFailures, configOverrides);
            previousPathElement = EntityRef.PathElement.create(collectionId, resourceId);
            pathBuilder.add((Object)previousPathElement);
        }
        return EntityRef.create(partitionRef, (List<EntityRef.PathElement>)pathBuilder.build());
    }

    public EntityRef convertEntityRefForValue(OnestoreEntity.PropertyValue.ReferenceValue v3EntityRef, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        if (v3EntityRef.hasNameSpace()) {
            InvalidConversionException.checkConversion(!v3EntityRef.getNameSpace().isEmpty(), "The namespace is the empty string.");
        }
        PartitionRef partitionRef = this.convertPartition("OnestoreEntity.PropertyValue.ReferenceValue", v3EntityRef.getAppAsBytes(), v3EntityRef.getDatabaseIdAsBytes(), v3EntityRef.getNameSpaceAsBytes());
        List v3PathElements = v3EntityRef.pathElements();
        InvalidConversionException.checkConversion(!v3PathElements.isEmpty(), "A OnestoreEntity.PropertyValue.ReferenceValue must have at least one PathElement.");
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        EntityRef.PathElement previousPathElement = null;
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement v3PathElement : v3PathElements) {
            if (previousPathElement != null) {
                InvalidConversionException.checkConversion(previousPathElement.resourceId() != null, "A OnestoreEntity.PropertyValue.ReferenceValue.PathElement must set either id or name unless it is the last element.");
            }
            byte[] collectionIdAsBytes = v3PathElement.getTypeAsBytes();
            InvalidConversionException.checkConversionIf(Utf8.isWellFormed((byte[])collectionIdAsBytes), ProblemCode.KIND_NOT_UTF8, DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateKindUtf8(), suppressedFailures, "OnestoreEntity.PropertyValue.ReferenceValue.PathElement.kind is not valid UTF-8.", new Object[0]);
            String collectionId = ConverterHelper.convertBytesToString("OnestoreEntity.PropertyValue.ReferenceValue.PathElement", collectionIdAsBytes);
            EntityRef.ResourceId resourceId = this.convertResourceId("OnestoreEntity.PropertyValue.ReferenceValuePathElement", v3PathElement.hasName(), v3PathElement.getNameAsBytes(), v3PathElement.hasId(), v3PathElement.getId(), suppressedFailures, configOverrides);
            previousPathElement = EntityRef.PathElement.create(collectionId, resourceId);
            pathBuilder.add((Object)previousPathElement);
        }
        return EntityRef.create(partitionRef, (List<EntityRef.PathElement>)pathBuilder.build());
    }

    private PartitionRef convertPartition(String v3MessageName, byte[] appIdBytes, byte[] databaseIdBytes, byte[] namespaceIdBytes) throws InvalidConversionException {
        String appId = ConverterHelper.convertUtf8(v3MessageName, ".appId", appIdBytes);
        String databaseId = ConverterHelper.convertUtf8(v3MessageName, ".databaseId", databaseIdBytes);
        String namespaceId = ConverterHelper.convertUtf8(v3MessageName, ".namespaceId", namespaceIdBytes);
        InvalidConversionException.checkConversion(!appId.isEmpty(), "A %s must set app.", v3MessageName);
        try {
            DatabaseRef databaseRef = DatabaseRef.createForApp(appId, databaseId);
            return PartitionRef.createFromDatabaseRefAndNamespace(databaseRef, namespaceId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConversionException(String.format("\"%s\" is an invalid app id", appId), e);
        }
    }

    @Nullable
    private EntityRef.ResourceId convertResourceId(String v3MessageName, boolean hasStringResourceId, byte[] stringResourceIdAsBytes, boolean hasIntResourceId, long intResourceId, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        if (hasStringResourceId) {
            InvalidConversionException.checkConversion(!hasIntResourceId, ProblemCode.PATH_WITH_BOTH_ID_AND_NAME_SET, "A %s must not set both id and name.", v3MessageName);
            InvalidConversionException.checkConversionIf(Utf8.isWellFormed((byte[])stringResourceIdAsBytes), ProblemCode.KEY_NAME_NOT_UTF8, DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateKeyNameUtf8(), suppressedFailures, "%s.name is not valid UTF-8.", v3MessageName);
            String stringResourceId = ConverterHelper.convertBytesToString(v3MessageName, stringResourceIdAsBytes);
            return EntityRef.ResourceId.ofString(stringResourceId);
        }
        if (hasIntResourceId) {
            if (intResourceId == 0L) {
                return null;
            }
            return EntityRef.ResourceId.ofNumber(intResourceId);
        }
        return null;
    }
}

