/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.InputStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@GwtCompatible
public class EncodedInts {
    public static long readVarint64(InputStream input) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = InputStreams.readByte(input);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed varint.");
    }

    public static void writeVarint64(OutputStream output, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((byte)value);
                return;
            }
            output.write((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public static long decodeUintWithLength(InputStream input, int bytesPerWord) throws IOException {
        long x = 0L;
        for (int i = 0; i < bytesPerWord; ++i) {
            x += ((long)InputStreams.readByte(input) & 0xFFL) << 8 * i;
        }
        return x;
    }

    public static void encodeUintWithLength(OutputStream output, long value, int bytesPerWord) throws IOException {
        while (--bytesPerWord >= 0) {
            output.write((byte)value);
            value >>>= 8;
        }
        assert (value == 0L);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }
}

