/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.geometry.ByteBuffers;
import com.google.appengine.repackaged.com.google.common.geometry.CodeableS2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedByteArrayVector;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedS2PointVector;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.List;

@GwtIncompatible(value="Uses ByteBuffer")
class S2ShapeCodingUtil {
    @VisibleForTesting
    static final ShapeCoder FAST_SHAPE_CODER = new ShapeCoder(){

        @Override
        public void encode(CodeableS2Shape shape, OutputStream output) throws IOException {
            switch (shape.typeTag()) {
                case POLYGON: {
                    ((S2Polygon.Shape)shape).polygon().encodeUncompressed(new LittleEndianOutput(output));
                    break;
                }
                case POLYLINE: {
                    ((S2Polyline)shape).encode(output);
                    break;
                }
                case POINT: {
                    ((S2Point.Shape)shape).encode(EncodedS2PointVector.CodingHint.FAST, output);
                    break;
                }
                default: {
                    String string = String.valueOf((Object)shape.typeTag());
                    throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unsupported S2Shape type: ").append(string).toString());
                }
            }
        }

        @Override
        public S2Shape decode(CodeableS2Shape.TypeTag typeTag, ByteBuffer buffer) throws IOException {
            switch (typeTag) {
                case POLYGON: {
                    return S2Polygon.decode(ByteBuffers.asInputStream(buffer)).shape();
                }
                case POLYLINE: {
                    return S2Polyline.decode(ByteBuffers.asInputStream(buffer));
                }
                case POINT: {
                    return S2Point.Shape.decode(buffer);
                }
            }
            String string = String.valueOf((Object)typeTag);
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unsupported S2Shape type: ").append(string).toString());
        }
    };

    S2ShapeCodingUtil() {
    }

    static void fastEncodeTaggedShapes(List<S2Shape> shapes, OutputStream output) throws IOException {
        S2ShapeCodingUtil.encodeTaggedShapes(shapes, FAST_SHAPE_CODER, output);
    }

    private static void encodeTaggedShapes(List<S2Shape> shapes, ShapeCoder shapeCoder, OutputStream output) throws IOException {
        EncodedByteArrayVector.Encoder shapeVector = new EncodedByteArrayVector.Encoder();
        for (S2Shape shape : shapes) {
            OutputStream os = shapeVector.addViaOutputStream();
            if (shape == null) continue;
            if (!(shape instanceof CodeableS2Shape)) {
                throw new IllegalArgumentException("All shapes to encode must implement CodeableS2Shape.");
            }
            CodeableS2Shape codeableShape = (CodeableS2Shape)shape;
            EncodedInts.writeVarint64(os, codeableShape.typeTag().value);
            shapeCoder.encode(codeableShape, os);
        }
        shapeVector.encode(output);
    }

    static TaggedShapeFactory fastDecodeTaggedShapeFactory(ByteBuffer buffer) throws IOException {
        return new TaggedShapeFactory(FAST_SHAPE_CODER, buffer);
    }

    static class TaggedShapeFactory
    extends AbstractList<S2Shape> {
        private final ShapeCoder shapeCoder;
        private final EncodedByteArrayVector encodedShapes;

        public TaggedShapeFactory(ShapeCoder shapeCoder, ByteBuffer buffer) throws IOException {
            this.shapeCoder = shapeCoder;
            this.encodedShapes = new EncodedByteArrayVector(buffer);
        }

        @Override
        public S2Shape get(int shapeId) {
            ByteBuffer buffer = this.encodedShapes.get(shapeId);
            if (!buffer.hasRemaining()) {
                return null;
            }
            try {
                int ordinal = Ints.checkedCast((long)EncodedInts.readVarint64(ByteBuffers.asInputStream(buffer)));
                return this.shapeCoder.decode(CodeableS2Shape.TypeTag.fromValue(ordinal), buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int size() {
            return this.encodedShapes.size();
        }
    }

    static interface ShapeCoder {
        public void encode(CodeableS2Shape var1, OutputStream var2) throws IOException;

        public S2Shape decode(CodeableS2Shape.TypeTag var1, ByteBuffer var2) throws IOException;
    }
}

