/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.geometry.ByteBuffers;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedUintVector;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.primitives.ImmutableLongArray;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractList;

@GwtIncompatible(value="Uses ByteBuffer")
class EncodedS2CellIdVector
extends AbstractList<S2CellId> {
    private final EncodedUintVector deltas;
    private final long base;
    private final int shift;

    public EncodedS2CellIdVector(ByteBuffer buffer) throws IOException {
        Preconditions.checkArgument((buffer.remaining() >= 2 ? 1 : 0) != 0);
        ByteBuffer tmpBuffer = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        int codePlusLen = tmpBuffer.get() & 0xFF;
        int shiftCode = codePlusLen >> 3;
        if (shiftCode == 31) {
            shiftCode = 29 + (tmpBuffer.get() & 0xFF);
        }
        int baseLen = codePlusLen & 7;
        long tmpBase = EncodedInts.decodeUintWithLength(ByteBuffers.asInputStream(tmpBuffer), baseLen);
        tmpBase <<= 64 - 8 * Math.max(1, baseLen);
        if (shiftCode >= 29) {
            this.shift = 2 * (shiftCode - 29) + 1;
            tmpBase |= 1L << this.shift - 1;
        } else {
            this.shift = 2 * shiftCode;
        }
        this.base = tmpBase;
        this.deltas = EncodedUintVector.createEncodedUint64Vector(tmpBuffer);
        buffer.position(tmpBuffer.position());
    }

    public static void encode(Iterable<S2CellId> v, OutputStream output) throws IOException {
        int vSize = Iterables.size(v);
        long vOr = 0L;
        long vAnd = -1L;
        long vMin = -1L;
        long vMax = 0L;
        for (S2CellId cellid : v) {
            vOr |= cellid.id();
            vAnd &= cellid.id();
            vMin = UnsignedLongs.min((long[])new long[]{vMin, cellid.id()});
            vMax = UnsignedLongs.max((long[])new long[]{vMax, cellid.id()});
        }
        long eBase = 0L;
        int eBaseLen = 0;
        int eShift = 0;
        int eMaxDeltaMsb = 0;
        if (UnsignedLongs.compare((long)vOr, (long)0L) > 0) {
            eShift = Math.min(56, Long.numberOfTrailingZeros(vOr) & 0xFFFFFFFE);
            if ((vAnd & 1L << eShift) != 0L) {
                ++eShift;
            }
            long eBytes = -1L;
            for (int len = 0; len < 8; ++len) {
                long tBase = vMin & (-1L >>> 8 * len ^ 0xFFFFFFFFFFFFFFFFL);
                int tMaxDeltaMsb = Math.max(0, 63 - Long.numberOfLeadingZeros(vMax - tBase >>> eShift));
                long tBytes = (long)len + (long)(vSize * ((tMaxDeltaMsb >> 3) + 1));
                if (UnsignedLongs.compare((long)tBytes, (long)eBytes) >= 0) continue;
                eBase = tBase;
                eBaseLen = len;
                eMaxDeltaMsb = tMaxDeltaMsb;
                eBytes = tBytes;
            }
            if ((eShift & 1) != 0 && (eMaxDeltaMsb & 7) != 7) {
                --eShift;
            }
        }
        assert (eShift <= 56);
        int shiftCode = eShift >> 1;
        if ((eShift & 1) != 0) {
            shiftCode = Math.min(31, shiftCode + 29);
        }
        output.write((byte)(shiftCode << 3 | eBaseLen));
        if (shiftCode == 31) {
            output.write((byte)(eShift >> 1));
        }
        long baseBytes = eBase >>> 64 - 8 * Math.max(1, eBaseLen);
        EncodedInts.encodeUintWithLength(output, baseBytes, eBaseLen);
        ImmutableLongArray.Builder deltasBuilder = ImmutableLongArray.builder((int)vSize);
        for (S2CellId cellid : v) {
            deltasBuilder.add(cellid.id() - eBase >>> eShift);
        }
        EncodedUintVector.encodeUint64Vector(deltasBuilder.build(), output);
    }

    @Override
    public S2CellId get(int i) {
        return new S2CellId((this.deltas.get(i) << this.shift) + this.base);
    }

    public int lowerBound(S2CellId target) {
        if (UnsignedLongs.compare((long)target.id(), (long)this.base) <= 0) {
            return 0;
        }
        if (target.greaterOrEquals(S2CellId.end(30))) {
            return this.size();
        }
        return this.deltas.lowerBound(target.id() - this.base + (1L << this.shift) - 1L >>> this.shift);
    }

    @Override
    public int size() {
        return this.deltas.size();
    }
}

