/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.AutoValue_CloudDatastoreV1_RequestHeader;
import com.google.appengine.api.datastore.dev.DatastoreV3;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpression;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.CloudDatastoreV1ServiceValidator;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.EntityV3V1Converter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.QueryHelper;
import com.google.apphosting.datastore.shared.UserValueObfuscator;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class CloudDatastoreV1 {
    private static final Collection<OnestoreEntity.CompositeIndex> EMPTY_INDEX_COLLECTION = Collections.emptySet();
    private static final boolean NO_IN_MEMORY_OPERATIONS = false;
    private static final Long NO_VERSION = 0L;
    private static final Long MINIMUM_VERSION = 1L;
    private static final int CONCURRENT_MODIFICATION_CANONICAL_CODE = DatastoreHelper.getCanonicalCodeForAppError(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue()).getNumber();
    private static final long BLIND_WRITE_MAX_RETRIES = 25L;
    private static final long BLIND_WRITE_MIN_WAIT_MS = 10L;
    private static final long BLIND_WRITE_MAX_WAIT_MS = 1000L;
    static final EntityV4Converter ENTITY_V4_CONVERTER = new EntityV4Converter(false, UserValueObfuscator.IDENTITY);
    private static final Config.DatastoreConfig LOCAL_CONFIG = Config.DatastoreConfig.newBuilder().setAllowIncompleteKeyPathsInQueryFilters(true).setEnableIndexedEntityValues(true).addAllReservedKindsToAllow(LocalDatastoreService.RESERVED_KIND_WHITELIST).setAllowMutationBaseVersion(true).setAllowSingleUseTransaction(true).setAllowNewTransactionReadOptions(true).build();
    static final DatastoreServiceProtoConverter LOCAL_SERVICE_CONVERTER = new DatastoreServiceProtoConverter(new DatastoreProtoConverter(ENTITY_V4_CONVERTER, LOCAL_CONFIG)){

        @Override
        public DatastorePb.Transaction toV3Transaction(ByteString transactionBytes, String unusedAppId, String unusedDatabaseId) throws InvalidConversionException {
            try {
                return (DatastorePb.Transaction)DatastorePb.Transaction.parser().parseFrom(transactionBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toTransactionBytes(DatastorePb.Transaction transactionV3) {
            return transactionV3.toByteString();
        }

        @Override
        public DatastorePb.Cursor toV3Cursor(ByteString queryHandleV4) throws InvalidConversionException {
            try {
                return (DatastorePb.Cursor)DatastorePb.Cursor.parser().parseFrom(queryHandleV4);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toV4QueryHandle(DatastorePb.Cursor cursorV3) {
            return cursorV3.toByteString();
        }
    };
    private static final CloudDatastoreV1ServiceValidator LOCAL_VALIDATOR = new CloudDatastoreV1ServiceValidator(new CloudDatastoreV1Validator(new EntityV1Validator(LOCAL_CONFIG)));
    private final DatastoreV3 datastoreV3;

    public CloudDatastoreV1(DatastoreV3 datastoreV3) {
        this.datastoreV3 = new CanonicalCodeDatastoreV3(datastoreV3);
    }

    public AllocateIdsResponse allocateIds(RequestHeader header, AllocateIdsRequest req) {
        DatastorePb.AllocateIdsResponse respV3;
        AllocateIdsResponse.Builder respBuilder = AllocateIdsResponse.newBuilder();
        try {
            LOCAL_VALIDATOR.validateAllocateIdsRequest((AllocateIdsRequestOrBuilder)req);
            DatastorePb.AllocateIdsRequest reqV3 = new DatastorePb.AllocateIdsRequest();
            reqV3.setSize((long)req.getKeysCount());
            respV3 = this.datastoreV3.allocateIds(reqV3);
        }
        catch (ValidationException e) {
            throw CloudDatastoreV1.invalidArgument(e);
        }
        if (respV3.getEnd() - respV3.getStart() + 1L < (long)req.getKeysCount()) {
            throw CloudDatastoreV1.invalidArgument("could not allocate sufficent ids");
        }
        ProjectIdAppIdResolver resolver = CloudDatastoreV1.newResolver(header.appId(), req.getProjectId());
        long i = respV3.getStart();
        for (Key reqKey : req.getKeysList()) {
            Key.Builder respKey;
            try {
                respKey = EntityV3V1Converter.INSTANCE.toV1Key(resolver, EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)reqKey));
            }
            catch (InvalidConversionException e) {
                throw CloudDatastoreV1.internalError(e);
            }
            respKey.getPathBuilder(respKey.getPathCount() - 1).setId(LocalDatastoreService.toScatteredId(i++));
            respBuilder.addKeys(respKey);
        }
        return respBuilder.build();
    }

    public BeginTransactionResponse beginTransaction(RequestHeader header, BeginTransactionRequest req) {
        try {
            LOCAL_VALIDATOR.validateBeginTransactionRequest((BeginTransactionRequestOrBuilder)req);
        }
        catch (ValidationException e) {
            throw CloudDatastoreV1.invalidArgument(e);
        }
        ProjectIdAppIdResolver resolver = CloudDatastoreV1.newResolver(header.appId(), req.getProjectId());
        try {
            DatastorePb.BeginTransactionRequest reqV3 = new DatastorePb.BeginTransactionRequest().setApp(resolver.toAppId(req.getProjectId())).setAllowMultipleEg(true);
            DatastorePb.Transaction internalResp = this.datastoreV3.beginTransaction(reqV3);
            return LOCAL_SERVICE_CONVERTER.toV1BeginTransactionResponse(internalResp).build();
        }
        catch (InvalidConversionException e) {
            throw CloudDatastoreV1.internalError(e);
        }
    }

    private ByteString beginAdHocTransaction(RequestHeader header, String projectId, String databaseId) {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setProjectId(projectId).setDatabaseId(databaseId).build();
        return this.beginTransaction(header, request).getTransaction();
    }

    private void rollbackAdHocTransactionQuietly(RequestHeader header, ByteString txn, String projectId, String databaseId, Throwable cause) {
        RollbackRequest request = RollbackRequest.newBuilder().setProjectId(projectId).setDatabaseId(databaseId).setTransaction(txn).build();
        try {
            this.rollback(header, request);
        }
        catch (ApiProxy.ApplicationException e) {
            cause.addSuppressed(e);
        }
    }

    private LoadingCache<OnestoreEntity.Reference, Long> newExistenceCache(final DatastorePb.Transaction transactionV3) {
        Preconditions.checkNotNull((Object)transactionV3);
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<OnestoreEntity.Reference, Long>(){

            public Long load(OnestoreEntity.Reference key) throws Exception {
                DatastorePb.GetRequest req = new DatastorePb.GetRequest().setTransaction(transactionV3);
                req.addKey(key);
                DatastorePb.GetResponse res = CloudDatastoreV1.this.datastoreV3.get(req);
                DatastorePb.GetResponse.Entity responseEntity = res.getEntity(0);
                return responseEntity.hasEntity() ? responseEntity.getVersion() : NO_VERSION.longValue();
            }
        });
    }

    public CommitResponse commit(RequestHeader header, CommitRequest req) {
        CommitResponse.Builder builder;
        block7: {
            builder = CommitResponse.newBuilder();
            try {
                LOCAL_VALIDATOR.validateCommitRequest(false, (CommitRequestOrBuilder)req);
                if (req.getMode() == CommitRequest.Mode.NON_TRANSACTIONAL) {
                    this.commitNonTransactional(header, req, builder, 25L, 10L, 1000L);
                    break block7;
                }
                ByteString singleUseTxn = null;
                ByteString txn = req.getTransaction();
                if (req.getTransactionSelectorCase() == CommitRequest.TransactionSelectorCase.SINGLE_USE_TRANSACTION) {
                    txn = singleUseTxn = this.beginAdHocTransaction(header, req.getProjectId(), req.getDatabaseId());
                }
                try {
                    this.applyMutationList(header, req, txn, builder);
                }
                catch (RuntimeException e) {
                    if (singleUseTxn != null) {
                        this.rollbackAdHocTransactionQuietly(header, singleUseTxn, req.getProjectId(), req.getDatabaseId(), e);
                    }
                    throw e;
                }
            }
            catch (ValidationException e) {
                throw CloudDatastoreV1.invalidArgument(e);
            }
        }
        return builder.build();
    }

    private void commitNonTransactional(RequestHeader header, CommitRequest originalRequest, CommitResponse.Builder response, long maxRetries, long minWaitMs, long maxWaitMs) {
        block4: for (Mutation mutation : originalRequest.getMutationsList()) {
            long waitMs = minWaitMs;
            long retries = maxRetries;
            while (true) {
                ByteString txn = null;
                try {
                    txn = this.beginAdHocTransaction(header, originalRequest.getProjectId(), originalRequest.getDatabaseId());
                    CommitRequest commitRequest = CommitRequest.newBuilder((CommitRequest)originalRequest).setProjectId(originalRequest.getProjectId()).setDatabaseId(originalRequest.getDatabaseId()).setMode(CommitRequest.Mode.TRANSACTIONAL).clearMutations().addMutations(mutation).setTransaction(txn).build();
                    CommitResponse commitResponse = this.commit(header, commitRequest);
                    response.setIndexUpdates(response.getIndexUpdates() + commitResponse.getIndexUpdates());
                    response.addMutationResults(commitResponse.getMutationResults(0));
                    continue block4;
                }
                catch (ApiProxy.ApplicationException e) {
                    if (txn != null) {
                        this.rollbackAdHocTransactionQuietly(header, txn, originalRequest.getProjectId(), originalRequest.getDatabaseId(), e);
                    }
                    if (e.getApplicationError() == CONCURRENT_MODIFICATION_CANONICAL_CODE && retries-- > 0L) {
                        try {
                            Thread.sleep((long)(Math.random() * (double)waitMs));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        waitMs = Math.min(maxWaitMs, waitMs * 2L);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
    }

    public RollbackResponse rollback(RequestHeader header, RollbackRequest req) {
        ProjectIdAppIdResolver resolver = CloudDatastoreV1.newResolver(header.appId(), req.getProjectId());
        try {
            LOCAL_VALIDATOR.validateRollbackRequest((RollbackRequestOrBuilder)req);
            this.datastoreV3.rollback(LOCAL_SERVICE_CONVERTER.toV3Transaction((RollbackRequestOrBuilder)req, resolver.toAppId(req.getProjectId()), req.getDatabaseId()));
        }
        catch (ValidationException e) {
            throw CloudDatastoreV1.invalidArgument(e);
        }
        return RollbackResponse.getDefaultInstance();
    }

    public LookupResponse lookup(RequestHeader header, LookupRequest request) {
        ByteString newTxn = null;
        ProjectIdAppIdResolver resolver = CloudDatastoreV1.newResolver(header.appId(), request.getProjectId());
        try {
            DatastorePb.GetResponse internResp;
            try {
                LOCAL_VALIDATOR.validateLookupRequest((LookupRequestOrBuilder)request);
                if (request.getReadOptions().getConsistencyTypeCase() == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION) {
                    newTxn = this.beginAdHocTransaction(header, request.getProjectId(), request.getDatabaseId());
                }
                internResp = this.datastoreV3.get(LOCAL_SERVICE_CONVERTER.toV3GetRequest(resolver, (LookupRequestOrBuilder)request, newTxn, request.getProjectId(), request.getDatabaseId()));
            }
            catch (ValidationException e) {
                throw CloudDatastoreV1.invalidArgument(e);
            }
            try {
                return LOCAL_SERVICE_CONVERTER.toV1LookupResponse(resolver, internResp, newTxn).build();
            }
            catch (InvalidConversionException e) {
                throw CloudDatastoreV1.internalError(e);
            }
        }
        catch (RuntimeException e) {
            if (newTxn != null) {
                this.rollbackAdHocTransactionQuietly(header, newTxn, request.getProjectId(), request.getDatabaseId(), e);
            }
            throw e;
        }
    }

    private RunQueryRequest normalizeRunQueryRequest(RunQueryRequest request) throws ValidationException, InvalidConversionException {
        if (request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY) {
            LOCAL_VALIDATOR.getDatastoreV1Validator().validateGqlQuery((GqlQueryOrBuilder)request.getGqlQuery());
            request = RunQueryRequest.newBuilder((RunQueryRequest)request).setQuery(LOCAL_SERVICE_CONVERTER.getDatastoreProtoConverter().toV1Query((GqlQueryOrBuilder)request.getGqlQuery(), request.getPartitionId())).clearGqlQuery().build();
        }
        return request;
    }

    public RunQueryResponse runQuery(RequestHeader header, RunQueryRequest request) {
        ProjectIdAppIdResolver resolver = CloudDatastoreV1.newResolver(header.appId(), request.getProjectId());
        long snapshotVersion = 0L;
        ByteString txn = null;
        ByteString txnToCleanUpOnError = null;
        ByteString newTxn = null;
        try {
            DatastorePb.QueryResult internResp;
            RunQueryRequest normalizedRequest;
            try {
                normalizedRequest = this.normalizeRunQueryRequest(request);
                LOCAL_VALIDATOR.validateRunQueryRequest((RunQueryRequestOrBuilder)normalizedRequest);
                switch (normalizedRequest.getReadOptions().getConsistencyTypeCase()) {
                    case TRANSACTION: {
                        txn = normalizedRequest.getReadOptions().getTransaction();
                        break;
                    }
                    case NEW_TRANSACTION: {
                        txn = txnToCleanUpOnError = (newTxn = this.beginAdHocTransaction(header, request.getProjectId(), request.getDatabaseId()));
                        break;
                    }
                    default: {
                        boolean hasAncestor = QueryHelper.hasAncestorOrParent((QueryOrBuilder)normalizedRequest.getQuery());
                        KindExpression propertyPseudokind = KindExpression.newBuilder().setName("__property__").build();
                        if (normalizedRequest.getReadOptions().getReadConsistency() == ReadOptions.ReadConsistency.EVENTUAL || normalizedRequest.getQuery().getKindList().contains(propertyPseudokind) || !hasAncestor) break;
                        txn = txnToCleanUpOnError = this.beginAdHocTransaction(header, request.getProjectId(), request.getDatabaseId());
                        RunQueryRequest.Builder newRequestBuilder = normalizedRequest.toBuilder();
                        newRequestBuilder.getReadOptionsBuilder().setTransaction(txn);
                        normalizedRequest = newRequestBuilder.build();
                    }
                }
                internResp = this.datastoreV3.runQuery(LOCAL_SERVICE_CONVERTER.toV3Query(resolver, (RunQueryRequestOrBuilder)normalizedRequest, newTxn, false, EMPTY_INDEX_COLLECTION));
                if (txn != null) {
                    LookupRequest lookupReq = LookupRequest.newBuilder().setProjectId(request.getProjectId()).setDatabaseId(request.getDatabaseId()).setReadOptions(ReadOptions.newBuilder().setTransaction(txn)).addKeys(Key.newBuilder().setPartitionId(PartitionId.newBuilder().setProjectId(request.getProjectId()).setDatabaseId(request.getDatabaseId())).addPath(Key.PathElement.newBuilder().setKind("__none__").setId(1L))).build();
                    DatastorePb.GetResponse getResp = this.datastoreV3.get(LOCAL_SERVICE_CONVERTER.toV3GetRequest(resolver, (LookupRequestOrBuilder)lookupReq, null, resolver.toAppId(request.getProjectId()), request.getDatabaseId()));
                    snapshotVersion = getResp.getEntity(0).getVersion();
                }
            }
            catch (ValidationException e) {
                throw CloudDatastoreV1.invalidArgument(e);
            }
            try {
                RunQueryResponse.Builder responseBuilder = LOCAL_SERVICE_CONVERTER.toV1RunQueryResponse(resolver, internResp, request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY ? normalizedRequest.getQuery() : null, newTxn);
                responseBuilder.getBatchBuilder().setSnapshotVersion(snapshotVersion);
                return responseBuilder.build();
            }
            catch (InvalidConversionException e) {
                throw CloudDatastoreV1.internalError(e);
            }
        }
        catch (RuntimeException e) {
            if (txnToCleanUpOnError != null) {
                this.rollbackAdHocTransactionQuietly(header, txnToCleanUpOnError, request.getProjectId(), request.getDatabaseId(), e);
            }
            throw e;
        }
    }

    private static long getPersistedVersion(LoadingCache<OnestoreEntity.Reference, Long> existenceCache, OnestoreEntity.Reference key) {
        try {
            return (Long)existenceCache.get((Object)key);
        }
        catch (ExecutionException e) {
            throw CloudDatastoreV1.internalError(e);
        }
    }

    private static boolean exists(LoadingCache<OnestoreEntity.Reference, Long> existenceCache, OnestoreEntity.Reference key) {
        return CloudDatastoreV1.getPersistedVersion(existenceCache, key) != NO_VERSION;
    }

    private static boolean conflicts(long persistedVersion, long baseVersion) {
        if (persistedVersion != NO_VERSION && baseVersion > persistedVersion) {
            throw CloudDatastoreV1.invalidArgument("Invalid base version, it is greater than the stored version");
        }
        return persistedVersion != baseVersion;
    }

    private OnestoreEntity.Reference put(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn) {
        Preconditions.checkNotNull((Object)txn);
        DatastorePb.PutRequest req = new DatastorePb.PutRequest().setTransaction(txn);
        req.addEntity(entity);
        return this.datastoreV3.put(req).getKey(0);
    }

    private void delete(OnestoreEntity.Reference key, DatastorePb.Transaction txn) {
        Preconditions.checkNotNull((Object)txn);
        DatastorePb.DeleteRequest req = new DatastorePb.DeleteRequest();
        req.setTransaction(txn);
        req.addKey(key);
        this.datastoreV3.delete(req);
    }

    private void applyMutationList(RequestHeader header, CommitRequest request, ByteString v1Txn, CommitResponse.Builder response) throws InvalidConversionException, ValidationException {
        ProjectIdAppIdResolver resolver = CloudDatastoreV1.newResolver(header.appId(), request.getProjectId());
        DatastorePb.Transaction txn = LOCAL_SERVICE_CONVERTER.toV3Transaction(v1Txn, resolver.toAppId(request.getProjectId()), request.getDatabaseId());
        LinkedList<Key> mutationKeys = new LinkedList<Key>();
        HashSet<Key> seenKeys = new HashSet<Key>();
        HashSet<Key> allocatedKeys = new HashSet<Key>();
        HashMap<Key, Long> conflictingVersions = new HashMap<Key, Long>();
        LoadingCache<OnestoreEntity.Reference, Long> existenceCache = this.newExistenceCache(txn);
        for (Mutation mutation : request.getMutationsList()) {
            Long baseVersion;
            Long conflictingVersion;
            Key key = this.normalizeKey(resolver, CloudDatastoreV1.getMutationKey(mutation));
            if (Paths.hasIncompleteLastElement((KeyOrBuilder)key)) {
                key = this.applyIncompleteKeyMutation(resolver, mutation, txn);
                allocatedKeys.add(key);
            } else if (!conflictingVersions.containsKey(key) && (conflictingVersion = this.applyMutation(resolver, mutation, txn, existenceCache, baseVersion = mutation.getConflictDetectionStrategyCase() == Mutation.ConflictDetectionStrategyCase.BASE_VERSION && !seenKeys.contains(key) ? Long.valueOf(mutation.getBaseVersion()) : null)) != null) {
                conflictingVersions.put(key, conflictingVersion);
            }
            mutationKeys.add(key);
            seenKeys.add(key);
        }
        this.commitMutations(resolver, txn, mutationKeys, allocatedKeys, conflictingVersions, response);
    }

    private Key applyIncompleteKeyMutation(ProjectIdAppIdResolver resolver, Mutation mutation, DatastorePb.Transaction txn) throws InvalidConversionException {
        Preconditions.checkArgument((mutation.getOperationCase() == Mutation.OperationCase.INSERT || mutation.getOperationCase() == Mutation.OperationCase.UPSERT ? 1 : 0) != 0, (Object)"Invalid operation on an incomplete key.");
        OnestoreEntity.EntityProto entityV3 = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)(mutation.getOperationCase() == Mutation.OperationCase.INSERT ? mutation.getInsert() : mutation.getUpsert()));
        OnestoreEntity.Reference keyV3 = this.put(entityV3, txn);
        return EntityV3V1Converter.INSTANCE.toV1Key(resolver, keyV3).build();
    }

    private Long applyMutation(ProjectIdAppIdResolver resolver, Mutation mutation, DatastorePb.Transaction txn, LoadingCache<OnestoreEntity.Reference, Long> existenceCache, Long baseVersion) throws InvalidConversionException, ValidationException {
        long persistedVersion;
        OnestoreEntity.Reference keyV3 = EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)CloudDatastoreV1.getMutationKey(mutation));
        if (mutation.getOperationCase() == Mutation.OperationCase.INSERT) {
            if (baseVersion != null && !baseVersion.equals(NO_VERSION)) {
                throw CloudDatastoreV1.invalidArgument("Cannot insert an entity with a base version greater than zero");
            }
            if (CloudDatastoreV1.exists(existenceCache, keyV3)) {
                throw CloudDatastoreV1.invalidArgument("entity already exists");
            }
        } else if (mutation.getOperationCase() == Mutation.OperationCase.UPDATE) {
            if (baseVersion != null && baseVersion.equals(NO_VERSION)) {
                throw CloudDatastoreV1.invalidArgument("Cannot update an entity with a base version set to zero");
            }
            if (!CloudDatastoreV1.exists(existenceCache, keyV3)) {
                throw CloudDatastoreV1.invalidArgument("no entity to update");
            }
        }
        if (baseVersion != null && CloudDatastoreV1.conflicts(persistedVersion = CloudDatastoreV1.getPersistedVersion(existenceCache, keyV3), baseVersion)) {
            return persistedVersion;
        }
        if (mutation.getOperationCase() == Mutation.OperationCase.DELETE) {
            this.delete(keyV3, txn);
            existenceCache.put((Object)keyV3, (Object)NO_VERSION);
        } else {
            OnestoreEntity.EntityProto entityV3 = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)CloudDatastoreV1.getMutationEntity(mutation));
            this.put(entityV3, txn);
            existenceCache.put((Object)keyV3, (Object)MINIMUM_VERSION);
        }
        return null;
    }

    private void commitMutations(ProjectIdAppIdResolver resolver, DatastorePb.Transaction txn, Collection<Key> mutationKeys, Set<Key> allocatedKeys, Map<Key, Long> conflictingVersions, CommitResponse.Builder responseBuilder) throws InvalidConversionException {
        DatastorePb.CommitResponse commitResponse = this.datastoreV3.commit(txn);
        responseBuilder.setIndexUpdates(commitResponse.getCost().getIndexWrites());
        HashMap<Key, Long> nonConflictingVersions = new HashMap<Key, Long>();
        for (DatastorePb.CommitResponse.Version version : commitResponse.versions()) {
            Key key = EntityV3V1Converter.INSTANCE.toV1Key(resolver, version.getRootEntityKey()).build();
            nonConflictingVersions.put(key, version.getVersion());
        }
        for (Key mutatedKey : mutationKeys) {
            MutationResult.Builder mutationResult = responseBuilder.addMutationResultsBuilder();
            if (allocatedKeys.contains(mutatedKey)) {
                mutationResult.setKey(mutatedKey);
            }
            if (conflictingVersions.containsKey(mutatedKey)) {
                mutationResult.setConflictDetected(true);
                mutationResult.setVersion(conflictingVersions.get(mutatedKey).longValue());
                continue;
            }
            mutationResult.setVersion(((Long)nonConflictingVersions.get(mutatedKey)).longValue());
        }
    }

    private static Key getMutationKey(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return mutation.getInsert().getKey();
            }
            case UPSERT: {
                return mutation.getUpsert().getKey();
            }
            case UPDATE: {
                return mutation.getUpdate().getKey();
            }
            case DELETE: {
                return mutation.getDelete();
            }
        }
        String string = String.valueOf(mutation.getOperationCase());
        throw new ValidationException(new StringBuilder(28 + String.valueOf(string).length()).append("Unknown mutation operation: ").append(string).toString());
    }

    private static Entity getMutationEntity(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return mutation.getInsert();
            }
            case UPSERT: {
                return mutation.getUpsert();
            }
            case UPDATE: {
                return mutation.getUpdate();
            }
            case DELETE: {
                return null;
            }
        }
        String string = String.valueOf(mutation.getOperationCase());
        throw new ValidationException(new StringBuilder(28 + String.valueOf(string).length()).append("Unknown mutation operation: ").append(string).toString());
    }

    private Key normalizeKey(ProjectIdAppIdResolver resolver, Key key) throws InvalidConversionException {
        Key.Builder normalizedKey = Key.newBuilder((Key)key);
        OnestoreEntity.Reference keyV3 = EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)normalizedKey.build());
        return EntityV3V1Converter.INSTANCE.toV1Key(resolver, keyV3).build();
    }

    public static ProjectIdAppIdResolver newResolver(String requestAppId, final String requestProjectId) {
        final String cluster = DatastoreHelper.getCluster(requestAppId);
        return new ProjectIdAppIdResolver(){

            @Override
            public String toAppId(String projectId) throws InvalidConversionException {
                if (projectId.isEmpty()) {
                    projectId = requestProjectId;
                }
                return DatastoreHelper.projectIdToApp(cluster, projectId);
            }

            @Override
            public String toProjectId(String appId) {
                return DatastoreHelper.appToProjectId(appId);
            }
        };
    }

    private static ApiProxy.ApplicationException invalidArgument(Throwable cause) {
        return CloudDatastoreV1.invalidArgument(cause.getMessage());
    }

    private static ApiProxy.ApplicationException invalidArgument(String message) {
        return new CanonicalCodeException(Code.INVALID_ARGUMENT, message, DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue());
    }

    private static ApiProxy.ApplicationException internalError(Throwable cause) {
        return new CanonicalCodeException(Code.INTERNAL, cause.getMessage(), DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue());
    }

    static DatastorePb.Transaction toV3Transaction(ByteString transactionBytes) throws InvalidConversionException {
        return LOCAL_SERVICE_CONVERTER.toV3Transaction(transactionBytes, null, null);
    }

    static class CanonicalCodeException
    extends ApiProxy.ApplicationException {
        private final int originalApplicationError;

        public CanonicalCodeException(Code canonicalCode, String errorDetail, int datastoreV3Error) {
            super(canonicalCode.getNumber(), errorDetail);
            this.originalApplicationError = datastoreV3Error;
        }

        public static CanonicalCodeException fromApplicationException(ApiProxy.ApplicationException e) {
            if (e instanceof CanonicalCodeException) {
                return (CanonicalCodeException)e;
            }
            return new CanonicalCodeException(DatastoreHelper.getGoogleRpcCanonicalCodeForAppError(e.getApplicationError()), e.getErrorDetail(), e.getApplicationError());
        }

        public int getOriginalApplicationError() {
            return this.originalApplicationError;
        }
    }

    private static class CanonicalCodeDatastoreV3
    implements DatastoreV3 {
        private final DatastoreV3 delegate;

        public CanonicalCodeDatastoreV3(DatastoreV3 delegate) {
            this.delegate = delegate;
        }

        @Override
        public void addActions(TaskQueuePb.TaskQueueBulkAddRequest req) {
            try {
                this.delegate.addActions(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.AllocateIdsResponse allocateIds(DatastorePb.AllocateIdsRequest req) {
            try {
                return this.delegate.allocateIds(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.Transaction beginTransaction(DatastorePb.BeginTransactionRequest req) {
            try {
                return this.delegate.beginTransaction(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.CommitResponse commit(DatastorePb.Transaction req) {
            try {
                return this.delegate.commit(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public long createIndex(OnestoreEntity.CompositeIndex req) {
            try {
                return this.delegate.createIndex(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.DeleteResponse delete(DatastorePb.DeleteRequest req) {
            try {
                return this.delegate.delete(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public void deleteCursor(DatastorePb.Cursor req) {
            try {
                this.delegate.deleteCursor(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public void deleteIndex(OnestoreEntity.CompositeIndex req) {
            try {
                this.delegate.deleteIndex(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.GetResponse get(DatastorePb.GetRequest req) {
            try {
                return this.delegate.get(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.CompositeIndices getIndices(String appId) {
            try {
                return this.delegate.getIndices(appId);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.QueryResult next(DatastorePb.NextRequest req) {
            try {
                return this.delegate.next(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.PutResponse put(DatastorePb.PutRequest req) {
            try {
                return this.delegate.put(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public void rollback(DatastorePb.Transaction req) {
            try {
                this.delegate.rollback(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public DatastorePb.QueryResult runQuery(DatastorePb.Query req) {
            try {
                return this.delegate.runQuery(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }

        @Override
        public void updateIndex(OnestoreEntity.CompositeIndex req) {
            try {
                this.delegate.updateIndex(req);
            }
            catch (ApiProxy.ApplicationException e) {
                throw CanonicalCodeException.fromApplicationException(e);
            }
        }
    }

    public static abstract class RequestHeader {
        abstract String appId();

        public static RequestHeader create() {
            return RequestHeader.create("");
        }

        public static RequestHeader create(String appId) {
            return new AutoValue_CloudDatastoreV1_RequestHeader(appId);
        }
    }
}

