/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.nl;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Tokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.WordlistLoader;
import com.google.appengine.repackaged.org.apache.lucene.analysis.nl.DutchStemFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DutchAnalyzer
extends Analyzer {
    public static final String[] DUTCH_STOP_WORDS = new String[]{"de", "en", "van", "ik", "te", "dat", "die", "in", "een", "hij", "het", "niet", "zijn", "is", "was", "op", "aan", "met", "als", "voor", "had", "er", "maar", "om", "hem", "dan", "zou", "of", "wat", "mijn", "men", "dit", "zo", "door", "over", "ze", "zich", "bij", "ook", "tot", "je", "mij", "uit", "der", "daar", "haar", "naar", "heb", "hoe", "heeft", "hebben", "deze", "u", "want", "nog", "zal", "me", "zij", "nu", "ge", "geen", "omdat", "iets", "worden", "toch", "al", "waren", "veel", "meer", "doen", "toen", "moet", "ben", "zonder", "kan", "hun", "dus", "alles", "onder", "ja", "eens", "hier", "wie", "werd", "altijd", "doch", "wordt", "wezen", "kunnen", "ons", "zelf", "tegen", "na", "reeds", "wil", "kon", "niets", "uw", "iemand", "geweest", "andere"};
    private Set stoptable = new HashSet();
    private Set excltable = new HashSet();
    private Map stemdict = new HashMap();
    private final Version matchVersion;

    public DutchAnalyzer() {
        this(Version.LUCENE_23);
    }

    public DutchAnalyzer(Version matchVersion) {
        this.setOverridesTokenStreamMethod(DutchAnalyzer.class);
        this.stoptable = StopFilter.makeStopSet(DUTCH_STOP_WORDS);
        this.stemdict.put("fiets", "fiets");
        this.stemdict.put("bromfiets", "bromfiets");
        this.stemdict.put("ei", "eier");
        this.stemdict.put("kind", "kinder");
        this.matchVersion = matchVersion;
    }

    public DutchAnalyzer(String[] stopwords) {
        this(Version.LUCENE_23, stopwords);
    }

    public DutchAnalyzer(Version matchVersion, String[] stopwords) {
        this.setOverridesTokenStreamMethod(DutchAnalyzer.class);
        this.stoptable = StopFilter.makeStopSet(stopwords);
        this.matchVersion = matchVersion;
    }

    public DutchAnalyzer(HashSet stopwords) {
        this(Version.LUCENE_23, stopwords);
    }

    public DutchAnalyzer(Version matchVersion, HashSet stopwords) {
        this.setOverridesTokenStreamMethod(DutchAnalyzer.class);
        this.stoptable = stopwords;
        this.matchVersion = matchVersion;
    }

    public DutchAnalyzer(File stopwords) {
        this(Version.LUCENE_23, stopwords);
    }

    public DutchAnalyzer(Version matchVersion, File stopwords) {
        this.setOverridesTokenStreamMethod(DutchAnalyzer.class);
        try {
            this.stoptable = WordlistLoader.getWordSet(stopwords);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.matchVersion = matchVersion;
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.excltable = StopFilter.makeStopSet(exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(HashSet exclusionlist) {
        this.excltable = exclusionlist;
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(File exclusionlist) {
        try {
            this.excltable = WordlistLoader.getWordSet(exclusionlist);
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setStemDictionary(File stemdictFile) {
        try {
            this.stemdict = WordlistLoader.getStemDict(stemdictFile);
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter(result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), result, this.stoptable);
        result = new DutchStemFilter(result, this.excltable, this.stemdict);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter(streams.source);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault(this.matchVersion), streams.result, this.stoptable);
            streams.result = new DutchStemFilter(streams.result, this.excltable, this.stemdict);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

