/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient;

import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.ProtocolException;

public class StatusLine {
    private final String statusLine;
    private final String httpVersion;
    private final int statusCode;
    private final String reasonPhrase;

    public StatusLine(String string) throws HttpException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        try {
            while (Character.isWhitespace(string.charAt(n2))) {
                ++n2;
                ++n3;
            }
            if (!"HTTP".equals(string.substring(n2, n2 += 4))) {
                throw new HttpException("Status-Line '" + string + "' does not start with HTTP");
            }
            if ((n2 = string.indexOf(" ", n2)) <= 0) {
                throw new ProtocolException("Unable to parse HTTP-Version from the status line: '" + string + "'");
            }
            this.httpVersion = string.substring(n3, n2).toUpperCase();
            while (string.charAt(n2) == ' ') {
                ++n2;
            }
            int n4 = string.indexOf(" ", n2);
            if (n4 < 0) {
                n4 = n;
            }
            try {
                this.statusCode = Integer.parseInt(string.substring(n2, n4));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Unable to parse status code from status line: '" + string + "'");
            }
            n2 = n4 + 1;
            this.reasonPhrase = n2 < n ? string.substring(n2).trim() : "";
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new HttpException("Status-Line '" + string + "' is not valid");
        }
        this.statusLine = string;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getHttpVersion() {
        return this.httpVersion;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public final String toString() {
        return this.statusLine;
    }

    public static boolean startsWithHTTP(String string) {
        try {
            int n = 0;
            while (Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            return "HTTP".equals(string.substring(n, n + 4));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }
}

