/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.LuceneQueryTreeContext;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2RegionCoverer;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanClause;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.TermQuery;
import com.google.apphosting.api.search.DocumentPb;

class GeometricQuery
extends BooleanQuery {
    private final String fieldName;
    private final String luceneFieldName;
    private final S2LatLng point;
    private final LuceneQueryTreeContext.ComparisonOp op;
    private final double distance;

    static Query create(String fieldName, double latitude, double longitude, LuceneQueryTreeContext.ComparisonOp op, double distance) {
        switch (op) {
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                return new GeometricQuery(fieldName, latitude, longitude, op, distance);
            }
        }
        return LuceneUtils.getMatchNoneQuery();
    }

    private GeometricQuery(String fieldName, double latitude, double longitude, LuceneQueryTreeContext.ComparisonOp op, double distance) {
        this.fieldName = fieldName;
        this.luceneFieldName = LuceneUtils.makeLuceneFieldName(fieldName, DocumentPb.FieldValue.ContentType.GEO);
        this.point = S2LatLng.fromDegrees(latitude, longitude).normalized();
        this.op = op;
        this.distance = distance;
        this.init();
    }

    private void init() {
        S1Angle angle = S1Angle.radians(this.distance / 6371010.0);
        S2Cap cap = S2Cap.fromAxisAngle(this.point.toPoint(), angle);
        S2RegionCoverer coverer = new S2RegionCoverer();
        coverer.setMinLevel(0);
        coverer.setMaxLevel(30);
        switch (this.op) {
            case LE: 
            case LT: {
                for (S2CellId cell : coverer.getCovering(cap)) {
                    int n = cell.level();
                    String string = String.valueOf(cell.toToken());
                    Term term = new Term(this.luceneFieldName, new StringBuilder(15 + String.valueOf(string).length()).append("S2:").append(n).append(":").append(string).toString());
                    this.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
                }
                break;
            }
            case GE: 
            case GT: {
                for (S2CellId cell : coverer.getInteriorCovering(cap)) {
                    int n = cell.level();
                    String string = String.valueOf(cell.toToken());
                    Term term = new Term(this.luceneFieldName, new StringBuilder(15 + String.valueOf(string).length()).append("S2:").append(n).append(":").append(string).toString());
                    this.add(new TermQuery(term), BooleanClause.Occur.MUST_NOT);
                }
                Term term = new Term("_ALLDOC", "X");
                this.add(new TermQuery(term), BooleanClause.Occur.MUST);
                break;
            }
            default: {
                String string = String.valueOf((Object)this.op);
                throw new IllegalStateException(new StringBuilder(3 + String.valueOf(string).length()).append("op ").append(string).toString());
            }
        }
    }

    @Override
    public String toString() {
        return String.format("GeometricQuery(field='%s' geopoint=(%f,%f) op=%s distance=%f)", new Object[]{this.fieldName, this.point.latDegrees(), this.point.lngDegrees(), this.op, this.distance});
    }
}

