/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.tools.appstats.TemplateObjectModel;
import com.google.appengine.tools.appstats.TemplateTool;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class TemplateValueHelper {
    private final Logger log;
    private final Map<String, Object> parameters;
    private Map<String, TemplateObjectModel> blocks;
    private boolean autoEscape;
    private TemplateTool templateTool;
    private final boolean strict;

    TemplateValueHelper(Map<String, ?> parameters) {
        this(parameters, false);
    }

    TemplateValueHelper(Map<String, ?> parameters, boolean strict) {
        this.parameters = parameters == null ? new HashMap<String, Object>() : new HashMap(parameters);
        this.blocks = new HashMap<String, TemplateObjectModel>();
        this.log = Logger.getLogger(this.getClass().getName());
        this.strict = strict;
    }

    public Loop openLoop(List<? extends Object> content, String ... fields) {
        Loop parent = (Loop)this.parameters.get("forloop");
        Loop child = new Loop(content, parent, this, fields);
        this.parameters.put("forloop", child);
        return child;
    }

    public Object extract(String ... fieldNames) {
        return this.extract(this.parameters, 0, fieldNames);
    }

    public String format(String tag) {
        String[] tagsAndFilter = tag.split("\\|");
        tag = tagsAndFilter[0];
        String[] subTags = tag.split("\\.");
        Object transformation = null;
        Object rawObject = this.extract(subTags);
        if (rawObject == null) {
            return "";
        }
        if (tagsAndFilter.length == 1 && this.autoEscape) {
            return TemplateValueHelper.escape(String.valueOf(rawObject));
        }
        for (int i = 1; i < tagsAndFilter.length; ++i) {
            rawObject = this.transform(rawObject, tagsAndFilter[i].trim());
        }
        return String.valueOf(rawObject);
    }

    public boolean eval(String condition) {
        boolean hasNot = false;
        Boolean result = null;
        for (String c : condition.split("\\s")) {
            boolean asBool;
            if (c.equals("not")) {
                hasNot = true;
                continue;
            }
            Object rawObject = this.extract(c.split("\\."));
            boolean bl = asBool = rawObject != null && !rawObject.equals(false) && !rawObject.equals("") && (!(rawObject instanceof Number) || ((Number)rawObject).doubleValue() != 0.0);
            if (hasNot) {
                asBool = !asBool;
                hasNot = false;
            }
            result = asBool;
        }
        return result;
    }

    public void registerBlock(String name, TemplateObjectModel block) {
        if (!this.blocks.containsKey(name)) {
            this.blocks.put(name, block);
        }
    }

    public TemplateObjectModel getBlock(String name) {
        if (!this.blocks.containsKey(name)) {
            String string = String.valueOf(name);
            throw new AssertionError((Object)(string.length() != 0 ? "Block not found: ".concat(string) : new String("Block not found: ")));
        }
        return this.blocks.get(name);
    }

    public void setAutoEscape(boolean autoEscape) {
        this.autoEscape = autoEscape;
    }

    void setValue(String tag, Object value) {
        if (value == null) {
            this.parameters.remove(tag);
        } else {
            this.parameters.put(tag, value);
        }
    }

    public Object getValue(String fullyQualifiedName) {
        try {
            return this.extract(fullyQualifiedName.split("(\\s|\\.)+"));
        }
        catch (RuntimeException e) {
            String string = String.valueOf(fullyQualifiedName);
            this.log.logp(Level.WARNING, "com.google.appengine.tools.appstats.TemplateValueHelper", "getValue", string.length() != 0 ? "Failed to extract ".concat(string) : new String("Failed to extract "));
            throw e;
        }
    }

    private static String unwrap(String s) {
        while (s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        char[] toEscape = s.toCharArray();
        block7: for (int i = 0; i < toEscape.length; ++i) {
            switch (toEscape[i]) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(toEscape[i]);
                }
            }
        }
        return sb.toString();
    }

    static BigDecimal parse(Object o) {
        if (o instanceof Integer || o instanceof Long) {
            return new BigDecimal(((Number)o).longValue());
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        String s = TemplateValueHelper.unwrap(o.toString().trim());
        return new BigDecimal(s);
    }

    String transform(Object transformThis, String transformation) {
        if (transformation == null || transformation.length() == 0) {
            return this.autoEscape ? TemplateValueHelper.escape(String.valueOf(transformThis)) : String.valueOf(transformThis);
        }
        String[] split = transformation.split(":");
        String name = split[0];
        if (name.equals("add")) {
            return TemplateValueHelper.parse(transformThis).add(TemplateValueHelper.parse(split[1])).toString();
        }
        if (name.equals("floatformat")) {
            int digits = -1;
            if (split.length == 2) {
                digits = TemplateValueHelper.parse(split[1]).intValue();
            }
            BigDecimal roundThis = TemplateValueHelper.parse(transformThis);
            StringBuilder sb = new StringBuilder("#########0.");
            char c = digits < 0 ? (char)'#' : '0';
            for (int i = Math.abs(digits); i > 0; --i) {
                sb.append(c);
            }
            return new DecimalFormat(sb.toString()).format(roundThis.doubleValue());
        }
        if (name.equals("rjust")) {
            int width = TemplateValueHelper.parse(split[1]).intValue();
            StringBuilder sb = new StringBuilder(transformThis.toString());
            while (sb.length() < width) {
                sb.insert(0, ' ');
            }
            return sb.toString();
        }
        if (name.equals("pluralize")) {
            String suffix = "s";
            if (split.length == 2) {
                suffix = TemplateValueHelper.unwrap(split[1]);
            }
            if (1 != TemplateValueHelper.parse(transformThis).intValue()) {
                return suffix;
            }
            return "";
        }
        if (name.equals("safe")) {
            return transformThis.toString();
        }
        if (name.equals("escape")) {
            return TemplateValueHelper.escape(transformThis.toString());
        }
        if (this.strict) {
            String string = String.valueOf(transformation);
            throw new AssertionError((Object)(string.length() != 0 ? "Unknown template filter ".concat(string) : new String("Unknown template filter ")));
        }
        this.log.logp(Level.WARNING, "com.google.appengine.tools.appstats.TemplateValueHelper", "transform", new StringBuilder(42 + String.valueOf(transformation).length()).append("Unknown template filter ").append(transformation).append(", ignoring for now").toString());
        return this.autoEscape ? TemplateValueHelper.escape(String.valueOf(transformThis)) : String.valueOf(transformThis);
    }

    Object extract(Object source, int index, String ... fieldNames) {
        if (source == null && index == 1) {
            for (Loop loop = (Loop)this.parameters.get("forloop"); loop != null; loop = loop.getParentLoop()) {
                Iterator<Descriptors.FieldDescriptor> o = loop.extract(0, fieldNames);
                if (o == null) continue;
                return o;
            }
        }
        if (index == fieldNames.length) {
            return source;
        }
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            return this.extract(((Map)source).get(fieldNames[index]), index + 1, fieldNames);
        }
        if (source instanceof Loop) {
            return ((Loop)source).extract(index, fieldNames);
        }
        if (source instanceof Message) {
            Message m = (Message)source;
            for (Descriptors.FieldDescriptor field : m.getDescriptorForType().getFields()) {
                if (field.getName().equals(fieldNames[index])) {
                    return this.extract(m.getField(field), index + 1, fieldNames);
                }
                if (field.isRepeated() && String.valueOf(field.getName()).concat("_size").equals(fieldNames[index])) {
                    return this.extract(m.getRepeatedFieldCount(field), index + 1, fieldNames);
                }
                if (!field.isRepeated() || !String.valueOf(field.getName()).concat("_list").equals(fieldNames[index])) continue;
                return this.extract(m.getField(field), index + 1, fieldNames);
            }
            String string = String.valueOf(fieldNames[index]);
            throw new IllegalArgumentException(string.length() != 0 ? "Unknown field: ".concat(string) : new String("Unknown field: "));
        }
        if (source instanceof Descriptors.EnumValueDescriptor) {
            Descriptors.EnumValueDescriptor enumDesc = (Descriptors.EnumValueDescriptor)source;
            return enumDesc.getName();
        }
        if (source instanceof List) {
            int idx = Integer.parseInt(fieldNames[index]);
            List l = (List)source;
            Object value = null;
            try {
                value = l.get(idx);
            }
            catch (IndexOutOfBoundsException e) {
                return "";
            }
            return this.extract(value, index + 1, fieldNames);
        }
        if (source instanceof Map.Entry) {
            int idx = Integer.parseInt(fieldNames[index]);
            Map.Entry e = (Map.Entry)source;
            if (idx == 0) {
                return this.extract(e.getKey(), index + 1, fieldNames);
            }
            if (idx == 1) {
                return this.extract(e.getValue(), index + 1, fieldNames);
            }
        }
        String string = fieldNames[index];
        String string2 = String.valueOf(source.getClass());
        throw new ClassCastException(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Not supported (yet) for field '").append(string).append("': ").append(string2).toString());
    }

    public TemplateTool getTemplateTool() {
        return this.templateTool;
    }

    public void setTemplateTool(TemplateTool templateTool) {
        this.templateTool = templateTool;
    }

    public class Loop {
        private Loop parentloop;
        private List<? extends Object> content;
        private int index;
        private TemplateValueHelper helper;
        private String[] fields;

        private Loop(List<? extends Object> content, Loop parent, TemplateValueHelper helper, String[] fields) {
            this.content = content;
            this.parentloop = parent;
            this.helper = helper;
            this.fields = fields;
        }

        public boolean hasNext() {
            return this.index + 1 < this.content.size();
        }

        public boolean hasCurrent() {
            return this.index < this.content.size();
        }

        Object getCurrent() {
            return this.content.get(this.index);
        }

        public void next() {
            ++this.index;
        }

        public Loop getParentLoop() {
            return this.parentloop;
        }

        public void close() {
            this.helper.parameters.put("forloop", this.parentloop);
        }

        Object extract(int i, String ... fieldNames) {
            String field = fieldNames[i];
            if ("counter".equals(field)) {
                return this.index + 1;
            }
            if ("counter0".equals(field)) {
                return this.index;
            }
            if ("revcounter".equals(field)) {
                return this.content.size() - this.index;
            }
            if ("revcounter0".equals(field)) {
                return this.content.size() - this.index - 1;
            }
            if ("first".equals(field)) {
                return this.index == 0;
            }
            if ("last".equals(field)) {
                return this.index + 1 == this.content.size();
            }
            if ("parentloop".equals(field)) {
                return this.parentloop.extract(i + 1, fieldNames);
            }
            int idx = 0;
            for (String f : this.fields) {
                if (f.equals(field)) {
                    Object current = this.getCurrent();
                    if (idx == 0 && this.fields.length == 1) {
                        return this.helper.extract(current, i + 1, fieldNames);
                    }
                    if (current instanceof List) {
                        return this.helper.extract(((List)current).get(idx), i + 1, fieldNames);
                    }
                    if (current instanceof Map.Entry) {
                        if (idx == 0) {
                            return this.helper.extract(((Map.Entry)current).getKey(), i + 1, fieldNames);
                        }
                        if (idx == 1) {
                            return this.helper.extract(((Map.Entry)current).getValue(), i + 1, fieldNames);
                        }
                        int n = idx;
                        throw new AssertionError((Object)new StringBuilder(45).append("Map.Entry not supported for index ").append(n).toString());
                    }
                }
                ++idx;
            }
            if (TemplateValueHelper.this.strict) {
                String string = String.valueOf(Arrays.asList(fieldNames));
                throw new AssertionError((Object)new StringBuilder(42 + String.valueOf(string).length()).append("Could not extract position ").append(i).append(" of ").append(string).toString());
            }
            return null;
        }
    }
}

