/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.BinaryReader;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionSchema;
import com.google.appengine.repackaged.com.google.protobuf.FieldSet;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Internal;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Protobuf;
import com.google.appengine.repackaged.com.google.protobuf.Reader;
import com.google.appengine.repackaged.com.google.protobuf.SchemaUtil;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSchema;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import com.google.appengine.repackaged.com.google.protobuf.Writer;
import java.io.IOException;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class ExtensionSchemaLite
extends ExtensionSchema<GeneratedMessageLite.ExtensionDescriptor> {
    ExtensionSchemaLite() {
    }

    @Override
    boolean hasExtensions(Class<?> messageType) {
        return GeneratedMessageLite.ExtendableMessage.class.isAssignableFrom(messageType);
    }

    @Override
    FieldSet<GeneratedMessageLite.ExtensionDescriptor> getExtensions(Object message) {
        return ((GeneratedMessageLite.ExtendableMessage)message).extensions;
    }

    @Override
    void setExtensions(Object message, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) {
        ((GeneratedMessageLite.ExtendableMessage)message).extensions = extensions;
    }

    @Override
    <UT, UB> UB parseExtension(Reader reader, MessageLite defaultInstance, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        int fieldNumber = extension.getNumber();
        if (extension.descriptor.isRepeated() && extension.descriptor.isPacked()) {
            ArrayList<Constable> value = null;
            switch (extension.getLiteType()) {
                case DOUBLE: {
                    ArrayList<Double> list = new ArrayList<Double>();
                    reader.readDoubleList(list);
                    value = list;
                    break;
                }
                case FLOAT: {
                    ArrayList<Float> list = new ArrayList<Float>();
                    reader.readFloatList(list);
                    value = list;
                    break;
                }
                case INT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readInt64List(list);
                    value = list;
                    break;
                }
                case UINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readUInt64List(list);
                    value = list;
                    break;
                }
                case INT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readInt32List(list);
                    value = list;
                    break;
                }
                case FIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readFixed64List(list);
                    value = list;
                    break;
                }
                case FIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readFixed32List(list);
                    value = list;
                    break;
                }
                case BOOL: {
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    reader.readBoolList(list);
                    value = list;
                    break;
                }
                case UINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readUInt32List(list);
                    value = list;
                    break;
                }
                case SFIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSFixed32List(list);
                    value = list;
                    break;
                }
                case SFIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSFixed64List(list);
                    value = list;
                    break;
                }
                case SINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readSInt32List(list);
                    value = list;
                    break;
                }
                case SINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader.readSInt64List(list);
                    value = list;
                    break;
                }
                case ENUM: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader.readEnumList(list);
                    unknownFields = SchemaUtil.filterUnknownEnumList(fieldNumber, list, extension.descriptor.getEnumType(), unknownFields, unknownFieldSchema);
                    value = list;
                    break;
                }
                default: {
                    String list = String.valueOf((Object)extension.descriptor.getLiteType());
                    throw new IllegalStateException(new StringBuilder(23 + String.valueOf(list).length()).append("Type cannot be packed: ").append(list).toString());
                }
            }
            extensions.setField(extension.descriptor, value);
        } else {
            Object value = null;
            if (extension.getLiteType() == WireFormat.FieldType.ENUM) {
                int number = reader.readInt32();
                Object enumValue = extension.descriptor.getEnumType().findValueByNumber(number);
                if (enumValue == null) {
                    return SchemaUtil.storeUnknownEnum(fieldNumber, number, unknownFields, unknownFieldSchema);
                }
                value = number;
            } else {
                switch (extension.getLiteType()) {
                    case DOUBLE: {
                        value = reader.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(reader.readFloat());
                        break;
                    }
                    case INT64: {
                        value = reader.readInt64();
                        break;
                    }
                    case UINT64: {
                        value = reader.readUInt64();
                        break;
                    }
                    case INT32: {
                        value = reader.readInt32();
                        break;
                    }
                    case FIXED64: {
                        value = reader.readFixed64();
                        break;
                    }
                    case FIXED32: {
                        value = reader.readFixed32();
                        break;
                    }
                    case BOOL: {
                        value = reader.readBool();
                        break;
                    }
                    case BYTES: {
                        value = reader.readBytes();
                        break;
                    }
                    case UINT32: {
                        value = reader.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value = reader.readSFixed32();
                        break;
                    }
                    case SFIXED64: {
                        value = reader.readSFixed64();
                        break;
                    }
                    case SINT32: {
                        value = reader.readSInt32();
                        break;
                    }
                    case SINT64: {
                        value = reader.readSInt64();
                        break;
                    }
                    case STRING: {
                        value = reader.readString();
                        break;
                    }
                    case GROUP: {
                        value = reader.readGroup(extension.getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case MESSAGE: {
                        value = reader.readMessage(extension.getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (extension.isRepeated()) {
                extensions.addRepeatedField(extension.descriptor, value);
            } else {
                switch (extension.getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object oldValue = extensions.getField(extension.descriptor);
                        if (oldValue == null) break;
                        value = Internal.mergeMessage(oldValue, value);
                        break;
                    }
                }
                extensions.setField(extension.descriptor, value);
            }
        }
        return unknownFields;
    }

    @Override
    int extensionNumber(Map.Entry<?, ?> extension) {
        GeneratedMessageLite.ExtensionDescriptor descriptor = (GeneratedMessageLite.ExtensionDescriptor)extension.getKey();
        return descriptor.getNumber();
    }

    @Override
    void serializeExtension(Writer writer, Map.Entry<?, ?> extension) {
        GeneratedMessageLite.ExtensionDescriptor descriptor = (GeneratedMessageLite.ExtensionDescriptor)extension.getKey();
        if (descriptor.isRepeated()) {
            switch (descriptor.getLiteType()) {
                case DOUBLE: {
                    SchemaUtil.writeDoubleList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case FLOAT: {
                    SchemaUtil.writeFloatList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case INT64: {
                    SchemaUtil.writeInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case UINT64: {
                    SchemaUtil.writeUInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case INT32: {
                    SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case FIXED64: {
                    SchemaUtil.writeFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case FIXED32: {
                    SchemaUtil.writeFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case BOOL: {
                    SchemaUtil.writeBoolList(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case BYTES: {
                    SchemaUtil.writeBytesList(descriptor.getNumber(), (List)extension.getValue(), writer);
                    break;
                }
                case UINT32: {
                    SchemaUtil.writeUInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SFIXED32: {
                    SchemaUtil.writeSFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SFIXED64: {
                    SchemaUtil.writeSFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SINT32: {
                    SchemaUtil.writeSInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case SINT64: {
                    SchemaUtil.writeSInt64List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case ENUM: {
                    SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension.getValue(), writer, descriptor.isPacked());
                    break;
                }
                case STRING: {
                    SchemaUtil.writeStringList(descriptor.getNumber(), (List)extension.getValue(), writer);
                    break;
                }
                case GROUP: {
                    SchemaUtil.writeGroupList(descriptor.getNumber(), (List)extension.getValue(), writer);
                    break;
                }
                case MESSAGE: {
                    SchemaUtil.writeMessageList(descriptor.getNumber(), (List)extension.getValue(), writer);
                }
            }
        } else {
            switch (descriptor.getLiteType()) {
                case DOUBLE: {
                    writer.writeDouble(descriptor.getNumber(), (Double)extension.getValue());
                    break;
                }
                case FLOAT: {
                    writer.writeFloat(descriptor.getNumber(), ((Float)extension.getValue()).floatValue());
                    break;
                }
                case INT64: {
                    writer.writeInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case UINT64: {
                    writer.writeUInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case INT32: {
                    writer.writeInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case FIXED64: {
                    writer.writeFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case FIXED32: {
                    writer.writeFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case BOOL: {
                    writer.writeBool(descriptor.getNumber(), (Boolean)extension.getValue());
                    break;
                }
                case BYTES: {
                    writer.writeBytes(descriptor.getNumber(), (ByteString)extension.getValue());
                    break;
                }
                case UINT32: {
                    writer.writeUInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SFIXED32: {
                    writer.writeSFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SFIXED64: {
                    writer.writeSFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case SINT32: {
                    writer.writeSInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SINT64: {
                    writer.writeSInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case ENUM: {
                    writer.writeInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case STRING: {
                    writer.writeString(descriptor.getNumber(), (String)extension.getValue());
                    break;
                }
                case GROUP: {
                    writer.writeGroup(descriptor.getNumber(), extension.getValue());
                    break;
                }
                case MESSAGE: {
                    writer.writeMessage(descriptor.getNumber(), extension.getValue());
                }
            }
        }
    }

    @Override
    Object findExtensionByNumber(ExtensionRegistryLite extensionRegistry, MessageLite defaultInstance, int number) {
        return extensionRegistry.findLiteExtensionByNumber(defaultInstance, number);
    }

    @Override
    void parseLengthPrefixedMessageSetItem(Reader reader, MessageLite defaultInstance, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        Object value = reader.readMessage(extension.getMessageDefaultInstance().getClass(), extensionRegistry);
        extensions.setField(extension.descriptor, value);
    }

    @Override
    void parseMessageSetItem(ByteString data, MessageLite defaultInstance, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        MessageLite value = extension.getMessageDefaultInstance().newBuilderForType().buildPartial();
        BinaryReader reader = BinaryReader.newInstance(ByteBuffer.wrap(data.toByteArray()), true);
        Protobuf.getInstance().mergeFrom(value, reader, extensionRegistry);
        extensions.setField(extension.descriptor, value);
        if (reader.getFieldNumber() != Integer.MAX_VALUE) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }
}

