/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractObjectCountMap;
import com.google.appengine.repackaged.com.google.common.collect.CollectPreconditions;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.appengine.repackaged.com.google.common.collect.ObjectArrays;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
class EnumCountHashMap<K extends Enum<K>>
extends AbstractObjectCountMap<K> {
    private final Class<K> keyType;

    public static <K extends Enum<K>> EnumCountHashMap<K> create(Class<K> type) {
        return new EnumCountHashMap<K>(type);
    }

    EnumCountHashMap(Class<K> keyType) {
        this.keyType = keyType;
        this.keys = keyType.getEnumConstants();
        if (this.keys == null) {
            String string = String.valueOf(keyType.getName());
            throw new IllegalStateException(string.length() != 0 ? "Expected Enum class type, but got ".concat(string) : new String("Expected Enum class type, but got "));
        }
        this.values = new int[this.keys.length];
        Arrays.fill(this.values, 0, this.keys.length, -1);
    }

    @Override
    int firstIndex() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.values[i] <= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    int nextIndex(int index) {
        for (int i = index + 1; i < this.keys.length; ++i) {
            if (this.values[i] <= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    Set<K> createKeySet() {
        return new AbstractObjectCountMap.KeySetView(){

            private Object[] getFilteredKeyArray() {
                Object[] filteredKeys = new Object[EnumCountHashMap.this.size];
                int j = 0;
                for (int i = 0; i < EnumCountHashMap.this.keys.length; ++i) {
                    if (EnumCountHashMap.this.values[i] == -1) continue;
                    filteredKeys[j++] = EnumCountHashMap.this.keys[i];
                }
                return filteredKeys;
            }

            @Override
            public Object[] toArray() {
                return this.getFilteredKeyArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return ObjectArrays.toArrayImpl(this.getFilteredKeyArray(), 0, EnumCountHashMap.this.size, a);
            }

            @Override
            public Iterator<K> iterator() {
                return new EnumIterator<K>(){

                    @Override
                    K getOutput(int entry) {
                        return (Enum)EnumCountHashMap.this.keys[entry];
                    }
                };
            }
        };
    }

    @Override
    Multiset.Entry<K> getEntry(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return new EnumMapEntry(index);
    }

    @Override
    Set<Multiset.Entry<K>> createEntrySet() {
        return new AbstractObjectCountMap.EntrySetView(){

            @Override
            public Iterator<Multiset.Entry<K>> iterator() {
                return new EnumIterator<Multiset.Entry<K>>(){

                    @Override
                    Multiset.Entry<K> getOutput(int entry) {
                        return new EnumMapEntry(entry);
                    }
                };
            }
        };
    }

    @Override
    public void clear() {
        ++this.modCount;
        if (this.keys != null) {
            Arrays.fill(this.values, 0, this.values.length, -1);
            this.size = 0;
        }
    }

    private boolean isValidKey(Object key) {
        if (key == null) {
            return false;
        }
        Class<?> keyClass = key.getClass();
        return keyClass == this.keyType || keyClass.getSuperclass() == this.keyType;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.isValidKey(key) && this.values[((Enum)key).ordinal()] != -1;
    }

    @Override
    public int get(@Nullable Object key) {
        return this.containsKey(key) ? this.values[((Enum)key).ordinal()] : 0;
    }

    @Override
    int indexOf(@Nullable Object key) {
        if (!this.isValidKey(key)) {
            return -1;
        }
        return ((Enum)key).ordinal();
    }

    @Override
    @CanIgnoreReturnValue
    int removeEntry(int entryIndex) {
        return this.remove(this.keys[entryIndex]);
    }

    @Override
    @CanIgnoreReturnValue
    public int put(@Nullable K key, int value) {
        CollectPreconditions.checkPositive(value, "count");
        this.typeCheck(key);
        int index = ((Enum)key).ordinal();
        int oldValue = this.values[index];
        this.values[index] = value;
        ++this.modCount;
        if (oldValue == -1) {
            ++this.size;
            return 0;
        }
        return oldValue;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@Nullable Object key) {
        if (!this.isValidKey(key)) {
            return 0;
        }
        int index = ((Enum)key).ordinal();
        int oldValue = this.values[index];
        if (oldValue == -1) {
            return 0;
        }
        this.values[index] = -1;
        --this.size;
        ++this.modCount;
        return oldValue;
    }

    private void typeCheck(K key) {
        Class<?> keyClass = key.getClass();
        if (keyClass != this.keyType && keyClass.getSuperclass() != this.keyType) {
            String string = String.valueOf(keyClass);
            String string2 = String.valueOf(this.keyType);
            throw new ClassCastException(new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" != ").append(string2).toString());
        }
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            h += this.keys[i].hashCode() ^ this.values[i];
        }
        return h;
    }

    class EnumMapEntry
    extends AbstractObjectCountMap.MapEntry {
        EnumMapEntry(int index) {
            super(index);
        }

        @Override
        public int getCount() {
            return EnumCountHashMap.this.values[this.lastKnownIndex] == -1 ? 0 : EnumCountHashMap.this.values[this.lastKnownIndex];
        }

        @Override
        public int setCount(int count) {
            if (EnumCountHashMap.this.values[this.lastKnownIndex] == -1) {
                EnumCountHashMap.this.put((Enum)this.key, count);
                return 0;
            }
            int old = EnumCountHashMap.this.values[this.lastKnownIndex];
            EnumCountHashMap.this.values[this.lastKnownIndex] = count;
            return old == -1 ? 0 : old;
        }
    }

    private abstract class EnumIterator<T>
    extends AbstractObjectCountMap.Itr<T> {
        int nextIndex = -1;

        private EnumIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < EnumCountHashMap.this.values.length && EnumCountHashMap.this.values[this.index] <= 0) {
                ++this.index;
            }
            return this.index != EnumCountHashMap.this.values.length;
        }

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextCalled = true;
            this.nextIndex = this.index;
            return this.getOutput(this.index++);
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.nextCalled);
            ++this.expectedModCount;
            EnumCountHashMap.this.removeEntry(this.nextIndex);
            this.nextCalled = false;
            this.nextIndex = -1;
            --this.index;
        }
    }
}

