/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.labs.datastore.overlay.IdAllocationPolicy;
import com.google.appengine.api.labs.datastore.overlay.IncompleteKey;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class OverlayUtils {
    private static final String TOMBSTONE_UUID = "EB4BD565-1C12-494B-9A6D-182BA54D0B3F";

    private OverlayUtils() {
    }

    static boolean isTombstone(Entity entity) {
        return TOMBSTONE_UUID.equals(entity.getKind());
    }

    static Key getKeyFromTombstoneKey(Key tombstoneKey) {
        Preconditions.checkNotNull(tombstoneKey);
        return tombstoneKey.getParent();
    }

    static Entity getTombstoneForKey(Key key) {
        Preconditions.checkNotNull(key);
        return new Entity(OverlayUtils.getTombstoneKey(key));
    }

    static Key getTombstoneKey(Key key) {
        Preconditions.checkNotNull(key);
        return key.getChild(TOMBSTONE_UUID, TOMBSTONE_UUID);
    }

    static List<Key> getTombstoneKeys(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        ImmutableList.Builder newKeys = ImmutableList.builder();
        for (Key key : keys) {
            newKeys.add(OverlayUtils.getTombstoneKey(key));
        }
        return newKeys.build();
    }

    static List<Key> getKeysAndTombstoneKeys(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        ImmutableList.Builder newKeys = ImmutableList.builder();
        for (Key key : keys) {
            newKeys.add(key);
            newKeys.add(OverlayUtils.getTombstoneKey(key));
        }
        return newKeys.build();
    }

    static List<Key> getTombstoneKeysForEntities(Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        ImmutableList.Builder newKeys = ImmutableList.builder();
        for (Entity entity : entities) {
            Key key = entity.getKey();
            newKeys.add(OverlayUtils.getTombstoneKey(key));
        }
        return newKeys.build();
    }

    static List<Key> getKeysAndTombstoneKeysForEntities(Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        ImmutableList.Builder newKeys = ImmutableList.builder();
        for (Entity entity : entities) {
            Key key = entity.getKey();
            newKeys.add(key);
            newKeys.add(OverlayUtils.getTombstoneKey(key));
        }
        return newKeys.build();
    }

    static List<Entity> getTombstonesForKeys(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        ImmutableList.Builder tombstones = ImmutableList.builder();
        for (Key key : keys) {
            tombstones.add(OverlayUtils.getTombstoneForKey(key));
        }
        return tombstones.build();
    }

    static Entity completeKey(Entity entity, Key newKey) {
        Preconditions.checkNotNull(entity);
        Preconditions.checkNotNull(newKey);
        Preconditions.checkArgument(!entity.getKey().isComplete());
        Preconditions.checkArgument(Objects.equals(entity.getParent(), newKey.getParent()));
        Preconditions.checkArgument(Objects.equals(entity.getKind(), newKey.getKind()));
        Entity newEntity = new Entity(newKey);
        newEntity.setPropertiesFrom(entity);
        return newEntity;
    }

    static Map<IncompleteKey, Integer> getIdsNeededMap(Iterable<Entity> entities) {
        HashMap<IncompleteKey, Integer> idsNeededMap = Maps.newHashMap();
        for (Entity entity : entities) {
            if (entity.getKey().isComplete()) continue;
            IncompleteKey incompleteKey = new IncompleteKey(entity);
            Integer countInteger = (Integer)idsNeededMap.get(incompleteKey);
            if (countInteger != null) {
                idsNeededMap.put(incompleteKey, countInteger + 1);
                continue;
            }
            idsNeededMap.put(incompleteKey, 1);
        }
        return idsNeededMap;
    }

    static List<Entity> getEntitiesWithPreexistingCompleteKeys(Iterable<Entity> entities) {
        ImmutableList.Builder entitiesWithCompleteKeys = ImmutableList.builder();
        for (Entity entity : entities) {
            if (!entity.getKey().isComplete()) continue;
            entitiesWithCompleteKeys.add(entity);
        }
        return entitiesWithCompleteKeys.build();
    }

    static List<Entity> translateAndCompleteEntityKeys(Iterable<Entity> entities, Map<IncompleteKey, Iterator<Key>> idsAllocatedMap) {
        ImmutableList.Builder entitiesWithCompleteKeys = ImmutableList.builder();
        Iterator<Object> iterator = entities.iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Entity newEntity = entity = iterator.next();
            if (!entity.getKey().isComplete()) {
                IncompleteKey incompleteKey = new IncompleteKey(entity);
                Iterator<Key> keyIterator = idsAllocatedMap.get(incompleteKey);
                Key k = keyIterator.next();
                Key newKey = KeyFactory.createKey((Key)k.getParent(), (String)k.getKind(), (long)IdAllocationPolicy.overlayIdFromDefaultId(k.getId()));
                newEntity = OverlayUtils.completeKey(entity, newKey);
            }
            entitiesWithCompleteKeys.add(newEntity);
        }
        for (Iterator iterator2 : idsAllocatedMap.values()) {
            Preconditions.checkState(!iterator2.hasNext());
        }
        return entitiesWithCompleteKeys.build();
    }
}

