/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-18 at 18:06:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtubeAnalytics;

/**
 * Service definition for YouTubeAnalytics (v1).
 *
 * <p>
 * Retrieves your YouTube Analytics data.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="http://developers.google.com/youtube/analytics/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link YouTubeAnalyticsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class YouTubeAnalytics extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.22.0 of the YouTube Analytics API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "youtube/analytics/v1/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public YouTubeAnalytics(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  YouTubeAnalytics(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the GroupItems collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTubeAnalytics youtubeAnalytics = new YouTubeAnalytics(...);}
   *   {@code YouTubeAnalytics.GroupItems.List request = youtubeAnalytics.groupItems().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GroupItems groupItems() {
    return new GroupItems();
  }

  /**
   * The "groupItems" collection of methods.
   */
  public class GroupItems {

    /**
     * Removes an item from a group.
     *
     * Create a request for the method "groupItems.delete".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube group item ID for the group that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeAnalyticsRequest<Void> {

      private static final String REST_PATH = "groupItems";

      /**
       * Removes an item from a group.
       *
       * Create a request for the method "groupItems.delete".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube group item ID for the group that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTubeAnalytics.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the YouTube group item ID for the group that is being deleted.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube group item ID for the group that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies the YouTube group item ID for the group that is being deleted.
       */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a group item.
     *
     * Create a request for the method "groupItems.insert".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtubeAnalytics.model.GroupItem}
     * @return the request
     */
    public Insert insert(com.google.api.services.youtubeAnalytics.model.GroupItem content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeAnalyticsRequest<com.google.api.services.youtubeAnalytics.model.GroupItem> {

      private static final String REST_PATH = "groupItems";

      /**
       * Creates a group item.
       *
       * Create a request for the method "groupItems.insert".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtubeAnalytics.model.GroupItem}
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtubeAnalytics.model.GroupItem content) {
        super(YouTubeAnalytics.this, "POST", REST_PATH, content, com.google.api.services.youtubeAnalytics.model.GroupItem.class);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a collection of group items that match the API request parameters.
     *
     * Create a request for the method "groupItems.list".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param groupId The id parameter specifies the unique ID of the group for which you want to retrieve group items.
     * @return the request
     */
    public List list(java.lang.String groupId) throws java.io.IOException {
      List result = new List(groupId);
      initialize(result);
      return result;
    }

    public class List extends YouTubeAnalyticsRequest<com.google.api.services.youtubeAnalytics.model.GroupItemListResponse> {

      private static final String REST_PATH = "groupItems";

      /**
       * Returns a collection of group items that match the API request parameters.
       *
       * Create a request for the method "groupItems.list".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param groupId The id parameter specifies the unique ID of the group for which you want to retrieve group items.
       * @since 1.13
       */
      protected List(java.lang.String groupId) {
        super(YouTubeAnalytics.this, "GET", REST_PATH, null, com.google.api.services.youtubeAnalytics.model.GroupItemListResponse.class);
        this.groupId = com.google.api.client.util.Preconditions.checkNotNull(groupId, "Required parameter groupId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies the unique ID of the group for which you want to retrieve group
       * items.
       */
      @com.google.api.client.util.Key
      private java.lang.String groupId;

      /** The id parameter specifies the unique ID of the group for which you want to retrieve group items.
       */
      public java.lang.String getGroupId() {
        return groupId;
      }

      /**
       * The id parameter specifies the unique ID of the group for which you want to retrieve group
       * items.
       */
      public List setGroupId(java.lang.String groupId) {
        this.groupId = groupId;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Groups collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTubeAnalytics youtubeAnalytics = new YouTubeAnalytics(...);}
   *   {@code YouTubeAnalytics.Groups.List request = youtubeAnalytics.groups().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Groups groups() {
    return new Groups();
  }

  /**
   * The "groups" collection of methods.
   */
  public class Groups {

    /**
     * Deletes a group.
     *
     * Create a request for the method "groups.delete".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param id The id parameter specifies the YouTube group ID for the group that is being deleted.
     * @return the request
     */
    public Delete delete(java.lang.String id) throws java.io.IOException {
      Delete result = new Delete(id);
      initialize(result);
      return result;
    }

    public class Delete extends YouTubeAnalyticsRequest<Void> {

      private static final String REST_PATH = "groups";

      /**
       * Deletes a group.
       *
       * Create a request for the method "groups.delete".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param id The id parameter specifies the YouTube group ID for the group that is being deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String id) {
        super(YouTubeAnalytics.this, "DELETE", REST_PATH, null, Void.class);
        this.id = com.google.api.client.util.Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The id parameter specifies the YouTube group ID for the group that is being deleted. */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies the YouTube group ID for the group that is being deleted.
       */
      public java.lang.String getId() {
        return id;
      }

      /** The id parameter specifies the YouTube group ID for the group that is being deleted. */
      public Delete setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Delete setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Creates a group.
     *
     * Create a request for the method "groups.insert".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtubeAnalytics.model.Group}
     * @return the request
     */
    public Insert insert(com.google.api.services.youtubeAnalytics.model.Group content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends YouTubeAnalyticsRequest<com.google.api.services.youtubeAnalytics.model.Group> {

      private static final String REST_PATH = "groups";

      /**
       * Creates a group.
       *
       * Create a request for the method "groups.insert".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtubeAnalytics.model.Group}
       * @since 1.13
       */
      protected Insert(com.google.api.services.youtubeAnalytics.model.Group content) {
        super(YouTubeAnalytics.this, "POST", REST_PATH, content, com.google.api.services.youtubeAnalytics.model.Group.class);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Insert setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a collection of groups that match the API request parameters. For example, you can
     * retrieve all groups that the authenticated user owns, or you can retrieve one or more groups by
     * their unique IDs.
     *
     * Create a request for the method "groups.list".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends YouTubeAnalyticsRequest<com.google.api.services.youtubeAnalytics.model.GroupListResponse> {

      private static final String REST_PATH = "groups";

      /**
       * Returns a collection of groups that match the API request parameters. For example, you can
       * retrieve all groups that the authenticated user owns, or you can retrieve one or more groups by
       * their unique IDs.
       *
       * Create a request for the method "groups.list".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(YouTubeAnalytics.this, "GET", REST_PATH, null, com.google.api.services.youtubeAnalytics.model.GroupListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube group ID(s) for the
       * resource(s) that are being retrieved. In a group resource, the id property specifies the
       * group's YouTube group ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /** The id parameter specifies a comma-separated list of the YouTube group ID(s) for the resource(s)
     that are being retrieved. In a group resource, the id property specifies the group's YouTube group
     ID.
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * The id parameter specifies a comma-separated list of the YouTube group ID(s) for the
       * resource(s) that are being retrieved. In a group resource, the id property specifies the
       * group's YouTube group ID.
       */
      public List setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return groups owned by the
       * authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean mine;

      /** Set this parameter's value to true to instruct the API to only return groups owned by the
     authenticated user.
       */
      public java.lang.Boolean getMine() {
        return mine;
      }

      /**
       * Set this parameter's value to true to instruct the API to only return groups owned by the
       * authenticated user.
       */
      public List setMine(java.lang.Boolean mine) {
        this.mine = mine;
        return this;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public List setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identifies the next page that can
       * be retrieved.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The pageToken parameter identifies a specific page in the result set that should be returned. In an
     API response, the nextPageToken property identifies the next page that can be retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The pageToken parameter identifies a specific page in the result set that should be
       * returned. In an API response, the nextPageToken property identifies the next page that can
       * be retrieved.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies a group. For example, you could change a group's title.
     *
     * Create a request for the method "groups.update".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.youtubeAnalytics.model.Group}
     * @return the request
     */
    public Update update(com.google.api.services.youtubeAnalytics.model.Group content) throws java.io.IOException {
      Update result = new Update(content);
      initialize(result);
      return result;
    }

    public class Update extends YouTubeAnalyticsRequest<com.google.api.services.youtubeAnalytics.model.Group> {

      private static final String REST_PATH = "groups";

      /**
       * Modifies a group. For example, you could change a group's title.
       *
       * Create a request for the method "groups.update".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.youtubeAnalytics.model.Group}
       * @since 1.13
       */
      protected Update(com.google.api.services.youtubeAnalytics.model.Group content) {
        super(YouTubeAnalytics.this, "PUT", REST_PATH, content, com.google.api.services.youtubeAnalytics.model.Group.class);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String onBehalfOfContentOwner;

      /** Note: This parameter is intended exclusively for YouTube content partners.

     The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
     identify a YouTube CMS user who is acting on behalf of the content owner specified in the parameter
     value. This parameter is intended for YouTube content partners that own and manage many different
     YouTube channels. It allows content owners to authenticate once and get access to all their video
     and channel data, without having to provide authentication credentials for each individual channel.
     The CMS account that the user authenticates with must be linked to the specified YouTube content
     owner.
       */
      public java.lang.String getOnBehalfOfContentOwner() {
        return onBehalfOfContentOwner;
      }

      /**
       * Note: This parameter is intended exclusively for YouTube content partners.
       *
       * The onBehalfOfContentOwner parameter indicates that the request's authorization credentials
       * identify a YouTube CMS user who is acting on behalf of the content owner specified in the
       * parameter value. This parameter is intended for YouTube content partners that own and
       * manage many different YouTube channels. It allows content owners to authenticate once and
       * get access to all their video and channel data, without having to provide authentication
       * credentials for each individual channel. The CMS account that the user authenticates with
       * must be linked to the specified YouTube content owner.
       */
      public Update setOnBehalfOfContentOwner(java.lang.String onBehalfOfContentOwner) {
        this.onBehalfOfContentOwner = onBehalfOfContentOwner;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Reports collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code YouTubeAnalytics youtubeAnalytics = new YouTubeAnalytics(...);}
   *   {@code YouTubeAnalytics.Reports.List request = youtubeAnalytics.reports().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Reports reports() {
    return new Reports();
  }

  /**
   * The "reports" collection of methods.
   */
  public class Reports {

    /**
     * Retrieve your YouTube Analytics reports.
     *
     * Create a request for the method "reports.query".
     *
     * This request holds the parameters needed by the youtubeAnalytics server.  After setting any
     * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
     *
     * @param ids Identifies the YouTube channel or content owner for which you are retrieving YouTube Analytics data.
     *        - To request data for a YouTube user, set the ids parameter value to channel==CHANNEL_ID,
     *        where CHANNEL_ID specifies the unique YouTube channel ID.
    - To request data for a YouTube
     *        CMS content owner, set the ids parameter value to contentOwner==OWNER_NAME, where
     *        OWNER_NAME is the CMS name of the content owner.
     * @param startDate The start date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
     * @param endDate The end date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
     * @param metrics A comma-separated list of YouTube Analytics metrics, such as views or likes,dislikes. See the
     *        Available Reports document for a list of the reports that you can retrieve and the metrics
     *        available in each report, and see the Metrics document for definitions of those metrics.
     * @return the request
     */
    public Query query(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) throws java.io.IOException {
      Query result = new Query(ids, startDate, endDate, metrics);
      initialize(result);
      return result;
    }

    public class Query extends YouTubeAnalyticsRequest<com.google.api.services.youtubeAnalytics.model.ResultTable> {

      private static final String REST_PATH = "reports";

      private final java.util.regex.Pattern IDS_PATTERN =
          java.util.regex.Pattern.compile("[a-zA-Z]+==[a-zA-Z0-9_+-]+");

      private final java.util.regex.Pattern START_DATE_PATTERN =
          java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

      private final java.util.regex.Pattern END_DATE_PATTERN =
          java.util.regex.Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

      private final java.util.regex.Pattern METRICS_PATTERN =
          java.util.regex.Pattern.compile("[0-9a-zA-Z,]+");

      private final java.util.regex.Pattern CURRENCY_PATTERN =
          java.util.regex.Pattern.compile("[A-Z]{3}");

      private final java.util.regex.Pattern DIMENSIONS_PATTERN =
          java.util.regex.Pattern.compile("[0-9a-zA-Z,]+");

      private final java.util.regex.Pattern SORT_PATTERN =
          java.util.regex.Pattern.compile("[-0-9a-zA-Z,]+");

      /**
       * Retrieve your YouTube Analytics reports.
       *
       * Create a request for the method "reports.query".
       *
       * This request holds the parameters needed by the the youtubeAnalytics server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       * <p> {@link
       * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param ids Identifies the YouTube channel or content owner for which you are retrieving YouTube Analytics data.
     *        - To request data for a YouTube user, set the ids parameter value to channel==CHANNEL_ID,
     *        where CHANNEL_ID specifies the unique YouTube channel ID.
    - To request data for a YouTube
     *        CMS content owner, set the ids parameter value to contentOwner==OWNER_NAME, where
     *        OWNER_NAME is the CMS name of the content owner.
       * @param startDate The start date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
       * @param endDate The end date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
       * @param metrics A comma-separated list of YouTube Analytics metrics, such as views or likes,dislikes. See the
     *        Available Reports document for a list of the reports that you can retrieve and the metrics
     *        available in each report, and see the Metrics document for definitions of those metrics.
       * @since 1.13
       */
      protected Query(java.lang.String ids, java.lang.String startDate, java.lang.String endDate, java.lang.String metrics) {
        super(YouTubeAnalytics.this, "GET", REST_PATH, null, com.google.api.services.youtubeAnalytics.model.ResultTable.class);
        this.ids = com.google.api.client.util.Preconditions.checkNotNull(ids, "Required parameter ids must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
              "Parameter ids must conform to the pattern " +
              "[a-zA-Z]+==[a-zA-Z0-9_+-]+");
        }
        this.startDate = com.google.api.client.util.Preconditions.checkNotNull(startDate, "Required parameter startDate must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(START_DATE_PATTERN.matcher(startDate).matches(),
              "Parameter startDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.endDate = com.google.api.client.util.Preconditions.checkNotNull(endDate, "Required parameter endDate must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(END_DATE_PATTERN.matcher(endDate).matches(),
              "Parameter endDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.metrics = com.google.api.client.util.Preconditions.checkNotNull(metrics, "Required parameter metrics must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
              "Parameter metrics must conform to the pattern " +
              "[0-9a-zA-Z,]+");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Query setAlt(java.lang.String alt) {
        return (Query) super.setAlt(alt);
      }

      @Override
      public Query setFields(java.lang.String fields) {
        return (Query) super.setFields(fields);
      }

      @Override
      public Query setKey(java.lang.String key) {
        return (Query) super.setKey(key);
      }

      @Override
      public Query setOauthToken(java.lang.String oauthToken) {
        return (Query) super.setOauthToken(oauthToken);
      }

      @Override
      public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Query) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Query setQuotaUser(java.lang.String quotaUser) {
        return (Query) super.setQuotaUser(quotaUser);
      }

      @Override
      public Query setUserIp(java.lang.String userIp) {
        return (Query) super.setUserIp(userIp);
      }

      /**
       * Identifies the YouTube channel or content owner for which you are retrieving YouTube
       * Analytics data. - To request data for a YouTube user, set the ids parameter value to
       * channel==CHANNEL_ID, where CHANNEL_ID specifies the unique YouTube channel ID. - To request
       * data for a YouTube CMS content owner, set the ids parameter value to
       * contentOwner==OWNER_NAME, where OWNER_NAME is the CMS name of the content owner.
       */
      @com.google.api.client.util.Key
      private java.lang.String ids;

      /** Identifies the YouTube channel or content owner for which you are retrieving YouTube Analytics
     data. - To request data for a YouTube user, set the ids parameter value to channel==CHANNEL_ID,
     where CHANNEL_ID specifies the unique YouTube channel ID. - To request data for a YouTube CMS
     content owner, set the ids parameter value to contentOwner==OWNER_NAME, where OWNER_NAME is the CMS
     name of the content owner.
       */
      public java.lang.String getIds() {
        return ids;
      }

      /**
       * Identifies the YouTube channel or content owner for which you are retrieving YouTube
       * Analytics data. - To request data for a YouTube user, set the ids parameter value to
       * channel==CHANNEL_ID, where CHANNEL_ID specifies the unique YouTube channel ID. - To request
       * data for a YouTube CMS content owner, set the ids parameter value to
       * contentOwner==OWNER_NAME, where OWNER_NAME is the CMS name of the content owner.
       */
      public Query setIds(java.lang.String ids) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IDS_PATTERN.matcher(ids).matches(),
              "Parameter ids must conform to the pattern " +
              "[a-zA-Z]+==[a-zA-Z0-9_+-]+");
        }
        this.ids = ids;
        return this;
      }

      /**
       * The start date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD
       * format.
       */
      @com.google.api.client.util.Key("start-date")
      private java.lang.String startDate;

      /** The start date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
       */
      public java.lang.String getStartDate() {
        return startDate;
      }

      /**
       * The start date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD
       * format.
       */
      public Query setStartDate(java.lang.String startDate) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(START_DATE_PATTERN.matcher(startDate).matches(),
              "Parameter startDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.startDate = startDate;
        return this;
      }

      /**
       * The end date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
       */
      @com.google.api.client.util.Key("end-date")
      private java.lang.String endDate;

      /** The end date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
       */
      public java.lang.String getEndDate() {
        return endDate;
      }

      /**
       * The end date for fetching YouTube Analytics data. The value should be in YYYY-MM-DD format.
       */
      public Query setEndDate(java.lang.String endDate) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(END_DATE_PATTERN.matcher(endDate).matches(),
              "Parameter endDate must conform to the pattern " +
              "[0-9]{4}-[0-9]{2}-[0-9]{2}");
        }
        this.endDate = endDate;
        return this;
      }

      /**
       * A comma-separated list of YouTube Analytics metrics, such as views or likes,dislikes. See
       * the Available Reports document for a list of the reports that you can retrieve and the
       * metrics available in each report, and see the Metrics document for definitions of those
       * metrics.
       */
      @com.google.api.client.util.Key
      private java.lang.String metrics;

      /** A comma-separated list of YouTube Analytics metrics, such as views or likes,dislikes. See the
     Available Reports document for a list of the reports that you can retrieve and the metrics
     available in each report, and see the Metrics document for definitions of those metrics.
       */
      public java.lang.String getMetrics() {
        return metrics;
      }

      /**
       * A comma-separated list of YouTube Analytics metrics, such as views or likes,dislikes. See
       * the Available Reports document for a list of the reports that you can retrieve and the
       * metrics available in each report, and see the Metrics document for definitions of those
       * metrics.
       */
      public Query setMetrics(java.lang.String metrics) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(METRICS_PATTERN.matcher(metrics).matches(),
              "Parameter metrics must conform to the pattern " +
              "[0-9a-zA-Z,]+");
        }
        this.metrics = metrics;
        return this;
      }

      /**
       * The currency to which financial metrics should be converted. The default is US Dollar
       * (USD). If the result contains no financial metrics, this flag will be ignored. Responds
       * with an error if the specified currency is not recognized.
       */
      @com.google.api.client.util.Key
      private java.lang.String currency;

      /** The currency to which financial metrics should be converted. The default is US Dollar (USD). If the
     result contains no financial metrics, this flag will be ignored. Responds with an error if the
     specified currency is not recognized.
       */
      public java.lang.String getCurrency() {
        return currency;
      }

      /**
       * The currency to which financial metrics should be converted. The default is US Dollar
       * (USD). If the result contains no financial metrics, this flag will be ignored. Responds
       * with an error if the specified currency is not recognized.
       */
      public Query setCurrency(java.lang.String currency) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(CURRENCY_PATTERN.matcher(currency).matches(),
              "Parameter currency must conform to the pattern " +
              "[A-Z]{3}");
        }
        this.currency = currency;
        return this;
      }

      /**
       * A comma-separated list of YouTube Analytics dimensions, such as views or ageGroup,gender.
       * See the Available Reports document for a list of the reports that you can retrieve and the
       * dimensions used for those reports. Also see the Dimensions document for definitions of
       * those dimensions.
       */
      @com.google.api.client.util.Key
      private java.lang.String dimensions;

      /** A comma-separated list of YouTube Analytics dimensions, such as views or ageGroup,gender. See the
     Available Reports document for a list of the reports that you can retrieve and the dimensions used
     for those reports. Also see the Dimensions document for definitions of those dimensions.
       */
      public java.lang.String getDimensions() {
        return dimensions;
      }

      /**
       * A comma-separated list of YouTube Analytics dimensions, such as views or ageGroup,gender.
       * See the Available Reports document for a list of the reports that you can retrieve and the
       * dimensions used for those reports. Also see the Dimensions document for definitions of
       * those dimensions.
       */
      public Query setDimensions(java.lang.String dimensions) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DIMENSIONS_PATTERN.matcher(dimensions).matches(),
              "Parameter dimensions must conform to the pattern " +
              "[0-9a-zA-Z,]+");
        }
        this.dimensions = dimensions;
        return this;
      }

      /**
       * A list of filters that should be applied when retrieving YouTube Analytics data. The
       * Available Reports document identifies the dimensions that can be used to filter each
       * report, and the Dimensions document defines those dimensions. If a request uses multiple
       * filters, join them together with a semicolon (;), and the returned result table will
       * satisfy both filters. For example, a filters parameter value of
       * video==dMH0bHeiRNg;country==IT restricts the result set to include data for the given video
       * in Italy.
       */
      @com.google.api.client.util.Key
      private java.lang.String filters;

      /** A list of filters that should be applied when retrieving YouTube Analytics data. The Available
     Reports document identifies the dimensions that can be used to filter each report, and the
     Dimensions document defines those dimensions. If a request uses multiple filters, join them
     together with a semicolon (;), and the returned result table will satisfy both filters. For
     example, a filters parameter value of video==dMH0bHeiRNg;country==IT restricts the result set to
     include data for the given video in Italy.
       */
      public java.lang.String getFilters() {
        return filters;
      }

      /**
       * A list of filters that should be applied when retrieving YouTube Analytics data. The
       * Available Reports document identifies the dimensions that can be used to filter each
       * report, and the Dimensions document defines those dimensions. If a request uses multiple
       * filters, join them together with a semicolon (;), and the returned result table will
       * satisfy both filters. For example, a filters parameter value of
       * video==dMH0bHeiRNg;country==IT restricts the result set to include data for the given video
       * in Italy.
       */
      public Query setFilters(java.lang.String filters) {
        this.filters = filters;
        return this;
      }

      /**
       * If set to true historical data (i.e. channel data from before the linking of the channel to
       * the content owner) will be retrieved.
       */
      @com.google.api.client.util.Key("include-historical-channel-data")
      private java.lang.Boolean includeHistoricalChannelData;

      /** If set to true historical data (i.e. channel data from before the linking of the channel to the
     content owner) will be retrieved.
       */
      public java.lang.Boolean getIncludeHistoricalChannelData() {
        return includeHistoricalChannelData;
      }

      /**
       * If set to true historical data (i.e. channel data from before the linking of the channel to
       * the content owner) will be retrieved.
       */
      public Query setIncludeHistoricalChannelData(java.lang.Boolean includeHistoricalChannelData) {
        this.includeHistoricalChannelData = includeHistoricalChannelData;
        return this;
      }

      /** The maximum number of rows to include in the response. */
      @com.google.api.client.util.Key("max-results")
      private java.lang.Integer maxResults;

      /** The maximum number of rows to include in the response.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /** The maximum number of rows to include in the response. */
      public Query setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A comma-separated list of dimensions or metrics that determine the sort order for YouTube
       * Analytics data. By default the sort order is ascending. The '-' prefix causes descending
       * sort order.
       */
      @com.google.api.client.util.Key
      private java.lang.String sort;

      /** A comma-separated list of dimensions or metrics that determine the sort order for YouTube Analytics
     data. By default the sort order is ascending. The '-' prefix causes descending sort order.
       */
      public java.lang.String getSort() {
        return sort;
      }

      /**
       * A comma-separated list of dimensions or metrics that determine the sort order for YouTube
       * Analytics data. By default the sort order is ascending. The '-' prefix causes descending
       * sort order.
       */
      public Query setSort(java.lang.String sort) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SORT_PATTERN.matcher(sort).matches(),
              "Parameter sort must conform to the pattern " +
              "[-0-9a-zA-Z,]+");
        }
        this.sort = sort;
        return this;
      }

      /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter (one-based, inclusive).
       */
      @com.google.api.client.util.Key("start-index")
      private java.lang.Integer startIndex;

      /** An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with
     the max-results parameter (one-based, inclusive).

     [minimum: 1]
       */
      public java.lang.Integer getStartIndex() {
        return startIndex;
      }

      /**
       * An index of the first entity to retrieve. Use this parameter as a pagination mechanism
       * along with the max-results parameter (one-based, inclusive).
       */
      public Query setStartIndex(java.lang.Integer startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      @Override
      public Query set(String parameterName, Object value) {
        return (Query) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link YouTubeAnalytics}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link YouTubeAnalytics}. */
    @Override
    public YouTubeAnalytics build() {
      return new YouTubeAnalytics(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link YouTubeAnalyticsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setYouTubeAnalyticsRequestInitializer(
        YouTubeAnalyticsRequestInitializer youtubeanalyticsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(youtubeanalyticsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
