/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.webmasters;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.webmasters.WebmastersRequest;
import com.google.api.services.webmasters.WebmastersRequestInitializer;
import com.google.api.services.webmasters.model.SearchAnalyticsQueryRequest;
import com.google.api.services.webmasters.model.SearchAnalyticsQueryResponse;
import com.google.api.services.webmasters.model.SitemapsListResponse;
import com.google.api.services.webmasters.model.SitesListResponse;
import com.google.api.services.webmasters.model.WmxSite;
import com.google.api.services.webmasters.model.WmxSitemap;
import java.io.IOException;

public class Webmasters
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "webmasters/v3/";
    public static final String DEFAULT_BATCH_PATH = "batch/webmasters/v3";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/webmasters/v3/";

    public Webmasters(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Webmasters(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Searchanalytics searchanalytics() {
        return new Searchanalytics();
    }

    public Sitemaps sitemaps() {
        return new Sitemaps();
    }

    public Sites sites() {
        return new Sites();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.8 of the Search Console API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Webmasters.DEFAULT_ROOT_URL, Webmasters.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Webmasters.DEFAULT_BATCH_PATH);
        }

        public Webmasters build() {
            return new Webmasters(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setWebmastersRequestInitializer(WebmastersRequestInitializer webmastersRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)webmastersRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Sites {
        public Add add(String siteUrl) throws IOException {
            Add result = new Add(siteUrl);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String siteUrl) throws IOException {
            Delete result = new Delete(siteUrl);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String siteUrl) throws IOException {
            Get result = new Get(siteUrl);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends WebmastersRequest<SitesListResponse> {
            private static final String REST_PATH = "sites";

            protected List() {
                super(Webmasters.this, "GET", REST_PATH, null, SitesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends WebmastersRequest<WmxSite> {
            private static final String REST_PATH = "sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Get(String siteUrl) {
                super(Webmasters.this, "GET", REST_PATH, null, WmxSite.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Get setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Delete(String siteUrl) {
                super(Webmasters.this, "DELETE", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Delete setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Add
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}";
            @Key
            private String siteUrl;

            protected Add(String siteUrl) {
                super(Webmasters.this, "PUT", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public Add setAlt(String alt) {
                return (Add)super.setAlt(alt);
            }

            public Add setFields(String fields) {
                return (Add)super.setFields(fields);
            }

            public Add setKey(String key) {
                return (Add)super.setKey(key);
            }

            public Add setOauthToken(String oauthToken) {
                return (Add)super.setOauthToken(oauthToken);
            }

            public Add setPrettyPrint(Boolean prettyPrint) {
                return (Add)super.setPrettyPrint(prettyPrint);
            }

            public Add setQuotaUser(String quotaUser) {
                return (Add)super.setQuotaUser(quotaUser);
            }

            public Add setUserIp(String userIp) {
                return (Add)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Add setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Add set(String parameterName, Object value) {
                return (Add)super.set(parameterName, value);
            }
        }
    }

    public class Sitemaps {
        public Delete delete(String siteUrl, String feedpath) throws IOException {
            Delete result = new Delete(siteUrl, feedpath);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String siteUrl, String feedpath) throws IOException {
            Get result = new Get(siteUrl, feedpath);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String siteUrl) throws IOException {
            List result = new List(siteUrl);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Submit submit(String siteUrl, String feedpath) throws IOException {
            Submit result = new Submit(siteUrl, feedpath);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Submit
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Submit(String siteUrl, String feedpath) {
                super(Webmasters.this, "PUT", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)feedpath, (Object)"Required parameter feedpath must be specified.");
            }

            public Submit setAlt(String alt) {
                return (Submit)super.setAlt(alt);
            }

            public Submit setFields(String fields) {
                return (Submit)super.setFields(fields);
            }

            public Submit setKey(String key) {
                return (Submit)super.setKey(key);
            }

            public Submit setOauthToken(String oauthToken) {
                return (Submit)super.setOauthToken(oauthToken);
            }

            public Submit setPrettyPrint(Boolean prettyPrint) {
                return (Submit)super.setPrettyPrint(prettyPrint);
            }

            public Submit setQuotaUser(String quotaUser) {
                return (Submit)super.setQuotaUser(quotaUser);
            }

            public Submit setUserIp(String userIp) {
                return (Submit)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Submit setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Submit setFeedpath(String feedpath) {
                this.feedpath = feedpath;
                return this;
            }

            @Override
            public Submit set(String parameterName, Object value) {
                return (Submit)super.set(parameterName, value);
            }
        }

        public class List
        extends WebmastersRequest<SitemapsListResponse> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps";
            @Key
            private String siteUrl;
            @Key
            private String sitemapIndex;

            protected List(String siteUrl) {
                super(Webmasters.this, "GET", REST_PATH, null, SitemapsListResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public List setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getSitemapIndex() {
                return this.sitemapIndex;
            }

            public List setSitemapIndex(String sitemapIndex) {
                this.sitemapIndex = sitemapIndex;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends WebmastersRequest<WmxSitemap> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Get(String siteUrl, String feedpath) {
                super(Webmasters.this, "GET", REST_PATH, null, WmxSitemap.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)feedpath, (Object)"Required parameter feedpath must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Get setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Get setFeedpath(String feedpath) {
                this.feedpath = feedpath;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends WebmastersRequest<Void> {
            private static final String REST_PATH = "sites/{siteUrl}/sitemaps/{feedpath}";
            @Key
            private String siteUrl;
            @Key
            private String feedpath;

            protected Delete(String siteUrl, String feedpath) {
                super(Webmasters.this, "DELETE", REST_PATH, null, Void.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
                this.feedpath = (String)Preconditions.checkNotNull((Object)feedpath, (Object)"Required parameter feedpath must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Delete setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            public String getFeedpath() {
                return this.feedpath;
            }

            public Delete setFeedpath(String feedpath) {
                this.feedpath = feedpath;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Searchanalytics {
        public Query query(String siteUrl, SearchAnalyticsQueryRequest content) throws IOException {
            Query result = new Query(siteUrl, content);
            Webmasters.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Query
        extends WebmastersRequest<SearchAnalyticsQueryResponse> {
            private static final String REST_PATH = "sites/{siteUrl}/searchAnalytics/query";
            @Key
            private String siteUrl;

            protected Query(String siteUrl, SearchAnalyticsQueryRequest content) {
                super(Webmasters.this, "POST", REST_PATH, (Object)content, SearchAnalyticsQueryResponse.class);
                this.siteUrl = (String)Preconditions.checkNotNull((Object)siteUrl, (Object)"Required parameter siteUrl must be specified.");
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUserIp(String userIp) {
                return (Query)super.setUserIp(userIp);
            }

            public String getSiteUrl() {
                return this.siteUrl;
            }

            public Query setSiteUrl(String siteUrl) {
                this.siteUrl = siteUrl;
                return this;
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }
    }
}

