/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TransitObject.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TransitObject extends com.google.api.client.json.GenericJson {

  /**
   * The activation status for the object. Required if the class has `activationOptions` set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivationStatus activationStatus;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * The barcode type and value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Barcode barcode;

  /**
   * Required. The class associated with this object. The class must be of the same type as this
   * object, must already exist, and must be approved. Class IDs should follow the format issuer
   * ID.identifier where the former is issued by Google and latter is chosen by you.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String classId;

  /**
   * A copy of the inherited fields of the parent class. These fields are retrieved during a GET.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransitClass classReference;

  /**
   * The concession category for the ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String concessionCategory;

  /**
   * A custom concession category to use when `concessionCategory` does not provide the right
   * option. Both `concessionCategory` and `customConcessionCategory` may not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customConcessionCategory;

  /**
   * A custom status to use for the ticket status value when `ticketStatus` does not provide the
   * right option. Both `ticketStatus` and `customTicketStatus` may not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customTicketStatus;

  /**
   * Device context associated with the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeviceContext deviceContext;

  /**
   * Indicates if notifications should explicitly be suppressed. If this field is set to true,
   * regardless of the `messages` field, expiration notifications to the user will be suppressed. By
   * default, this field is set to false. Currently, this can only be set for offers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableExpirationNotification;

  /**
   * Information that controls how passes are grouped together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GroupingInfo groupingInfo;

  /**
   * Whether this object is currently linked to a single device. This field is set by the platform
   * when a user saves the object, linking it to their device. Intended for use by select partners.
   * Contact support for additional information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasLinkedDevice;

  /**
   * Indicates if the object has users. This field is set by the platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasUsers;

  /**
   * Optional banner image displayed on the front of the card. If none is present, hero image of the
   * class, if present, will be displayed. If hero image of the class is also not present, nothing
   * will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image heroImage;

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hexBackgroundColor;

  /**
   * Required. The unique identifier for an object. This ID must be unique across all objects from
   * an issuer. This value should follow the format issuer ID.identifier where the former is issued
   * by Google and latter is chosen by you. The unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  static {
    // hack to force ProGuard to consider ImageModuleData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ImageModuleData.class);
  }

  /**
   * Deprecated. Use textModulesData instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InfoModuleData infoModuleData;

  /**
   * linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
   * giftcard, transit and boarding pass that should be automatically attached to this transit
   * object. If a user had saved this transit card, then these linked_object_ids would be
   * automatically pushed to the user's wallet (unless they turned off the setting to receive such
   * linked passes). Make sure that objects present in linked_object_ids are already inserted - if
   * not, calls would fail. Once linked, the linked objects cannot be unlinked. You cannot link
   * objects belonging to another issuer. There is a limit to the number of objects that can be
   * linked to a single object. After the limit is reached, new linked objects in the call will be
   * ignored silently. Object IDs should follow the format issuer ID. identifier where the former is
   * issued by Google and the latter is chosen by you.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> linkedObjectIds;

  /**
   * Links module data. If links module data is also defined on the class, both will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LatLongPoint> locations;

  static {
    // hack to force ProGuard to consider LatLongPoint used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LatLongPoint.class);
  }

  /**
   * Merchant locations. There is a maximum of ten on the object. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  static {
    // hack to force ProGuard to consider MerchantLocation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MerchantLocation.class);
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  static {
    // hack to force ProGuard to consider Message used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Message.class);
  }

  /**
   * Whether or not field updates to this object should trigger notifications. When set to NOTIFY,
   * we will attempt to trigger a field update notification to users. These notifications will only
   * be sent to users if the field is part of an allowlist. If set to DO_NOT_NOTIFY or
   * NOTIFICATION_SETTINGS_UNSPECIFIED, no notification will be triggered. This setting is ephemeral
   * and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
   * triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notifyPreference;

  /**
   * Pass constraints for the object. Includes limiting NFC and screenshot behaviors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PassConstraints passConstraints;

  /**
   * The name(s) of the passengers the ticket is assigned to. The above `passengerType` field is
   * meant to give Google context on this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String passengerNames;

  /**
   * The number of passengers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String passengerType;

  /**
   * Purchase details for this ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PurchaseDetails purchaseDetails;

  /**
   * The rotating barcode type and value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RotatingBarcode rotatingBarcode;

  /**
   * Restrictions on the object that needs to be verified before the user tries to save the pass.
   * Note that this restrictions will only be applied during save time. If the restrictions changed
   * after a user saves the pass, the new restrictions will not be applied to an already saved pass.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SaveRestrictions saveRestrictions;

  /**
   * The value that will be transmitted to a Smart Tap certified terminal over NFC for this object.
   * The class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly
   * in order for the pass to support Smart Tap. Only ASCII characters are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String smartTapRedemptionValue;

  /**
   * Required. The state of the object. This field is used to determine how an object is displayed
   * in the app. For example, an `inactive` object is moved to the "Expired passes" section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  static {
    // hack to force ProGuard to consider TextModuleData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TextModuleData.class);
  }

  /**
   * A single ticket leg contains departure and arrival information along with boarding and seating
   * information. If more than one leg is to be specified then use the `ticketLegs` field instead.
   * Both `ticketLeg` and `ticketLegs` may not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TicketLeg ticketLeg;

  /**
   * Each ticket may contain one or more legs. Each leg contains departure and arrival information
   * along with boarding and seating information. If only one leg is to be specified then use the
   * `ticketLeg` field instead. Both `ticketLeg` and `ticketLegs` may not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TicketLeg> ticketLegs;

  static {
    // hack to force ProGuard to consider TicketLeg used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TicketLeg.class);
  }

  /**
   * The number of the ticket. This is a unique identifier for the ticket in the transit operator's
   * system.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ticketNumber;

  /**
   * Information about what kind of restrictions there are on using this ticket. For example, which
   * days of the week it must be used, or which routes are allowed to be taken.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TicketRestrictions ticketRestrictions;

  /**
   * The status of the ticket. For states which affect display, use the `state` field instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ticketStatus;

  /**
   * This id is used to group tickets together if the user has saved multiple tickets for the same
   * trip.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tripId;

  /**
   * Required. The type of trip this transit object represents. Used to determine the pass title
   * and/or which symbol to use between the origin and destination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tripType;

  /**
   * The time period this object will be `active` and object can be used. An object's state will be
   * changed to `expired` when this time period has passed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeInterval validTimeInterval;

  /**
   * Optional value added module data. Maximum of ten on the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * Deprecated
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * The activation status for the object. Required if the class has `activationOptions` set.
   * @return value or {@code null} for none
   */
  public ActivationStatus getActivationStatus() {
    return activationStatus;
  }

  /**
   * The activation status for the object. Required if the class has `activationOptions` set.
   * @param activationStatus activationStatus or {@code null} for none
   */
  public TransitObject setActivationStatus(ActivationStatus activationStatus) {
    this.activationStatus = activationStatus;
    return this;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public TransitObject setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * The barcode type and value.
   * @return value or {@code null} for none
   */
  public Barcode getBarcode() {
    return barcode;
  }

  /**
   * The barcode type and value.
   * @param barcode barcode or {@code null} for none
   */
  public TransitObject setBarcode(Barcode barcode) {
    this.barcode = barcode;
    return this;
  }

  /**
   * Required. The class associated with this object. The class must be of the same type as this
   * object, must already exist, and must be approved. Class IDs should follow the format issuer
   * ID.identifier where the former is issued by Google and latter is chosen by you.
   * @return value or {@code null} for none
   */
  public java.lang.String getClassId() {
    return classId;
  }

  /**
   * Required. The class associated with this object. The class must be of the same type as this
   * object, must already exist, and must be approved. Class IDs should follow the format issuer
   * ID.identifier where the former is issued by Google and latter is chosen by you.
   * @param classId classId or {@code null} for none
   */
  public TransitObject setClassId(java.lang.String classId) {
    this.classId = classId;
    return this;
  }

  /**
   * A copy of the inherited fields of the parent class. These fields are retrieved during a GET.
   * @return value or {@code null} for none
   */
  public TransitClass getClassReference() {
    return classReference;
  }

  /**
   * A copy of the inherited fields of the parent class. These fields are retrieved during a GET.
   * @param classReference classReference or {@code null} for none
   */
  public TransitObject setClassReference(TransitClass classReference) {
    this.classReference = classReference;
    return this;
  }

  /**
   * The concession category for the ticket.
   * @return value or {@code null} for none
   */
  public java.lang.String getConcessionCategory() {
    return concessionCategory;
  }

  /**
   * The concession category for the ticket.
   * @param concessionCategory concessionCategory or {@code null} for none
   */
  public TransitObject setConcessionCategory(java.lang.String concessionCategory) {
    this.concessionCategory = concessionCategory;
    return this;
  }

  /**
   * A custom concession category to use when `concessionCategory` does not provide the right
   * option. Both `concessionCategory` and `customConcessionCategory` may not be set.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomConcessionCategory() {
    return customConcessionCategory;
  }

  /**
   * A custom concession category to use when `concessionCategory` does not provide the right
   * option. Both `concessionCategory` and `customConcessionCategory` may not be set.
   * @param customConcessionCategory customConcessionCategory or {@code null} for none
   */
  public TransitObject setCustomConcessionCategory(LocalizedString customConcessionCategory) {
    this.customConcessionCategory = customConcessionCategory;
    return this;
  }

  /**
   * A custom status to use for the ticket status value when `ticketStatus` does not provide the
   * right option. Both `ticketStatus` and `customTicketStatus` may not be set.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomTicketStatus() {
    return customTicketStatus;
  }

  /**
   * A custom status to use for the ticket status value when `ticketStatus` does not provide the
   * right option. Both `ticketStatus` and `customTicketStatus` may not be set.
   * @param customTicketStatus customTicketStatus or {@code null} for none
   */
  public TransitObject setCustomTicketStatus(LocalizedString customTicketStatus) {
    this.customTicketStatus = customTicketStatus;
    return this;
  }

  /**
   * Device context associated with the object.
   * @return value or {@code null} for none
   */
  public DeviceContext getDeviceContext() {
    return deviceContext;
  }

  /**
   * Device context associated with the object.
   * @param deviceContext deviceContext or {@code null} for none
   */
  public TransitObject setDeviceContext(DeviceContext deviceContext) {
    this.deviceContext = deviceContext;
    return this;
  }

  /**
   * Indicates if notifications should explicitly be suppressed. If this field is set to true,
   * regardless of the `messages` field, expiration notifications to the user will be suppressed. By
   * default, this field is set to false. Currently, this can only be set for offers.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableExpirationNotification() {
    return disableExpirationNotification;
  }

  /**
   * Indicates if notifications should explicitly be suppressed. If this field is set to true,
   * regardless of the `messages` field, expiration notifications to the user will be suppressed. By
   * default, this field is set to false. Currently, this can only be set for offers.
   * @param disableExpirationNotification disableExpirationNotification or {@code null} for none
   */
  public TransitObject setDisableExpirationNotification(java.lang.Boolean disableExpirationNotification) {
    this.disableExpirationNotification = disableExpirationNotification;
    return this;
  }

  /**
   * Information that controls how passes are grouped together.
   * @return value or {@code null} for none
   */
  public GroupingInfo getGroupingInfo() {
    return groupingInfo;
  }

  /**
   * Information that controls how passes are grouped together.
   * @param groupingInfo groupingInfo or {@code null} for none
   */
  public TransitObject setGroupingInfo(GroupingInfo groupingInfo) {
    this.groupingInfo = groupingInfo;
    return this;
  }

  /**
   * Whether this object is currently linked to a single device. This field is set by the platform
   * when a user saves the object, linking it to their device. Intended for use by select partners.
   * Contact support for additional information.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasLinkedDevice() {
    return hasLinkedDevice;
  }

  /**
   * Whether this object is currently linked to a single device. This field is set by the platform
   * when a user saves the object, linking it to their device. Intended for use by select partners.
   * Contact support for additional information.
   * @param hasLinkedDevice hasLinkedDevice or {@code null} for none
   */
  public TransitObject setHasLinkedDevice(java.lang.Boolean hasLinkedDevice) {
    this.hasLinkedDevice = hasLinkedDevice;
    return this;
  }

  /**
   * Indicates if the object has users. This field is set by the platform.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasUsers() {
    return hasUsers;
  }

  /**
   * Indicates if the object has users. This field is set by the platform.
   * @param hasUsers hasUsers or {@code null} for none
   */
  public TransitObject setHasUsers(java.lang.Boolean hasUsers) {
    this.hasUsers = hasUsers;
    return this;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, hero image of the
   * class, if present, will be displayed. If hero image of the class is also not present, nothing
   * will be displayed.
   * @return value or {@code null} for none
   */
  public Image getHeroImage() {
    return heroImage;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, hero image of the
   * class, if present, will be displayed. If hero image of the class is also not present, nothing
   * will be displayed.
   * @param heroImage heroImage or {@code null} for none
   */
  public TransitObject setHeroImage(Image heroImage) {
    this.heroImage = heroImage;
    return this;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @return value or {@code null} for none
   */
  public java.lang.String getHexBackgroundColor() {
    return hexBackgroundColor;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @param hexBackgroundColor hexBackgroundColor or {@code null} for none
   */
  public TransitObject setHexBackgroundColor(java.lang.String hexBackgroundColor) {
    this.hexBackgroundColor = hexBackgroundColor;
    return this;
  }

  /**
   * Required. The unique identifier for an object. This ID must be unique across all objects from
   * an issuer. This value should follow the format issuer ID.identifier where the former is issued
   * by Google and latter is chosen by you. The unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for an object. This ID must be unique across all objects from
   * an issuer. This value should follow the format issuer ID.identifier where the former is issued
   * by Google and latter is chosen by you. The unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @param id id or {@code null} for none
   */
  public TransitObject setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public TransitObject setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @return value or {@code null} for none
   */
  public InfoModuleData getInfoModuleData() {
    return infoModuleData;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @param infoModuleData infoModuleData or {@code null} for none
   */
  public TransitObject setInfoModuleData(InfoModuleData infoModuleData) {
    this.infoModuleData = infoModuleData;
    return this;
  }

  /**
   * linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
   * giftcard, transit and boarding pass that should be automatically attached to this transit
   * object. If a user had saved this transit card, then these linked_object_ids would be
   * automatically pushed to the user's wallet (unless they turned off the setting to receive such
   * linked passes). Make sure that objects present in linked_object_ids are already inserted - if
   * not, calls would fail. Once linked, the linked objects cannot be unlinked. You cannot link
   * objects belonging to another issuer. There is a limit to the number of objects that can be
   * linked to a single object. After the limit is reached, new linked objects in the call will be
   * ignored silently. Object IDs should follow the format issuer ID. identifier where the former is
   * issued by Google and the latter is chosen by you.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLinkedObjectIds() {
    return linkedObjectIds;
  }

  /**
   * linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
   * giftcard, transit and boarding pass that should be automatically attached to this transit
   * object. If a user had saved this transit card, then these linked_object_ids would be
   * automatically pushed to the user's wallet (unless they turned off the setting to receive such
   * linked passes). Make sure that objects present in linked_object_ids are already inserted - if
   * not, calls would fail. Once linked, the linked objects cannot be unlinked. You cannot link
   * objects belonging to another issuer. There is a limit to the number of objects that can be
   * linked to a single object. After the limit is reached, new linked objects in the call will be
   * ignored silently. Object IDs should follow the format issuer ID. identifier where the former is
   * issued by Google and the latter is chosen by you.
   * @param linkedObjectIds linkedObjectIds or {@code null} for none
   */
  public TransitObject setLinkedObjectIds(java.util.List<java.lang.String> linkedObjectIds) {
    this.linkedObjectIds = linkedObjectIds;
    return this;
  }

  /**
   * Links module data. If links module data is also defined on the class, both will be displayed.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If links module data is also defined on the class, both will be displayed.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public TransitObject setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @return value or {@code null} for none
   */
  public java.util.List<LatLongPoint> getLocations() {
    return locations;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @param locations locations or {@code null} for none
   */
  public TransitObject setLocations(java.util.List<LatLongPoint> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the object. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the object. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public TransitObject setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public TransitObject setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * Whether or not field updates to this object should trigger notifications. When set to NOTIFY,
   * we will attempt to trigger a field update notification to users. These notifications will only
   * be sent to users if the field is part of an allowlist. If set to DO_NOT_NOTIFY or
   * NOTIFICATION_SETTINGS_UNSPECIFIED, no notification will be triggered. This setting is ephemeral
   * and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
   * triggered.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotifyPreference() {
    return notifyPreference;
  }

  /**
   * Whether or not field updates to this object should trigger notifications. When set to NOTIFY,
   * we will attempt to trigger a field update notification to users. These notifications will only
   * be sent to users if the field is part of an allowlist. If set to DO_NOT_NOTIFY or
   * NOTIFICATION_SETTINGS_UNSPECIFIED, no notification will be triggered. This setting is ephemeral
   * and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
   * triggered.
   * @param notifyPreference notifyPreference or {@code null} for none
   */
  public TransitObject setNotifyPreference(java.lang.String notifyPreference) {
    this.notifyPreference = notifyPreference;
    return this;
  }

  /**
   * Pass constraints for the object. Includes limiting NFC and screenshot behaviors.
   * @return value or {@code null} for none
   */
  public PassConstraints getPassConstraints() {
    return passConstraints;
  }

  /**
   * Pass constraints for the object. Includes limiting NFC and screenshot behaviors.
   * @param passConstraints passConstraints or {@code null} for none
   */
  public TransitObject setPassConstraints(PassConstraints passConstraints) {
    this.passConstraints = passConstraints;
    return this;
  }

  /**
   * The name(s) of the passengers the ticket is assigned to. The above `passengerType` field is
   * meant to give Google context on this field.
   * @return value or {@code null} for none
   */
  public java.lang.String getPassengerNames() {
    return passengerNames;
  }

  /**
   * The name(s) of the passengers the ticket is assigned to. The above `passengerType` field is
   * meant to give Google context on this field.
   * @param passengerNames passengerNames or {@code null} for none
   */
  public TransitObject setPassengerNames(java.lang.String passengerNames) {
    this.passengerNames = passengerNames;
    return this;
  }

  /**
   * The number of passengers.
   * @return value or {@code null} for none
   */
  public java.lang.String getPassengerType() {
    return passengerType;
  }

  /**
   * The number of passengers.
   * @param passengerType passengerType or {@code null} for none
   */
  public TransitObject setPassengerType(java.lang.String passengerType) {
    this.passengerType = passengerType;
    return this;
  }

  /**
   * Purchase details for this ticket.
   * @return value or {@code null} for none
   */
  public PurchaseDetails getPurchaseDetails() {
    return purchaseDetails;
  }

  /**
   * Purchase details for this ticket.
   * @param purchaseDetails purchaseDetails or {@code null} for none
   */
  public TransitObject setPurchaseDetails(PurchaseDetails purchaseDetails) {
    this.purchaseDetails = purchaseDetails;
    return this;
  }

  /**
   * The rotating barcode type and value.
   * @return value or {@code null} for none
   */
  public RotatingBarcode getRotatingBarcode() {
    return rotatingBarcode;
  }

  /**
   * The rotating barcode type and value.
   * @param rotatingBarcode rotatingBarcode or {@code null} for none
   */
  public TransitObject setRotatingBarcode(RotatingBarcode rotatingBarcode) {
    this.rotatingBarcode = rotatingBarcode;
    return this;
  }

  /**
   * Restrictions on the object that needs to be verified before the user tries to save the pass.
   * Note that this restrictions will only be applied during save time. If the restrictions changed
   * after a user saves the pass, the new restrictions will not be applied to an already saved pass.
   * @return value or {@code null} for none
   */
  public SaveRestrictions getSaveRestrictions() {
    return saveRestrictions;
  }

  /**
   * Restrictions on the object that needs to be verified before the user tries to save the pass.
   * Note that this restrictions will only be applied during save time. If the restrictions changed
   * after a user saves the pass, the new restrictions will not be applied to an already saved pass.
   * @param saveRestrictions saveRestrictions or {@code null} for none
   */
  public TransitObject setSaveRestrictions(SaveRestrictions saveRestrictions) {
    this.saveRestrictions = saveRestrictions;
    return this;
  }

  /**
   * The value that will be transmitted to a Smart Tap certified terminal over NFC for this object.
   * The class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly
   * in order for the pass to support Smart Tap. Only ASCII characters are supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getSmartTapRedemptionValue() {
    return smartTapRedemptionValue;
  }

  /**
   * The value that will be transmitted to a Smart Tap certified terminal over NFC for this object.
   * The class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly
   * in order for the pass to support Smart Tap. Only ASCII characters are supported.
   * @param smartTapRedemptionValue smartTapRedemptionValue or {@code null} for none
   */
  public TransitObject setSmartTapRedemptionValue(java.lang.String smartTapRedemptionValue) {
    this.smartTapRedemptionValue = smartTapRedemptionValue;
    return this;
  }

  /**
   * Required. The state of the object. This field is used to determine how an object is displayed
   * in the app. For example, an `inactive` object is moved to the "Expired passes" section.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Required. The state of the object. This field is used to determine how an object is displayed
   * in the app. For example, an `inactive` object is moved to the "Expired passes" section.
   * @param state state or {@code null} for none
   */
  public TransitObject setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public TransitObject setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * A single ticket leg contains departure and arrival information along with boarding and seating
   * information. If more than one leg is to be specified then use the `ticketLegs` field instead.
   * Both `ticketLeg` and `ticketLegs` may not be set.
   * @return value or {@code null} for none
   */
  public TicketLeg getTicketLeg() {
    return ticketLeg;
  }

  /**
   * A single ticket leg contains departure and arrival information along with boarding and seating
   * information. If more than one leg is to be specified then use the `ticketLegs` field instead.
   * Both `ticketLeg` and `ticketLegs` may not be set.
   * @param ticketLeg ticketLeg or {@code null} for none
   */
  public TransitObject setTicketLeg(TicketLeg ticketLeg) {
    this.ticketLeg = ticketLeg;
    return this;
  }

  /**
   * Each ticket may contain one or more legs. Each leg contains departure and arrival information
   * along with boarding and seating information. If only one leg is to be specified then use the
   * `ticketLeg` field instead. Both `ticketLeg` and `ticketLegs` may not be set.
   * @return value or {@code null} for none
   */
  public java.util.List<TicketLeg> getTicketLegs() {
    return ticketLegs;
  }

  /**
   * Each ticket may contain one or more legs. Each leg contains departure and arrival information
   * along with boarding and seating information. If only one leg is to be specified then use the
   * `ticketLeg` field instead. Both `ticketLeg` and `ticketLegs` may not be set.
   * @param ticketLegs ticketLegs or {@code null} for none
   */
  public TransitObject setTicketLegs(java.util.List<TicketLeg> ticketLegs) {
    this.ticketLegs = ticketLegs;
    return this;
  }

  /**
   * The number of the ticket. This is a unique identifier for the ticket in the transit operator's
   * system.
   * @return value or {@code null} for none
   */
  public java.lang.String getTicketNumber() {
    return ticketNumber;
  }

  /**
   * The number of the ticket. This is a unique identifier for the ticket in the transit operator's
   * system.
   * @param ticketNumber ticketNumber or {@code null} for none
   */
  public TransitObject setTicketNumber(java.lang.String ticketNumber) {
    this.ticketNumber = ticketNumber;
    return this;
  }

  /**
   * Information about what kind of restrictions there are on using this ticket. For example, which
   * days of the week it must be used, or which routes are allowed to be taken.
   * @return value or {@code null} for none
   */
  public TicketRestrictions getTicketRestrictions() {
    return ticketRestrictions;
  }

  /**
   * Information about what kind of restrictions there are on using this ticket. For example, which
   * days of the week it must be used, or which routes are allowed to be taken.
   * @param ticketRestrictions ticketRestrictions or {@code null} for none
   */
  public TransitObject setTicketRestrictions(TicketRestrictions ticketRestrictions) {
    this.ticketRestrictions = ticketRestrictions;
    return this;
  }

  /**
   * The status of the ticket. For states which affect display, use the `state` field instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getTicketStatus() {
    return ticketStatus;
  }

  /**
   * The status of the ticket. For states which affect display, use the `state` field instead.
   * @param ticketStatus ticketStatus or {@code null} for none
   */
  public TransitObject setTicketStatus(java.lang.String ticketStatus) {
    this.ticketStatus = ticketStatus;
    return this;
  }

  /**
   * This id is used to group tickets together if the user has saved multiple tickets for the same
   * trip.
   * @return value or {@code null} for none
   */
  public java.lang.String getTripId() {
    return tripId;
  }

  /**
   * This id is used to group tickets together if the user has saved multiple tickets for the same
   * trip.
   * @param tripId tripId or {@code null} for none
   */
  public TransitObject setTripId(java.lang.String tripId) {
    this.tripId = tripId;
    return this;
  }

  /**
   * Required. The type of trip this transit object represents. Used to determine the pass title
   * and/or which symbol to use between the origin and destination.
   * @return value or {@code null} for none
   */
  public java.lang.String getTripType() {
    return tripType;
  }

  /**
   * Required. The type of trip this transit object represents. Used to determine the pass title
   * and/or which symbol to use between the origin and destination.
   * @param tripType tripType or {@code null} for none
   */
  public TransitObject setTripType(java.lang.String tripType) {
    this.tripType = tripType;
    return this;
  }

  /**
   * The time period this object will be `active` and object can be used. An object's state will be
   * changed to `expired` when this time period has passed.
   * @return value or {@code null} for none
   */
  public TimeInterval getValidTimeInterval() {
    return validTimeInterval;
  }

  /**
   * The time period this object will be `active` and object can be used. An object's state will be
   * changed to `expired` when this time period has passed.
   * @param validTimeInterval validTimeInterval or {@code null} for none
   */
  public TransitObject setValidTimeInterval(TimeInterval validTimeInterval) {
    this.validTimeInterval = validTimeInterval;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public TransitObject setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * Deprecated
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Deprecated
   * @param version version or {@code null} for none
   */
  public TransitObject setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  @Override
  public TransitObject set(String fieldName, Object value) {
    return (TransitObject) super.set(fieldName, value);
  }

  @Override
  public TransitObject clone() {
    return (TransitObject) super.clone();
  }

}
