/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TransitClass.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TransitClass extends com.google.api.client.json.GenericJson {

  /**
   * Activation options for an activatable ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActivationOptions activationOptions;

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowMultipleUsersPerObject;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CallbackOptions callbackOptions;

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClassTemplateInfo classTemplateInfo;

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * A custom label to use for the carriage value (`transitObject.ticketLeg.carriage`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customCarriageLabel;

  /**
   * A custom label to use for the coach value (`transitObject.ticketLeg.ticketSeat.coach`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customCoachLabel;

  /**
   * A custom label to use for the transit concession category value
   * (`transitObject.concessionCategory`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customConcessionCategoryLabel;

  /**
   * A custom label to use for the confirmation code value
   * (`transitObject.purchaseDetails.confirmationCode`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customConfirmationCodeLabel;

  /**
   * A custom label to use for the transit discount message value
   * (`transitObject.purchaseDetails.ticketCost.discountMessage`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customDiscountMessageLabel;

  /**
   * A custom label to use for the fare class value
   * (`transitObject.ticketLeg.ticketSeat.fareClass`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customFareClassLabel;

  /**
   * A custom label to use for the transit fare name value (`transitObject.ticketLeg.fareName`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customFareNameLabel;

  /**
   * A custom label to use for the other restrictions value
   * (`transitObject.ticketRestrictions.otherRestrictions`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customOtherRestrictionsLabel;

  /**
   * A custom label to use for the boarding platform value (`transitObject.ticketLeg.platform`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customPlatformLabel;

  /**
   * A custom label to use for the purchase face value
   * (`transitObject.purchaseDetails.ticketCost.faceValue`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customPurchaseFaceValueLabel;

  /**
   * A custom label to use for the purchase price value
   * (`transitObject.purchaseDetails.ticketCost.purchasePrice`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customPurchasePriceLabel;

  /**
   * A custom label to use for the purchase receipt number value
   * (`transitObject.purchaseDetails.purchaseReceiptNumber`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customPurchaseReceiptNumberLabel;

  /**
   * A custom label to use for the route restrictions details value
   * (`transitObject.ticketRestrictions.routeRestrictionsDetails`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customRouteRestrictionsDetailsLabel;

  /**
   * A custom label to use for the route restrictions value
   * (`transitObject.ticketRestrictions.routeRestrictions`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customRouteRestrictionsLabel;

  /**
   * A custom label to use for the seat location value (`transitObject.ticketLeg.ticketSeat.seat`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customSeatLabel;

  /**
   * A custom label to use for the ticket number value (`transitObject.ticketNumber`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customTicketNumberLabel;

  /**
   * A custom label to use for the time restrictions details value
   * (`transitObject.ticketRestrictions.timeRestrictions`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customTimeRestrictionsLabel;

  /**
   * A custom label to use for the transit terminus name value
   * (`transitObject.ticketLeg.transitTerminusName`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customTransitTerminusNameLabel;

  /**
   * A custom label to use for the boarding zone value (`transitObject.ticketLeg.zone`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customZoneLabel;

  /**
   * Controls the display of the single-leg itinerary for this class. By default, an itinerary will
   * only display for multi-leg trips.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSingleLegItinerary;

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSmartTap;

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image heroImage;

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hexBackgroundColor;

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uri homepageUri;

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  static {
    // hack to force ProGuard to consider ImageModuleData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ImageModuleData.class);
  }

  /**
   * Deprecated. Use textModulesData instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InfoModuleData infoModuleData;

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuerName;

  /**
   * If this field is present, transit tickets served to a user's device will always be in this
   * language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or
   * "de-AT".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageOverride;

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedIssuerName;

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LatLongPoint> locations;

  static {
    // hack to force ProGuard to consider LatLongPoint used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LatLongPoint.class);
  }

  /**
   * Required. The logo image of the ticket. This image is displayed in the card detail view of the
   * app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image logo;

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  static {
    // hack to force ProGuard to consider MerchantLocation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MerchantLocation.class);
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  static {
    // hack to force ProGuard to consider Message used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Message.class);
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multipleDevicesAndHoldersAllowedStatus;

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If set to DO_NOT_NOTIFY or
   * NOTIFICATION_SETTINGS_UNSPECIFIED, no notification will be triggered. This setting is ephemeral
   * and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
   * triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notifyPreference;

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> redemptionIssuers;

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Review review;

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewStatus;

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityAnimation securityAnimation;

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  static {
    // hack to force ProGuard to consider TextModuleData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TextModuleData.class);
  }

  /**
   * The name of the transit operator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString transitOperatorName;

  /**
   * Required. The type of transit this class represents, such as "bus".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transitType;

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * Deprecated
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * View Unlock Requirement options for the transit ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String viewUnlockRequirement;

  /**
   * Watermark image to display on the user's device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image watermark;

  /**
   * The wide logo of the ticket. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wideLogo;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wordMark;

  /**
   * Activation options for an activatable ticket.
   * @return value or {@code null} for none
   */
  public ActivationOptions getActivationOptions() {
    return activationOptions;
  }

  /**
   * Activation options for an activatable ticket.
   * @param activationOptions activationOptions or {@code null} for none
   */
  public TransitClass setActivationOptions(ActivationOptions activationOptions) {
    this.activationOptions = activationOptions;
    return this;
  }

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowMultipleUsersPerObject() {
    return allowMultipleUsersPerObject;
  }

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @param allowMultipleUsersPerObject allowMultipleUsersPerObject or {@code null} for none
   */
  public TransitClass setAllowMultipleUsersPerObject(java.lang.Boolean allowMultipleUsersPerObject) {
    this.allowMultipleUsersPerObject = allowMultipleUsersPerObject;
    return this;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public TransitClass setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @return value or {@code null} for none
   */
  public CallbackOptions getCallbackOptions() {
    return callbackOptions;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @param callbackOptions callbackOptions or {@code null} for none
   */
  public TransitClass setCallbackOptions(CallbackOptions callbackOptions) {
    this.callbackOptions = callbackOptions;
    return this;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @return value or {@code null} for none
   */
  public ClassTemplateInfo getClassTemplateInfo() {
    return classTemplateInfo;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @param classTemplateInfo classTemplateInfo or {@code null} for none
   */
  public TransitClass setClassTemplateInfo(ClassTemplateInfo classTemplateInfo) {
    this.classTemplateInfo = classTemplateInfo;
    return this;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @param countryCode countryCode or {@code null} for none
   */
  public TransitClass setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * A custom label to use for the carriage value (`transitObject.ticketLeg.carriage`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomCarriageLabel() {
    return customCarriageLabel;
  }

  /**
   * A custom label to use for the carriage value (`transitObject.ticketLeg.carriage`).
   * @param customCarriageLabel customCarriageLabel or {@code null} for none
   */
  public TransitClass setCustomCarriageLabel(LocalizedString customCarriageLabel) {
    this.customCarriageLabel = customCarriageLabel;
    return this;
  }

  /**
   * A custom label to use for the coach value (`transitObject.ticketLeg.ticketSeat.coach`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomCoachLabel() {
    return customCoachLabel;
  }

  /**
   * A custom label to use for the coach value (`transitObject.ticketLeg.ticketSeat.coach`).
   * @param customCoachLabel customCoachLabel or {@code null} for none
   */
  public TransitClass setCustomCoachLabel(LocalizedString customCoachLabel) {
    this.customCoachLabel = customCoachLabel;
    return this;
  }

  /**
   * A custom label to use for the transit concession category value
   * (`transitObject.concessionCategory`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomConcessionCategoryLabel() {
    return customConcessionCategoryLabel;
  }

  /**
   * A custom label to use for the transit concession category value
   * (`transitObject.concessionCategory`).
   * @param customConcessionCategoryLabel customConcessionCategoryLabel or {@code null} for none
   */
  public TransitClass setCustomConcessionCategoryLabel(LocalizedString customConcessionCategoryLabel) {
    this.customConcessionCategoryLabel = customConcessionCategoryLabel;
    return this;
  }

  /**
   * A custom label to use for the confirmation code value
   * (`transitObject.purchaseDetails.confirmationCode`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomConfirmationCodeLabel() {
    return customConfirmationCodeLabel;
  }

  /**
   * A custom label to use for the confirmation code value
   * (`transitObject.purchaseDetails.confirmationCode`).
   * @param customConfirmationCodeLabel customConfirmationCodeLabel or {@code null} for none
   */
  public TransitClass setCustomConfirmationCodeLabel(LocalizedString customConfirmationCodeLabel) {
    this.customConfirmationCodeLabel = customConfirmationCodeLabel;
    return this;
  }

  /**
   * A custom label to use for the transit discount message value
   * (`transitObject.purchaseDetails.ticketCost.discountMessage`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomDiscountMessageLabel() {
    return customDiscountMessageLabel;
  }

  /**
   * A custom label to use for the transit discount message value
   * (`transitObject.purchaseDetails.ticketCost.discountMessage`).
   * @param customDiscountMessageLabel customDiscountMessageLabel or {@code null} for none
   */
  public TransitClass setCustomDiscountMessageLabel(LocalizedString customDiscountMessageLabel) {
    this.customDiscountMessageLabel = customDiscountMessageLabel;
    return this;
  }

  /**
   * A custom label to use for the fare class value
   * (`transitObject.ticketLeg.ticketSeat.fareClass`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomFareClassLabel() {
    return customFareClassLabel;
  }

  /**
   * A custom label to use for the fare class value
   * (`transitObject.ticketLeg.ticketSeat.fareClass`).
   * @param customFareClassLabel customFareClassLabel or {@code null} for none
   */
  public TransitClass setCustomFareClassLabel(LocalizedString customFareClassLabel) {
    this.customFareClassLabel = customFareClassLabel;
    return this;
  }

  /**
   * A custom label to use for the transit fare name value (`transitObject.ticketLeg.fareName`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomFareNameLabel() {
    return customFareNameLabel;
  }

  /**
   * A custom label to use for the transit fare name value (`transitObject.ticketLeg.fareName`).
   * @param customFareNameLabel customFareNameLabel or {@code null} for none
   */
  public TransitClass setCustomFareNameLabel(LocalizedString customFareNameLabel) {
    this.customFareNameLabel = customFareNameLabel;
    return this;
  }

  /**
   * A custom label to use for the other restrictions value
   * (`transitObject.ticketRestrictions.otherRestrictions`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomOtherRestrictionsLabel() {
    return customOtherRestrictionsLabel;
  }

  /**
   * A custom label to use for the other restrictions value
   * (`transitObject.ticketRestrictions.otherRestrictions`).
   * @param customOtherRestrictionsLabel customOtherRestrictionsLabel or {@code null} for none
   */
  public TransitClass setCustomOtherRestrictionsLabel(LocalizedString customOtherRestrictionsLabel) {
    this.customOtherRestrictionsLabel = customOtherRestrictionsLabel;
    return this;
  }

  /**
   * A custom label to use for the boarding platform value (`transitObject.ticketLeg.platform`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomPlatformLabel() {
    return customPlatformLabel;
  }

  /**
   * A custom label to use for the boarding platform value (`transitObject.ticketLeg.platform`).
   * @param customPlatformLabel customPlatformLabel or {@code null} for none
   */
  public TransitClass setCustomPlatformLabel(LocalizedString customPlatformLabel) {
    this.customPlatformLabel = customPlatformLabel;
    return this;
  }

  /**
   * A custom label to use for the purchase face value
   * (`transitObject.purchaseDetails.ticketCost.faceValue`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomPurchaseFaceValueLabel() {
    return customPurchaseFaceValueLabel;
  }

  /**
   * A custom label to use for the purchase face value
   * (`transitObject.purchaseDetails.ticketCost.faceValue`).
   * @param customPurchaseFaceValueLabel customPurchaseFaceValueLabel or {@code null} for none
   */
  public TransitClass setCustomPurchaseFaceValueLabel(LocalizedString customPurchaseFaceValueLabel) {
    this.customPurchaseFaceValueLabel = customPurchaseFaceValueLabel;
    return this;
  }

  /**
   * A custom label to use for the purchase price value
   * (`transitObject.purchaseDetails.ticketCost.purchasePrice`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomPurchasePriceLabel() {
    return customPurchasePriceLabel;
  }

  /**
   * A custom label to use for the purchase price value
   * (`transitObject.purchaseDetails.ticketCost.purchasePrice`).
   * @param customPurchasePriceLabel customPurchasePriceLabel or {@code null} for none
   */
  public TransitClass setCustomPurchasePriceLabel(LocalizedString customPurchasePriceLabel) {
    this.customPurchasePriceLabel = customPurchasePriceLabel;
    return this;
  }

  /**
   * A custom label to use for the purchase receipt number value
   * (`transitObject.purchaseDetails.purchaseReceiptNumber`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomPurchaseReceiptNumberLabel() {
    return customPurchaseReceiptNumberLabel;
  }

  /**
   * A custom label to use for the purchase receipt number value
   * (`transitObject.purchaseDetails.purchaseReceiptNumber`).
   * @param customPurchaseReceiptNumberLabel customPurchaseReceiptNumberLabel or {@code null} for none
   */
  public TransitClass setCustomPurchaseReceiptNumberLabel(LocalizedString customPurchaseReceiptNumberLabel) {
    this.customPurchaseReceiptNumberLabel = customPurchaseReceiptNumberLabel;
    return this;
  }

  /**
   * A custom label to use for the route restrictions details value
   * (`transitObject.ticketRestrictions.routeRestrictionsDetails`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomRouteRestrictionsDetailsLabel() {
    return customRouteRestrictionsDetailsLabel;
  }

  /**
   * A custom label to use for the route restrictions details value
   * (`transitObject.ticketRestrictions.routeRestrictionsDetails`).
   * @param customRouteRestrictionsDetailsLabel customRouteRestrictionsDetailsLabel or {@code null} for none
   */
  public TransitClass setCustomRouteRestrictionsDetailsLabel(LocalizedString customRouteRestrictionsDetailsLabel) {
    this.customRouteRestrictionsDetailsLabel = customRouteRestrictionsDetailsLabel;
    return this;
  }

  /**
   * A custom label to use for the route restrictions value
   * (`transitObject.ticketRestrictions.routeRestrictions`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomRouteRestrictionsLabel() {
    return customRouteRestrictionsLabel;
  }

  /**
   * A custom label to use for the route restrictions value
   * (`transitObject.ticketRestrictions.routeRestrictions`).
   * @param customRouteRestrictionsLabel customRouteRestrictionsLabel or {@code null} for none
   */
  public TransitClass setCustomRouteRestrictionsLabel(LocalizedString customRouteRestrictionsLabel) {
    this.customRouteRestrictionsLabel = customRouteRestrictionsLabel;
    return this;
  }

  /**
   * A custom label to use for the seat location value (`transitObject.ticketLeg.ticketSeat.seat`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomSeatLabel() {
    return customSeatLabel;
  }

  /**
   * A custom label to use for the seat location value (`transitObject.ticketLeg.ticketSeat.seat`).
   * @param customSeatLabel customSeatLabel or {@code null} for none
   */
  public TransitClass setCustomSeatLabel(LocalizedString customSeatLabel) {
    this.customSeatLabel = customSeatLabel;
    return this;
  }

  /**
   * A custom label to use for the ticket number value (`transitObject.ticketNumber`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomTicketNumberLabel() {
    return customTicketNumberLabel;
  }

  /**
   * A custom label to use for the ticket number value (`transitObject.ticketNumber`).
   * @param customTicketNumberLabel customTicketNumberLabel or {@code null} for none
   */
  public TransitClass setCustomTicketNumberLabel(LocalizedString customTicketNumberLabel) {
    this.customTicketNumberLabel = customTicketNumberLabel;
    return this;
  }

  /**
   * A custom label to use for the time restrictions details value
   * (`transitObject.ticketRestrictions.timeRestrictions`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomTimeRestrictionsLabel() {
    return customTimeRestrictionsLabel;
  }

  /**
   * A custom label to use for the time restrictions details value
   * (`transitObject.ticketRestrictions.timeRestrictions`).
   * @param customTimeRestrictionsLabel customTimeRestrictionsLabel or {@code null} for none
   */
  public TransitClass setCustomTimeRestrictionsLabel(LocalizedString customTimeRestrictionsLabel) {
    this.customTimeRestrictionsLabel = customTimeRestrictionsLabel;
    return this;
  }

  /**
   * A custom label to use for the transit terminus name value
   * (`transitObject.ticketLeg.transitTerminusName`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomTransitTerminusNameLabel() {
    return customTransitTerminusNameLabel;
  }

  /**
   * A custom label to use for the transit terminus name value
   * (`transitObject.ticketLeg.transitTerminusName`).
   * @param customTransitTerminusNameLabel customTransitTerminusNameLabel or {@code null} for none
   */
  public TransitClass setCustomTransitTerminusNameLabel(LocalizedString customTransitTerminusNameLabel) {
    this.customTransitTerminusNameLabel = customTransitTerminusNameLabel;
    return this;
  }

  /**
   * A custom label to use for the boarding zone value (`transitObject.ticketLeg.zone`).
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomZoneLabel() {
    return customZoneLabel;
  }

  /**
   * A custom label to use for the boarding zone value (`transitObject.ticketLeg.zone`).
   * @param customZoneLabel customZoneLabel or {@code null} for none
   */
  public TransitClass setCustomZoneLabel(LocalizedString customZoneLabel) {
    this.customZoneLabel = customZoneLabel;
    return this;
  }

  /**
   * Controls the display of the single-leg itinerary for this class. By default, an itinerary will
   * only display for multi-leg trips.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSingleLegItinerary() {
    return enableSingleLegItinerary;
  }

  /**
   * Controls the display of the single-leg itinerary for this class. By default, an itinerary will
   * only display for multi-leg trips.
   * @param enableSingleLegItinerary enableSingleLegItinerary or {@code null} for none
   */
  public TransitClass setEnableSingleLegItinerary(java.lang.Boolean enableSingleLegItinerary) {
    this.enableSingleLegItinerary = enableSingleLegItinerary;
    return this;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSmartTap() {
    return enableSmartTap;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @param enableSmartTap enableSmartTap or {@code null} for none
   */
  public TransitClass setEnableSmartTap(java.lang.Boolean enableSmartTap) {
    this.enableSmartTap = enableSmartTap;
    return this;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @return value or {@code null} for none
   */
  public Image getHeroImage() {
    return heroImage;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @param heroImage heroImage or {@code null} for none
   */
  public TransitClass setHeroImage(Image heroImage) {
    this.heroImage = heroImage;
    return this;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @return value or {@code null} for none
   */
  public java.lang.String getHexBackgroundColor() {
    return hexBackgroundColor;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @param hexBackgroundColor hexBackgroundColor or {@code null} for none
   */
  public TransitClass setHexBackgroundColor(java.lang.String hexBackgroundColor) {
    this.hexBackgroundColor = hexBackgroundColor;
    return this;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @return value or {@code null} for none
   */
  public Uri getHomepageUri() {
    return homepageUri;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @param homepageUri homepageUri or {@code null} for none
   */
  public TransitClass setHomepageUri(Uri homepageUri) {
    this.homepageUri = homepageUri;
    return this;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @param id id or {@code null} for none
   */
  public TransitClass setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public TransitClass setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @return value or {@code null} for none
   */
  public InfoModuleData getInfoModuleData() {
    return infoModuleData;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @param infoModuleData infoModuleData or {@code null} for none
   */
  public TransitClass setInfoModuleData(InfoModuleData infoModuleData) {
    this.infoModuleData = infoModuleData;
    return this;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuerName() {
    return issuerName;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @param issuerName issuerName or {@code null} for none
   */
  public TransitClass setIssuerName(java.lang.String issuerName) {
    this.issuerName = issuerName;
    return this;
  }

  /**
   * If this field is present, transit tickets served to a user's device will always be in this
   * language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or
   * "de-AT".
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageOverride() {
    return languageOverride;
  }

  /**
   * If this field is present, transit tickets served to a user's device will always be in this
   * language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or
   * "de-AT".
   * @param languageOverride languageOverride or {@code null} for none
   */
  public TransitClass setLanguageOverride(java.lang.String languageOverride) {
    this.languageOverride = languageOverride;
    return this;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public TransitClass setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedIssuerName() {
    return localizedIssuerName;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @param localizedIssuerName localizedIssuerName or {@code null} for none
   */
  public TransitClass setLocalizedIssuerName(LocalizedString localizedIssuerName) {
    this.localizedIssuerName = localizedIssuerName;
    return this;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @return value or {@code null} for none
   */
  public java.util.List<LatLongPoint> getLocations() {
    return locations;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @param locations locations or {@code null} for none
   */
  public TransitClass setLocations(java.util.List<LatLongPoint> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * Required. The logo image of the ticket. This image is displayed in the card detail view of the
   * app.
   * @return value or {@code null} for none
   */
  public Image getLogo() {
    return logo;
  }

  /**
   * Required. The logo image of the ticket. This image is displayed in the card detail view of the
   * app.
   * @param logo logo or {@code null} for none
   */
  public TransitClass setLogo(Image logo) {
    this.logo = logo;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public TransitClass setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public TransitClass setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @return value or {@code null} for none
   */
  public java.lang.String getMultipleDevicesAndHoldersAllowedStatus() {
    return multipleDevicesAndHoldersAllowedStatus;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @param multipleDevicesAndHoldersAllowedStatus multipleDevicesAndHoldersAllowedStatus or {@code null} for none
   */
  public TransitClass setMultipleDevicesAndHoldersAllowedStatus(java.lang.String multipleDevicesAndHoldersAllowedStatus) {
    this.multipleDevicesAndHoldersAllowedStatus = multipleDevicesAndHoldersAllowedStatus;
    return this;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If set to DO_NOT_NOTIFY or
   * NOTIFICATION_SETTINGS_UNSPECIFIED, no notification will be triggered. This setting is ephemeral
   * and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
   * triggered.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotifyPreference() {
    return notifyPreference;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If set to DO_NOT_NOTIFY or
   * NOTIFICATION_SETTINGS_UNSPECIFIED, no notification will be triggered. This setting is ephemeral
   * and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
   * triggered.
   * @param notifyPreference notifyPreference or {@code null} for none
   */
  public TransitClass setNotifyPreference(java.lang.String notifyPreference) {
    this.notifyPreference = notifyPreference;
    return this;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getRedemptionIssuers() {
    return redemptionIssuers;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @param redemptionIssuers redemptionIssuers or {@code null} for none
   */
  public TransitClass setRedemptionIssuers(java.util.List<java.lang.Long> redemptionIssuers) {
    this.redemptionIssuers = redemptionIssuers;
    return this;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @return value or {@code null} for none
   */
  public Review getReview() {
    return review;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @param review review or {@code null} for none
   */
  public TransitClass setReview(Review review) {
    this.review = review;
    return this;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewStatus() {
    return reviewStatus;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @param reviewStatus reviewStatus or {@code null} for none
   */
  public TransitClass setReviewStatus(java.lang.String reviewStatus) {
    this.reviewStatus = reviewStatus;
    return this;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @return value or {@code null} for none
   */
  public SecurityAnimation getSecurityAnimation() {
    return securityAnimation;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @param securityAnimation securityAnimation or {@code null} for none
   */
  public TransitClass setSecurityAnimation(SecurityAnimation securityAnimation) {
    this.securityAnimation = securityAnimation;
    return this;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public TransitClass setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * The name of the transit operator.
   * @return value or {@code null} for none
   */
  public LocalizedString getTransitOperatorName() {
    return transitOperatorName;
  }

  /**
   * The name of the transit operator.
   * @param transitOperatorName transitOperatorName or {@code null} for none
   */
  public TransitClass setTransitOperatorName(LocalizedString transitOperatorName) {
    this.transitOperatorName = transitOperatorName;
    return this;
  }

  /**
   * Required. The type of transit this class represents, such as "bus".
   * @return value or {@code null} for none
   */
  public java.lang.String getTransitType() {
    return transitType;
  }

  /**
   * Required. The type of transit this class represents, such as "bus".
   * @param transitType transitType or {@code null} for none
   */
  public TransitClass setTransitType(java.lang.String transitType) {
    this.transitType = transitType;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public TransitClass setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * Deprecated
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Deprecated
   * @param version version or {@code null} for none
   */
  public TransitClass setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * View Unlock Requirement options for the transit ticket.
   * @return value or {@code null} for none
   */
  public java.lang.String getViewUnlockRequirement() {
    return viewUnlockRequirement;
  }

  /**
   * View Unlock Requirement options for the transit ticket.
   * @param viewUnlockRequirement viewUnlockRequirement or {@code null} for none
   */
  public TransitClass setViewUnlockRequirement(java.lang.String viewUnlockRequirement) {
    this.viewUnlockRequirement = viewUnlockRequirement;
    return this;
  }

  /**
   * Watermark image to display on the user's device.
   * @return value or {@code null} for none
   */
  public Image getWatermark() {
    return watermark;
  }

  /**
   * Watermark image to display on the user's device.
   * @param watermark watermark or {@code null} for none
   */
  public TransitClass setWatermark(Image watermark) {
    this.watermark = watermark;
    return this;
  }

  /**
   * The wide logo of the ticket. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * @return value or {@code null} for none
   */
  public Image getWideLogo() {
    return wideLogo;
  }

  /**
   * The wide logo of the ticket. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * @param wideLogo wideLogo or {@code null} for none
   */
  public TransitClass setWideLogo(Image wideLogo) {
    this.wideLogo = wideLogo;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public Image getWordMark() {
    return wordMark;
  }

  /**
   * Deprecated.
   * @param wordMark wordMark or {@code null} for none
   */
  public TransitClass setWordMark(Image wordMark) {
    this.wordMark = wordMark;
    return this;
  }

  @Override
  public TransitClass set(String fieldName, Object value) {
    return (TransitClass) super.set(fieldName, value);
  }

  @Override
  public TransitClass clone() {
    return (TransitClass) super.clone();
  }

}
