/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TicketSeat.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TicketSeat extends com.google.api.client.json.GenericJson {

  /**
   * The identifier of the train car or coach in which the ticketed seat is located. Eg. "10"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String coach;

  /**
   * A custome fare class to be used if no `fareClass` applies. Both `fareClass` and
   * `customFareClass` may not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customFareClass;

  /**
   * The fare class of the ticketed seat.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fareClass;

  /**
   * The identifier of where the ticketed seat is located. Eg. "42". If there is no specific
   * identifier, use `seatAssigment` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String seat;

  /**
   * The passenger's seat assignment. Eg. "no specific seat". To be used when there is no specific
   * identifier to use in `seat`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString seatAssignment;

  /**
   * The identifier of the train car or coach in which the ticketed seat is located. Eg. "10"
   * @return value or {@code null} for none
   */
  public java.lang.String getCoach() {
    return coach;
  }

  /**
   * The identifier of the train car or coach in which the ticketed seat is located. Eg. "10"
   * @param coach coach or {@code null} for none
   */
  public TicketSeat setCoach(java.lang.String coach) {
    this.coach = coach;
    return this;
  }

  /**
   * A custome fare class to be used if no `fareClass` applies. Both `fareClass` and
   * `customFareClass` may not be set.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomFareClass() {
    return customFareClass;
  }

  /**
   * A custome fare class to be used if no `fareClass` applies. Both `fareClass` and
   * `customFareClass` may not be set.
   * @param customFareClass customFareClass or {@code null} for none
   */
  public TicketSeat setCustomFareClass(LocalizedString customFareClass) {
    this.customFareClass = customFareClass;
    return this;
  }

  /**
   * The fare class of the ticketed seat.
   * @return value or {@code null} for none
   */
  public java.lang.String getFareClass() {
    return fareClass;
  }

  /**
   * The fare class of the ticketed seat.
   * @param fareClass fareClass or {@code null} for none
   */
  public TicketSeat setFareClass(java.lang.String fareClass) {
    this.fareClass = fareClass;
    return this;
  }

  /**
   * The identifier of where the ticketed seat is located. Eg. "42". If there is no specific
   * identifier, use `seatAssigment` instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeat() {
    return seat;
  }

  /**
   * The identifier of where the ticketed seat is located. Eg. "42". If there is no specific
   * identifier, use `seatAssigment` instead.
   * @param seat seat or {@code null} for none
   */
  public TicketSeat setSeat(java.lang.String seat) {
    this.seat = seat;
    return this;
  }

  /**
   * The passenger's seat assignment. Eg. "no specific seat". To be used when there is no specific
   * identifier to use in `seat`.
   * @return value or {@code null} for none
   */
  public LocalizedString getSeatAssignment() {
    return seatAssignment;
  }

  /**
   * The passenger's seat assignment. Eg. "no specific seat". To be used when there is no specific
   * identifier to use in `seat`.
   * @param seatAssignment seatAssignment or {@code null} for none
   */
  public TicketSeat setSeatAssignment(LocalizedString seatAssignment) {
    this.seatAssignment = seatAssignment;
    return this;
  }

  @Override
  public TicketSeat set(String fieldName, Object value) {
    return (TicketSeat) super.set(fieldName, value);
  }

  @Override
  public TicketSeat clone() {
    return (TicketSeat) super.clone();
  }

}
