/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for SmartTapMerchantData.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SmartTapMerchantData extends com.google.api.client.json.GenericJson {

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AuthenticationKey> authenticationKeys;

  static {
    // hack to force ProGuard to consider AuthenticationKey used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AuthenticationKey.class);
  }

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long smartTapMerchantId;

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * @return value or {@code null} for none
   */
  public java.util.List<AuthenticationKey> getAuthenticationKeys() {
    return authenticationKeys;
  }

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * @param authenticationKeys authenticationKeys or {@code null} for none
   */
  public SmartTapMerchantData setAuthenticationKeys(java.util.List<AuthenticationKey> authenticationKeys) {
    this.authenticationKeys = authenticationKeys;
    return this;
  }

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSmartTapMerchantId() {
    return smartTapMerchantId;
  }

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * @param smartTapMerchantId smartTapMerchantId or {@code null} for none
   */
  public SmartTapMerchantData setSmartTapMerchantId(java.lang.Long smartTapMerchantId) {
    this.smartTapMerchantId = smartTapMerchantId;
    return this;
  }

  @Override
  public SmartTapMerchantData set(String fieldName, Object value) {
    return (SmartTapMerchantData) super.set(fieldName, value);
  }

  @Override
  public SmartTapMerchantData clone() {
    return (SmartTapMerchantData) super.clone();
  }

}
