/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Request to send a private pass update notice information to Google, so that devices can then
 * fetch the notice prompting the user to update a pass.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SetPassUpdateNoticeRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. A fully qualified identifier of the pass that the issuer wants to notify the pass
   * holder(s) about. Formatted as .
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalPassId;

  /**
   * Required. The issuer endpoint URI the pass holder needs to follow in order to receive an
   * updated pass JWT. It can not contain any sensitive information. The endpoint needs to
   * authenticate the user before giving the user the updated JWT. Example update URI
   * https://someissuer.com/update/passId=someExternalPassId
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updateUri;

  /**
   * Required. The JWT signature of the updated pass that the issuer wants to notify Google about.
   * Only devices that report a different JWT signature than this JWT signature will receive the
   * update notification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updatedPassJwtSignature;

  /**
   * Required. A fully qualified identifier of the pass that the issuer wants to notify the pass
   * holder(s) about. Formatted as .
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalPassId() {
    return externalPassId;
  }

  /**
   * Required. A fully qualified identifier of the pass that the issuer wants to notify the pass
   * holder(s) about. Formatted as .
   * @param externalPassId externalPassId or {@code null} for none
   */
  public SetPassUpdateNoticeRequest setExternalPassId(java.lang.String externalPassId) {
    this.externalPassId = externalPassId;
    return this;
  }

  /**
   * Required. The issuer endpoint URI the pass holder needs to follow in order to receive an
   * updated pass JWT. It can not contain any sensitive information. The endpoint needs to
   * authenticate the user before giving the user the updated JWT. Example update URI
   * https://someissuer.com/update/passId=someExternalPassId
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdateUri() {
    return updateUri;
  }

  /**
   * Required. The issuer endpoint URI the pass holder needs to follow in order to receive an
   * updated pass JWT. It can not contain any sensitive information. The endpoint needs to
   * authenticate the user before giving the user the updated JWT. Example update URI
   * https://someissuer.com/update/passId=someExternalPassId
   * @param updateUri updateUri or {@code null} for none
   */
  public SetPassUpdateNoticeRequest setUpdateUri(java.lang.String updateUri) {
    this.updateUri = updateUri;
    return this;
  }

  /**
   * Required. The JWT signature of the updated pass that the issuer wants to notify Google about.
   * Only devices that report a different JWT signature than this JWT signature will receive the
   * update notification.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdatedPassJwtSignature() {
    return updatedPassJwtSignature;
  }

  /**
   * Required. The JWT signature of the updated pass that the issuer wants to notify Google about.
   * Only devices that report a different JWT signature than this JWT signature will receive the
   * update notification.
   * @param updatedPassJwtSignature updatedPassJwtSignature or {@code null} for none
   */
  public SetPassUpdateNoticeRequest setUpdatedPassJwtSignature(java.lang.String updatedPassJwtSignature) {
    this.updatedPassJwtSignature = updatedPassJwtSignature;
    return this;
  }

  @Override
  public SetPassUpdateNoticeRequest set(String fieldName, Object value) {
    return (SetPassUpdateNoticeRequest) super.set(fieldName, value);
  }

  @Override
  public SetPassUpdateNoticeRequest clone() {
    return (SetPassUpdateNoticeRequest) super.clone();
  }

}
