/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Configuration for the key and value length. See https://www.rfc-
 * editor.org/rfc/rfc4226#section-5.3
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RotatingBarcodeTotpDetailsTotpParameters extends com.google.api.client.json.GenericJson {

  /**
   * The secret key used for the TOTP value generation, encoded as a Base16 string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * The length of the TOTP value in decimal digits.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer valueLength;

  /**
   * The secret key used for the TOTP value generation, encoded as a Base16 string.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * The secret key used for the TOTP value generation, encoded as a Base16 string.
   * @param key key or {@code null} for none
   */
  public RotatingBarcodeTotpDetailsTotpParameters setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * The length of the TOTP value in decimal digits.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getValueLength() {
    return valueLength;
  }

  /**
   * The length of the TOTP value in decimal digits.
   * @param valueLength valueLength or {@code null} for none
   */
  public RotatingBarcodeTotpDetailsTotpParameters setValueLength(java.lang.Integer valueLength) {
    this.valueLength = valueLength;
    return this;
  }

  @Override
  public RotatingBarcodeTotpDetailsTotpParameters set(String fieldName, Object value) {
    return (RotatingBarcodeTotpDetailsTotpParameters) super.set(fieldName, value);
  }

  @Override
  public RotatingBarcodeTotpDetailsTotpParameters clone() {
    return (RotatingBarcodeTotpDetailsTotpParameters) super.clone();
  }

}
