/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for OfferClass.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OfferClass extends com.google.api.client.json.GenericJson {

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowMultipleUsersPerObject;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CallbackOptions callbackOptions;

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClassTemplateInfo classTemplateInfo;

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * The details of the offer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String details;

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSmartTap;

  /**
   * The fine print or terms of the offer, such as "20% off any t-shirt at Adam's Apparel."
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String finePrint;

  /**
   * The help link for the offer, such as `http://myownpersonaldomain.com/help`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uri helpUri;

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image heroImage;

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hexBackgroundColor;

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uri homepageUri;

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  static {
    // hack to force ProGuard to consider ImageModuleData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ImageModuleData.class);
  }

  /**
   * Deprecated. Use textModulesData instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InfoModuleData infoModuleData;

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuerName;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#offerClass"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * Translated strings for the details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedDetails;

  /**
   * Translated strings for the fine_print.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedFinePrint;

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedIssuerName;

  /**
   * Translated strings for the provider. Recommended maximum length is 12 characters to ensure full
   * string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedProvider;

  /**
   * Translated strings for the short title. Recommended maximum length is 20 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedShortTitle;

  /**
   * Translated strings for the title. Recommended maximum length is 60 characters to ensure full
   * string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedTitle;

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LatLongPoint> locations;

  static {
    // hack to force ProGuard to consider LatLongPoint used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LatLongPoint.class);
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  static {
    // hack to force ProGuard to consider MerchantLocation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MerchantLocation.class);
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  static {
    // hack to force ProGuard to consider Message used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Message.class);
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multipleDevicesAndHoldersAllowedStatus;

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notifyPreference;

  /**
   * Required. The offer provider (either the aggregator name or merchant name). Recommended maximum
   * length is 12 characters to ensure full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String provider;

  /**
   * Required. The redemption channels applicable to this offer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String redemptionChannel;

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> redemptionIssuers;

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Review review;

  /**
   * Required. The status of the class. This field can be set to `draft` or The status of the class.
   * This field can be set to `draft` or `underReview` using the insert, patch, or update API calls.
   * Once the review state is changed from `draft` it may not be changed back to `draft`. You should
   * keep this field to `draft` when the class is under development. A `draft` class cannot be used
   * to create any object. You should set this field to `underReview` when you believe the class is
   * ready for use. The platform will automatically set this field to `approved` and it can be
   * immediately used to create or migrate objects. When updating an already `approved` class you
   * should keep setting this field to `underReview`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewStatus;

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityAnimation securityAnimation;

  /**
   * A shortened version of the title of the offer, such as "20% off," shown to users as a quick
   * reference to the offer contents. Recommended maximum length is 20 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shortTitle;

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  /**
   * Required. The title of the offer, such as "20% off any t-shirt." Recommended maximum length is
   * 60 characters to ensure full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The title image of the offer. This image is displayed in both the details and list views of the
   * app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image titleImage;

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * Deprecated
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * View Unlock Requirement options for the offer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String viewUnlockRequirement;

  /**
   * The wide title image of the offer. When provided, this will be used in place of the title image
   * in the top left of the card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wideTitleImage;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wordMark;

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowMultipleUsersPerObject() {
    return allowMultipleUsersPerObject;
  }

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @param allowMultipleUsersPerObject allowMultipleUsersPerObject or {@code null} for none
   */
  public OfferClass setAllowMultipleUsersPerObject(java.lang.Boolean allowMultipleUsersPerObject) {
    this.allowMultipleUsersPerObject = allowMultipleUsersPerObject;
    return this;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public OfferClass setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @return value or {@code null} for none
   */
  public CallbackOptions getCallbackOptions() {
    return callbackOptions;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @param callbackOptions callbackOptions or {@code null} for none
   */
  public OfferClass setCallbackOptions(CallbackOptions callbackOptions) {
    this.callbackOptions = callbackOptions;
    return this;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @return value or {@code null} for none
   */
  public ClassTemplateInfo getClassTemplateInfo() {
    return classTemplateInfo;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @param classTemplateInfo classTemplateInfo or {@code null} for none
   */
  public OfferClass setClassTemplateInfo(ClassTemplateInfo classTemplateInfo) {
    this.classTemplateInfo = classTemplateInfo;
    return this;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @param countryCode countryCode or {@code null} for none
   */
  public OfferClass setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * The details of the offer.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetails() {
    return details;
  }

  /**
   * The details of the offer.
   * @param details details or {@code null} for none
   */
  public OfferClass setDetails(java.lang.String details) {
    this.details = details;
    return this;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSmartTap() {
    return enableSmartTap;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @param enableSmartTap enableSmartTap or {@code null} for none
   */
  public OfferClass setEnableSmartTap(java.lang.Boolean enableSmartTap) {
    this.enableSmartTap = enableSmartTap;
    return this;
  }

  /**
   * The fine print or terms of the offer, such as "20% off any t-shirt at Adam's Apparel."
   * @return value or {@code null} for none
   */
  public java.lang.String getFinePrint() {
    return finePrint;
  }

  /**
   * The fine print or terms of the offer, such as "20% off any t-shirt at Adam's Apparel."
   * @param finePrint finePrint or {@code null} for none
   */
  public OfferClass setFinePrint(java.lang.String finePrint) {
    this.finePrint = finePrint;
    return this;
  }

  /**
   * The help link for the offer, such as `http://myownpersonaldomain.com/help`
   * @return value or {@code null} for none
   */
  public Uri getHelpUri() {
    return helpUri;
  }

  /**
   * The help link for the offer, such as `http://myownpersonaldomain.com/help`
   * @param helpUri helpUri or {@code null} for none
   */
  public OfferClass setHelpUri(Uri helpUri) {
    this.helpUri = helpUri;
    return this;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @return value or {@code null} for none
   */
  public Image getHeroImage() {
    return heroImage;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @param heroImage heroImage or {@code null} for none
   */
  public OfferClass setHeroImage(Image heroImage) {
    this.heroImage = heroImage;
    return this;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @return value or {@code null} for none
   */
  public java.lang.String getHexBackgroundColor() {
    return hexBackgroundColor;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @param hexBackgroundColor hexBackgroundColor or {@code null} for none
   */
  public OfferClass setHexBackgroundColor(java.lang.String hexBackgroundColor) {
    this.hexBackgroundColor = hexBackgroundColor;
    return this;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @return value or {@code null} for none
   */
  public Uri getHomepageUri() {
    return homepageUri;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @param homepageUri homepageUri or {@code null} for none
   */
  public OfferClass setHomepageUri(Uri homepageUri) {
    this.homepageUri = homepageUri;
    return this;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @param id id or {@code null} for none
   */
  public OfferClass setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public OfferClass setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @return value or {@code null} for none
   */
  public InfoModuleData getInfoModuleData() {
    return infoModuleData;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @param infoModuleData infoModuleData or {@code null} for none
   */
  public OfferClass setInfoModuleData(InfoModuleData infoModuleData) {
    this.infoModuleData = infoModuleData;
    return this;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuerName() {
    return issuerName;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @param issuerName issuerName or {@code null} for none
   */
  public OfferClass setIssuerName(java.lang.String issuerName) {
    this.issuerName = issuerName;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#offerClass"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#offerClass"`.
   * @param kind kind or {@code null} for none
   */
  public OfferClass setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public OfferClass setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * Translated strings for the details.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedDetails() {
    return localizedDetails;
  }

  /**
   * Translated strings for the details.
   * @param localizedDetails localizedDetails or {@code null} for none
   */
  public OfferClass setLocalizedDetails(LocalizedString localizedDetails) {
    this.localizedDetails = localizedDetails;
    return this;
  }

  /**
   * Translated strings for the fine_print.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedFinePrint() {
    return localizedFinePrint;
  }

  /**
   * Translated strings for the fine_print.
   * @param localizedFinePrint localizedFinePrint or {@code null} for none
   */
  public OfferClass setLocalizedFinePrint(LocalizedString localizedFinePrint) {
    this.localizedFinePrint = localizedFinePrint;
    return this;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedIssuerName() {
    return localizedIssuerName;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @param localizedIssuerName localizedIssuerName or {@code null} for none
   */
  public OfferClass setLocalizedIssuerName(LocalizedString localizedIssuerName) {
    this.localizedIssuerName = localizedIssuerName;
    return this;
  }

  /**
   * Translated strings for the provider. Recommended maximum length is 12 characters to ensure full
   * string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedProvider() {
    return localizedProvider;
  }

  /**
   * Translated strings for the provider. Recommended maximum length is 12 characters to ensure full
   * string is displayed on smaller screens.
   * @param localizedProvider localizedProvider or {@code null} for none
   */
  public OfferClass setLocalizedProvider(LocalizedString localizedProvider) {
    this.localizedProvider = localizedProvider;
    return this;
  }

  /**
   * Translated strings for the short title. Recommended maximum length is 20 characters.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedShortTitle() {
    return localizedShortTitle;
  }

  /**
   * Translated strings for the short title. Recommended maximum length is 20 characters.
   * @param localizedShortTitle localizedShortTitle or {@code null} for none
   */
  public OfferClass setLocalizedShortTitle(LocalizedString localizedShortTitle) {
    this.localizedShortTitle = localizedShortTitle;
    return this;
  }

  /**
   * Translated strings for the title. Recommended maximum length is 60 characters to ensure full
   * string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedTitle() {
    return localizedTitle;
  }

  /**
   * Translated strings for the title. Recommended maximum length is 60 characters to ensure full
   * string is displayed on smaller screens.
   * @param localizedTitle localizedTitle or {@code null} for none
   */
  public OfferClass setLocalizedTitle(LocalizedString localizedTitle) {
    this.localizedTitle = localizedTitle;
    return this;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @return value or {@code null} for none
   */
  public java.util.List<LatLongPoint> getLocations() {
    return locations;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @param locations locations or {@code null} for none
   */
  public OfferClass setLocations(java.util.List<LatLongPoint> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public OfferClass setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public OfferClass setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @return value or {@code null} for none
   */
  public java.lang.String getMultipleDevicesAndHoldersAllowedStatus() {
    return multipleDevicesAndHoldersAllowedStatus;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @param multipleDevicesAndHoldersAllowedStatus multipleDevicesAndHoldersAllowedStatus or {@code null} for none
   */
  public OfferClass setMultipleDevicesAndHoldersAllowedStatus(java.lang.String multipleDevicesAndHoldersAllowedStatus) {
    this.multipleDevicesAndHoldersAllowedStatus = multipleDevicesAndHoldersAllowedStatus;
    return this;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotifyPreference() {
    return notifyPreference;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @param notifyPreference notifyPreference or {@code null} for none
   */
  public OfferClass setNotifyPreference(java.lang.String notifyPreference) {
    this.notifyPreference = notifyPreference;
    return this;
  }

  /**
   * Required. The offer provider (either the aggregator name or merchant name). Recommended maximum
   * length is 12 characters to ensure full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getProvider() {
    return provider;
  }

  /**
   * Required. The offer provider (either the aggregator name or merchant name). Recommended maximum
   * length is 12 characters to ensure full string is displayed on smaller screens.
   * @param provider provider or {@code null} for none
   */
  public OfferClass setProvider(java.lang.String provider) {
    this.provider = provider;
    return this;
  }

  /**
   * Required. The redemption channels applicable to this offer.
   * @return value or {@code null} for none
   */
  public java.lang.String getRedemptionChannel() {
    return redemptionChannel;
  }

  /**
   * Required. The redemption channels applicable to this offer.
   * @param redemptionChannel redemptionChannel or {@code null} for none
   */
  public OfferClass setRedemptionChannel(java.lang.String redemptionChannel) {
    this.redemptionChannel = redemptionChannel;
    return this;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getRedemptionIssuers() {
    return redemptionIssuers;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @param redemptionIssuers redemptionIssuers or {@code null} for none
   */
  public OfferClass setRedemptionIssuers(java.util.List<java.lang.Long> redemptionIssuers) {
    this.redemptionIssuers = redemptionIssuers;
    return this;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @return value or {@code null} for none
   */
  public Review getReview() {
    return review;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @param review review or {@code null} for none
   */
  public OfferClass setReview(Review review) {
    this.review = review;
    return this;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or The status of the class.
   * This field can be set to `draft` or `underReview` using the insert, patch, or update API calls.
   * Once the review state is changed from `draft` it may not be changed back to `draft`. You should
   * keep this field to `draft` when the class is under development. A `draft` class cannot be used
   * to create any object. You should set this field to `underReview` when you believe the class is
   * ready for use. The platform will automatically set this field to `approved` and it can be
   * immediately used to create or migrate objects. When updating an already `approved` class you
   * should keep setting this field to `underReview`.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewStatus() {
    return reviewStatus;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or The status of the class.
   * This field can be set to `draft` or `underReview` using the insert, patch, or update API calls.
   * Once the review state is changed from `draft` it may not be changed back to `draft`. You should
   * keep this field to `draft` when the class is under development. A `draft` class cannot be used
   * to create any object. You should set this field to `underReview` when you believe the class is
   * ready for use. The platform will automatically set this field to `approved` and it can be
   * immediately used to create or migrate objects. When updating an already `approved` class you
   * should keep setting this field to `underReview`.
   * @param reviewStatus reviewStatus or {@code null} for none
   */
  public OfferClass setReviewStatus(java.lang.String reviewStatus) {
    this.reviewStatus = reviewStatus;
    return this;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @return value or {@code null} for none
   */
  public SecurityAnimation getSecurityAnimation() {
    return securityAnimation;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @param securityAnimation securityAnimation or {@code null} for none
   */
  public OfferClass setSecurityAnimation(SecurityAnimation securityAnimation) {
    this.securityAnimation = securityAnimation;
    return this;
  }

  /**
   * A shortened version of the title of the offer, such as "20% off," shown to users as a quick
   * reference to the offer contents. Recommended maximum length is 20 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getShortTitle() {
    return shortTitle;
  }

  /**
   * A shortened version of the title of the offer, such as "20% off," shown to users as a quick
   * reference to the offer contents. Recommended maximum length is 20 characters.
   * @param shortTitle shortTitle or {@code null} for none
   */
  public OfferClass setShortTitle(java.lang.String shortTitle) {
    this.shortTitle = shortTitle;
    return this;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public OfferClass setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * Required. The title of the offer, such as "20% off any t-shirt." Recommended maximum length is
   * 60 characters to ensure full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Required. The title of the offer, such as "20% off any t-shirt." Recommended maximum length is
   * 60 characters to ensure full string is displayed on smaller screens.
   * @param title title or {@code null} for none
   */
  public OfferClass setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The title image of the offer. This image is displayed in both the details and list views of the
   * app.
   * @return value or {@code null} for none
   */
  public Image getTitleImage() {
    return titleImage;
  }

  /**
   * The title image of the offer. This image is displayed in both the details and list views of the
   * app.
   * @param titleImage titleImage or {@code null} for none
   */
  public OfferClass setTitleImage(Image titleImage) {
    this.titleImage = titleImage;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public OfferClass setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * Deprecated
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Deprecated
   * @param version version or {@code null} for none
   */
  public OfferClass setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * View Unlock Requirement options for the offer.
   * @return value or {@code null} for none
   */
  public java.lang.String getViewUnlockRequirement() {
    return viewUnlockRequirement;
  }

  /**
   * View Unlock Requirement options for the offer.
   * @param viewUnlockRequirement viewUnlockRequirement or {@code null} for none
   */
  public OfferClass setViewUnlockRequirement(java.lang.String viewUnlockRequirement) {
    this.viewUnlockRequirement = viewUnlockRequirement;
    return this;
  }

  /**
   * The wide title image of the offer. When provided, this will be used in place of the title image
   * in the top left of the card view.
   * @return value or {@code null} for none
   */
  public Image getWideTitleImage() {
    return wideTitleImage;
  }

  /**
   * The wide title image of the offer. When provided, this will be used in place of the title image
   * in the top left of the card view.
   * @param wideTitleImage wideTitleImage or {@code null} for none
   */
  public OfferClass setWideTitleImage(Image wideTitleImage) {
    this.wideTitleImage = wideTitleImage;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public Image getWordMark() {
    return wordMark;
  }

  /**
   * Deprecated.
   * @param wordMark wordMark or {@code null} for none
   */
  public OfferClass setWordMark(Image wordMark) {
    this.wordMark = wordMark;
    return this;
  }

  @Override
  public OfferClass set(String fieldName, Object value) {
    return (OfferClass) super.set(fieldName, value);
  }

  @Override
  public OfferClass clone() {
    return (OfferClass) super.clone();
  }

}
