/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Constraints that all must be met for the module to be shown.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModuleViewConstraints extends com.google.api.client.json.GenericJson {

  /**
   * The period of time that the module will be displayed to users. Can define both a `startTime`
   * and `endTime`. The module is displayed immediately after insertion unless a `startTime` is set.
   * The module is displayed indefinitely if `endTime` is not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeInterval displayInterval;

  /**
   * The period of time that the module will be displayed to users. Can define both a `startTime`
   * and `endTime`. The module is displayed immediately after insertion unless a `startTime` is set.
   * The module is displayed indefinitely if `endTime` is not set.
   * @return value or {@code null} for none
   */
  public TimeInterval getDisplayInterval() {
    return displayInterval;
  }

  /**
   * The period of time that the module will be displayed to users. Can define both a `startTime`
   * and `endTime`. The module is displayed immediately after insertion unless a `startTime` is set.
   * The module is displayed indefinitely if `endTime` is not set.
   * @param displayInterval displayInterval or {@code null} for none
   */
  public ModuleViewConstraints setDisplayInterval(TimeInterval displayInterval) {
    this.displayInterval = displayInterval;
    return this;
  }

  @Override
  public ModuleViewConstraints set(String fieldName, Object value) {
    return (ModuleViewConstraints) super.set(fieldName, value);
  }

  @Override
  public ModuleViewConstraints clone() {
    return (ModuleViewConstraints) super.clone();
  }

}
