/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for LoyaltyPointsBalance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LoyaltyPointsBalance extends com.google.api.client.json.GenericJson {

  /**
   * The double form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("double")
  private java.lang.Double double__;

  /**
   * The integer form of a balance. Only one of these subtypes (string, int, double, money) should
   * be populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("int")
  private java.lang.Integer int__;

  /**
   * The money form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money money;

  /**
   * The string form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("string")
  private java.lang.String string__;

  /**
   * The double form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * @return value or {@code null} for none
   */
  public java.lang.Double getDouble() {
    return double__;
  }

  /**
   * The double form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * @param double__ double__ or {@code null} for none
   */
  public LoyaltyPointsBalance setDouble(java.lang.Double double__) {
    this.double__ = double__;
    return this;
  }

  /**
   * The integer form of a balance. Only one of these subtypes (string, int, double, money) should
   * be populated.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getInt() {
    return int__;
  }

  /**
   * The integer form of a balance. Only one of these subtypes (string, int, double, money) should
   * be populated.
   * @param int__ int__ or {@code null} for none
   */
  public LoyaltyPointsBalance setInt(java.lang.Integer int__) {
    this.int__ = int__;
    return this;
  }

  /**
   * The money form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * @return value or {@code null} for none
   */
  public Money getMoney() {
    return money;
  }

  /**
   * The money form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * @param money money or {@code null} for none
   */
  public LoyaltyPointsBalance setMoney(Money money) {
    this.money = money;
    return this;
  }

  /**
   * The string form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * @return value or {@code null} for none
   */
  public java.lang.String getString() {
    return string__;
  }

  /**
   * The string form of a balance. Only one of these subtypes (string, int, double, money) should be
   * populated.
   * @param string__ string__ or {@code null} for none
   */
  public LoyaltyPointsBalance setString(java.lang.String string__) {
    this.string__ = string__;
    return this;
  }

  @Override
  public LoyaltyPointsBalance set(String fieldName, Object value) {
    return (LoyaltyPointsBalance) super.set(fieldName, value);
  }

  @Override
  public LoyaltyPointsBalance clone() {
    return (LoyaltyPointsBalance) super.clone();
  }

}
