/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for LocalizedString.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocalizedString extends com.google.api.client.json.GenericJson {

  /**
   * Contains the string to be displayed if no appropriate translation is available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TranslatedString defaultValue;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#localizedString"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Contains the translations for the string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TranslatedString> translatedValues;

  /**
   * Contains the string to be displayed if no appropriate translation is available.
   * @return value or {@code null} for none
   */
  public TranslatedString getDefaultValue() {
    return defaultValue;
  }

  /**
   * Contains the string to be displayed if no appropriate translation is available.
   * @param defaultValue defaultValue or {@code null} for none
   */
  public LocalizedString setDefaultValue(TranslatedString defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#localizedString"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#localizedString"`.
   * @param kind kind or {@code null} for none
   */
  public LocalizedString setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Contains the translations for the string.
   * @return value or {@code null} for none
   */
  public java.util.List<TranslatedString> getTranslatedValues() {
    return translatedValues;
  }

  /**
   * Contains the translations for the string.
   * @param translatedValues translatedValues or {@code null} for none
   */
  public LocalizedString setTranslatedValues(java.util.List<TranslatedString> translatedValues) {
    this.translatedValues = translatedValues;
    return this;
  }

  @Override
  public LocalizedString set(String fieldName, Object value) {
    return (LocalizedString) super.set(fieldName, value);
  }

  @Override
  public LocalizedString clone() {
    return (LocalizedString) super.clone();
  }

}
