/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Wrapping type for Google hosted images.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Image extends com.google.api.client.json.GenericJson {

  /**
   * Description of the image used for accessibility.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString contentDescription;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#image"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The URI for the image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageUri sourceUri;

  /**
   * Description of the image used for accessibility.
   * @return value or {@code null} for none
   */
  public LocalizedString getContentDescription() {
    return contentDescription;
  }

  /**
   * Description of the image used for accessibility.
   * @param contentDescription contentDescription or {@code null} for none
   */
  public Image setContentDescription(LocalizedString contentDescription) {
    this.contentDescription = contentDescription;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#image"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#image"`.
   * @param kind kind or {@code null} for none
   */
  public Image setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The URI for the image.
   * @return value or {@code null} for none
   */
  public ImageUri getSourceUri() {
    return sourceUri;
  }

  /**
   * The URI for the image.
   * @param sourceUri sourceUri or {@code null} for none
   */
  public Image setSourceUri(ImageUri sourceUri) {
    this.sourceUri = sourceUri;
    return this;
  }

  @Override
  public Image set(String fieldName, Object value) {
    return (Image) super.set(fieldName, value);
  }

  @Override
  public Image clone() {
    return (Image) super.clone();
  }

}
