/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for GroupingInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GroupingInfo extends com.google.api.client.json.GenericJson {

  /**
   * Optional grouping ID for grouping the passes with the same ID visually together. Grouping with
   * different types of passes is allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String groupingId;

  /**
   * Optional index for sorting the passes when they are grouped with other passes. Passes with
   * lower sort index are shown before passes with higher sort index. If unspecified, the value is
   * assumed to be INT_MAX. For two passes with the same sort index, the sorting behavior is
   * undefined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sortIndex;

  /**
   * Optional grouping ID for grouping the passes with the same ID visually together. Grouping with
   * different types of passes is allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroupingId() {
    return groupingId;
  }

  /**
   * Optional grouping ID for grouping the passes with the same ID visually together. Grouping with
   * different types of passes is allowed.
   * @param groupingId groupingId or {@code null} for none
   */
  public GroupingInfo setGroupingId(java.lang.String groupingId) {
    this.groupingId = groupingId;
    return this;
  }

  /**
   * Optional index for sorting the passes when they are grouped with other passes. Passes with
   * lower sort index are shown before passes with higher sort index. If unspecified, the value is
   * assumed to be INT_MAX. For two passes with the same sort index, the sorting behavior is
   * undefined.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSortIndex() {
    return sortIndex;
  }

  /**
   * Optional index for sorting the passes when they are grouped with other passes. Passes with
   * lower sort index are shown before passes with higher sort index. If unspecified, the value is
   * assumed to be INT_MAX. For two passes with the same sort index, the sorting behavior is
   * undefined.
   * @param sortIndex sortIndex or {@code null} for none
   */
  public GroupingInfo setSortIndex(java.lang.Integer sortIndex) {
    this.sortIndex = sortIndex;
    return this;
  }

  @Override
  public GroupingInfo set(String fieldName, Object value) {
    return (GroupingInfo) super.set(fieldName, value);
  }

  @Override
  public GroupingInfo clone() {
    return (GroupingInfo) super.clone();
  }

}
