/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Generic Class
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GenericClass extends com.google.api.client.json.GenericJson {

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CallbackOptions callbackOptions;

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClassTemplateInfo classTemplateInfo;

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSmartTap;

  /**
   * Required. The unique identifier for the class. This ID must be unique across all from an
   * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued
   * by Google and `identifier` is chosen by you. The unique identifier can only include
   * alphanumeric characters, `.`, `_`, or `-`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. If `imageModulesData` is also defined on the object, both will be displayed.
   * Only one of the image from class and one from object level will be rendered when both set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  /**
   * Links module data. If `linksModuleData` is also defined on the object, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multipleDevicesAndHoldersAllowedStatus;

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> redemptionIssuers;

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityAnimation securityAnimation;

  /**
   * Text module data. If `textModulesData` is also defined on the object, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * View Unlock Requirement options for the generic pass.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String viewUnlockRequirement;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public GenericClass setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @return value or {@code null} for none
   */
  public CallbackOptions getCallbackOptions() {
    return callbackOptions;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @param callbackOptions callbackOptions or {@code null} for none
   */
  public GenericClass setCallbackOptions(CallbackOptions callbackOptions) {
    this.callbackOptions = callbackOptions;
    return this;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @return value or {@code null} for none
   */
  public ClassTemplateInfo getClassTemplateInfo() {
    return classTemplateInfo;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @param classTemplateInfo classTemplateInfo or {@code null} for none
   */
  public GenericClass setClassTemplateInfo(ClassTemplateInfo classTemplateInfo) {
    this.classTemplateInfo = classTemplateInfo;
    return this;
  }

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSmartTap() {
    return enableSmartTap;
  }

  /**
   * Available only to Smart Tap enabled partners. Contact support for additional guidance.
   * @param enableSmartTap enableSmartTap or {@code null} for none
   */
  public GenericClass setEnableSmartTap(java.lang.Boolean enableSmartTap) {
    this.enableSmartTap = enableSmartTap;
    return this;
  }

  /**
   * Required. The unique identifier for the class. This ID must be unique across all from an
   * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued
   * by Google and `identifier` is chosen by you. The unique identifier can only include
   * alphanumeric characters, `.`, `_`, or `-`.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for the class. This ID must be unique across all from an
   * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued
   * by Google and `identifier` is chosen by you. The unique identifier can only include
   * alphanumeric characters, `.`, `_`, or `-`.
   * @param id id or {@code null} for none
   */
  public GenericClass setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. If `imageModulesData` is also defined on the object, both will be displayed.
   * Only one of the image from class and one from object level will be rendered when both set.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. If `imageModulesData` is also defined on the object, both will be displayed.
   * Only one of the image from class and one from object level will be rendered when both set.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public GenericClass setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * Links module data. If `linksModuleData` is also defined on the object, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If `linksModuleData` is also defined on the object, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public GenericClass setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public GenericClass setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public GenericClass setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @return value or {@code null} for none
   */
  public java.lang.String getMultipleDevicesAndHoldersAllowedStatus() {
    return multipleDevicesAndHoldersAllowedStatus;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @param multipleDevicesAndHoldersAllowedStatus multipleDevicesAndHoldersAllowedStatus or {@code null} for none
   */
  public GenericClass setMultipleDevicesAndHoldersAllowedStatus(java.lang.String multipleDevicesAndHoldersAllowedStatus) {
    this.multipleDevicesAndHoldersAllowedStatus = multipleDevicesAndHoldersAllowedStatus;
    return this;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getRedemptionIssuers() {
    return redemptionIssuers;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @param redemptionIssuers redemptionIssuers or {@code null} for none
   */
  public GenericClass setRedemptionIssuers(java.util.List<java.lang.Long> redemptionIssuers) {
    this.redemptionIssuers = redemptionIssuers;
    return this;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @return value or {@code null} for none
   */
  public SecurityAnimation getSecurityAnimation() {
    return securityAnimation;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @param securityAnimation securityAnimation or {@code null} for none
   */
  public GenericClass setSecurityAnimation(SecurityAnimation securityAnimation) {
    this.securityAnimation = securityAnimation;
    return this;
  }

  /**
   * Text module data. If `textModulesData` is also defined on the object, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If `textModulesData` is also defined on the object, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public GenericClass setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public GenericClass setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * View Unlock Requirement options for the generic pass.
   * @return value or {@code null} for none
   */
  public java.lang.String getViewUnlockRequirement() {
    return viewUnlockRequirement;
  }

  /**
   * View Unlock Requirement options for the generic pass.
   * @param viewUnlockRequirement viewUnlockRequirement or {@code null} for none
   */
  public GenericClass setViewUnlockRequirement(java.lang.String viewUnlockRequirement) {
    this.viewUnlockRequirement = viewUnlockRequirement;
    return this;
  }

  @Override
  public GenericClass set(String fieldName, Object value) {
    return (GenericClass) super.set(fieldName, value);
  }

  @Override
  public GenericClass clone() {
    return (GenericClass) super.clone();
  }

}
