/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for FlightHeader.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FlightHeader extends com.google.api.client.json.GenericJson {

  /**
   * Information about airline carrier. This is a required property of `flightHeader`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FlightCarrier carrier;

  /**
   * The flight number without IATA carrier code. This field should contain only digits. This is a
   * required property of `flightHeader`. eg: "123"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String flightNumber;

  /**
   * Override value to use for flight number. The default value used for display purposes is carrier
   * + flight_number. If a different value needs to be shown to passengers, use this field to
   * override the default behavior. eg: "XX1234 / YY576"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String flightNumberDisplayOverride;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightHeader"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Information about operating airline carrier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FlightCarrier operatingCarrier;

  /**
   * The flight number used by the operating carrier without IATA carrier code. This field should
   * contain only digits. eg: "234"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operatingFlightNumber;

  /**
   * Information about airline carrier. This is a required property of `flightHeader`.
   * @return value or {@code null} for none
   */
  public FlightCarrier getCarrier() {
    return carrier;
  }

  /**
   * Information about airline carrier. This is a required property of `flightHeader`.
   * @param carrier carrier or {@code null} for none
   */
  public FlightHeader setCarrier(FlightCarrier carrier) {
    this.carrier = carrier;
    return this;
  }

  /**
   * The flight number without IATA carrier code. This field should contain only digits. This is a
   * required property of `flightHeader`. eg: "123"
   * @return value or {@code null} for none
   */
  public java.lang.String getFlightNumber() {
    return flightNumber;
  }

  /**
   * The flight number without IATA carrier code. This field should contain only digits. This is a
   * required property of `flightHeader`. eg: "123"
   * @param flightNumber flightNumber or {@code null} for none
   */
  public FlightHeader setFlightNumber(java.lang.String flightNumber) {
    this.flightNumber = flightNumber;
    return this;
  }

  /**
   * Override value to use for flight number. The default value used for display purposes is carrier
   * + flight_number. If a different value needs to be shown to passengers, use this field to
   * override the default behavior. eg: "XX1234 / YY576"
   * @return value or {@code null} for none
   */
  public java.lang.String getFlightNumberDisplayOverride() {
    return flightNumberDisplayOverride;
  }

  /**
   * Override value to use for flight number. The default value used for display purposes is carrier
   * + flight_number. If a different value needs to be shown to passengers, use this field to
   * override the default behavior. eg: "XX1234 / YY576"
   * @param flightNumberDisplayOverride flightNumberDisplayOverride or {@code null} for none
   */
  public FlightHeader setFlightNumberDisplayOverride(java.lang.String flightNumberDisplayOverride) {
    this.flightNumberDisplayOverride = flightNumberDisplayOverride;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightHeader"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightHeader"`.
   * @param kind kind or {@code null} for none
   */
  public FlightHeader setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Information about operating airline carrier.
   * @return value or {@code null} for none
   */
  public FlightCarrier getOperatingCarrier() {
    return operatingCarrier;
  }

  /**
   * Information about operating airline carrier.
   * @param operatingCarrier operatingCarrier or {@code null} for none
   */
  public FlightHeader setOperatingCarrier(FlightCarrier operatingCarrier) {
    this.operatingCarrier = operatingCarrier;
    return this;
  }

  /**
   * The flight number used by the operating carrier without IATA carrier code. This field should
   * contain only digits. eg: "234"
   * @return value or {@code null} for none
   */
  public java.lang.String getOperatingFlightNumber() {
    return operatingFlightNumber;
  }

  /**
   * The flight number used by the operating carrier without IATA carrier code. This field should
   * contain only digits. eg: "234"
   * @param operatingFlightNumber operatingFlightNumber or {@code null} for none
   */
  public FlightHeader setOperatingFlightNumber(java.lang.String operatingFlightNumber) {
    this.operatingFlightNumber = operatingFlightNumber;
    return this;
  }

  @Override
  public FlightHeader set(String fieldName, Object value) {
    return (FlightHeader) super.set(fieldName, value);
  }

  @Override
  public FlightHeader clone() {
    return (FlightHeader) super.clone();
  }

}
