/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Reference definition to use with field overrides.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FieldReference extends com.google.api.client.json.GenericJson {

  /**
   * Only valid if the `fieldPath` references a date field. Chooses how the date field will be
   * formatted and displayed in the UI.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dateFormat;

  /**
   * Path to the field being referenced, prefixed with "object" or "class" and separated with dots.
   * For example, it may be the string "object.purchaseDetails.purchasePrice".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldPath;

  /**
   * Only valid if the `fieldPath` references a date field. Chooses how the date field will be
   * formatted and displayed in the UI.
   * @return value or {@code null} for none
   */
  public java.lang.String getDateFormat() {
    return dateFormat;
  }

  /**
   * Only valid if the `fieldPath` references a date field. Chooses how the date field will be
   * formatted and displayed in the UI.
   * @param dateFormat dateFormat or {@code null} for none
   */
  public FieldReference setDateFormat(java.lang.String dateFormat) {
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Path to the field being referenced, prefixed with "object" or "class" and separated with dots.
   * For example, it may be the string "object.purchaseDetails.purchasePrice".
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldPath() {
    return fieldPath;
  }

  /**
   * Path to the field being referenced, prefixed with "object" or "class" and separated with dots.
   * For example, it may be the string "object.purchaseDetails.purchasePrice".
   * @param fieldPath fieldPath or {@code null} for none
   */
  public FieldReference setFieldPath(java.lang.String fieldPath) {
    this.fieldPath = fieldPath;
    return this;
  }

  @Override
  public FieldReference set(String fieldName, Object value) {
    return (FieldReference) super.set(fieldName, value);
  }

  @Override
  public FieldReference clone() {
    return (FieldReference) super.clone();
  }

}
