/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Device context associated with the object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeviceContext extends com.google.api.client.json.GenericJson {

  /**
   * If set, redemption information will only be returned to the given device upon activation of the
   * object. This should not be used as a stable identifier to trace a user's device. It can change
   * across different passes for the same device or even across different activations for the same
   * device. When setting this, callers must also set has_linked_device on the object being
   * activated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceToken;

  /**
   * If set, redemption information will only be returned to the given device upon activation of the
   * object. This should not be used as a stable identifier to trace a user's device. It can change
   * across different passes for the same device or even across different activations for the same
   * device. When setting this, callers must also set has_linked_device on the object being
   * activated.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceToken() {
    return deviceToken;
  }

  /**
   * If set, redemption information will only be returned to the given device upon activation of the
   * object. This should not be used as a stable identifier to trace a user's device. It can change
   * across different passes for the same device or even across different activations for the same
   * device. When setting this, callers must also set has_linked_device on the object being
   * activated.
   * @param deviceToken deviceToken or {@code null} for none
   */
  public DeviceContext setDeviceToken(java.lang.String deviceToken) {
    this.deviceToken = deviceToken;
    return this;
  }

  @Override
  public DeviceContext set(String fieldName, Object value) {
    return (DeviceContext) super.set(fieldName, value);
  }

  @Override
  public DeviceContext clone() {
    return (DeviceContext) super.clone();
  }

}
