/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for CardTemplateOverride.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CardTemplateOverride extends com.google.api.client.json.GenericJson {

  /**
   * Template information for rows in the card view. At most three rows are allowed to be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CardRowTemplateInfo> cardRowTemplateInfos;

  static {
    // hack to force ProGuard to consider CardRowTemplateInfo used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CardRowTemplateInfo.class);
  }

  /**
   * Template information for rows in the card view. At most three rows are allowed to be specified.
   * @return value or {@code null} for none
   */
  public java.util.List<CardRowTemplateInfo> getCardRowTemplateInfos() {
    return cardRowTemplateInfos;
  }

  /**
   * Template information for rows in the card view. At most three rows are allowed to be specified.
   * @param cardRowTemplateInfos cardRowTemplateInfos or {@code null} for none
   */
  public CardTemplateOverride setCardRowTemplateInfos(java.util.List<CardRowTemplateInfo> cardRowTemplateInfos) {
    this.cardRowTemplateInfos = cardRowTemplateInfos;
    return this;
  }

  @Override
  public CardTemplateOverride set(String fieldName, Object value) {
    return (CardTemplateOverride) super.set(fieldName, value);
  }

  @Override
  public CardTemplateOverride clone() {
    return (CardTemplateOverride) super.clone();
  }

}
