/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for BoardingAndSeatingInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BoardingAndSeatingInfo extends com.google.api.client.json.GenericJson {

  /**
   * Set this field only if this flight boards through more than one door or bridge and you want to
   * explicitly print the door location on the boarding pass. Most airlines route their passengers
   * to the right door or bridge by refering to doors/bridges by the `seatClass`. In those cases
   * `boardingDoor` should not be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String boardingDoor;

  /**
   * The value of boarding group (or zone) this passenger shall board with. eg: "B" The label for
   * this value will be determined by the `boardingPolicy` field in the `flightClass` referenced by
   * this object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String boardingGroup;

  /**
   * The value of boarding position. eg: "76"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String boardingPosition;

  /**
   * A small image shown above the boarding barcode. Airlines can use it to communicate any special
   * boarding privileges. In the event the security program logo is also set, this image might be
   * rendered alongside the logo for that security program.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image boardingPrivilegeImage;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#boardingAndSeatingInfo"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The passenger's seat assignment. To be used when there is no specific identifier to use in
   * `seatNumber`. eg: "assigned at gate"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString seatAssignment;

  /**
   * The value of the seat class. eg: "Economy" or "Economy Plus"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String seatClass;

  /**
   * The value of passenger seat. If there is no specific identifier, use `seatAssignment` instead.
   * eg: "25A"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String seatNumber;

  /**
   * The sequence number on the boarding pass. This usually matches the sequence in which the
   * passengers checked in. Airline might use the number for manual boarding and bag tags. eg: "49"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sequenceNumber;

  /**
   * Set this field only if this flight boards through more than one door or bridge and you want to
   * explicitly print the door location on the boarding pass. Most airlines route their passengers
   * to the right door or bridge by refering to doors/bridges by the `seatClass`. In those cases
   * `boardingDoor` should not be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getBoardingDoor() {
    return boardingDoor;
  }

  /**
   * Set this field only if this flight boards through more than one door or bridge and you want to
   * explicitly print the door location on the boarding pass. Most airlines route their passengers
   * to the right door or bridge by refering to doors/bridges by the `seatClass`. In those cases
   * `boardingDoor` should not be set.
   * @param boardingDoor boardingDoor or {@code null} for none
   */
  public BoardingAndSeatingInfo setBoardingDoor(java.lang.String boardingDoor) {
    this.boardingDoor = boardingDoor;
    return this;
  }

  /**
   * The value of boarding group (or zone) this passenger shall board with. eg: "B" The label for
   * this value will be determined by the `boardingPolicy` field in the `flightClass` referenced by
   * this object.
   * @return value or {@code null} for none
   */
  public java.lang.String getBoardingGroup() {
    return boardingGroup;
  }

  /**
   * The value of boarding group (or zone) this passenger shall board with. eg: "B" The label for
   * this value will be determined by the `boardingPolicy` field in the `flightClass` referenced by
   * this object.
   * @param boardingGroup boardingGroup or {@code null} for none
   */
  public BoardingAndSeatingInfo setBoardingGroup(java.lang.String boardingGroup) {
    this.boardingGroup = boardingGroup;
    return this;
  }

  /**
   * The value of boarding position. eg: "76"
   * @return value or {@code null} for none
   */
  public java.lang.String getBoardingPosition() {
    return boardingPosition;
  }

  /**
   * The value of boarding position. eg: "76"
   * @param boardingPosition boardingPosition or {@code null} for none
   */
  public BoardingAndSeatingInfo setBoardingPosition(java.lang.String boardingPosition) {
    this.boardingPosition = boardingPosition;
    return this;
  }

  /**
   * A small image shown above the boarding barcode. Airlines can use it to communicate any special
   * boarding privileges. In the event the security program logo is also set, this image might be
   * rendered alongside the logo for that security program.
   * @return value or {@code null} for none
   */
  public Image getBoardingPrivilegeImage() {
    return boardingPrivilegeImage;
  }

  /**
   * A small image shown above the boarding barcode. Airlines can use it to communicate any special
   * boarding privileges. In the event the security program logo is also set, this image might be
   * rendered alongside the logo for that security program.
   * @param boardingPrivilegeImage boardingPrivilegeImage or {@code null} for none
   */
  public BoardingAndSeatingInfo setBoardingPrivilegeImage(Image boardingPrivilegeImage) {
    this.boardingPrivilegeImage = boardingPrivilegeImage;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#boardingAndSeatingInfo"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#boardingAndSeatingInfo"`.
   * @param kind kind or {@code null} for none
   */
  public BoardingAndSeatingInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The passenger's seat assignment. To be used when there is no specific identifier to use in
   * `seatNumber`. eg: "assigned at gate"
   * @return value or {@code null} for none
   */
  public LocalizedString getSeatAssignment() {
    return seatAssignment;
  }

  /**
   * The passenger's seat assignment. To be used when there is no specific identifier to use in
   * `seatNumber`. eg: "assigned at gate"
   * @param seatAssignment seatAssignment or {@code null} for none
   */
  public BoardingAndSeatingInfo setSeatAssignment(LocalizedString seatAssignment) {
    this.seatAssignment = seatAssignment;
    return this;
  }

  /**
   * The value of the seat class. eg: "Economy" or "Economy Plus"
   * @return value or {@code null} for none
   */
  public java.lang.String getSeatClass() {
    return seatClass;
  }

  /**
   * The value of the seat class. eg: "Economy" or "Economy Plus"
   * @param seatClass seatClass or {@code null} for none
   */
  public BoardingAndSeatingInfo setSeatClass(java.lang.String seatClass) {
    this.seatClass = seatClass;
    return this;
  }

  /**
   * The value of passenger seat. If there is no specific identifier, use `seatAssignment` instead.
   * eg: "25A"
   * @return value or {@code null} for none
   */
  public java.lang.String getSeatNumber() {
    return seatNumber;
  }

  /**
   * The value of passenger seat. If there is no specific identifier, use `seatAssignment` instead.
   * eg: "25A"
   * @param seatNumber seatNumber or {@code null} for none
   */
  public BoardingAndSeatingInfo setSeatNumber(java.lang.String seatNumber) {
    this.seatNumber = seatNumber;
    return this;
  }

  /**
   * The sequence number on the boarding pass. This usually matches the sequence in which the
   * passengers checked in. Airline might use the number for manual boarding and bag tags. eg: "49"
   * @return value or {@code null} for none
   */
  public java.lang.String getSequenceNumber() {
    return sequenceNumber;
  }

  /**
   * The sequence number on the boarding pass. This usually matches the sequence in which the
   * passengers checked in. Airline might use the number for manual boarding and bag tags. eg: "49"
   * @param sequenceNumber sequenceNumber or {@code null} for none
   */
  public BoardingAndSeatingInfo setSequenceNumber(java.lang.String sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
    return this;
  }

  @Override
  public BoardingAndSeatingInfo set(String fieldName, Object value) {
    return (BoardingAndSeatingInfo) super.set(fieldName, value);
  }

  @Override
  public BoardingAndSeatingInfo clone() {
    return (BoardingAndSeatingInfo) super.clone();
  }

}
