/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for AppLinkDataAppLinkInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppLinkDataAppLinkInfo extends com.google.api.client.json.GenericJson {

  /**
   * Deprecated. Image isn't supported in the app link module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image appLogoImage;

  /**
   * Target to follow when opening the app link on clients. It will be used by partners to open
   * their app or webpage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkDataAppLinkInfoAppTarget appTarget;

  /**
   * Deprecated. Description isn't supported in the app link module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString description;

  /**
   * Deprecated. Title isn't supported in the app link module.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString title;

  /**
   * Deprecated. Image isn't supported in the app link module.
   * @return value or {@code null} for none
   */
  public Image getAppLogoImage() {
    return appLogoImage;
  }

  /**
   * Deprecated. Image isn't supported in the app link module.
   * @param appLogoImage appLogoImage or {@code null} for none
   */
  public AppLinkDataAppLinkInfo setAppLogoImage(Image appLogoImage) {
    this.appLogoImage = appLogoImage;
    return this;
  }

  /**
   * Target to follow when opening the app link on clients. It will be used by partners to open
   * their app or webpage.
   * @return value or {@code null} for none
   */
  public AppLinkDataAppLinkInfoAppTarget getAppTarget() {
    return appTarget;
  }

  /**
   * Target to follow when opening the app link on clients. It will be used by partners to open
   * their app or webpage.
   * @param appTarget appTarget or {@code null} for none
   */
  public AppLinkDataAppLinkInfo setAppTarget(AppLinkDataAppLinkInfoAppTarget appTarget) {
    this.appTarget = appTarget;
    return this;
  }

  /**
   * Deprecated. Description isn't supported in the app link module.
   * @return value or {@code null} for none
   */
  public LocalizedString getDescription() {
    return description;
  }

  /**
   * Deprecated. Description isn't supported in the app link module.
   * @param description description or {@code null} for none
   */
  public AppLinkDataAppLinkInfo setDescription(LocalizedString description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated. Title isn't supported in the app link module.
   * @return value or {@code null} for none
   */
  public LocalizedString getTitle() {
    return title;
  }

  /**
   * Deprecated. Title isn't supported in the app link module.
   * @param title title or {@code null} for none
   */
  public AppLinkDataAppLinkInfo setTitle(LocalizedString title) {
    this.title = title;
    return this;
  }

  @Override
  public AppLinkDataAppLinkInfo set(String fieldName, Object value) {
    return (AppLinkDataAppLinkInfo) super.set(fieldName, value);
  }

  @Override
  public AppLinkDataAppLinkInfo clone() {
    return (AppLinkDataAppLinkInfo) super.clone();
  }

}
