/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects;

/**
 * Service definition for Walletobjects (v1).
 *
 * <p>
 * API for issuers to save and manage Google Wallet Objects.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/pay/passes" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link WalletobjectsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Walletobjects extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Google Wallet API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://walletobjects.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://walletobjects.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Walletobjects(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Walletobjects(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Eventticketclass collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Eventticketclass.List request = walletobjects.eventticketclass().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Eventticketclass eventticketclass() {
    return new Eventticketclass();
  }

  /**
   * The "eventticketclass" collection of methods.
   */
  public class Eventticketclass {

    /**
     * Adds a message to the event ticket class referenced by the given class ID.
     *
     * Create a request for the method "eventticketclass.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketClassAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketClass/{resourceId}/addMessage";

      /**
       * Adds a message to the event ticket class referenced by the given class ID.
       *
       * Create a request for the method "eventticketclass.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketClassAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the event ticket class with the given class ID.
     *
     * Create a request for the method "eventticketclass.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketClass> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketClass/{resourceId}";

      /**
       * Returns the event ticket class with the given class ID.
       *
       * Create a request for the method "eventticketclass.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.EventTicketClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an event ticket class with the given ID and properties.
     *
     * Create a request for the method "eventticketclass.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.EventTicketClass}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.EventTicketClass content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketClass> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketClass";

      /**
       * Inserts an event ticket class with the given ID and properties.
       *
       * Create a request for the method "eventticketclass.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.EventTicketClass}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.EventTicketClass content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketClass.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all event ticket classes for a given issuer ID.
     *
     * Create a request for the method "eventticketclass.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketClassListResponse> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketClass";

      /**
       * Returns a list of all event ticket classes for a given issuer ID.
       *
       * Create a request for the method "eventticketclass.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.EventTicketClassListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the issuer authorized to list classes. */
      @com.google.api.client.util.Key
      private java.lang.Long issuerId;

      /** The ID of the issuer authorized to list classes.
       */
      public java.lang.Long getIssuerId() {
        return issuerId;
      }

      /** The ID of the issuer authorized to list classes. */
      public List setIssuerId(java.lang.Long issuerId) {
        this.issuerId = issuerId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     classes are available in a list. For example, if you have a list of 200 classes and you call list
     with `maxResults` set to 20, list will return the first 20 classes and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 classes.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the event ticket class referenced by the given class ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "eventticketclass.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.EventTicketClass}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketClass content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketClass> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketClass/{resourceId}";

      /**
       * Updates the event ticket class referenced by the given class ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "eventticketclass.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.EventTicketClass}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketClass content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the event ticket class referenced by the given class ID.
     *
     * Create a request for the method "eventticketclass.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.EventTicketClass}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketClass content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketClass> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketClass/{resourceId}";

      /**
       * Updates the event ticket class referenced by the given class ID.
       *
       * Create a request for the method "eventticketclass.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.EventTicketClass}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketClass content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Eventticketobject collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Eventticketobject.List request = walletobjects.eventticketobject().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Eventticketobject eventticketobject() {
    return new Eventticketobject();
  }

  /**
   * The "eventticketobject" collection of methods.
   */
  public class Eventticketobject {

    /**
     * Adds a message to the event ticket object referenced by the given object ID.
     *
     * Create a request for the method "eventticketobject.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketObjectAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketObject/{resourceId}/addMessage";

      /**
       * Adds a message to the event ticket object referenced by the given object ID.
       *
       * Create a request for the method "eventticketobject.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketObjectAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the event ticket object with the given object ID.
     *
     * Create a request for the method "eventticketobject.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketObject> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketObject/{resourceId}";

      /**
       * Returns the event ticket object with the given object ID.
       *
       * Create a request for the method "eventticketobject.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.EventTicketObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an event ticket object with the given ID and properties.
     *
     * Create a request for the method "eventticketobject.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.EventTicketObject}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.EventTicketObject content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketObject> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketObject";

      /**
       * Inserts an event ticket object with the given ID and properties.
       *
       * Create a request for the method "eventticketobject.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.EventTicketObject}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.EventTicketObject content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketObject.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all event ticket objects for a given issuer ID.
     *
     * Create a request for the method "eventticketobject.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketObjectListResponse> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketObject";

      /**
       * Returns a list of all event ticket objects for a given issuer ID.
       *
       * Create a request for the method "eventticketobject.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.EventTicketObjectListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the class whose objects will be listed. */
      @com.google.api.client.util.Key
      private java.lang.String classId;

      /** The ID of the class whose objects will be listed.
       */
      public java.lang.String getClassId() {
        return classId;
      }

      /** The ID of the class whose objects will be listed. */
      public List setClassId(java.lang.String classId) {
        this.classId = classId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     objects are available in a list. For example, if you have a list of 200 objects and you call list
     with `maxResults` set to 20, list will return the first 20 objects and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 objects.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies linked offer objects for the event ticket object with the given ID.
     *
     * Create a request for the method "eventticketobject.modifylinkedofferobjects".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Modifylinkedofferobjects#execute()} method to invoke the remote
     * operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest}
     * @return the request
     */
    public Modifylinkedofferobjects modifylinkedofferobjects(java.lang.String resourceId, com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest content) throws java.io.IOException {
      Modifylinkedofferobjects result = new Modifylinkedofferobjects(resourceId, content);
      initialize(result);
      return result;
    }

    public class Modifylinkedofferobjects extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketObject> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketObject/{resourceId}/modifyLinkedOfferObjects";

      /**
       * Modifies linked offer objects for the event ticket object with the given ID.
       *
       * Create a request for the method "eventticketobject.modifylinkedofferobjects".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Modifylinkedofferobjects#execute()} method to invoke the
       * remote operation. <p> {@link Modifylinkedofferobjects#initialize(com.google.api.client.googleap
       * is.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest}
       * @since 1.13
       */
      protected Modifylinkedofferobjects(java.lang.String resourceId, com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Modifylinkedofferobjects set$Xgafv(java.lang.String $Xgafv) {
        return (Modifylinkedofferobjects) super.set$Xgafv($Xgafv);
      }

      @Override
      public Modifylinkedofferobjects setAccessToken(java.lang.String accessToken) {
        return (Modifylinkedofferobjects) super.setAccessToken(accessToken);
      }

      @Override
      public Modifylinkedofferobjects setAlt(java.lang.String alt) {
        return (Modifylinkedofferobjects) super.setAlt(alt);
      }

      @Override
      public Modifylinkedofferobjects setCallback(java.lang.String callback) {
        return (Modifylinkedofferobjects) super.setCallback(callback);
      }

      @Override
      public Modifylinkedofferobjects setFields(java.lang.String fields) {
        return (Modifylinkedofferobjects) super.setFields(fields);
      }

      @Override
      public Modifylinkedofferobjects setKey(java.lang.String key) {
        return (Modifylinkedofferobjects) super.setKey(key);
      }

      @Override
      public Modifylinkedofferobjects setOauthToken(java.lang.String oauthToken) {
        return (Modifylinkedofferobjects) super.setOauthToken(oauthToken);
      }

      @Override
      public Modifylinkedofferobjects setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Modifylinkedofferobjects) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Modifylinkedofferobjects setQuotaUser(java.lang.String quotaUser) {
        return (Modifylinkedofferobjects) super.setQuotaUser(quotaUser);
      }

      @Override
      public Modifylinkedofferobjects setUploadType(java.lang.String uploadType) {
        return (Modifylinkedofferobjects) super.setUploadType(uploadType);
      }

      @Override
      public Modifylinkedofferobjects setUploadProtocol(java.lang.String uploadProtocol) {
        return (Modifylinkedofferobjects) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Modifylinkedofferobjects setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Modifylinkedofferobjects set(String parameterName, Object value) {
        return (Modifylinkedofferobjects) super.set(parameterName, value);
      }
    }
    /**
     * Updates the event ticket object referenced by the given object ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "eventticketobject.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.EventTicketObject}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketObject content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketObject> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketObject/{resourceId}";

      /**
       * Updates the event ticket object referenced by the given object ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "eventticketobject.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.EventTicketObject}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketObject content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the event ticket object referenced by the given object ID.
     *
     * Create a request for the method "eventticketobject.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.EventTicketObject}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketObject content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.EventTicketObject> {

      private static final String REST_PATH = "walletobjects/v1/eventTicketObject/{resourceId}";

      /**
       * Updates the event ticket object referenced by the given object ID.
       *
       * Create a request for the method "eventticketobject.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.EventTicketObject}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.EventTicketObject content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.EventTicketObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Flightclass collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Flightclass.List request = walletobjects.flightclass().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Flightclass flightclass() {
    return new Flightclass();
  }

  /**
   * The "flightclass" collection of methods.
   */
  public class Flightclass {

    /**
     * Adds a message to the flight class referenced by the given class ID.
     *
     * Create a request for the method "flightclass.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightClassAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/flightClass/{resourceId}/addMessage";

      /**
       * Adds a message to the flight class referenced by the given class ID.
       *
       * Create a request for the method "flightclass.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.FlightClassAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the flight class with the given class ID.
     *
     * Create a request for the method "flightclass.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightClass> {

      private static final String REST_PATH = "walletobjects/v1/flightClass/{resourceId}";

      /**
       * Returns the flight class with the given class ID.
       *
       * Create a request for the method "flightclass.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.FlightClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an flight class with the given ID and properties.
     *
     * Create a request for the method "flightclass.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.FlightClass}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.FlightClass content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightClass> {

      private static final String REST_PATH = "walletobjects/v1/flightClass";

      /**
       * Inserts an flight class with the given ID and properties.
       *
       * Create a request for the method "flightclass.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.FlightClass}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.FlightClass content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.FlightClass.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all flight classes for a given issuer ID.
     *
     * Create a request for the method "flightclass.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightClassListResponse> {

      private static final String REST_PATH = "walletobjects/v1/flightClass";

      /**
       * Returns a list of all flight classes for a given issuer ID.
       *
       * Create a request for the method "flightclass.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.FlightClassListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the issuer authorized to list classes. */
      @com.google.api.client.util.Key
      private java.lang.Long issuerId;

      /** The ID of the issuer authorized to list classes.
       */
      public java.lang.Long getIssuerId() {
        return issuerId;
      }

      /** The ID of the issuer authorized to list classes. */
      public List setIssuerId(java.lang.Long issuerId) {
        this.issuerId = issuerId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     classes are available in a list. For example, if you have a list of 200 classes and you call list
     with `maxResults` set to 20, list will return the first 20 classes and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 classes.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the flight class referenced by the given class ID. This method supports patch semantics.
     *
     * Create a request for the method "flightclass.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.FlightClass}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightClass content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightClass> {

      private static final String REST_PATH = "walletobjects/v1/flightClass/{resourceId}";

      /**
       * Updates the flight class referenced by the given class ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "flightclass.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.FlightClass}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightClass content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.FlightClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the flight class referenced by the given class ID.
     *
     * Create a request for the method "flightclass.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.FlightClass}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightClass content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightClass> {

      private static final String REST_PATH = "walletobjects/v1/flightClass/{resourceId}";

      /**
       * Updates the flight class referenced by the given class ID.
       *
       * Create a request for the method "flightclass.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.FlightClass}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightClass content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.FlightClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Flightobject collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Flightobject.List request = walletobjects.flightobject().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Flightobject flightobject() {
    return new Flightobject();
  }

  /**
   * The "flightobject" collection of methods.
   */
  public class Flightobject {

    /**
     * Adds a message to the flight object referenced by the given object ID.
     *
     * Create a request for the method "flightobject.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightObjectAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/flightObject/{resourceId}/addMessage";

      /**
       * Adds a message to the flight object referenced by the given object ID.
       *
       * Create a request for the method "flightobject.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.FlightObjectAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the flight object with the given object ID.
     *
     * Create a request for the method "flightobject.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightObject> {

      private static final String REST_PATH = "walletobjects/v1/flightObject/{resourceId}";

      /**
       * Returns the flight object with the given object ID.
       *
       * Create a request for the method "flightobject.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.FlightObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an flight object with the given ID and properties.
     *
     * Create a request for the method "flightobject.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.FlightObject}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.FlightObject content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightObject> {

      private static final String REST_PATH = "walletobjects/v1/flightObject";

      /**
       * Inserts an flight object with the given ID and properties.
       *
       * Create a request for the method "flightobject.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.FlightObject}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.FlightObject content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.FlightObject.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all flight objects for a given issuer ID.
     *
     * Create a request for the method "flightobject.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightObjectListResponse> {

      private static final String REST_PATH = "walletobjects/v1/flightObject";

      /**
       * Returns a list of all flight objects for a given issuer ID.
       *
       * Create a request for the method "flightobject.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.FlightObjectListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the class whose objects will be listed. */
      @com.google.api.client.util.Key
      private java.lang.String classId;

      /** The ID of the class whose objects will be listed.
       */
      public java.lang.String getClassId() {
        return classId;
      }

      /** The ID of the class whose objects will be listed. */
      public List setClassId(java.lang.String classId) {
        this.classId = classId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     objects are available in a list. For example, if you have a list of 200 objects and you call list
     with `maxResults` set to 20, list will return the first 20 objects and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 objects.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the flight object referenced by the given object ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "flightobject.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.FlightObject}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightObject content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightObject> {

      private static final String REST_PATH = "walletobjects/v1/flightObject/{resourceId}";

      /**
       * Updates the flight object referenced by the given object ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "flightobject.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.FlightObject}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightObject content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.FlightObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the flight object referenced by the given object ID.
     *
     * Create a request for the method "flightobject.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.FlightObject}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightObject content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.FlightObject> {

      private static final String REST_PATH = "walletobjects/v1/flightObject/{resourceId}";

      /**
       * Updates the flight object referenced by the given object ID.
       *
       * Create a request for the method "flightobject.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.FlightObject}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.FlightObject content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.FlightObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Genericclass collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Genericclass.List request = walletobjects.genericclass().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Genericclass genericclass() {
    return new Genericclass();
  }

  /**
   * The "genericclass" collection of methods.
   */
  public class Genericclass {

    /**
     * Adds a message to the generic class referenced by the given class ID.
     *
     * Create a request for the method "genericclass.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericClassAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/genericClass/{resourceId}/addMessage";

      /**
       * Adds a message to the generic class referenced by the given class ID.
       *
       * Create a request for the method "genericclass.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GenericClassAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the generic class with the given class ID.
     *
     * Create a request for the method "genericclass.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericClass> {

      private static final String REST_PATH = "walletobjects/v1/genericClass/{resourceId}";

      /**
       * Returns the generic class with the given class ID.
       *
       * Create a request for the method "genericclass.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GenericClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
     `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`,
     `_`, or `-`.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a generic class with the given ID and properties.
     *
     * Create a request for the method "genericclass.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.GenericClass}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.GenericClass content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericClass> {

      private static final String REST_PATH = "walletobjects/v1/genericClass";

      /**
       * Inserts a generic class with the given ID and properties.
       *
       * Create a request for the method "genericclass.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.GenericClass}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.GenericClass content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GenericClass.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all generic classes for a given issuer ID.
     *
     * Create a request for the method "genericclass.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericClassListResponse> {

      private static final String REST_PATH = "walletobjects/v1/genericClass";

      /**
       * Returns a list of all generic classes for a given issuer ID.
       *
       * Create a request for the method "genericclass.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GenericClassListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the issuer authorized to list classes. */
      @com.google.api.client.util.Key
      private java.lang.Long issuerId;

      /** The ID of the issuer authorized to list classes.
       */
      public java.lang.Long getIssuerId() {
        return issuerId;
      }

      /** The ID of the issuer authorized to list classes. */
      public List setIssuerId(java.lang.Long issuerId) {
        this.issuerId = issuerId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     classes are available in a list. For example, if you have a list of 200 classes and you call list
     with `maxResults` set to 20, list will return the first 20 classes and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 classes.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the generic class referenced by the given class ID. This method supports patch semantics.
     *
     * Create a request for the method "genericclass.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
     * @param content the {@link com.google.api.services.walletobjects.model.GenericClass}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericClass content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericClass> {

      private static final String REST_PATH = "walletobjects/v1/genericClass/{resourceId}";

      /**
       * Updates the generic class referenced by the given class ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "genericclass.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
       * @param content the {@link com.google.api.services.walletobjects.model.GenericClass}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericClass content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.GenericClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
     `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`,
     `_`, or `-`.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the Generic class referenced by the given class ID.
     *
     * Create a request for the method "genericclass.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
     * @param content the {@link com.google.api.services.walletobjects.model.GenericClass}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericClass content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericClass> {

      private static final String REST_PATH = "walletobjects/v1/genericClass/{resourceId}";

      /**
       * Updates the Generic class referenced by the given class ID.
       *
       * Create a request for the method "genericclass.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
       * @param content the {@link com.google.api.services.walletobjects.model.GenericClass}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericClass content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.GenericClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
     `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`,
     `_`, or `-`.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Genericobject collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Genericobject.List request = walletobjects.genericobject().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Genericobject genericobject() {
    return new Genericobject();
  }

  /**
   * The "genericobject" collection of methods.
   */
  public class Genericobject {

    /**
     * Adds a message to the generic object referenced by the given object ID.
     *
     * Create a request for the method "genericobject.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericObjectAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/genericObject/{resourceId}/addMessage";

      /**
       * Adds a message to the generic object referenced by the given object ID.
       *
       * Create a request for the method "genericobject.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GenericObjectAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the generic object with the given object ID.
     *
     * Create a request for the method "genericobject.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericObject> {

      private static final String REST_PATH = "walletobjects/v1/genericObject/{resourceId}";

      /**
       * Returns the generic object with the given object ID.
       *
       * Create a request for the method "genericobject.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GenericObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
     `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`,
     `_`, or `-`.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a generic object with the given ID and properties.
     *
     * Create a request for the method "genericobject.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.GenericObject}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.GenericObject content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericObject> {

      private static final String REST_PATH = "walletobjects/v1/genericObject";

      /**
       * Inserts a generic object with the given ID and properties.
       *
       * Create a request for the method "genericobject.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.GenericObject}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.GenericObject content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GenericObject.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all generic objects for a given issuer ID.
     *
     * Create a request for the method "genericobject.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericObjectListResponse> {

      private static final String REST_PATH = "walletobjects/v1/genericObject";

      /**
       * Returns a list of all generic objects for a given issuer ID.
       *
       * Create a request for the method "genericobject.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GenericObjectListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the class whose objects will be listed. */
      @com.google.api.client.util.Key
      private java.lang.String classId;

      /** The ID of the class whose objects will be listed.
       */
      public java.lang.String getClassId() {
        return classId;
      }

      /** The ID of the class whose objects will be listed. */
      public List setClassId(java.lang.String classId) {
        this.classId = classId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     objects are available in a list. For example, if you have a list of 200 objects and you call list
     with `maxResults` set to 20, list will return the first 20 objects and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 objects.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the generic object referenced by the given object ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "genericobject.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
     * @param content the {@link com.google.api.services.walletobjects.model.GenericObject}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericObject content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericObject> {

      private static final String REST_PATH = "walletobjects/v1/genericObject/{resourceId}";

      /**
       * Updates the generic object referenced by the given object ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "genericobject.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
       * @param content the {@link com.google.api.services.walletobjects.model.GenericObject}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericObject content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.GenericObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
     `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`,
     `_`, or `-`.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the generic object referenced by the given object ID.
     *
     * Create a request for the method "genericobject.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
     * @param content the {@link com.google.api.services.walletobjects.model.GenericObject}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericObject content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GenericObject> {

      private static final String REST_PATH = "walletobjects/v1/genericObject/{resourceId}";

      /**
       * Updates the generic object referenced by the given object ID.
       *
       * Create a request for the method "genericobject.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value needs to follow the format `issuerID.identifier` where `issuerID` is issued by
     *        Google and `identifier` is chosen by you. The unique identifier can only include
     *        alphanumeric characters, `.`, `_`, or `-`.
       * @param content the {@link com.google.api.services.walletobjects.model.GenericObject}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GenericObject content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.GenericObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
     `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`,
     `_`, or `-`.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
       * issued by Google and `identifier` is chosen by you. The unique identifier can only include
       * alphanumeric characters, `.`, `_`, or `-`.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Giftcardclass collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Giftcardclass.List request = walletobjects.giftcardclass().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Giftcardclass giftcardclass() {
    return new Giftcardclass();
  }

  /**
   * The "giftcardclass" collection of methods.
   */
  public class Giftcardclass {

    /**
     * Adds a message to the gift card class referenced by the given class ID.
     *
     * Create a request for the method "giftcardclass.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardClassAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/giftCardClass/{resourceId}/addMessage";

      /**
       * Adds a message to the gift card class referenced by the given class ID.
       *
       * Create a request for the method "giftcardclass.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardClassAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the gift card class with the given class ID.
     *
     * Create a request for the method "giftcardclass.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardClass> {

      private static final String REST_PATH = "walletobjects/v1/giftCardClass/{resourceId}";

      /**
       * Returns the gift card class with the given class ID.
       *
       * Create a request for the method "giftcardclass.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GiftCardClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an gift card class with the given ID and properties.
     *
     * Create a request for the method "giftcardclass.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.GiftCardClass}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.GiftCardClass content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardClass> {

      private static final String REST_PATH = "walletobjects/v1/giftCardClass";

      /**
       * Inserts an gift card class with the given ID and properties.
       *
       * Create a request for the method "giftcardclass.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.GiftCardClass}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.GiftCardClass content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardClass.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all gift card classes for a given issuer ID.
     *
     * Create a request for the method "giftcardclass.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardClassListResponse> {

      private static final String REST_PATH = "walletobjects/v1/giftCardClass";

      /**
       * Returns a list of all gift card classes for a given issuer ID.
       *
       * Create a request for the method "giftcardclass.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GiftCardClassListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the issuer authorized to list classes. */
      @com.google.api.client.util.Key
      private java.lang.Long issuerId;

      /** The ID of the issuer authorized to list classes.
       */
      public java.lang.Long getIssuerId() {
        return issuerId;
      }

      /** The ID of the issuer authorized to list classes. */
      public List setIssuerId(java.lang.Long issuerId) {
        this.issuerId = issuerId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     classes are available in a list. For example, if you have a list of 200 classes and you call list
     with `maxResults` set to 20, list will return the first 20 classes and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 classes.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the gift card class referenced by the given class ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "giftcardclass.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.GiftCardClass}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardClass content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardClass> {

      private static final String REST_PATH = "walletobjects/v1/giftCardClass/{resourceId}";

      /**
       * Updates the gift card class referenced by the given class ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "giftcardclass.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.GiftCardClass}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardClass content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the gift card class referenced by the given class ID.
     *
     * Create a request for the method "giftcardclass.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.GiftCardClass}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardClass content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardClass> {

      private static final String REST_PATH = "walletobjects/v1/giftCardClass/{resourceId}";

      /**
       * Updates the gift card class referenced by the given class ID.
       *
       * Create a request for the method "giftcardclass.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.GiftCardClass}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardClass content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Giftcardobject collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Giftcardobject.List request = walletobjects.giftcardobject().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Giftcardobject giftcardobject() {
    return new Giftcardobject();
  }

  /**
   * The "giftcardobject" collection of methods.
   */
  public class Giftcardobject {

    /**
     * Adds a message to the gift card object referenced by the given object ID.
     *
     * Create a request for the method "giftcardobject.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardObjectAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/giftCardObject/{resourceId}/addMessage";

      /**
       * Adds a message to the gift card object referenced by the given object ID.
       *
       * Create a request for the method "giftcardobject.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardObjectAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the gift card object with the given object ID.
     *
     * Create a request for the method "giftcardobject.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardObject> {

      private static final String REST_PATH = "walletobjects/v1/giftCardObject/{resourceId}";

      /**
       * Returns the gift card object with the given object ID.
       *
       * Create a request for the method "giftcardobject.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GiftCardObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an gift card object with the given ID and properties.
     *
     * Create a request for the method "giftcardobject.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.GiftCardObject}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.GiftCardObject content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardObject> {

      private static final String REST_PATH = "walletobjects/v1/giftCardObject";

      /**
       * Inserts an gift card object with the given ID and properties.
       *
       * Create a request for the method "giftcardobject.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.GiftCardObject}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.GiftCardObject content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardObject.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all gift card objects for a given issuer ID.
     *
     * Create a request for the method "giftcardobject.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardObjectListResponse> {

      private static final String REST_PATH = "walletobjects/v1/giftCardObject";

      /**
       * Returns a list of all gift card objects for a given issuer ID.
       *
       * Create a request for the method "giftcardobject.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.GiftCardObjectListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the class whose objects will be listed. */
      @com.google.api.client.util.Key
      private java.lang.String classId;

      /** The ID of the class whose objects will be listed.
       */
      public java.lang.String getClassId() {
        return classId;
      }

      /** The ID of the class whose objects will be listed. */
      public List setClassId(java.lang.String classId) {
        this.classId = classId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     objects are available in a list. For example, if you have a list of 200 objects and you call list
     with `maxResults` set to 20, list will return the first 20 objects and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 objects.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the gift card object referenced by the given object ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "giftcardobject.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.GiftCardObject}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardObject content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardObject> {

      private static final String REST_PATH = "walletobjects/v1/giftCardObject/{resourceId}";

      /**
       * Updates the gift card object referenced by the given object ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "giftcardobject.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.GiftCardObject}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardObject content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the gift card object referenced by the given object ID.
     *
     * Create a request for the method "giftcardobject.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.GiftCardObject}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardObject content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.GiftCardObject> {

      private static final String REST_PATH = "walletobjects/v1/giftCardObject/{resourceId}";

      /**
       * Updates the gift card object referenced by the given object ID.
       *
       * Create a request for the method "giftcardobject.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.GiftCardObject}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.GiftCardObject content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.GiftCardObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Issuer collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Issuer.List request = walletobjects.issuer().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Issuer issuer() {
    return new Issuer();
  }

  /**
   * The "issuer" collection of methods.
   */
  public class Issuer {

    /**
     * Returns the issuer with the given issuer ID.
     *
     * Create a request for the method "issuer.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an issuer.
     * @return the request
     */
    public Get get(java.lang.Long resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.Issuer> {

      private static final String REST_PATH = "walletobjects/v1/issuer/{resourceId}";

      /**
       * Returns the issuer with the given issuer ID.
       *
       * Create a request for the method "issuer.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an issuer.
       * @since 1.13
       */
      protected Get(java.lang.Long resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.Issuer.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The unique identifier for an issuer. */
      @com.google.api.client.util.Key
      private java.lang.Long resourceId;

      /** The unique identifier for an issuer.
       */
      public java.lang.Long getResourceId() {
        return resourceId;
      }

      /** The unique identifier for an issuer. */
      public Get setResourceId(java.lang.Long resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an issuer with the given ID and properties.
     *
     * Create a request for the method "issuer.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.Issuer}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.Issuer content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.Issuer> {

      private static final String REST_PATH = "walletobjects/v1/issuer";

      /**
       * Inserts an issuer with the given ID and properties.
       *
       * Create a request for the method "issuer.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.Issuer}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.Issuer content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.Issuer.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all issuers shared to the caller.
     *
     * Create a request for the method "issuer.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.IssuerListResponse> {

      private static final String REST_PATH = "walletobjects/v1/issuer";

      /**
       * Returns a list of all issuers shared to the caller.
       *
       * Create a request for the method "issuer.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.IssuerListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the issuer referenced by the given issuer ID. This method supports patch semantics.
     *
     * Create a request for the method "issuer.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an issuer.
     * @param content the {@link com.google.api.services.walletobjects.model.Issuer}
     * @return the request
     */
    public Patch patch(java.lang.Long resourceId, com.google.api.services.walletobjects.model.Issuer content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.Issuer> {

      private static final String REST_PATH = "walletobjects/v1/issuer/{resourceId}";

      /**
       * Updates the issuer referenced by the given issuer ID. This method supports patch semantics.
       *
       * Create a request for the method "issuer.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an issuer.
       * @param content the {@link com.google.api.services.walletobjects.model.Issuer}
       * @since 1.13
       */
      protected Patch(java.lang.Long resourceId, com.google.api.services.walletobjects.model.Issuer content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.Issuer.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** The unique identifier for an issuer. */
      @com.google.api.client.util.Key
      private java.lang.Long resourceId;

      /** The unique identifier for an issuer.
       */
      public java.lang.Long getResourceId() {
        return resourceId;
      }

      /** The unique identifier for an issuer. */
      public Patch setResourceId(java.lang.Long resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the issuer referenced by the given issuer ID.
     *
     * Create a request for the method "issuer.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an issuer.
     * @param content the {@link com.google.api.services.walletobjects.model.Issuer}
     * @return the request
     */
    public Update update(java.lang.Long resourceId, com.google.api.services.walletobjects.model.Issuer content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.Issuer> {

      private static final String REST_PATH = "walletobjects/v1/issuer/{resourceId}";

      /**
       * Updates the issuer referenced by the given issuer ID.
       *
       * Create a request for the method "issuer.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an issuer.
       * @param content the {@link com.google.api.services.walletobjects.model.Issuer}
       * @since 1.13
       */
      protected Update(java.lang.Long resourceId, com.google.api.services.walletobjects.model.Issuer content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.Issuer.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The unique identifier for an issuer. */
      @com.google.api.client.util.Key
      private java.lang.Long resourceId;

      /** The unique identifier for an issuer.
       */
      public java.lang.Long getResourceId() {
        return resourceId;
      }

      /** The unique identifier for an issuer. */
      public Update setResourceId(java.lang.Long resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Jwt collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Jwt.List request = walletobjects.jwt().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Jwt jwt() {
    return new Jwt();
  }

  /**
   * The "jwt" collection of methods.
   */
  public class Jwt {

    /**
     * Inserts the resources in the JWT.
     *
     * Create a request for the method "jwt.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.JwtResource}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.JwtResource content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.JwtInsertResponse> {

      private static final String REST_PATH = "walletobjects/v1/jwt";

      /**
       * Inserts the resources in the JWT.
       *
       * Create a request for the method "jwt.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.JwtResource}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.JwtResource content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.JwtInsertResponse.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Loyaltyclass collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Loyaltyclass.List request = walletobjects.loyaltyclass().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Loyaltyclass loyaltyclass() {
    return new Loyaltyclass();
  }

  /**
   * The "loyaltyclass" collection of methods.
   */
  public class Loyaltyclass {

    /**
     * Adds a message to the loyalty class referenced by the given class ID.
     *
     * Create a request for the method "loyaltyclass.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyClassAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyClass/{resourceId}/addMessage";

      /**
       * Adds a message to the loyalty class referenced by the given class ID.
       *
       * Create a request for the method "loyaltyclass.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyClassAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the loyalty class with the given class ID.
     *
     * Create a request for the method "loyaltyclass.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyClass> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyClass/{resourceId}";

      /**
       * Returns the loyalty class with the given class ID.
       *
       * Create a request for the method "loyaltyclass.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.LoyaltyClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an loyalty class with the given ID and properties.
     *
     * Create a request for the method "loyaltyclass.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyClass}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.LoyaltyClass content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyClass> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyClass";

      /**
       * Inserts an loyalty class with the given ID and properties.
       *
       * Create a request for the method "loyaltyclass.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyClass}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.LoyaltyClass content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyClass.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all loyalty classes for a given issuer ID.
     *
     * Create a request for the method "loyaltyclass.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyClassListResponse> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyClass";

      /**
       * Returns a list of all loyalty classes for a given issuer ID.
       *
       * Create a request for the method "loyaltyclass.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.LoyaltyClassListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the issuer authorized to list classes. */
      @com.google.api.client.util.Key
      private java.lang.Long issuerId;

      /** The ID of the issuer authorized to list classes.
       */
      public java.lang.Long getIssuerId() {
        return issuerId;
      }

      /** The ID of the issuer authorized to list classes. */
      public List setIssuerId(java.lang.Long issuerId) {
        this.issuerId = issuerId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     classes are available in a list. For example, if you have a list of 200 classes and you call list
     with `maxResults` set to 20, list will return the first 20 classes and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 classes.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the loyalty class referenced by the given class ID. This method supports patch semantics.
     *
     * Create a request for the method "loyaltyclass.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyClass}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyClass content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyClass> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyClass/{resourceId}";

      /**
       * Updates the loyalty class referenced by the given class ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "loyaltyclass.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyClass}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyClass content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the loyalty class referenced by the given class ID.
     *
     * Create a request for the method "loyaltyclass.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyClass}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyClass content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyClass> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyClass/{resourceId}";

      /**
       * Updates the loyalty class referenced by the given class ID.
       *
       * Create a request for the method "loyaltyclass.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyClass}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyClass content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Loyaltyobject collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Loyaltyobject.List request = walletobjects.loyaltyobject().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Loyaltyobject loyaltyobject() {
    return new Loyaltyobject();
  }

  /**
   * The "loyaltyobject" collection of methods.
   */
  public class Loyaltyobject {

    /**
     * Adds a message to the loyalty object referenced by the given object ID.
     *
     * Create a request for the method "loyaltyobject.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyObjectAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyObject/{resourceId}/addMessage";

      /**
       * Adds a message to the loyalty object referenced by the given object ID.
       *
       * Create a request for the method "loyaltyobject.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyObjectAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the loyalty object with the given object ID.
     *
     * Create a request for the method "loyaltyobject.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyObject> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyObject/{resourceId}";

      /**
       * Returns the loyalty object with the given object ID.
       *
       * Create a request for the method "loyaltyobject.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.LoyaltyObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an loyalty object with the given ID and properties.
     *
     * Create a request for the method "loyaltyobject.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyObject}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.LoyaltyObject content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyObject> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyObject";

      /**
       * Inserts an loyalty object with the given ID and properties.
       *
       * Create a request for the method "loyaltyobject.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyObject}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.LoyaltyObject content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyObject.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all loyalty objects for a given issuer ID.
     *
     * Create a request for the method "loyaltyobject.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyObjectListResponse> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyObject";

      /**
       * Returns a list of all loyalty objects for a given issuer ID.
       *
       * Create a request for the method "loyaltyobject.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.LoyaltyObjectListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the class whose objects will be listed. */
      @com.google.api.client.util.Key
      private java.lang.String classId;

      /** The ID of the class whose objects will be listed.
       */
      public java.lang.String getClassId() {
        return classId;
      }

      /** The ID of the class whose objects will be listed. */
      public List setClassId(java.lang.String classId) {
        this.classId = classId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     objects are available in a list. For example, if you have a list of 200 objects and you call list
     with `maxResults` set to 20, list will return the first 20 objects and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 objects.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Modifies linked offer objects for the loyalty object with the given ID.
     *
     * Create a request for the method "loyaltyobject.modifylinkedofferobjects".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Modifylinkedofferobjects#execute()} method to invoke the remote
     * operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest}
     * @return the request
     */
    public Modifylinkedofferobjects modifylinkedofferobjects(java.lang.String resourceId, com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest content) throws java.io.IOException {
      Modifylinkedofferobjects result = new Modifylinkedofferobjects(resourceId, content);
      initialize(result);
      return result;
    }

    public class Modifylinkedofferobjects extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyObject> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyObject/{resourceId}/modifyLinkedOfferObjects";

      /**
       * Modifies linked offer objects for the loyalty object with the given ID.
       *
       * Create a request for the method "loyaltyobject.modifylinkedofferobjects".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Modifylinkedofferobjects#execute()} method to invoke the
       * remote operation. <p> {@link Modifylinkedofferobjects#initialize(com.google.api.client.googleap
       * is.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest}
       * @since 1.13
       */
      protected Modifylinkedofferobjects(java.lang.String resourceId, com.google.api.services.walletobjects.model.ModifyLinkedOfferObjectsRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Modifylinkedofferobjects set$Xgafv(java.lang.String $Xgafv) {
        return (Modifylinkedofferobjects) super.set$Xgafv($Xgafv);
      }

      @Override
      public Modifylinkedofferobjects setAccessToken(java.lang.String accessToken) {
        return (Modifylinkedofferobjects) super.setAccessToken(accessToken);
      }

      @Override
      public Modifylinkedofferobjects setAlt(java.lang.String alt) {
        return (Modifylinkedofferobjects) super.setAlt(alt);
      }

      @Override
      public Modifylinkedofferobjects setCallback(java.lang.String callback) {
        return (Modifylinkedofferobjects) super.setCallback(callback);
      }

      @Override
      public Modifylinkedofferobjects setFields(java.lang.String fields) {
        return (Modifylinkedofferobjects) super.setFields(fields);
      }

      @Override
      public Modifylinkedofferobjects setKey(java.lang.String key) {
        return (Modifylinkedofferobjects) super.setKey(key);
      }

      @Override
      public Modifylinkedofferobjects setOauthToken(java.lang.String oauthToken) {
        return (Modifylinkedofferobjects) super.setOauthToken(oauthToken);
      }

      @Override
      public Modifylinkedofferobjects setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Modifylinkedofferobjects) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Modifylinkedofferobjects setQuotaUser(java.lang.String quotaUser) {
        return (Modifylinkedofferobjects) super.setQuotaUser(quotaUser);
      }

      @Override
      public Modifylinkedofferobjects setUploadType(java.lang.String uploadType) {
        return (Modifylinkedofferobjects) super.setUploadType(uploadType);
      }

      @Override
      public Modifylinkedofferobjects setUploadProtocol(java.lang.String uploadProtocol) {
        return (Modifylinkedofferobjects) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Modifylinkedofferobjects setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Modifylinkedofferobjects set(String parameterName, Object value) {
        return (Modifylinkedofferobjects) super.set(parameterName, value);
      }
    }
    /**
     * Updates the loyalty object referenced by the given object ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "loyaltyobject.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyObject}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyObject content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyObject> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyObject/{resourceId}";

      /**
       * Updates the loyalty object referenced by the given object ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "loyaltyobject.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyObject}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyObject content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the loyalty object referenced by the given object ID.
     *
     * Create a request for the method "loyaltyobject.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyObject}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyObject content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.LoyaltyObject> {

      private static final String REST_PATH = "walletobjects/v1/loyaltyObject/{resourceId}";

      /**
       * Updates the loyalty object referenced by the given object ID.
       *
       * Create a request for the method "loyaltyobject.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.LoyaltyObject}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.LoyaltyObject content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.LoyaltyObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Media collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Media.List request = walletobjects.media().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Media media() {
    return new Media();
  }

  /**
   * The "media" collection of methods.
   */
  public class Media {

    /**
     * Downloads rotating barcode values for the transit object referenced by the given object ID.
     *
     * Create a request for the method "media.download".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Download#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Download download(java.lang.String resourceId) throws java.io.IOException {
      Download result = new Download(resourceId);
      initialize(result);
      return result;
    }

    public class Download extends WalletobjectsRequest<com.google.api.services.walletobjects.model.Media> {

      private static final String REST_PATH = "walletobjects/v1/transitObject/{resourceId}/downloadRotatingBarcodeValues";

      /**
       * Downloads rotating barcode values for the transit object referenced by the given object ID.
       *
       * Create a request for the method "media.download".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Download#execute()} method to invoke the remote operation.
       * <p> {@link
       * Download#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Download(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.Media.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Download set$Xgafv(java.lang.String $Xgafv) {
        return (Download) super.set$Xgafv($Xgafv);
      }

      @Override
      public Download setAccessToken(java.lang.String accessToken) {
        return (Download) super.setAccessToken(accessToken);
      }

      @Override
      public Download setAlt(java.lang.String alt) {
        return (Download) super.setAlt(alt);
      }

      @Override
      public Download setCallback(java.lang.String callback) {
        return (Download) super.setCallback(callback);
      }

      @Override
      public Download setFields(java.lang.String fields) {
        return (Download) super.setFields(fields);
      }

      @Override
      public Download setKey(java.lang.String key) {
        return (Download) super.setKey(key);
      }

      @Override
      public Download setOauthToken(java.lang.String oauthToken) {
        return (Download) super.setOauthToken(oauthToken);
      }

      @Override
      public Download setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Download) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Download setQuotaUser(java.lang.String quotaUser) {
        return (Download) super.setQuotaUser(quotaUser);
      }

      @Override
      public Download setUploadType(java.lang.String uploadType) {
        return (Download) super.setUploadType(uploadType);
      }

      @Override
      public Download setUploadProtocol(java.lang.String uploadProtocol) {
        return (Download) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Download setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Download set(String parameterName, Object value) {
        return (Download) super.set(parameterName, value);
      }
    }
    /**
     * Uploads rotating barcode values for the transit object referenced by the given object ID. Note
     * the max upload size is specified in google3/production/config/cdd/apps-upload/customers/payments-
     * consumer-passes/config.gcl and enforced by Scotty.
     *
     * Create a request for the method "media.upload".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Upload#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest}
     * @return the request
     */
    public Upload upload(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest content) throws java.io.IOException {
      Upload result = new Upload(resourceId, content);
      initialize(result);
      return result;
    }

    /**
     * Uploads rotating barcode values for the transit object referenced by the given object ID. Note
     * the max upload size is specified in google3/production/config/cdd/apps-upload/customers/payments-
     * consumer-passes/config.gcl and enforced by Scotty.
     *
     * Create a request for the method "media.upload".
     *
     * This request holds the parameters needed by the the walletobjects server.  After setting any
     * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Upload upload(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Upload result = new Upload(resourceId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Upload extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesResponse> {

      private static final String REST_PATH = "walletobjects/v1/transitObject/{resourceId}/uploadRotatingBarcodeValues";

      /**
       * Uploads rotating barcode values for the transit object referenced by the given object ID. Note
       * the max upload size is specified in google3/production/config/cdd/apps-
       * upload/customers/payments-consumer-passes/config.gcl and enforced by Scotty.
       *
       * Create a request for the method "media.upload".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       * <p> {@link
       * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest}
       * @since 1.13
       */
      protected Upload(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      /**
       * Uploads rotating barcode values for the transit object referenced by the given object ID. Note
       * the max upload size is specified in google3/production/config/cdd/apps-
       * upload/customers/payments-consumer-passes/config.gcl and enforced by Scotty.
       *
       * Create a request for the method "media.upload".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Upload#execute()} method to invoke the remote operation.
       * <p> {@link
       * Upload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content.
       * @since 1.13
       */
      protected Upload(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesRequest content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Walletobjects.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.walletobjects.model.TransitObjectUploadRotatingBarcodeValuesResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
        com.google.api.client.util.Preconditions.checkNotNull(mediaContent, "Required parameter mediaContent must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Upload set$Xgafv(java.lang.String $Xgafv) {
        return (Upload) super.set$Xgafv($Xgafv);
      }

      @Override
      public Upload setAccessToken(java.lang.String accessToken) {
        return (Upload) super.setAccessToken(accessToken);
      }

      @Override
      public Upload setAlt(java.lang.String alt) {
        return (Upload) super.setAlt(alt);
      }

      @Override
      public Upload setCallback(java.lang.String callback) {
        return (Upload) super.setCallback(callback);
      }

      @Override
      public Upload setFields(java.lang.String fields) {
        return (Upload) super.setFields(fields);
      }

      @Override
      public Upload setKey(java.lang.String key) {
        return (Upload) super.setKey(key);
      }

      @Override
      public Upload setOauthToken(java.lang.String oauthToken) {
        return (Upload) super.setOauthToken(oauthToken);
      }

      @Override
      public Upload setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Upload) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Upload setQuotaUser(java.lang.String quotaUser) {
        return (Upload) super.setQuotaUser(quotaUser);
      }

      @Override
      public Upload setUploadType(java.lang.String uploadType) {
        return (Upload) super.setUploadType(uploadType);
      }

      @Override
      public Upload setUploadProtocol(java.lang.String uploadProtocol) {
        return (Upload) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Upload setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Upload set(String parameterName, Object value) {
        return (Upload) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Offerclass collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Offerclass.List request = walletobjects.offerclass().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Offerclass offerclass() {
    return new Offerclass();
  }

  /**
   * The "offerclass" collection of methods.
   */
  public class Offerclass {

    /**
     * Adds a message to the offer class referenced by the given class ID.
     *
     * Create a request for the method "offerclass.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferClassAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/offerClass/{resourceId}/addMessage";

      /**
       * Adds a message to the offer class referenced by the given class ID.
       *
       * Create a request for the method "offerclass.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.OfferClassAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the offer class with the given class ID.
     *
     * Create a request for the method "offerclass.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferClass> {

      private static final String REST_PATH = "walletobjects/v1/offerClass/{resourceId}";

      /**
       * Returns the offer class with the given class ID.
       *
       * Create a request for the method "offerclass.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.OfferClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an offer class with the given ID and properties.
     *
     * Create a request for the method "offerclass.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.OfferClass}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.OfferClass content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferClass> {

      private static final String REST_PATH = "walletobjects/v1/offerClass";

      /**
       * Inserts an offer class with the given ID and properties.
       *
       * Create a request for the method "offerclass.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.OfferClass}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.OfferClass content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.OfferClass.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all offer classes for a given issuer ID.
     *
     * Create a request for the method "offerclass.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferClassListResponse> {

      private static final String REST_PATH = "walletobjects/v1/offerClass";

      /**
       * Returns a list of all offer classes for a given issuer ID.
       *
       * Create a request for the method "offerclass.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.OfferClassListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the issuer authorized to list classes. */
      @com.google.api.client.util.Key
      private java.lang.Long issuerId;

      /** The ID of the issuer authorized to list classes.
       */
      public java.lang.Long getIssuerId() {
        return issuerId;
      }

      /** The ID of the issuer authorized to list classes. */
      public List setIssuerId(java.lang.Long issuerId) {
        this.issuerId = issuerId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     classes are available in a list. For example, if you have a list of 200 classes and you call list
     with `maxResults` set to 20, list will return the first 20 classes and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 classes.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the offer class referenced by the given class ID. This method supports patch semantics.
     *
     * Create a request for the method "offerclass.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.OfferClass}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferClass content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferClass> {

      private static final String REST_PATH = "walletobjects/v1/offerClass/{resourceId}";

      /**
       * Updates the offer class referenced by the given class ID. This method supports patch semantics.
       *
       * Create a request for the method "offerclass.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.OfferClass}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferClass content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.OfferClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the offer class referenced by the given class ID.
     *
     * Create a request for the method "offerclass.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.OfferClass}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferClass content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferClass> {

      private static final String REST_PATH = "walletobjects/v1/offerClass/{resourceId}";

      /**
       * Updates the offer class referenced by the given class ID.
       *
       * Create a request for the method "offerclass.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.OfferClass}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferClass content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.OfferClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Offerobject collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Offerobject.List request = walletobjects.offerobject().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Offerobject offerobject() {
    return new Offerobject();
  }

  /**
   * The "offerobject" collection of methods.
   */
  public class Offerobject {

    /**
     * Adds a message to the offer object referenced by the given object ID.
     *
     * Create a request for the method "offerobject.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferObjectAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/offerObject/{resourceId}/addMessage";

      /**
       * Adds a message to the offer object referenced by the given object ID.
       *
       * Create a request for the method "offerobject.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.OfferObjectAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the offer object with the given object ID.
     *
     * Create a request for the method "offerobject.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferObject> {

      private static final String REST_PATH = "walletobjects/v1/offerObject/{resourceId}";

      /**
       * Returns the offer object with the given object ID.
       *
       * Create a request for the method "offerobject.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.OfferObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an offer object with the given ID and properties.
     *
     * Create a request for the method "offerobject.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.OfferObject}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.OfferObject content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferObject> {

      private static final String REST_PATH = "walletobjects/v1/offerObject";

      /**
       * Inserts an offer object with the given ID and properties.
       *
       * Create a request for the method "offerobject.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.OfferObject}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.OfferObject content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.OfferObject.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all offer objects for a given issuer ID.
     *
     * Create a request for the method "offerobject.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferObjectListResponse> {

      private static final String REST_PATH = "walletobjects/v1/offerObject";

      /**
       * Returns a list of all offer objects for a given issuer ID.
       *
       * Create a request for the method "offerobject.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.OfferObjectListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the class whose objects will be listed. */
      @com.google.api.client.util.Key
      private java.lang.String classId;

      /** The ID of the class whose objects will be listed.
       */
      public java.lang.String getClassId() {
        return classId;
      }

      /** The ID of the class whose objects will be listed. */
      public List setClassId(java.lang.String classId) {
        this.classId = classId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     objects are available in a list. For example, if you have a list of 200 objects and you call list
     with `maxResults` set to 20, list will return the first 20 objects and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 objects.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the offer object referenced by the given object ID. This method supports patch semantics.
     *
     * Create a request for the method "offerobject.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.OfferObject}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferObject content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferObject> {

      private static final String REST_PATH = "walletobjects/v1/offerObject/{resourceId}";

      /**
       * Updates the offer object referenced by the given object ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "offerobject.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.OfferObject}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferObject content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.OfferObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the offer object referenced by the given object ID.
     *
     * Create a request for the method "offerobject.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.OfferObject}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferObject content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.OfferObject> {

      private static final String REST_PATH = "walletobjects/v1/offerObject/{resourceId}";

      /**
       * Updates the offer object referenced by the given object ID.
       *
       * Create a request for the method "offerobject.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.OfferObject}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.OfferObject content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.OfferObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Permissions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Permissions.List request = walletobjects.permissions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Permissions permissions() {
    return new Permissions();
  }

  /**
   * The "permissions" collection of methods.
   */
  public class Permissions {

    /**
     * Returns the permissions for the given issuer id.
     *
     * Create a request for the method "permissions.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an issuer. This ID must be unique across all issuers.
     * @return the request
     */
    public Get get(java.lang.Long resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.Permissions> {

      private static final String REST_PATH = "walletobjects/v1/permissions/{resourceId}";

      /**
       * Returns the permissions for the given issuer id.
       *
       * Create a request for the method "permissions.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an issuer. This ID must be unique across all issuers.
       * @since 1.13
       */
      protected Get(java.lang.Long resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.Permissions.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The unique identifier for an issuer. This ID must be unique across all issuers. */
      @com.google.api.client.util.Key
      private java.lang.Long resourceId;

      /** The unique identifier for an issuer. This ID must be unique across all issuers.
       */
      public java.lang.Long getResourceId() {
        return resourceId;
      }

      /** The unique identifier for an issuer. This ID must be unique across all issuers. */
      public Get setResourceId(java.lang.Long resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Updates the permissions for the given issuer.
     *
     * Create a request for the method "permissions.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an issuer. This ID must be unique across all issuers.
     * @param content the {@link com.google.api.services.walletobjects.model.Permissions}
     * @return the request
     */
    public Update update(java.lang.Long resourceId, com.google.api.services.walletobjects.model.Permissions content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.Permissions> {

      private static final String REST_PATH = "walletobjects/v1/permissions/{resourceId}";

      /**
       * Updates the permissions for the given issuer.
       *
       * Create a request for the method "permissions.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an issuer. This ID must be unique across all issuers.
       * @param content the {@link com.google.api.services.walletobjects.model.Permissions}
       * @since 1.13
       */
      protected Update(java.lang.Long resourceId, com.google.api.services.walletobjects.model.Permissions content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.Permissions.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The unique identifier for an issuer. This ID must be unique across all issuers. */
      @com.google.api.client.util.Key
      private java.lang.Long resourceId;

      /** The unique identifier for an issuer. This ID must be unique across all issuers.
       */
      public java.lang.Long getResourceId() {
        return resourceId;
      }

      /** The unique identifier for an issuer. This ID must be unique across all issuers. */
      public Update setResourceId(java.lang.Long resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Smarttap collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Smarttap.List request = walletobjects.smarttap().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Smarttap smarttap() {
    return new Smarttap();
  }

  /**
   * The "smarttap" collection of methods.
   */
  public class Smarttap {

    /**
     * Inserts the smart tap.
     *
     * Create a request for the method "smarttap.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.SmartTap}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.SmartTap content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.SmartTap> {

      private static final String REST_PATH = "walletobjects/v1/smartTap";

      /**
       * Inserts the smart tap.
       *
       * Create a request for the method "smarttap.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.SmartTap}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.SmartTap content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.SmartTap.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Transitclass collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Transitclass.List request = walletobjects.transitclass().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Transitclass transitclass() {
    return new Transitclass();
  }

  /**
   * The "transitclass" collection of methods.
   */
  public class Transitclass {

    /**
     * Adds a message to the transit class referenced by the given class ID.
     *
     * Create a request for the method "transitclass.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitClassAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/transitClass/{resourceId}/addMessage";

      /**
       * Adds a message to the transit class referenced by the given class ID.
       *
       * Create a request for the method "transitclass.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.TransitClassAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the transit class with the given class ID.
     *
     * Create a request for the method "transitclass.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitClass> {

      private static final String REST_PATH = "walletobjects/v1/transitClass/{resourceId}";

      /**
       * Returns the transit class with the given class ID.
       *
       * Create a request for the method "transitclass.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.TransitClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a transit class with the given ID and properties.
     *
     * Create a request for the method "transitclass.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.TransitClass}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.TransitClass content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitClass> {

      private static final String REST_PATH = "walletobjects/v1/transitClass";

      /**
       * Inserts a transit class with the given ID and properties.
       *
       * Create a request for the method "transitclass.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.TransitClass}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.TransitClass content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.TransitClass.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all transit classes for a given issuer ID.
     *
     * Create a request for the method "transitclass.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitClassListResponse> {

      private static final String REST_PATH = "walletobjects/v1/transitClass";

      /**
       * Returns a list of all transit classes for a given issuer ID.
       *
       * Create a request for the method "transitclass.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.TransitClassListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the issuer authorized to list classes. */
      @com.google.api.client.util.Key
      private java.lang.Long issuerId;

      /** The ID of the issuer authorized to list classes.
       */
      public java.lang.Long getIssuerId() {
        return issuerId;
      }

      /** The ID of the issuer authorized to list classes. */
      public List setIssuerId(java.lang.Long issuerId) {
        this.issuerId = issuerId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     classes are available in a list. For example, if you have a list of 200 classes and you call list
     with `maxResults` set to 20, list will return the first 20 classes and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 classes.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` classes are available in a list. For example, if you have a list of 200
       * classes and you call list with `maxResults` set to 20, list will return the first 20
       * classes and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 classes.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the transit class referenced by the given class ID. This method supports patch semantics.
     *
     * Create a request for the method "transitclass.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.TransitClass}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitClass content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitClass> {

      private static final String REST_PATH = "walletobjects/v1/transitClass/{resourceId}";

      /**
       * Updates the transit class referenced by the given class ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "transitclass.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.TransitClass}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitClass content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.TransitClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the transit class referenced by the given class ID.
     *
     * Create a request for the method "transitclass.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.TransitClass}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitClass content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitClass> {

      private static final String REST_PATH = "walletobjects/v1/transitClass/{resourceId}";

      /**
       * Updates the transit class referenced by the given class ID.
       *
       * Create a request for the method "transitclass.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.TransitClass}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitClass content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.TransitClass.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for a class. This ID must be unique across all classes from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for a class. This ID must be unique across all classes from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Transitobject collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.Transitobject.List request = walletobjects.transitobject().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Transitobject transitobject() {
    return new Transitobject();
  }

  /**
   * The "transitobject" collection of methods.
   */
  public class Transitobject {

    /**
     * Adds a message to the transit object referenced by the given object ID.
     *
     * Create a request for the method "transitobject.addmessage".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Addmessage#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
     * @return the request
     */
    public Addmessage addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) throws java.io.IOException {
      Addmessage result = new Addmessage(resourceId, content);
      initialize(result);
      return result;
    }

    public class Addmessage extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitObjectAddMessageResponse> {

      private static final String REST_PATH = "walletobjects/v1/transitObject/{resourceId}/addMessage";

      /**
       * Adds a message to the transit object referenced by the given object ID.
       *
       * Create a request for the method "transitobject.addmessage".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Addmessage#execute()} method to invoke the remote
       * operation. <p> {@link
       * Addmessage#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.AddMessageRequest}
       * @since 1.13
       */
      protected Addmessage(java.lang.String resourceId, com.google.api.services.walletobjects.model.AddMessageRequest content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.TransitObjectAddMessageResponse.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Addmessage set$Xgafv(java.lang.String $Xgafv) {
        return (Addmessage) super.set$Xgafv($Xgafv);
      }

      @Override
      public Addmessage setAccessToken(java.lang.String accessToken) {
        return (Addmessage) super.setAccessToken(accessToken);
      }

      @Override
      public Addmessage setAlt(java.lang.String alt) {
        return (Addmessage) super.setAlt(alt);
      }

      @Override
      public Addmessage setCallback(java.lang.String callback) {
        return (Addmessage) super.setCallback(callback);
      }

      @Override
      public Addmessage setFields(java.lang.String fields) {
        return (Addmessage) super.setFields(fields);
      }

      @Override
      public Addmessage setKey(java.lang.String key) {
        return (Addmessage) super.setKey(key);
      }

      @Override
      public Addmessage setOauthToken(java.lang.String oauthToken) {
        return (Addmessage) super.setOauthToken(oauthToken);
      }

      @Override
      public Addmessage setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Addmessage) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Addmessage setQuotaUser(java.lang.String quotaUser) {
        return (Addmessage) super.setQuotaUser(quotaUser);
      }

      @Override
      public Addmessage setUploadType(java.lang.String uploadType) {
        return (Addmessage) super.setUploadType(uploadType);
      }

      @Override
      public Addmessage setUploadProtocol(java.lang.String uploadProtocol) {
        return (Addmessage) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Addmessage setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Addmessage set(String parameterName, Object value) {
        return (Addmessage) super.set(parameterName, value);
      }
    }
    /**
     * Returns the transit object with the given object ID.
     *
     * Create a request for the method "transitobject.get".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @return the request
     */
    public Get get(java.lang.String resourceId) throws java.io.IOException {
      Get result = new Get(resourceId);
      initialize(result);
      return result;
    }

    public class Get extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitObject> {

      private static final String REST_PATH = "walletobjects/v1/transitObject/{resourceId}";

      /**
       * Returns the transit object with the given object ID.
       *
       * Create a request for the method "transitobject.get".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @since 1.13
       */
      protected Get(java.lang.String resourceId) {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.TransitObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Get setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an transit object with the given ID and properties.
     *
     * Create a request for the method "transitobject.insert".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.walletobjects.model.TransitObject}
     * @return the request
     */
    public Insert insert(com.google.api.services.walletobjects.model.TransitObject content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitObject> {

      private static final String REST_PATH = "walletobjects/v1/transitObject";

      /**
       * Inserts an transit object with the given ID and properties.
       *
       * Create a request for the method "transitobject.insert".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.walletobjects.model.TransitObject}
       * @since 1.13
       */
      protected Insert(com.google.api.services.walletobjects.model.TransitObject content) {
        super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.TransitObject.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of all transit objects for a given issuer ID.
     *
     * Create a request for the method "transitobject.list".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitObjectListResponse> {

      private static final String REST_PATH = "walletobjects/v1/transitObject";

      /**
       * Returns a list of all transit objects for a given issuer ID.
       *
       * Create a request for the method "transitobject.list".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Walletobjects.this, "GET", REST_PATH, null, com.google.api.services.walletobjects.model.TransitObjectListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The ID of the class whose objects will be listed. */
      @com.google.api.client.util.Key
      private java.lang.String classId;

      /** The ID of the class whose objects will be listed.
       */
      public java.lang.String getClassId() {
        return classId;
      }

      /** The ID of the class whose objects will be listed. */
      public List setClassId(java.lang.String classId) {
        this.classId = classId;
        return this;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Identifies the max number of results returned by a list. All results are returned if `maxResults`
     isn't defined.
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Identifies the max number of results returned by a list. All results are returned if
       * `maxResults` isn't defined.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      @com.google.api.client.util.Key
      private java.lang.String token;

      /** Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
     objects are available in a list. For example, if you have a list of 200 objects and you call list
     with `maxResults` set to 20, list will return the first 20 objects and a token. Call list again
     with `maxResults` set to 20 and the token to get the next 20 objects.
       */
      public java.lang.String getToken() {
        return token;
      }

      /**
       * Used to get the next set of results if `maxResults` is specified, but more than
       * `maxResults` objects are available in a list. For example, if you have a list of 200
       * objects and you call list with `maxResults` set to 20, list will return the first 20
       * objects and a token. Call list again with `maxResults` set to 20 and the token to get the
       * next 20 objects.
       */
      public List setToken(java.lang.String token) {
        this.token = token;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the transit object referenced by the given object ID. This method supports patch
     * semantics.
     *
     * Create a request for the method "transitobject.patch".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.TransitObject}
     * @return the request
     */
    public Patch patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObject content) throws java.io.IOException {
      Patch result = new Patch(resourceId, content);
      initialize(result);
      return result;
    }

    public class Patch extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitObject> {

      private static final String REST_PATH = "walletobjects/v1/transitObject/{resourceId}";

      /**
       * Updates the transit object referenced by the given object ID. This method supports patch
       * semantics.
       *
       * Create a request for the method "transitobject.patch".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.TransitObject}
       * @since 1.13
       */
      protected Patch(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObject content) {
        super(Walletobjects.this, "PATCH", REST_PATH, content, com.google.api.services.walletobjects.model.TransitObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Patch setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the transit object referenced by the given object ID.
     *
     * Create a request for the method "transitobject.update".
     *
     * This request holds the parameters needed by the walletobjects server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
     * @param content the {@link com.google.api.services.walletobjects.model.TransitObject}
     * @return the request
     */
    public Update update(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObject content) throws java.io.IOException {
      Update result = new Update(resourceId, content);
      initialize(result);
      return result;
    }

    public class Update extends WalletobjectsRequest<com.google.api.services.walletobjects.model.TransitObject> {

      private static final String REST_PATH = "walletobjects/v1/transitObject/{resourceId}";

      /**
       * Updates the transit object referenced by the given object ID.
       *
       * Create a request for the method "transitobject.update".
       *
       * This request holds the parameters needed by the the walletobjects server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceId The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     *        value should follow the format issuer ID. identifier where the former is issued by Google
     *        and latter is chosen by you. Your unique identifier should only include alphanumeric
     *        characters, '.', '_', or '-'.
       * @param content the {@link com.google.api.services.walletobjects.model.TransitObject}
       * @since 1.13
       */
      protected Update(java.lang.String resourceId, com.google.api.services.walletobjects.model.TransitObject content) {
        super(Walletobjects.this, "PUT", REST_PATH, content, com.google.api.services.walletobjects.model.TransitObject.class);
        this.resourceId = com.google.api.client.util.Preconditions.checkNotNull(resourceId, "Required parameter resourceId must be specified.");
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceId;

      /** The unique identifier for an object. This ID must be unique across all objects from an issuer. This
     value should follow the format issuer ID. identifier where the former is issued by Google and
     latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.',
     '_', or '-'.
       */
      public java.lang.String getResourceId() {
        return resourceId;
      }

      /**
       * The unique identifier for an object. This ID must be unique across all objects from an
       * issuer. This value should follow the format issuer ID. identifier where the former is
       * issued by Google and latter is chosen by you. Your unique identifier should only include
       * alphanumeric characters, '.', '_', or '-'.
       */
      public Update setResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the WalletobjectsOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Walletobjects walletobjects = new Walletobjects(...);}
   *   {@code Walletobjects.WalletobjectsOperations.List request = walletobjects.walletobjects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public WalletobjectsOperations walletobjects() {
    return new WalletobjectsOperations();
  }

  /**
   * The "walletobjects" collection of methods.
   */
  public class WalletobjectsOperations {

    /**
     * An accessor for creating requests from the V1 collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Walletobjects walletobjects = new Walletobjects(...);}
     *   {@code Walletobjects.V1.List request = walletobjects.v1().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public V1 v1() {
      return new V1();
    }

    /**
     * The "v1" collection of methods.
     */
    public class V1 {

      /**
       * An accessor for creating requests from the PrivateContent collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Walletobjects walletobjects = new Walletobjects(...);}
       *   {@code Walletobjects.PrivateContent.List request = walletobjects.privateContent().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public PrivateContent privateContent() {
        return new PrivateContent();
      }

      /**
       * The "privateContent" collection of methods.
       */
      public class PrivateContent {

        /**
         * Provide Google with information about awaiting private pass update. This will allow Google to
         * provide the update notification to the device that currently holds this pass.
         *
         * Create a request for the method "privateContent.setPassUpdateNotice".
         *
         * This request holds the parameters needed by the walletobjects server.  After setting any optional
         * parameters, call the {@link SetPassUpdateNotice#execute()} method to invoke the remote operation.
         *
         * @param content the {@link com.google.api.services.walletobjects.model.SetPassUpdateNoticeRequest}
         * @return the request
         */
        public SetPassUpdateNotice setPassUpdateNotice(com.google.api.services.walletobjects.model.SetPassUpdateNoticeRequest content) throws java.io.IOException {
          SetPassUpdateNotice result = new SetPassUpdateNotice(content);
          initialize(result);
          return result;
        }

        public class SetPassUpdateNotice extends WalletobjectsRequest<com.google.api.services.walletobjects.model.SetPassUpdateNoticeResponse> {

          private static final String REST_PATH = "walletobjects/v1/privateContent/setPassUpdateNotice";

          /**
           * Provide Google with information about awaiting private pass update. This will allow Google to
           * provide the update notification to the device that currently holds this pass.
           *
           * Create a request for the method "privateContent.setPassUpdateNotice".
           *
           * This request holds the parameters needed by the the walletobjects server.  After setting any
           * optional parameters, call the {@link SetPassUpdateNotice#execute()} method to invoke the remote
           * operation. <p> {@link SetPassUpdateNotice#initialize(com.google.api.client.googleapis.services.
           * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param content the {@link com.google.api.services.walletobjects.model.SetPassUpdateNoticeRequest}
           * @since 1.13
           */
          protected SetPassUpdateNotice(com.google.api.services.walletobjects.model.SetPassUpdateNoticeRequest content) {
            super(Walletobjects.this, "POST", REST_PATH, content, com.google.api.services.walletobjects.model.SetPassUpdateNoticeResponse.class);
          }

          @Override
          public SetPassUpdateNotice set$Xgafv(java.lang.String $Xgafv) {
            return (SetPassUpdateNotice) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetPassUpdateNotice setAccessToken(java.lang.String accessToken) {
            return (SetPassUpdateNotice) super.setAccessToken(accessToken);
          }

          @Override
          public SetPassUpdateNotice setAlt(java.lang.String alt) {
            return (SetPassUpdateNotice) super.setAlt(alt);
          }

          @Override
          public SetPassUpdateNotice setCallback(java.lang.String callback) {
            return (SetPassUpdateNotice) super.setCallback(callback);
          }

          @Override
          public SetPassUpdateNotice setFields(java.lang.String fields) {
            return (SetPassUpdateNotice) super.setFields(fields);
          }

          @Override
          public SetPassUpdateNotice setKey(java.lang.String key) {
            return (SetPassUpdateNotice) super.setKey(key);
          }

          @Override
          public SetPassUpdateNotice setOauthToken(java.lang.String oauthToken) {
            return (SetPassUpdateNotice) super.setOauthToken(oauthToken);
          }

          @Override
          public SetPassUpdateNotice setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetPassUpdateNotice) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetPassUpdateNotice setQuotaUser(java.lang.String quotaUser) {
            return (SetPassUpdateNotice) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetPassUpdateNotice setUploadType(java.lang.String uploadType) {
            return (SetPassUpdateNotice) super.setUploadType(uploadType);
          }

          @Override
          public SetPassUpdateNotice setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetPassUpdateNotice) super.setUploadProtocol(uploadProtocol);
          }

          @Override
          public SetPassUpdateNotice set(String parameterName, Object value) {
            return (SetPassUpdateNotice) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link Walletobjects}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Walletobjects}. */
    @Override
    public Walletobjects build() {
      return new Walletobjects(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link WalletobjectsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setWalletobjectsRequestInitializer(
        WalletobjectsRequestInitializer walletobjectsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(walletobjectsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }

    @Override
    public Builder setUniverseDomain(String universeDomain) {
      return (Builder) super.setUniverseDomain(universeDomain);
    }
  }
}
