/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-15 at 15:35:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.tasks.model;

/**
 * Model definition for TaskList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Tasks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TaskList extends com.google.api.client.json.GenericJson {

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Task list identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Type of the resource. This is always "tasks#taskList".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * URL pointing to this task list. Used to retrieve, update, or delete this task list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Title of the task list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Last modification time of the task list (as a RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public TaskList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Task list identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Task list identifier.
   * @param id id or {@code null} for none
   */
  public TaskList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource. This is always "tasks#taskList".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource. This is always "tasks#taskList".
   * @param kind kind or {@code null} for none
   */
  public TaskList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * URL pointing to this task list. Used to retrieve, update, or delete this task list.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * URL pointing to this task list. Used to retrieve, update, or delete this task list.
   * @param selfLink selfLink or {@code null} for none
   */
  public TaskList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Title of the task list.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of the task list.
   * @param title title or {@code null} for none
   */
  public TaskList setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Last modification time of the task list (as a RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Last modification time of the task list (as a RFC 3339 timestamp).
   * @param updated updated or {@code null} for none
   */
  public TaskList setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public TaskList set(String fieldName, Object value) {
    return (TaskList) super.set(fieldName, value);
  }

  @Override
  public TaskList clone() {
    return (TaskList) super.clone();
  }

}
