/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.storage;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.StorageRequestInitializer;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.Channel;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class Storage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://storage.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "storage/v1beta2/";
    public static final String DEFAULT_BATCH_PATH = "batch/storage/v1beta2";
    public static final String DEFAULT_BASE_URL = "https://storage.googleapis.com/storage/v1beta2/";

    public Storage(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Storage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public BucketAccessControls bucketAccessControls() {
        return new BucketAccessControls();
    }

    public Buckets buckets() {
        return new Buckets();
    }

    public Channels channels() {
        return new Channels();
    }

    public DefaultObjectAccessControls defaultObjectAccessControls() {
        return new DefaultObjectAccessControls();
    }

    public ObjectAccessControls objectAccessControls() {
        return new ObjectAccessControls();
    }

    public Objects objects() {
        return new Objects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.28.0 of the Cloud Storage JSON API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Storage.DEFAULT_ROOT_URL, Storage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Storage.DEFAULT_BATCH_PATH);
        }

        public Storage build() {
            return new Storage(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setStorageRequestInitializer(StorageRequestInitializer storageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)storageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Objects {
        public Compose compose(String destinationBucket, String destinationObject, ComposeRequest content) throws IOException {
            Compose result = new Compose(destinationBucket, destinationObject, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Copy copy(String sourceBucket, String sourceObject, String destinationBucket, String destinationObject, StorageObject content) throws IOException {
            Copy result = new Copy(sourceBucket, sourceObject, destinationBucket, destinationObject, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String bucket, String object__) throws IOException {
            Delete result = new Delete(bucket, object__);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket, String object__) throws IOException {
            Get result = new Get(bucket, object__);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, StorageObject content) throws IOException {
            Insert result = new Insert(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, StorageObject content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(bucket, content, mediaContent);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String bucket) throws IOException {
            List result = new List(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, String object__, StorageObject content) throws IOException {
            Patch result = new Patch(bucket, object__, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, String object__, StorageObject content) throws IOException {
            Update result = new Update(bucket, object__, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public WatchAll watchAll(String bucket, Channel content) throws IOException {
            WatchAll result = new WatchAll(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class WatchAll
        extends StorageRequest<Channel> {
            private static final String REST_PATH = "b/{bucket}/o/watch";
            @Key
            private String bucket;
            @Key
            private String delimiter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String prefix;
            @Key
            private String projection;
            @Key
            private Boolean versions;

            protected WatchAll(String bucket, Channel content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, Channel.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public WatchAll setAlt(String alt) {
                return (WatchAll)super.setAlt(alt);
            }

            public WatchAll setFields(String fields) {
                return (WatchAll)super.setFields(fields);
            }

            public WatchAll setKey(String key) {
                return (WatchAll)super.setKey(key);
            }

            public WatchAll setOauthToken(String oauthToken) {
                return (WatchAll)super.setOauthToken(oauthToken);
            }

            public WatchAll setPrettyPrint(Boolean prettyPrint) {
                return (WatchAll)super.setPrettyPrint(prettyPrint);
            }

            public WatchAll setQuotaUser(String quotaUser) {
                return (WatchAll)super.setQuotaUser(quotaUser);
            }

            public WatchAll setUserIp(String userIp) {
                return (WatchAll)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public WatchAll setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public WatchAll setDelimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public WatchAll setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public WatchAll setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public WatchAll setPrefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public WatchAll setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public Boolean getVersions() {
                return this.versions;
            }

            public WatchAll setVersions(Boolean versions) {
                this.versions = versions;
                return this;
            }

            @Override
            public WatchAll set(String parameterName, Object value) {
                return (WatchAll)super.set(parameterName, value);
            }
        }

        public class Update
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private BigInteger generation;
            @Key
            private BigInteger ifGenerationMatch;
            @Key
            private BigInteger ifGenerationNotMatch;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Update(String bucket, String object__, StorageObject content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getContentType(), "StorageObject.getContentType()");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Update setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            public BigInteger getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Update setIfGenerationMatch(BigInteger ifGenerationMatch) {
                this.ifGenerationMatch = ifGenerationMatch;
                return this;
            }

            public BigInteger getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Update setIfGenerationNotMatch(BigInteger ifGenerationNotMatch) {
                this.ifGenerationNotMatch = ifGenerationNotMatch;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Update setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Update setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private BigInteger generation;
            @Key
            private BigInteger ifGenerationMatch;
            @Key
            private BigInteger ifGenerationNotMatch;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Patch(String bucket, String object__, StorageObject content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Patch setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            public BigInteger getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Patch setIfGenerationMatch(BigInteger ifGenerationMatch) {
                this.ifGenerationMatch = ifGenerationMatch;
                return this;
            }

            public BigInteger getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Patch setIfGenerationNotMatch(BigInteger ifGenerationNotMatch) {
                this.ifGenerationNotMatch = ifGenerationNotMatch;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Patch setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Patch setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.Objects> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String delimiter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String prefix;
            @Key
            private String projection;
            @Key
            private Boolean versions;

            protected List(String bucket) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Objects.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public List setDelimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public List setPrefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public Boolean getVersions() {
                return this.versions;
            }

            public List setVersions(Boolean versions) {
                this.versions = versions;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private BigInteger ifGenerationMatch;
            @Key
            private BigInteger ifGenerationNotMatch;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private String name;
            @Key
            private String projection;

            protected Insert(String bucket, StorageObject content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaDownload();
            }

            protected Insert(String bucket, StorageObject content, AbstractInputStreamContent mediaContent) {
                super(Storage.this, "POST", "/upload/" + Storage.this.getServicePath() + REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public BigInteger getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Insert setIfGenerationMatch(BigInteger ifGenerationMatch) {
                this.ifGenerationMatch = ifGenerationMatch;
                return this;
            }

            public BigInteger getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Insert setIfGenerationNotMatch(BigInteger ifGenerationNotMatch) {
                this.ifGenerationNotMatch = ifGenerationNotMatch;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Insert setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Insert setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Insert setName(String name) {
                this.name = name;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private BigInteger generation;
            @Key
            private BigInteger ifGenerationMatch;
            @Key
            private BigInteger ifGenerationNotMatch;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Get(String bucket, String object__) {
                super(Storage.this, "GET", REST_PATH, null, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Get setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            public BigInteger getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Get setIfGenerationMatch(BigInteger ifGenerationMatch) {
                this.ifGenerationMatch = ifGenerationMatch;
                return this;
            }

            public BigInteger getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Get setIfGenerationNotMatch(BigInteger ifGenerationNotMatch) {
                this.ifGenerationNotMatch = ifGenerationNotMatch;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Get setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Get setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private BigInteger generation;
            @Key
            private BigInteger ifGenerationMatch;
            @Key
            private BigInteger ifGenerationNotMatch;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;

            protected Delete(String bucket, String object__) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Delete setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            public BigInteger getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Delete setIfGenerationMatch(BigInteger ifGenerationMatch) {
                this.ifGenerationMatch = ifGenerationMatch;
                return this;
            }

            public BigInteger getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Delete setIfGenerationNotMatch(BigInteger ifGenerationNotMatch) {
                this.ifGenerationNotMatch = ifGenerationNotMatch;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Delete setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Delete setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Copy
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}";
            @Key
            private String sourceBucket;
            @Key
            private String sourceObject;
            @Key
            private String destinationBucket;
            @Key
            private String destinationObject;
            @Key
            private BigInteger ifGenerationMatch;
            @Key
            private BigInteger ifGenerationNotMatch;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private BigInteger ifSourceGenerationMatch;
            @Key
            private BigInteger ifSourceGenerationNotMatch;
            @Key
            private BigInteger ifSourceMetagenerationMatch;
            @Key
            private BigInteger ifSourceMetagenerationNotMatch;
            @Key
            private String projection;
            @Key
            private BigInteger sourceGeneration;

            protected Copy(String sourceBucket, String sourceObject, String destinationBucket, String destinationObject, StorageObject content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, StorageObject.class);
                this.sourceBucket = (String)Preconditions.checkNotNull((Object)sourceBucket, (Object)"Required parameter sourceBucket must be specified.");
                this.sourceObject = (String)Preconditions.checkNotNull((Object)sourceObject, (Object)"Required parameter sourceObject must be specified.");
                this.destinationBucket = (String)Preconditions.checkNotNull((Object)destinationBucket, (Object)"Required parameter destinationBucket must be specified.");
                this.destinationObject = (String)Preconditions.checkNotNull((Object)destinationObject, (Object)"Required parameter destinationObject must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Copy setAlt(String alt) {
                return (Copy)super.setAlt(alt);
            }

            public Copy setFields(String fields) {
                return (Copy)super.setFields(fields);
            }

            public Copy setKey(String key) {
                return (Copy)super.setKey(key);
            }

            public Copy setOauthToken(String oauthToken) {
                return (Copy)super.setOauthToken(oauthToken);
            }

            public Copy setPrettyPrint(Boolean prettyPrint) {
                return (Copy)super.setPrettyPrint(prettyPrint);
            }

            public Copy setQuotaUser(String quotaUser) {
                return (Copy)super.setQuotaUser(quotaUser);
            }

            public Copy setUserIp(String userIp) {
                return (Copy)super.setUserIp(userIp);
            }

            public String getSourceBucket() {
                return this.sourceBucket;
            }

            public Copy setSourceBucket(String sourceBucket) {
                this.sourceBucket = sourceBucket;
                return this;
            }

            public String getSourceObject() {
                return this.sourceObject;
            }

            public Copy setSourceObject(String sourceObject) {
                this.sourceObject = sourceObject;
                return this;
            }

            public String getDestinationBucket() {
                return this.destinationBucket;
            }

            public Copy setDestinationBucket(String destinationBucket) {
                this.destinationBucket = destinationBucket;
                return this;
            }

            public String getDestinationObject() {
                return this.destinationObject;
            }

            public Copy setDestinationObject(String destinationObject) {
                this.destinationObject = destinationObject;
                return this;
            }

            public BigInteger getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Copy setIfGenerationMatch(BigInteger ifGenerationMatch) {
                this.ifGenerationMatch = ifGenerationMatch;
                return this;
            }

            public BigInteger getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Copy setIfGenerationNotMatch(BigInteger ifGenerationNotMatch) {
                this.ifGenerationNotMatch = ifGenerationNotMatch;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Copy setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Copy setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public BigInteger getIfSourceGenerationMatch() {
                return this.ifSourceGenerationMatch;
            }

            public Copy setIfSourceGenerationMatch(BigInteger ifSourceGenerationMatch) {
                this.ifSourceGenerationMatch = ifSourceGenerationMatch;
                return this;
            }

            public BigInteger getIfSourceGenerationNotMatch() {
                return this.ifSourceGenerationNotMatch;
            }

            public Copy setIfSourceGenerationNotMatch(BigInteger ifSourceGenerationNotMatch) {
                this.ifSourceGenerationNotMatch = ifSourceGenerationNotMatch;
                return this;
            }

            public BigInteger getIfSourceMetagenerationMatch() {
                return this.ifSourceMetagenerationMatch;
            }

            public Copy setIfSourceMetagenerationMatch(BigInteger ifSourceMetagenerationMatch) {
                this.ifSourceMetagenerationMatch = ifSourceMetagenerationMatch;
                return this;
            }

            public BigInteger getIfSourceMetagenerationNotMatch() {
                return this.ifSourceMetagenerationNotMatch;
            }

            public Copy setIfSourceMetagenerationNotMatch(BigInteger ifSourceMetagenerationNotMatch) {
                this.ifSourceMetagenerationNotMatch = ifSourceMetagenerationNotMatch;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Copy setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public BigInteger getSourceGeneration() {
                return this.sourceGeneration;
            }

            public Copy setSourceGeneration(BigInteger sourceGeneration) {
                this.sourceGeneration = sourceGeneration;
                return this;
            }

            @Override
            public Copy set(String parameterName, Object value) {
                return (Copy)super.set(parameterName, value);
            }
        }

        public class Compose
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{destinationBucket}/o/{destinationObject}/compose";
            @Key
            private String destinationBucket;
            @Key
            private String destinationObject;
            @Key
            private BigInteger ifGenerationMatch;
            @Key
            private BigInteger ifMetagenerationMatch;

            protected Compose(String destinationBucket, String destinationObject, ComposeRequest content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, StorageObject.class);
                this.destinationBucket = (String)Preconditions.checkNotNull((Object)destinationBucket, (Object)"Required parameter destinationBucket must be specified.");
                this.destinationObject = (String)Preconditions.checkNotNull((Object)destinationObject, (Object)"Required parameter destinationObject must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Compose setAlt(String alt) {
                return (Compose)super.setAlt(alt);
            }

            public Compose setFields(String fields) {
                return (Compose)super.setFields(fields);
            }

            public Compose setKey(String key) {
                return (Compose)super.setKey(key);
            }

            public Compose setOauthToken(String oauthToken) {
                return (Compose)super.setOauthToken(oauthToken);
            }

            public Compose setPrettyPrint(Boolean prettyPrint) {
                return (Compose)super.setPrettyPrint(prettyPrint);
            }

            public Compose setQuotaUser(String quotaUser) {
                return (Compose)super.setQuotaUser(quotaUser);
            }

            public Compose setUserIp(String userIp) {
                return (Compose)super.setUserIp(userIp);
            }

            public String getDestinationBucket() {
                return this.destinationBucket;
            }

            public Compose setDestinationBucket(String destinationBucket) {
                this.destinationBucket = destinationBucket;
                return this;
            }

            public String getDestinationObject() {
                return this.destinationObject;
            }

            public Compose setDestinationObject(String destinationObject) {
                this.destinationObject = destinationObject;
                return this;
            }

            public BigInteger getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Compose setIfGenerationMatch(BigInteger ifGenerationMatch) {
                this.ifGenerationMatch = ifGenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Compose setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            @Override
            public Compose set(String parameterName, Object value) {
                return (Compose)super.set(parameterName, value);
            }
        }
    }

    public class ObjectAccessControls {
        public Delete delete(String bucket, String object__, String entity) throws IOException {
            Delete result = new Delete(bucket, object__, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket, String object__, String entity) throws IOException {
            Get result = new Get(bucket, object__, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, String object__, ObjectAccessControl content) throws IOException {
            Insert result = new Insert(bucket, object__, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String bucket, String object__) throws IOException {
            List result = new List(bucket, object__);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, String object__, String entity, ObjectAccessControl content) throws IOException {
            Patch result = new Patch(bucket, object__, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, String object__, String entity, ObjectAccessControl content) throws IOException {
            Update result = new Update(bucket, object__, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private BigInteger generation;

            protected Update(String bucket, String object__, String entity, ObjectAccessControl content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Update setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private BigInteger generation;

            protected Patch(String bucket, String object__, String entity, ObjectAccessControl content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Patch setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private BigInteger generation;

            protected List(String bucket, String object__) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public List setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public List setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private BigInteger generation;

            protected Insert(String bucket, String object__, ObjectAccessControl content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Insert setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Insert setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private BigInteger generation;

            protected Get(String bucket, String object__, String entity) {
                super(Storage.this, "GET", REST_PATH, null, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Get setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private BigInteger generation;

            protected Delete(String bucket, String object__, String entity) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            public BigInteger getGeneration() {
                return this.generation;
            }

            public Delete setGeneration(BigInteger generation) {
                this.generation = generation;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class DefaultObjectAccessControls {
        public Delete delete(String bucket, String entity) throws IOException {
            Delete result = new Delete(bucket, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket, String entity) throws IOException {
            Get result = new Get(bucket, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, ObjectAccessControl content) throws IOException {
            Insert result = new Insert(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String bucket) throws IOException {
            List result = new List(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, String entity, ObjectAccessControl content) throws IOException {
            Patch result = new Patch(bucket, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, String entity, ObjectAccessControl content) throws IOException {
            Update result = new Update(bucket, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Update(String bucket, String entity, ObjectAccessControl content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Patch(String bucket, String entity, ObjectAccessControl content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;

            protected List(String bucket) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public List setIfMetagenerationMatch(Long ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public List setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";
            @Key
            private String bucket;

            protected Insert(String bucket, ObjectAccessControl content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Get(String bucket, String entity) {
                super(Storage.this, "GET", REST_PATH, null, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Delete(String bucket, String entity) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel content) throws IOException {
            Stop result = new Stop(content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Stop
        extends StorageRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, Void.class);
            }

            public Stop setAlt(String alt) {
                return (Stop)super.setAlt(alt);
            }

            public Stop setFields(String fields) {
                return (Stop)super.setFields(fields);
            }

            public Stop setKey(String key) {
                return (Stop)super.setKey(key);
            }

            public Stop setOauthToken(String oauthToken) {
                return (Stop)super.setOauthToken(oauthToken);
            }

            public Stop setPrettyPrint(Boolean prettyPrint) {
                return (Stop)super.setPrettyPrint(prettyPrint);
            }

            public Stop setQuotaUser(String quotaUser) {
                return (Stop)super.setQuotaUser(quotaUser);
            }

            public Stop setUserIp(String userIp) {
                return (Stop)super.setUserIp(userIp);
            }

            @Override
            public Stop set(String parameterName, Object value) {
                return (Stop)super.set(parameterName, value);
            }
        }
    }

    public class Buckets {
        public Delete delete(String bucket) throws IOException {
            Delete result = new Delete(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket) throws IOException {
            Get result = new Get(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, Bucket content) throws IOException {
            Insert result = new Insert(project, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, Bucket content) throws IOException {
            Patch result = new Patch(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, Bucket content) throws IOException {
            Update result = new Update(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Update(String bucket, Bucket content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Update setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Update setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Patch(String bucket, Bucket content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Patch setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Patch setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.Buckets> {
            private static final String REST_PATH = "b";
            @Key
            private String project;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String projection;

            protected List(String project) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Buckets.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                this.project = project;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b";
            @Key
            private String project;
            @Key
            private String projection;

            protected Insert(String project, Bucket content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, Bucket.class);
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getName(), "Bucket.getName()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                this.project = project;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Get(String bucket) {
                super(Storage.this, "GET", REST_PATH, null, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Get setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Get setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private BigInteger ifMetagenerationMatch;
            @Key
            private BigInteger ifMetagenerationNotMatch;

            protected Delete(String bucket) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public BigInteger getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Delete setIfMetagenerationMatch(BigInteger ifMetagenerationMatch) {
                this.ifMetagenerationMatch = ifMetagenerationMatch;
                return this;
            }

            public BigInteger getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Delete setIfMetagenerationNotMatch(BigInteger ifMetagenerationNotMatch) {
                this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class BucketAccessControls {
        public Delete delete(String bucket, String entity) throws IOException {
            Delete result = new Delete(bucket, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket, String entity) throws IOException {
            Get result = new Get(bucket, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, BucketAccessControl content) throws IOException {
            Insert result = new Insert(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String bucket) throws IOException {
            List result = new List(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, String entity, BucketAccessControl content) throws IOException {
            Patch result = new Patch(bucket, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, String entity, BucketAccessControl content) throws IOException {
            Update result = new Update(bucket, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Update(String bucket, String entity, BucketAccessControl content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Patch(String bucket, String entity, BucketAccessControl content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.BucketAccessControls> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected List(String bucket) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.BucketAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected Insert(String bucket, BucketAccessControl content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getEntity(), "BucketAccessControl.getEntity()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getRole(), "BucketAccessControl.getRole()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Get(String bucket, String entity) {
                super(Storage.this, "GET", REST_PATH, null, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Delete(String bucket, String entity) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

