/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.storage;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.StorageRequestInitializer;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.Channel;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "storage/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/storage/v1/";

    public Storage(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Storage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public BucketAccessControls bucketAccessControls() {
        return new BucketAccessControls();
    }

    public Buckets buckets() {
        return new Buckets();
    }

    public Channels channels() {
        return new Channels();
    }

    public DefaultObjectAccessControls defaultObjectAccessControls() {
        return new DefaultObjectAccessControls();
    }

    public ObjectAccessControls objectAccessControls() {
        return new ObjectAccessControls();
    }

    public Objects objects() {
        return new Objects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.16.0-rc of the Cloud Storage API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Storage.DEFAULT_ROOT_URL, Storage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Storage build() {
            return new Storage(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setStorageRequestInitializer(StorageRequestInitializer storageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)storageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Objects {
        public Compose compose(String string, String string2, ComposeRequest composeRequest) throws IOException {
            Compose compose = new Compose(string, string2, composeRequest);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)compose);
            return compose;
        }

        public Copy copy(String string, String string2, String string3, String string4, StorageObject storageObject) throws IOException {
            Copy copy = new Copy(string, string2, string3, string4, storageObject);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)copy);
            return copy;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, StorageObject storageObject) throws IOException {
            Insert insert = new Insert(string, storageObject);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(String string, StorageObject storageObject, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, storageObject, abstractInputStreamContent);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, StorageObject storageObject) throws IOException {
            Patch patch = new Patch(string, string2, storageObject);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, StorageObject storageObject) throws IOException {
            Update update = new Update(string, string2, storageObject);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public WatchAll watchAll(String string, Channel channel) throws IOException {
            WatchAll watchAll = new WatchAll(string, channel);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)watchAll);
            return watchAll;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class WatchAll
        extends StorageRequest<Channel> {
            private static final String REST_PATH = "b/{bucket}/o/watch";
            @Key
            private String bucket;
            @Key
            private String projection;
            @Key
            private Boolean versions;
            @Key
            private String prefix;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String delimiter;

            protected WatchAll(String string, Channel channel) {
                super(Storage.this, "POST", REST_PATH, (Object)channel, Channel.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public WatchAll setAlt(String string) {
                return (WatchAll)super.setAlt(string);
            }

            public WatchAll setFields(String string) {
                return (WatchAll)super.setFields(string);
            }

            public WatchAll setKey(String string) {
                return (WatchAll)super.setKey(string);
            }

            public WatchAll setOauthToken(String string) {
                return (WatchAll)super.setOauthToken(string);
            }

            public WatchAll setPrettyPrint(Boolean bl) {
                return (WatchAll)super.setPrettyPrint(bl);
            }

            public WatchAll setQuotaUser(String string) {
                return (WatchAll)super.setQuotaUser(string);
            }

            public WatchAll setUserIp(String string) {
                return (WatchAll)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public WatchAll setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public WatchAll setProjection(String string) {
                this.projection = string;
                return this;
            }

            public Boolean getVersions() {
                return this.versions;
            }

            public WatchAll setVersions(Boolean bl) {
                this.versions = bl;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public WatchAll setPrefix(String string) {
                this.prefix = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public WatchAll setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public WatchAll setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public WatchAll setDelimiter(String string) {
                this.delimiter = string;
                return this;
            }

            @Override
            public WatchAll set(String string, Object object) {
                return (WatchAll)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private String predefinedAcl;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long generation;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Update(String string, String string2, StorageObject storageObject) {
                super(Storage.this, "PUT", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
                this.checkRequiredParameter((Object)storageObject, "content");
                this.checkRequiredParameter(storageObject.getContentType(), "StorageObject.getContentType()");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Update setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Update setPredefinedAcl(String string) {
                this.predefinedAcl = string;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Update setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Update setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Update setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Update setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Update setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private String predefinedAcl;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long generation;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Patch(String string, String string2, StorageObject storageObject) {
                super(Storage.this, "PATCH", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Patch setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Patch setPredefinedAcl(String string) {
                this.predefinedAcl = string;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Patch setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Patch setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Patch setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Patch setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Patch setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.Objects> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String projection;
            @Key
            private Boolean versions;
            @Key
            private String prefix;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String delimiter;

            protected List(String string) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Objects.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public Boolean getVersions() {
                return this.versions;
            }

            public List setVersions(Boolean bl) {
                this.versions = bl;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public List setPrefix(String string) {
                this.prefix = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public List setDelimiter(String string) {
                this.delimiter = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String predefinedAcl;
            @Key
            private String projection;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private String contentEncoding;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String name;

            protected Insert(String string, StorageObject storageObject) {
                super(Storage.this, "POST", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaDownload();
            }

            protected Insert(String string, StorageObject storageObject, AbstractInputStreamContent abstractInputStreamContent) {
                super(Storage.this, "POST", "/upload/" + Storage.this.getServicePath() + REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Insert setPredefinedAcl(String string) {
                this.predefinedAcl = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String string) {
                this.projection = string;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Insert setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Insert setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public String getContentEncoding() {
                return this.contentEncoding;
            }

            public Insert setContentEncoding(String string) {
                this.contentEncoding = string;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Insert setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Insert setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Insert setName(String string) {
                this.name = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long generation;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Get(String string, String string2) {
                super(Storage.this, "GET", REST_PATH, null, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Get setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Get setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Get setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Get setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Get setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Get setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long generation;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;

            protected Delete(String string, String string2) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Delete setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Delete setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Delete setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Delete setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Delete setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Delete setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Copy
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}";
            @Key
            private String sourceBucket;
            @Key
            private String sourceObject;
            @Key
            private String destinationBucket;
            @Key
            private String destinationObject;
            @Key
            private Long ifSourceGenerationNotMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifSourceMetagenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long sourceGeneration;
            @Key
            private String destinationPredefinedAcl;
            @Key
            private Long ifSourceGenerationMatch;
            @Key
            private Long ifSourceMetagenerationMatch;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Copy(String string, String string2, String string3, String string4, StorageObject storageObject) {
                super(Storage.this, "POST", REST_PATH, (Object)storageObject, StorageObject.class);
                this.sourceBucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sourceBucket must be specified.");
                this.sourceObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter sourceObject must be specified.");
                this.destinationBucket = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter destinationBucket must be specified.");
                this.destinationObject = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter destinationObject must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Copy setAlt(String string) {
                return (Copy)super.setAlt(string);
            }

            public Copy setFields(String string) {
                return (Copy)super.setFields(string);
            }

            public Copy setKey(String string) {
                return (Copy)super.setKey(string);
            }

            public Copy setOauthToken(String string) {
                return (Copy)super.setOauthToken(string);
            }

            public Copy setPrettyPrint(Boolean bl) {
                return (Copy)super.setPrettyPrint(bl);
            }

            public Copy setQuotaUser(String string) {
                return (Copy)super.setQuotaUser(string);
            }

            public Copy setUserIp(String string) {
                return (Copy)super.setUserIp(string);
            }

            public String getSourceBucket() {
                return this.sourceBucket;
            }

            public Copy setSourceBucket(String string) {
                this.sourceBucket = string;
                return this;
            }

            public String getSourceObject() {
                return this.sourceObject;
            }

            public Copy setSourceObject(String string) {
                this.sourceObject = string;
                return this;
            }

            public String getDestinationBucket() {
                return this.destinationBucket;
            }

            public Copy setDestinationBucket(String string) {
                this.destinationBucket = string;
                return this;
            }

            public String getDestinationObject() {
                return this.destinationObject;
            }

            public Copy setDestinationObject(String string) {
                this.destinationObject = string;
                return this;
            }

            public Long getIfSourceGenerationNotMatch() {
                return this.ifSourceGenerationNotMatch;
            }

            public Copy setIfSourceGenerationNotMatch(Long l) {
                this.ifSourceGenerationNotMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Copy setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfSourceMetagenerationNotMatch() {
                return this.ifSourceMetagenerationNotMatch;
            }

            public Copy setIfSourceMetagenerationNotMatch(Long l) {
                this.ifSourceMetagenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Copy setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getSourceGeneration() {
                return this.sourceGeneration;
            }

            public Copy setSourceGeneration(Long l) {
                this.sourceGeneration = l;
                return this;
            }

            public String getDestinationPredefinedAcl() {
                return this.destinationPredefinedAcl;
            }

            public Copy setDestinationPredefinedAcl(String string) {
                this.destinationPredefinedAcl = string;
                return this;
            }

            public Long getIfSourceGenerationMatch() {
                return this.ifSourceGenerationMatch;
            }

            public Copy setIfSourceGenerationMatch(Long l) {
                this.ifSourceGenerationMatch = l;
                return this;
            }

            public Long getIfSourceMetagenerationMatch() {
                return this.ifSourceMetagenerationMatch;
            }

            public Copy setIfSourceMetagenerationMatch(Long l) {
                this.ifSourceMetagenerationMatch = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Copy setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Copy setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Copy setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Copy set(String string, Object object) {
                return (Copy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Compose
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{destinationBucket}/o/{destinationObject}/compose";
            @Key
            private String destinationBucket;
            @Key
            private String destinationObject;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private String destinationPredefinedAcl;

            protected Compose(String string, String string2, ComposeRequest composeRequest) {
                super(Storage.this, "POST", REST_PATH, (Object)composeRequest, StorageObject.class);
                this.destinationBucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter destinationBucket must be specified.");
                this.destinationObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter destinationObject must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Compose setAlt(String string) {
                return (Compose)super.setAlt(string);
            }

            public Compose setFields(String string) {
                return (Compose)super.setFields(string);
            }

            public Compose setKey(String string) {
                return (Compose)super.setKey(string);
            }

            public Compose setOauthToken(String string) {
                return (Compose)super.setOauthToken(string);
            }

            public Compose setPrettyPrint(Boolean bl) {
                return (Compose)super.setPrettyPrint(bl);
            }

            public Compose setQuotaUser(String string) {
                return (Compose)super.setQuotaUser(string);
            }

            public Compose setUserIp(String string) {
                return (Compose)super.setUserIp(string);
            }

            public String getDestinationBucket() {
                return this.destinationBucket;
            }

            public Compose setDestinationBucket(String string) {
                this.destinationBucket = string;
                return this;
            }

            public String getDestinationObject() {
                return this.destinationObject;
            }

            public Compose setDestinationObject(String string) {
                this.destinationObject = string;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Compose setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Compose setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public String getDestinationPredefinedAcl() {
                return this.destinationPredefinedAcl;
            }

            public Compose setDestinationPredefinedAcl(String string) {
                this.destinationPredefinedAcl = string;
                return this;
            }

            @Override
            public Compose set(String string, Object object) {
                return (Compose)super.set(string, object);
            }
        }
    }

    public class ObjectAccessControls {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, ObjectAccessControl objectAccessControl) throws IOException {
            Insert insert = new Insert(string, string2, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, ObjectAccessControl objectAccessControl) throws IOException {
            Patch patch = new Patch(string, string2, string3, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, String string3, ObjectAccessControl objectAccessControl) throws IOException {
            Update update = new Update(string, string2, string3, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private String entity;
            @Key
            private Long generation;

            protected Update(String string, String string2, String string3, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Update setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string) {
                this.entity = string;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Update setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private String entity;
            @Key
            private Long generation;

            protected Patch(String string, String string2, String string3, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Patch setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string) {
                this.entity = string;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Patch setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private Long generation;

            protected List(String string, String string2) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public List setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public List setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private Long generation;

            protected Insert(String string, String string2, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Insert setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Insert setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private String entity;
            @Key
            private Long generation;

            protected Get(String string, String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, null, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Get setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string) {
                this.entity = string;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Get setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String storageObject;
            @Key
            private String entity;
            @Key
            private Long generation;

            protected Delete(String string, String string2, String string3) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.storageObject = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter storageObject must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.storageObject;
            }

            public Delete setObject(String string) {
                this.storageObject = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string) {
                this.entity = string;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Delete setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class DefaultObjectAccessControls {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, ObjectAccessControl objectAccessControl) throws IOException {
            Insert insert = new Insert(string, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, ObjectAccessControl objectAccessControl) throws IOException {
            Patch patch = new Patch(string, string2, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, ObjectAccessControl objectAccessControl) throws IOException {
            Update update = new Update(string, string2, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Update(String string, String string2, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Patch(String string, String string2, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;

            protected List(String string) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public List setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public List setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";
            @Key
            private String bucket;

            protected Insert(String string, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string) {
                this.bucket = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Get(String string, String string2) {
                super(Storage.this, "GET", REST_PATH, null, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Delete(String string, String string2) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel channel) throws IOException {
            Stop stop = new Stop(channel);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends StorageRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel channel) {
                super(Storage.this, "POST", REST_PATH, (Object)channel, Void.class);
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }
    }

    public class Buckets {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Bucket bucket) throws IOException {
            Insert insert = new Insert(string, bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Bucket bucket) throws IOException {
            Patch patch = new Patch(string, bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, Bucket bucket) throws IOException {
            Update update = new Update(string, bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private String predefinedAcl;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Update(String string, Bucket bucket) {
                super(Storage.this, "PUT", REST_PATH, (Object)bucket, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Update setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Update setPredefinedAcl(String string) {
                this.predefinedAcl = string;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Update setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private String predefinedAcl;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Patch(String string, Bucket bucket) {
                super(Storage.this, "PATCH", REST_PATH, (Object)bucket, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Patch setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Patch setPredefinedAcl(String string) {
                this.predefinedAcl = string;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Patch setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.Buckets> {
            private static final String REST_PATH = "b";
            @Key
            private String project;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Buckets.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                this.project = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b";
            @Key
            private String project;
            @Key
            private String predefinedAcl;
            @Key
            private String projection;

            protected Insert(String string, Bucket bucket) {
                super(Storage.this, "POST", REST_PATH, (Object)bucket, Bucket.class);
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                this.checkRequiredParameter((Object)bucket, "content");
                this.checkRequiredParameter(bucket.getName(), "Bucket.getName()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                this.project = string;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Insert setPredefinedAcl(String string) {
                this.predefinedAcl = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;

            protected Get(String string) {
                super(Storage.this, "GET", REST_PATH, null, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Get setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Get setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;

            protected Delete(String string) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Delete setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Delete setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class BucketAccessControls {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, BucketAccessControl bucketAccessControl) throws IOException {
            Insert insert = new Insert(string, bucketAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, BucketAccessControl bucketAccessControl) throws IOException {
            Patch patch = new Patch(string, string2, bucketAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, BucketAccessControl bucketAccessControl) throws IOException {
            Update update = new Update(string, string2, bucketAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Update(String string, String string2, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Patch(String string, String string2, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.BucketAccessControls> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected List(String string) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.BucketAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string) {
                this.bucket = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected Insert(String string, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.checkRequiredParameter((Object)bucketAccessControl, "content");
                this.checkRequiredParameter(bucketAccessControl.getEntity(), "BucketAccessControl.getEntity()");
                this.checkRequiredParameter((Object)bucketAccessControl, "content");
                this.checkRequiredParameter(bucketAccessControl.getRole(), "BucketAccessControl.getRole()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string) {
                this.bucket = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Get(String string, String string2) {
                super(Storage.this, "GET", REST_PATH, null, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Delete(String string, String string2) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

