/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-29 at 20:21:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A custom subtotal column for a waterfall chart series.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WaterfallChartCustomSubtotal extends com.google.api.client.json.GenericJson {

  /**
   * True if the data point at subtotal_index is the subtotal. If false, the subtotal will be
   * computed and appear after the data point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dataIsSubtotal;

  /**
   * A label for the subtotal column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * The 0-based index of a data point within the series. If data_is_subtotal is true, the data
   * point at this index is the subtotal. Otherwise, the subtotal appears after the data point with
   * this index. A series can have multiple subtotals at arbitrary indices, but subtotals do not
   * affect the indices of the data points. For example, if a series has three data points, their
   * indices will always be 0, 1, and 2, regardless of how many subtotals exist on the series or
   * what data points they are associated with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer subtotalIndex;

  /**
   * True if the data point at subtotal_index is the subtotal. If false, the subtotal will be
   * computed and appear after the data point.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDataIsSubtotal() {
    return dataIsSubtotal;
  }

  /**
   * True if the data point at subtotal_index is the subtotal. If false, the subtotal will be
   * computed and appear after the data point.
   * @param dataIsSubtotal dataIsSubtotal or {@code null} for none
   */
  public WaterfallChartCustomSubtotal setDataIsSubtotal(java.lang.Boolean dataIsSubtotal) {
    this.dataIsSubtotal = dataIsSubtotal;
    return this;
  }

  /**
   * A label for the subtotal column.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * A label for the subtotal column.
   * @param label label or {@code null} for none
   */
  public WaterfallChartCustomSubtotal setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * The 0-based index of a data point within the series. If data_is_subtotal is true, the data
   * point at this index is the subtotal. Otherwise, the subtotal appears after the data point with
   * this index. A series can have multiple subtotals at arbitrary indices, but subtotals do not
   * affect the indices of the data points. For example, if a series has three data points, their
   * indices will always be 0, 1, and 2, regardless of how many subtotals exist on the series or
   * what data points they are associated with.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSubtotalIndex() {
    return subtotalIndex;
  }

  /**
   * The 0-based index of a data point within the series. If data_is_subtotal is true, the data
   * point at this index is the subtotal. Otherwise, the subtotal appears after the data point with
   * this index. A series can have multiple subtotals at arbitrary indices, but subtotals do not
   * affect the indices of the data points. For example, if a series has three data points, their
   * indices will always be 0, 1, and 2, regardless of how many subtotals exist on the series or
   * what data points they are associated with.
   * @param subtotalIndex subtotalIndex or {@code null} for none
   */
  public WaterfallChartCustomSubtotal setSubtotalIndex(java.lang.Integer subtotalIndex) {
    this.subtotalIndex = subtotalIndex;
    return this;
  }

  @Override
  public WaterfallChartCustomSubtotal set(String fieldName, Object value) {
    return (WaterfallChartCustomSubtotal) super.set(fieldName, value);
  }

  @Override
  public WaterfallChartCustomSubtotal clone() {
    return (WaterfallChartCustomSubtotal) super.clone();
  }

}
