/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-11 at 19:22:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A developer metadata entry and the data filters specified in the original request that matched
 * it.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MatchedDeveloperMetadata extends com.google.api.client.json.GenericJson {

  /**
   * All filters matching the returned developer metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataFilter> dataFilters;

  /**
   * The developer metadata matching the specified filters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeveloperMetadata developerMetadata;

  /**
   * All filters matching the returned developer metadata.
   * @return value or {@code null} for none
   */
  public java.util.List<DataFilter> getDataFilters() {
    return dataFilters;
  }

  /**
   * All filters matching the returned developer metadata.
   * @param dataFilters dataFilters or {@code null} for none
   */
  public MatchedDeveloperMetadata setDataFilters(java.util.List<DataFilter> dataFilters) {
    this.dataFilters = dataFilters;
    return this;
  }

  /**
   * The developer metadata matching the specified filters.
   * @return value or {@code null} for none
   */
  public DeveloperMetadata getDeveloperMetadata() {
    return developerMetadata;
  }

  /**
   * The developer metadata matching the specified filters.
   * @param developerMetadata developerMetadata or {@code null} for none
   */
  public MatchedDeveloperMetadata setDeveloperMetadata(DeveloperMetadata developerMetadata) {
    this.developerMetadata = developerMetadata;
    return this;
  }

  @Override
  public MatchedDeveloperMetadata set(String fieldName, Object value) {
    return (MatchedDeveloperMetadata) super.set(fieldName, value);
  }

  @Override
  public MatchedDeveloperMetadata clone() {
    return (MatchedDeveloperMetadata) super.clone();
  }

}
