/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-10-04 at 21:52:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Sorts data in rows based on a sort order per column.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SortRangeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range to sort.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The sort order per column. Later specifications are used when values are equal in the earlier
   * specifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SortSpec> sortSpecs;

  /**
   * The range to sort.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range to sort.
   * @param range range or {@code null} for none
   */
  public SortRangeRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The sort order per column. Later specifications are used when values are equal in the earlier
   * specifications.
   * @return value or {@code null} for none
   */
  public java.util.List<SortSpec> getSortSpecs() {
    return sortSpecs;
  }

  /**
   * The sort order per column. Later specifications are used when values are equal in the earlier
   * specifications.
   * @param sortSpecs sortSpecs or {@code null} for none
   */
  public SortRangeRequest setSortSpecs(java.util.List<SortSpec> sortSpecs) {
    this.sortSpecs = sortSpecs;
    return this;
  }

  @Override
  public SortRangeRequest set(String fieldName, Object value) {
    return (SortRangeRequest) super.set(fieldName, value);
  }

  @Override
  public SortRangeRequest clone() {
    return (SortRangeRequest) super.clone();
  }

}
