/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.safebrowsing;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.safebrowsing.SafebrowsingRequest;
import com.google.api.services.safebrowsing.SafebrowsingRequestInitializer;
import com.google.api.services.safebrowsing.model.Empty;
import com.google.api.services.safebrowsing.model.FetchThreatListUpdatesRequest;
import com.google.api.services.safebrowsing.model.FetchThreatListUpdatesResponse;
import com.google.api.services.safebrowsing.model.FindFullHashesRequest;
import com.google.api.services.safebrowsing.model.FindFullHashesResponse;
import com.google.api.services.safebrowsing.model.FindThreatMatchesRequest;
import com.google.api.services.safebrowsing.model.FindThreatMatchesResponse;
import com.google.api.services.safebrowsing.model.ListThreatListsResponse;
import com.google.api.services.safebrowsing.model.ThreatHit;
import java.io.IOException;

public class Safebrowsing
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://safebrowsing.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://safebrowsing.googleapis.com/";

    public Safebrowsing(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Safebrowsing(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public EncodedFullHashes encodedFullHashes() {
        return new EncodedFullHashes();
    }

    public EncodedUpdates encodedUpdates() {
        return new EncodedUpdates();
    }

    public FullHashes fullHashes() {
        return new FullHashes();
    }

    public ThreatHits threatHits() {
        return new ThreatHits();
    }

    public ThreatListUpdates threatListUpdates() {
        return new ThreatListUpdates();
    }

    public ThreatLists threatLists() {
        return new ThreatLists();
    }

    public ThreatMatches threatMatches() {
        return new ThreatMatches();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.9 of the Safe Browsing API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://safebrowsing.googleapis.com/", Safebrowsing.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Safebrowsing.DEFAULT_BATCH_PATH);
        }

        public Safebrowsing build() {
            return new Safebrowsing(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSafebrowsingRequestInitializer(SafebrowsingRequestInitializer safebrowsingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)safebrowsingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class ThreatMatches {
        public Find find(FindThreatMatchesRequest content) throws IOException {
            Find result = new Find(content);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Find
        extends SafebrowsingRequest<FindThreatMatchesResponse> {
            private static final String REST_PATH = "v4/threatMatches:find";

            protected Find(FindThreatMatchesRequest content) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)content, FindThreatMatchesResponse.class);
            }

            public Find set$Xgafv(String $Xgafv) {
                return (Find)super.set$Xgafv($Xgafv);
            }

            public Find setAccessToken(String accessToken) {
                return (Find)super.setAccessToken(accessToken);
            }

            public Find setAlt(String alt) {
                return (Find)super.setAlt(alt);
            }

            public Find setCallback(String callback) {
                return (Find)super.setCallback(callback);
            }

            public Find setFields(String fields) {
                return (Find)super.setFields(fields);
            }

            public Find setKey(String key) {
                return (Find)super.setKey(key);
            }

            public Find setOauthToken(String oauthToken) {
                return (Find)super.setOauthToken(oauthToken);
            }

            public Find setPrettyPrint(Boolean prettyPrint) {
                return (Find)super.setPrettyPrint(prettyPrint);
            }

            public Find setQuotaUser(String quotaUser) {
                return (Find)super.setQuotaUser(quotaUser);
            }

            public Find setUploadType(String uploadType) {
                return (Find)super.setUploadType(uploadType);
            }

            public Find setUploadProtocol(String uploadProtocol) {
                return (Find)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Find set(String parameterName, Object value) {
                return (Find)super.set(parameterName, value);
            }
        }
    }

    public class ThreatLists {
        public List list() throws IOException {
            List result = new List();
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends SafebrowsingRequest<ListThreatListsResponse> {
            private static final String REST_PATH = "v4/threatLists";

            protected List() {
                super(Safebrowsing.this, "GET", REST_PATH, null, ListThreatListsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class ThreatListUpdates {
        public Fetch fetch(FetchThreatListUpdatesRequest content) throws IOException {
            Fetch result = new Fetch(content);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Fetch
        extends SafebrowsingRequest<FetchThreatListUpdatesResponse> {
            private static final String REST_PATH = "v4/threatListUpdates:fetch";

            protected Fetch(FetchThreatListUpdatesRequest content) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)content, FetchThreatListUpdatesResponse.class);
            }

            public Fetch set$Xgafv(String $Xgafv) {
                return (Fetch)super.set$Xgafv($Xgafv);
            }

            public Fetch setAccessToken(String accessToken) {
                return (Fetch)super.setAccessToken(accessToken);
            }

            public Fetch setAlt(String alt) {
                return (Fetch)super.setAlt(alt);
            }

            public Fetch setCallback(String callback) {
                return (Fetch)super.setCallback(callback);
            }

            public Fetch setFields(String fields) {
                return (Fetch)super.setFields(fields);
            }

            public Fetch setKey(String key) {
                return (Fetch)super.setKey(key);
            }

            public Fetch setOauthToken(String oauthToken) {
                return (Fetch)super.setOauthToken(oauthToken);
            }

            public Fetch setPrettyPrint(Boolean prettyPrint) {
                return (Fetch)super.setPrettyPrint(prettyPrint);
            }

            public Fetch setQuotaUser(String quotaUser) {
                return (Fetch)super.setQuotaUser(quotaUser);
            }

            public Fetch setUploadType(String uploadType) {
                return (Fetch)super.setUploadType(uploadType);
            }

            public Fetch setUploadProtocol(String uploadProtocol) {
                return (Fetch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Fetch set(String parameterName, Object value) {
                return (Fetch)super.set(parameterName, value);
            }
        }
    }

    public class ThreatHits {
        public Create create(ThreatHit content) throws IOException {
            Create result = new Create(content);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Create
        extends SafebrowsingRequest<Empty> {
            private static final String REST_PATH = "v4/threatHits";

            protected Create(ThreatHit content) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class FullHashes {
        public Find find(FindFullHashesRequest content) throws IOException {
            Find result = new Find(content);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Find
        extends SafebrowsingRequest<FindFullHashesResponse> {
            private static final String REST_PATH = "v4/fullHashes:find";

            protected Find(FindFullHashesRequest content) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)content, FindFullHashesResponse.class);
            }

            public Find set$Xgafv(String $Xgafv) {
                return (Find)super.set$Xgafv($Xgafv);
            }

            public Find setAccessToken(String accessToken) {
                return (Find)super.setAccessToken(accessToken);
            }

            public Find setAlt(String alt) {
                return (Find)super.setAlt(alt);
            }

            public Find setCallback(String callback) {
                return (Find)super.setCallback(callback);
            }

            public Find setFields(String fields) {
                return (Find)super.setFields(fields);
            }

            public Find setKey(String key) {
                return (Find)super.setKey(key);
            }

            public Find setOauthToken(String oauthToken) {
                return (Find)super.setOauthToken(oauthToken);
            }

            public Find setPrettyPrint(Boolean prettyPrint) {
                return (Find)super.setPrettyPrint(prettyPrint);
            }

            public Find setQuotaUser(String quotaUser) {
                return (Find)super.setQuotaUser(quotaUser);
            }

            public Find setUploadType(String uploadType) {
                return (Find)super.setUploadType(uploadType);
            }

            public Find setUploadProtocol(String uploadProtocol) {
                return (Find)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Find set(String parameterName, Object value) {
                return (Find)super.set(parameterName, value);
            }
        }
    }

    public class EncodedUpdates {
        public Get get(String encodedRequest) throws IOException {
            Get result = new Get(encodedRequest);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends SafebrowsingRequest<FetchThreatListUpdatesResponse> {
            private static final String REST_PATH = "v4/encodedUpdates/{encodedRequest}";
            @Key
            private String encodedRequest;
            @Key
            private String clientId;
            @Key
            private String clientVersion;

            protected Get(String encodedRequest) {
                super(Safebrowsing.this, "GET", REST_PATH, null, FetchThreatListUpdatesResponse.class);
                this.encodedRequest = (String)Preconditions.checkNotNull((Object)encodedRequest, (Object)"Required parameter encodedRequest must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getEncodedRequest() {
                return this.encodedRequest;
            }

            public Get setEncodedRequest(String encodedRequest) {
                this.encodedRequest = encodedRequest;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Get setClientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public String getClientVersion() {
                return this.clientVersion;
            }

            public Get setClientVersion(String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class EncodedFullHashes {
        public Get get(String encodedRequest) throws IOException {
            Get result = new Get(encodedRequest);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends SafebrowsingRequest<FindFullHashesResponse> {
            private static final String REST_PATH = "v4/encodedFullHashes/{encodedRequest}";
            @Key
            private String encodedRequest;
            @Key
            private String clientId;
            @Key
            private String clientVersion;

            protected Get(String encodedRequest) {
                super(Safebrowsing.this, "GET", REST_PATH, null, FindFullHashesResponse.class);
                this.encodedRequest = (String)Preconditions.checkNotNull((Object)encodedRequest, (Object)"Required parameter encodedRequest must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getEncodedRequest() {
                return this.encodedRequest;
            }

            public Get setEncodedRequest(String encodedRequest) {
                this.encodedRequest = encodedRequest;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Get setClientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            public String getClientVersion() {
                return this.clientVersion;
            }

            public Get setClientVersion(String clientVersion) {
                this.clientVersion = clientVersion;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

