/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.safebrowsing;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.safebrowsing.SafebrowsingRequest;
import com.google.api.services.safebrowsing.SafebrowsingRequestInitializer;
import com.google.api.services.safebrowsing.model.Empty;
import com.google.api.services.safebrowsing.model.FetchThreatListUpdatesRequest;
import com.google.api.services.safebrowsing.model.FetchThreatListUpdatesResponse;
import com.google.api.services.safebrowsing.model.FindFullHashesRequest;
import com.google.api.services.safebrowsing.model.FindFullHashesResponse;
import com.google.api.services.safebrowsing.model.FindThreatMatchesRequest;
import com.google.api.services.safebrowsing.model.FindThreatMatchesResponse;
import com.google.api.services.safebrowsing.model.ListThreatListsResponse;
import com.google.api.services.safebrowsing.model.ThreatHit;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Safebrowsing
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://safebrowsing.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://safebrowsing.googleapis.com/";

    public Safebrowsing(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Safebrowsing(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public EncodedFullHashes encodedFullHashes() {
        return new EncodedFullHashes();
    }

    public EncodedUpdates encodedUpdates() {
        return new EncodedUpdates();
    }

    public FullHashes fullHashes() {
        return new FullHashes();
    }

    public ThreatHits threatHits() {
        return new ThreatHits();
    }

    public ThreatListUpdates threatListUpdates() {
        return new ThreatListUpdates();
    }

    public ThreatLists threatLists() {
        return new ThreatLists();
    }

    public ThreatMatches threatMatches() {
        return new ThreatMatches();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Safe Browsing API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://safebrowsing.googleapis.com/", Safebrowsing.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Safebrowsing.DEFAULT_BATCH_PATH);
        }

        public Safebrowsing build() {
            return new Safebrowsing(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setSafebrowsingRequestInitializer(SafebrowsingRequestInitializer safebrowsingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)safebrowsingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class ThreatMatches {
        public Find find(FindThreatMatchesRequest findThreatMatchesRequest) throws IOException {
            Find find = new Find(findThreatMatchesRequest);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)find);
            return find;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Find
        extends SafebrowsingRequest<FindThreatMatchesResponse> {
            private static final String REST_PATH = "v4/threatMatches:find";

            protected Find(FindThreatMatchesRequest findThreatMatchesRequest) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)findThreatMatchesRequest, FindThreatMatchesResponse.class);
            }

            public Find set$Xgafv(String string) {
                return (Find)super.set$Xgafv(string);
            }

            public Find setAccessToken(String string) {
                return (Find)super.setAccessToken(string);
            }

            public Find setAlt(String string) {
                return (Find)super.setAlt(string);
            }

            public Find setCallback(String string) {
                return (Find)super.setCallback(string);
            }

            public Find setFields(String string) {
                return (Find)super.setFields(string);
            }

            public Find setKey(String string) {
                return (Find)super.setKey(string);
            }

            public Find setOauthToken(String string) {
                return (Find)super.setOauthToken(string);
            }

            public Find setPrettyPrint(Boolean bl) {
                return (Find)super.setPrettyPrint(bl);
            }

            public Find setQuotaUser(String string) {
                return (Find)super.setQuotaUser(string);
            }

            public Find setUploadType(String string) {
                return (Find)super.setUploadType(string);
            }

            public Find setUploadProtocol(String string) {
                return (Find)super.setUploadProtocol(string);
            }

            @Override
            public Find set(String string, Object object) {
                return (Find)super.set(string, object);
            }
        }
    }

    public class ThreatLists {
        public List list() throws IOException {
            List list = new List();
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends SafebrowsingRequest<ListThreatListsResponse> {
            private static final String REST_PATH = "v4/threatLists";

            protected List() {
                super(Safebrowsing.this, "GET", REST_PATH, null, ListThreatListsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class ThreatListUpdates {
        public Fetch fetch(FetchThreatListUpdatesRequest fetchThreatListUpdatesRequest) throws IOException {
            Fetch fetch = new Fetch(fetchThreatListUpdatesRequest);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)fetch);
            return fetch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Fetch
        extends SafebrowsingRequest<FetchThreatListUpdatesResponse> {
            private static final String REST_PATH = "v4/threatListUpdates:fetch";

            protected Fetch(FetchThreatListUpdatesRequest fetchThreatListUpdatesRequest) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)fetchThreatListUpdatesRequest, FetchThreatListUpdatesResponse.class);
            }

            public Fetch set$Xgafv(String string) {
                return (Fetch)super.set$Xgafv(string);
            }

            public Fetch setAccessToken(String string) {
                return (Fetch)super.setAccessToken(string);
            }

            public Fetch setAlt(String string) {
                return (Fetch)super.setAlt(string);
            }

            public Fetch setCallback(String string) {
                return (Fetch)super.setCallback(string);
            }

            public Fetch setFields(String string) {
                return (Fetch)super.setFields(string);
            }

            public Fetch setKey(String string) {
                return (Fetch)super.setKey(string);
            }

            public Fetch setOauthToken(String string) {
                return (Fetch)super.setOauthToken(string);
            }

            public Fetch setPrettyPrint(Boolean bl) {
                return (Fetch)super.setPrettyPrint(bl);
            }

            public Fetch setQuotaUser(String string) {
                return (Fetch)super.setQuotaUser(string);
            }

            public Fetch setUploadType(String string) {
                return (Fetch)super.setUploadType(string);
            }

            public Fetch setUploadProtocol(String string) {
                return (Fetch)super.setUploadProtocol(string);
            }

            @Override
            public Fetch set(String string, Object object) {
                return (Fetch)super.set(string, object);
            }
        }
    }

    public class ThreatHits {
        public Create create(ThreatHit threatHit) throws IOException {
            Create create = new Create(threatHit);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends SafebrowsingRequest<Empty> {
            private static final String REST_PATH = "v4/threatHits";

            protected Create(ThreatHit threatHit) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)threatHit, Empty.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class FullHashes {
        public Find find(FindFullHashesRequest findFullHashesRequest) throws IOException {
            Find find = new Find(findFullHashesRequest);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)find);
            return find;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Find
        extends SafebrowsingRequest<FindFullHashesResponse> {
            private static final String REST_PATH = "v4/fullHashes:find";

            protected Find(FindFullHashesRequest findFullHashesRequest) {
                super(Safebrowsing.this, "POST", REST_PATH, (Object)findFullHashesRequest, FindFullHashesResponse.class);
            }

            public Find set$Xgafv(String string) {
                return (Find)super.set$Xgafv(string);
            }

            public Find setAccessToken(String string) {
                return (Find)super.setAccessToken(string);
            }

            public Find setAlt(String string) {
                return (Find)super.setAlt(string);
            }

            public Find setCallback(String string) {
                return (Find)super.setCallback(string);
            }

            public Find setFields(String string) {
                return (Find)super.setFields(string);
            }

            public Find setKey(String string) {
                return (Find)super.setKey(string);
            }

            public Find setOauthToken(String string) {
                return (Find)super.setOauthToken(string);
            }

            public Find setPrettyPrint(Boolean bl) {
                return (Find)super.setPrettyPrint(bl);
            }

            public Find setQuotaUser(String string) {
                return (Find)super.setQuotaUser(string);
            }

            public Find setUploadType(String string) {
                return (Find)super.setUploadType(string);
            }

            public Find setUploadProtocol(String string) {
                return (Find)super.setUploadProtocol(string);
            }

            @Override
            public Find set(String string, Object object) {
                return (Find)super.set(string, object);
            }
        }
    }

    public class EncodedUpdates {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SafebrowsingRequest<FetchThreatListUpdatesResponse> {
            private static final String REST_PATH = "v4/encodedUpdates/{encodedRequest}";
            @Key
            private String encodedRequest;
            @Key
            private String clientVersion;
            @Key
            private String clientId;

            protected Get(String string) {
                super(Safebrowsing.this, "GET", REST_PATH, null, FetchThreatListUpdatesResponse.class);
                this.encodedRequest = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter encodedRequest must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getEncodedRequest() {
                return this.encodedRequest;
            }

            public Get setEncodedRequest(String string) {
                this.encodedRequest = string;
                return this;
            }

            public String getClientVersion() {
                return this.clientVersion;
            }

            public Get setClientVersion(String string) {
                this.clientVersion = string;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Get setClientId(String string) {
                this.clientId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class EncodedFullHashes {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Safebrowsing.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SafebrowsingRequest<FindFullHashesResponse> {
            private static final String REST_PATH = "v4/encodedFullHashes/{encodedRequest}";
            @Key
            private String encodedRequest;
            @Key
            private String clientVersion;
            @Key
            private String clientId;

            protected Get(String string) {
                super(Safebrowsing.this, "GET", REST_PATH, null, FindFullHashesResponse.class);
                this.encodedRequest = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter encodedRequest must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getEncodedRequest() {
                return this.encodedRequest;
            }

            public Get setEncodedRequest(String string) {
                this.encodedRequest = string;
                return this;
            }

            public String getClientVersion() {
                return this.clientVersion;
            }

            public Get setClientVersion(String string) {
                this.clientVersion = string;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Get setClientId(String string) {
                this.clientId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

