/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.pubsub;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.pubsub.PubsubRequest;
import com.google.api.services.pubsub.PubsubRequestInitializer;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.CreateSnapshotRequest;
import com.google.api.services.pubsub.model.Empty;
import com.google.api.services.pubsub.model.ListSnapshotsResponse;
import com.google.api.services.pubsub.model.ListSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicSnapshotsResponse;
import com.google.api.services.pubsub.model.ListTopicSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicsResponse;
import com.google.api.services.pubsub.model.ModifyAckDeadlineRequest;
import com.google.api.services.pubsub.model.ModifyPushConfigRequest;
import com.google.api.services.pubsub.model.Policy;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.SeekRequest;
import com.google.api.services.pubsub.model.SeekResponse;
import com.google.api.services.pubsub.model.SetIamPolicyRequest;
import com.google.api.services.pubsub.model.Snapshot;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.TestIamPermissionsRequest;
import com.google.api.services.pubsub.model.TestIamPermissionsResponse;
import com.google.api.services.pubsub.model.Topic;
import com.google.api.services.pubsub.model.UpdateSnapshotRequest;
import com.google.api.services.pubsub.model.UpdateSubscriptionRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pubsub
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://pubsub.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://pubsub.googleapis.com/";

    public Pubsub(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Pubsub(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Google Cloud Pub/Sub API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://pubsub.googleapis.com/", Pubsub.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Pubsub.DEFAULT_BATCH_PATH);
        }

        public Pubsub build() {
            return new Pubsub(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setPubsubRequestInitializer(PubsubRequestInitializer pubsubRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)pubsubRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Snapshots snapshots() {
            return new Snapshots();
        }

        public Subscriptions subscriptions() {
            return new Subscriptions();
        }

        public Topics topics() {
            return new Topics();
        }

        public class Topics {
            public Create create(String string, Topic topic) throws IOException {
                Create create = new Create(string, topic);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Publish publish(String string, PublishRequest publishRequest) throws IOException {
                Publish publish = new Publish(string, publishRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)publish);
                return publish;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            public Snapshots snapshots() {
                return new Snapshots();
            }

            public Subscriptions subscriptions() {
                return new Subscriptions();
            }

            public class Subscriptions {
                public List list(String string) throws IOException {
                    List list = new List(string);
                    Pubsub.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends PubsubRequest<ListTopicSubscriptionsResponse> {
                    private static final String REST_PATH = "v1/{+topic}/subscriptions";
                    private final Pattern TOPIC_PATTERN;
                    @Key
                    private String topic;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Pubsub.this, "GET", REST_PATH, null, ListTopicSubscriptionsResponse.class);
                        this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                        this.topic = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter topic must be specified.");
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getTopic() {
                        return this.topic;
                    }

                    public List setTopic(String string) {
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                        this.topic = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }

            public class Snapshots {
                public List list(String string) throws IOException {
                    List list = new List(string);
                    Pubsub.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends PubsubRequest<ListTopicSnapshotsResponse> {
                    private static final String REST_PATH = "v1/{+topic}/snapshots";
                    private final Pattern TOPIC_PATTERN;
                    @Key
                    private String topic;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String string) {
                        super(Pubsub.this, "GET", REST_PATH, null, ListTopicSnapshotsResponse.class);
                        this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                        this.topic = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter topic must be specified.");
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getTopic() {
                        return this.topic;
                    }

                    public List setTopic(String string) {
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                        this.topic = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends PubsubRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setBearerToken(String string) {
                    return (TestIamPermissions)super.setBearerToken(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPp(Boolean bl) {
                    return (TestIamPermissions)super.setPp(bl);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setBearerToken(String string) {
                    return (SetIamPolicy)super.setBearerToken(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPp(Boolean bl) {
                    return (SetIamPolicy)super.setPp(bl);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Publish
            extends PubsubRequest<PublishResponse> {
                private static final String REST_PATH = "v1/{+topic}:publish";
                private final Pattern TOPIC_PATTERN;
                @Key
                private String topic;

                protected Publish(String string, PublishRequest publishRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)publishRequest, PublishResponse.class);
                    this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.topic = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter topic must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public Publish set$Xgafv(String string) {
                    return (Publish)super.set$Xgafv(string);
                }

                public Publish setAccessToken(String string) {
                    return (Publish)super.setAccessToken(string);
                }

                public Publish setAlt(String string) {
                    return (Publish)super.setAlt(string);
                }

                public Publish setBearerToken(String string) {
                    return (Publish)super.setBearerToken(string);
                }

                public Publish setCallback(String string) {
                    return (Publish)super.setCallback(string);
                }

                public Publish setFields(String string) {
                    return (Publish)super.setFields(string);
                }

                public Publish setKey(String string) {
                    return (Publish)super.setKey(string);
                }

                public Publish setOauthToken(String string) {
                    return (Publish)super.setOauthToken(string);
                }

                public Publish setPp(Boolean bl) {
                    return (Publish)super.setPp(bl);
                }

                public Publish setPrettyPrint(Boolean bl) {
                    return (Publish)super.setPrettyPrint(bl);
                }

                public Publish setQuotaUser(String string) {
                    return (Publish)super.setQuotaUser(string);
                }

                public Publish setUploadType(String string) {
                    return (Publish)super.setUploadType(string);
                }

                public Publish setUploadProtocol(String string) {
                    return (Publish)super.setUploadProtocol(string);
                }

                public String getTopic() {
                    return this.topic;
                }

                public Publish setTopic(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.topic = string;
                    return this;
                }

                @Override
                public Publish set(String string, Object object) {
                    return (Publish)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends PubsubRequest<ListTopicsResponse> {
                private static final String REST_PATH = "v1/{+project}/topics";
                private final Pattern PROJECT_PATTERN;
                @Key
                private String project;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, ListTopicsResponse.class);
                    this.PROJECT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                    this.project = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setBearerToken(String string) {
                    return (GetIamPolicy)super.setBearerToken(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPp(Boolean bl) {
                    return (GetIamPolicy)super.setPp(bl);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends PubsubRequest<Topic> {
                private static final String REST_PATH = "v1/{+topic}";
                private final Pattern TOPIC_PATTERN;
                @Key
                private String topic;

                protected Get(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, Topic.class);
                    this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.topic = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter topic must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getTopic() {
                    return this.topic;
                }

                public Get setTopic(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.topic = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+topic}";
                private final Pattern TOPIC_PATTERN;
                @Key
                private String topic;

                protected Delete(String string) {
                    super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                    this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.topic = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter topic must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getTopic() {
                    return this.topic;
                }

                public Delete setTopic(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(string).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.topic = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends PubsubRequest<Topic> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String string, Topic topic) {
                    super(Pubsub.this, "PUT", REST_PATH, (Object)topic, Topic.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Subscriptions {
            public Acknowledge acknowledge(String string, AcknowledgeRequest acknowledgeRequest) throws IOException {
                Acknowledge acknowledge = new Acknowledge(string, acknowledgeRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)acknowledge);
                return acknowledge;
            }

            public Create create(String string, Subscription subscription) throws IOException {
                Create create = new Create(string, subscription);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public ModifyAckDeadline modifyAckDeadline(String string, ModifyAckDeadlineRequest modifyAckDeadlineRequest) throws IOException {
                ModifyAckDeadline modifyAckDeadline = new ModifyAckDeadline(string, modifyAckDeadlineRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)modifyAckDeadline);
                return modifyAckDeadline;
            }

            public ModifyPushConfig modifyPushConfig(String string, ModifyPushConfigRequest modifyPushConfigRequest) throws IOException {
                ModifyPushConfig modifyPushConfig = new ModifyPushConfig(string, modifyPushConfigRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)modifyPushConfig);
                return modifyPushConfig;
            }

            public Patch patch(String string, UpdateSubscriptionRequest updateSubscriptionRequest) throws IOException {
                Patch patch = new Patch(string, updateSubscriptionRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Pull pull(String string, PullRequest pullRequest) throws IOException {
                Pull pull = new Pull(string, pullRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)pull);
                return pull;
            }

            public Seek seek(String string, SeekRequest seekRequest) throws IOException {
                Seek seek = new Seek(string, seekRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)seek);
                return seek;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends PubsubRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setBearerToken(String string) {
                    return (TestIamPermissions)super.setBearerToken(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPp(Boolean bl) {
                    return (TestIamPermissions)super.setPp(bl);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setBearerToken(String string) {
                    return (SetIamPolicy)super.setBearerToken(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPp(Boolean bl) {
                    return (SetIamPolicy)super.setPp(bl);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Seek
            extends PubsubRequest<SeekResponse> {
                private static final String REST_PATH = "v1/{+subscription}:seek";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Seek(String string, SeekRequest seekRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)seekRequest, SeekResponse.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Seek set$Xgafv(String string) {
                    return (Seek)super.set$Xgafv(string);
                }

                public Seek setAccessToken(String string) {
                    return (Seek)super.setAccessToken(string);
                }

                public Seek setAlt(String string) {
                    return (Seek)super.setAlt(string);
                }

                public Seek setBearerToken(String string) {
                    return (Seek)super.setBearerToken(string);
                }

                public Seek setCallback(String string) {
                    return (Seek)super.setCallback(string);
                }

                public Seek setFields(String string) {
                    return (Seek)super.setFields(string);
                }

                public Seek setKey(String string) {
                    return (Seek)super.setKey(string);
                }

                public Seek setOauthToken(String string) {
                    return (Seek)super.setOauthToken(string);
                }

                public Seek setPp(Boolean bl) {
                    return (Seek)super.setPp(bl);
                }

                public Seek setPrettyPrint(Boolean bl) {
                    return (Seek)super.setPrettyPrint(bl);
                }

                public Seek setQuotaUser(String string) {
                    return (Seek)super.setQuotaUser(string);
                }

                public Seek setUploadType(String string) {
                    return (Seek)super.setUploadType(string);
                }

                public Seek setUploadProtocol(String string) {
                    return (Seek)super.setUploadProtocol(string);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Seek setSubscription(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = string;
                    return this;
                }

                @Override
                public Seek set(String string, Object object) {
                    return (Seek)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Pull
            extends PubsubRequest<PullResponse> {
                private static final String REST_PATH = "v1/{+subscription}:pull";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Pull(String string, PullRequest pullRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)pullRequest, PullResponse.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Pull set$Xgafv(String string) {
                    return (Pull)super.set$Xgafv(string);
                }

                public Pull setAccessToken(String string) {
                    return (Pull)super.setAccessToken(string);
                }

                public Pull setAlt(String string) {
                    return (Pull)super.setAlt(string);
                }

                public Pull setBearerToken(String string) {
                    return (Pull)super.setBearerToken(string);
                }

                public Pull setCallback(String string) {
                    return (Pull)super.setCallback(string);
                }

                public Pull setFields(String string) {
                    return (Pull)super.setFields(string);
                }

                public Pull setKey(String string) {
                    return (Pull)super.setKey(string);
                }

                public Pull setOauthToken(String string) {
                    return (Pull)super.setOauthToken(string);
                }

                public Pull setPp(Boolean bl) {
                    return (Pull)super.setPp(bl);
                }

                public Pull setPrettyPrint(Boolean bl) {
                    return (Pull)super.setPrettyPrint(bl);
                }

                public Pull setQuotaUser(String string) {
                    return (Pull)super.setQuotaUser(string);
                }

                public Pull setUploadType(String string) {
                    return (Pull)super.setUploadType(string);
                }

                public Pull setUploadProtocol(String string) {
                    return (Pull)super.setUploadProtocol(string);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Pull setSubscription(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = string;
                    return this;
                }

                @Override
                public Pull set(String string, Object object) {
                    return (Pull)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends PubsubRequest<Subscription> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String string, UpdateSubscriptionRequest updateSubscriptionRequest) {
                    super(Pubsub.this, "PATCH", REST_PATH, (Object)updateSubscriptionRequest, Subscription.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class ModifyPushConfig
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}:modifyPushConfig";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected ModifyPushConfig(String string, ModifyPushConfigRequest modifyPushConfigRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)modifyPushConfigRequest, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public ModifyPushConfig set$Xgafv(String string) {
                    return (ModifyPushConfig)super.set$Xgafv(string);
                }

                public ModifyPushConfig setAccessToken(String string) {
                    return (ModifyPushConfig)super.setAccessToken(string);
                }

                public ModifyPushConfig setAlt(String string) {
                    return (ModifyPushConfig)super.setAlt(string);
                }

                public ModifyPushConfig setBearerToken(String string) {
                    return (ModifyPushConfig)super.setBearerToken(string);
                }

                public ModifyPushConfig setCallback(String string) {
                    return (ModifyPushConfig)super.setCallback(string);
                }

                public ModifyPushConfig setFields(String string) {
                    return (ModifyPushConfig)super.setFields(string);
                }

                public ModifyPushConfig setKey(String string) {
                    return (ModifyPushConfig)super.setKey(string);
                }

                public ModifyPushConfig setOauthToken(String string) {
                    return (ModifyPushConfig)super.setOauthToken(string);
                }

                public ModifyPushConfig setPp(Boolean bl) {
                    return (ModifyPushConfig)super.setPp(bl);
                }

                public ModifyPushConfig setPrettyPrint(Boolean bl) {
                    return (ModifyPushConfig)super.setPrettyPrint(bl);
                }

                public ModifyPushConfig setQuotaUser(String string) {
                    return (ModifyPushConfig)super.setQuotaUser(string);
                }

                public ModifyPushConfig setUploadType(String string) {
                    return (ModifyPushConfig)super.setUploadType(string);
                }

                public ModifyPushConfig setUploadProtocol(String string) {
                    return (ModifyPushConfig)super.setUploadProtocol(string);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public ModifyPushConfig setSubscription(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = string;
                    return this;
                }

                @Override
                public ModifyPushConfig set(String string, Object object) {
                    return (ModifyPushConfig)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class ModifyAckDeadline
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}:modifyAckDeadline";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected ModifyAckDeadline(String string, ModifyAckDeadlineRequest modifyAckDeadlineRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)modifyAckDeadlineRequest, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public ModifyAckDeadline set$Xgafv(String string) {
                    return (ModifyAckDeadline)super.set$Xgafv(string);
                }

                public ModifyAckDeadline setAccessToken(String string) {
                    return (ModifyAckDeadline)super.setAccessToken(string);
                }

                public ModifyAckDeadline setAlt(String string) {
                    return (ModifyAckDeadline)super.setAlt(string);
                }

                public ModifyAckDeadline setBearerToken(String string) {
                    return (ModifyAckDeadline)super.setBearerToken(string);
                }

                public ModifyAckDeadline setCallback(String string) {
                    return (ModifyAckDeadline)super.setCallback(string);
                }

                public ModifyAckDeadline setFields(String string) {
                    return (ModifyAckDeadline)super.setFields(string);
                }

                public ModifyAckDeadline setKey(String string) {
                    return (ModifyAckDeadline)super.setKey(string);
                }

                public ModifyAckDeadline setOauthToken(String string) {
                    return (ModifyAckDeadline)super.setOauthToken(string);
                }

                public ModifyAckDeadline setPp(Boolean bl) {
                    return (ModifyAckDeadline)super.setPp(bl);
                }

                public ModifyAckDeadline setPrettyPrint(Boolean bl) {
                    return (ModifyAckDeadline)super.setPrettyPrint(bl);
                }

                public ModifyAckDeadline setQuotaUser(String string) {
                    return (ModifyAckDeadline)super.setQuotaUser(string);
                }

                public ModifyAckDeadline setUploadType(String string) {
                    return (ModifyAckDeadline)super.setUploadType(string);
                }

                public ModifyAckDeadline setUploadProtocol(String string) {
                    return (ModifyAckDeadline)super.setUploadProtocol(string);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public ModifyAckDeadline setSubscription(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = string;
                    return this;
                }

                @Override
                public ModifyAckDeadline set(String string, Object object) {
                    return (ModifyAckDeadline)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends PubsubRequest<ListSubscriptionsResponse> {
                private static final String REST_PATH = "v1/{+project}/subscriptions";
                private final Pattern PROJECT_PATTERN;
                @Key
                private String project;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, ListSubscriptionsResponse.class);
                    this.PROJECT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                    this.project = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setBearerToken(String string) {
                    return (GetIamPolicy)super.setBearerToken(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPp(Boolean bl) {
                    return (GetIamPolicy)super.setPp(bl);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends PubsubRequest<Subscription> {
                private static final String REST_PATH = "v1/{+subscription}";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Get(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, Subscription.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Get setSubscription(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Delete(String string) {
                    super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Delete setSubscription(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends PubsubRequest<Subscription> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String string, Subscription subscription) {
                    super(Pubsub.this, "PUT", REST_PATH, (Object)subscription, Subscription.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Acknowledge
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}:acknowledge";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Acknowledge(String string, AcknowledgeRequest acknowledgeRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)acknowledgeRequest, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Acknowledge set$Xgafv(String string) {
                    return (Acknowledge)super.set$Xgafv(string);
                }

                public Acknowledge setAccessToken(String string) {
                    return (Acknowledge)super.setAccessToken(string);
                }

                public Acknowledge setAlt(String string) {
                    return (Acknowledge)super.setAlt(string);
                }

                public Acknowledge setBearerToken(String string) {
                    return (Acknowledge)super.setBearerToken(string);
                }

                public Acknowledge setCallback(String string) {
                    return (Acknowledge)super.setCallback(string);
                }

                public Acknowledge setFields(String string) {
                    return (Acknowledge)super.setFields(string);
                }

                public Acknowledge setKey(String string) {
                    return (Acknowledge)super.setKey(string);
                }

                public Acknowledge setOauthToken(String string) {
                    return (Acknowledge)super.setOauthToken(string);
                }

                public Acknowledge setPp(Boolean bl) {
                    return (Acknowledge)super.setPp(bl);
                }

                public Acknowledge setPrettyPrint(Boolean bl) {
                    return (Acknowledge)super.setPrettyPrint(bl);
                }

                public Acknowledge setQuotaUser(String string) {
                    return (Acknowledge)super.setQuotaUser(string);
                }

                public Acknowledge setUploadType(String string) {
                    return (Acknowledge)super.setUploadType(string);
                }

                public Acknowledge setUploadProtocol(String string) {
                    return (Acknowledge)super.setUploadProtocol(string);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Acknowledge setSubscription(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(string).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = string;
                    return this;
                }

                @Override
                public Acknowledge set(String string, Object object) {
                    return (Acknowledge)super.set(string, object);
                }
            }
        }

        public class Snapshots {
            public Create create(String string, CreateSnapshotRequest createSnapshotRequest) throws IOException {
                Create create = new Create(string, createSnapshotRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, UpdateSnapshotRequest updateSnapshotRequest) throws IOException {
                Patch patch = new Patch(string, updateSnapshotRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends PubsubRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setBearerToken(String string) {
                    return (TestIamPermissions)super.setBearerToken(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPp(Boolean bl) {
                    return (TestIamPermissions)super.setPp(bl);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setBearerToken(String string) {
                    return (SetIamPolicy)super.setBearerToken(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPp(Boolean bl) {
                    return (SetIamPolicy)super.setPp(bl);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends PubsubRequest<Snapshot> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String string, UpdateSnapshotRequest updateSnapshotRequest) {
                    super(Pubsub.this, "PATCH", REST_PATH, (Object)updateSnapshotRequest, Snapshot.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setBearerToken(String string) {
                    return (Patch)super.setBearerToken(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPp(Boolean bl) {
                    return (Patch)super.setPp(bl);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends PubsubRequest<ListSnapshotsResponse> {
                private static final String REST_PATH = "v1/{+project}/snapshots";
                private final Pattern PROJECT_PATTERN;
                @Key
                private String project;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, ListSnapshotsResponse.class);
                    this.PROJECT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                    this.project = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setBearerToken(String string) {
                    return (GetIamPolicy)super.setBearerToken(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPp(Boolean bl) {
                    return (GetIamPolicy)super.setPp(bl);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends PubsubRequest<Snapshot> {
                private static final String REST_PATH = "v1/{+snapshot}";
                private final Pattern SNAPSHOT_PATTERN;
                @Key
                private String snapshot;

                protected Get(String string) {
                    super(Pubsub.this, "GET", REST_PATH, null, Snapshot.class);
                    this.SNAPSHOT_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.snapshot = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter snapshot must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSnapshot() {
                    return this.snapshot;
                }

                public Get setSnapshot(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.snapshot = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+snapshot}";
                private final Pattern SNAPSHOT_PATTERN;
                @Key
                private String snapshot;

                protected Delete(String string) {
                    super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SNAPSHOT_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.snapshot = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter snapshot must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getSnapshot() {
                    return this.snapshot;
                }

                public Delete setSnapshot(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.snapshot = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends PubsubRequest<Snapshot> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String string, CreateSnapshotRequest createSnapshotRequest) {
                    super(Pubsub.this, "PUT", REST_PATH, (Object)createSnapshotRequest, Snapshot.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String string) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }
    }
}

