/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-25 at 21:38:37 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pubsub;

/**
 * Service definition for Pubsub (v1).
 *
 * <p>
 * Provides reliable, many-to-many, asynchronous messaging between applications.

 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/pubsub/docs" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link PubsubRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Pubsub extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.22.0 of the Google Cloud Pub/Sub API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://pubsub.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Pubsub(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Pubsub(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Pubsub pubsub = new Pubsub(...);}
   *   {@code Pubsub.Projects.List request = pubsub.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Snapshots collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Pubsub pubsub = new Pubsub(...);}
     *   {@code Pubsub.Snapshots.List request = pubsub.snapshots().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Snapshots snapshots() {
      return new Snapshots();
    }

    /**
     * The "snapshots" collection of methods.
     */
    public class Snapshots {

      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "snapshots.getIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "snapshots.getIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (GetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPp(java.lang.Boolean pp) {
          return (GetIamPolicy) super.setPp(pp);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "snapshots.setIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy.
         *
         * Create a request for the method "snapshots.setIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (SetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPp(java.lang.Boolean pp) {
          return (SetIamPolicy) super.setPp(pp);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a NOT_FOUND error.
       *
       * Note: This operation is designed to be used for building permission-aware UIs and command-line
       * tools, not for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "snapshots.testIamPermissions".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
       * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends PubsubRequest<com.google.api.services.pubsub.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a NOT_FOUND error.
         *
         * Note: This operation is designed to be used for building permission-aware UIs and command-line
         * tools, not for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "snapshots.testIamPermissions".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setBearerToken(java.lang.String bearerToken) {
          return (TestIamPermissions) super.setBearerToken(bearerToken);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPp(java.lang.Boolean pp) {
          return (TestIamPermissions) super.setPp(pp);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See the operation
       documentation for the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/snapshots/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Subscriptions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Pubsub pubsub = new Pubsub(...);}
     *   {@code Pubsub.Subscriptions.List request = pubsub.subscriptions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Subscriptions subscriptions() {
      return new Subscriptions();
    }

    /**
     * The "subscriptions" collection of methods.
     */
    public class Subscriptions {

      /**
       * Acknowledges the messages associated with the `ack_ids` in the `AcknowledgeRequest`. The Pub/Sub
       * system can remove the relevant messages from the subscription.
       *
       * Acknowledging a message whose ack deadline has expired may succeed, but such a message may be
       * redelivered later. Acknowledging a message more than once will not result in an error.
       *
       * Create a request for the method "subscriptions.acknowledge".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Acknowledge#execute()} method to invoke the remote operation.
       *
       * @param subscription The subscription whose message is being acknowledged.
      Format is
       *        `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.AcknowledgeRequest}
       * @return the request
       */
      public Acknowledge acknowledge(java.lang.String subscription, com.google.api.services.pubsub.model.AcknowledgeRequest content) throws java.io.IOException {
        Acknowledge result = new Acknowledge(subscription, content);
        initialize(result);
        return result;
      }

      public class Acknowledge extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}:acknowledge";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Acknowledges the messages associated with the `ack_ids` in the `AcknowledgeRequest`. The
         * Pub/Sub system can remove the relevant messages from the subscription.
         *
         * Acknowledging a message whose ack deadline has expired may succeed, but such a message may be
         * redelivered later. Acknowledging a message more than once will not result in an error.
         *
         * Create a request for the method "subscriptions.acknowledge".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Acknowledge#execute()} method to invoke the remote operation. <p>
         * {@link
         * Acknowledge#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription The subscription whose message is being acknowledged.
      Format is
       *        `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.AcknowledgeRequest}
         * @since 1.13
         */
        protected Acknowledge(java.lang.String subscription, com.google.api.services.pubsub.model.AcknowledgeRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Acknowledge set$Xgafv(java.lang.String $Xgafv) {
          return (Acknowledge) super.set$Xgafv($Xgafv);
        }

        @Override
        public Acknowledge setAccessToken(java.lang.String accessToken) {
          return (Acknowledge) super.setAccessToken(accessToken);
        }

        @Override
        public Acknowledge setAlt(java.lang.String alt) {
          return (Acknowledge) super.setAlt(alt);
        }

        @Override
        public Acknowledge setBearerToken(java.lang.String bearerToken) {
          return (Acknowledge) super.setBearerToken(bearerToken);
        }

        @Override
        public Acknowledge setCallback(java.lang.String callback) {
          return (Acknowledge) super.setCallback(callback);
        }

        @Override
        public Acknowledge setFields(java.lang.String fields) {
          return (Acknowledge) super.setFields(fields);
        }

        @Override
        public Acknowledge setKey(java.lang.String key) {
          return (Acknowledge) super.setKey(key);
        }

        @Override
        public Acknowledge setOauthToken(java.lang.String oauthToken) {
          return (Acknowledge) super.setOauthToken(oauthToken);
        }

        @Override
        public Acknowledge setPp(java.lang.Boolean pp) {
          return (Acknowledge) super.setPp(pp);
        }

        @Override
        public Acknowledge setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Acknowledge) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Acknowledge setQuotaUser(java.lang.String quotaUser) {
          return (Acknowledge) super.setQuotaUser(quotaUser);
        }

        @Override
        public Acknowledge setUploadType(java.lang.String uploadType) {
          return (Acknowledge) super.setUploadType(uploadType);
        }

        @Override
        public Acknowledge setUploadProtocol(java.lang.String uploadProtocol) {
          return (Acknowledge) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The subscription whose message is being acknowledged. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** The subscription whose message is being acknowledged. Format is
       `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * The subscription whose message is being acknowledged. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        public Acknowledge setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Acknowledge set(String parameterName, Object value) {
          return (Acknowledge) super.set(parameterName, value);
        }
      }
      /**
       * Creates a subscription to a given topic. If the subscription already exists, returns
       * `ALREADY_EXISTS`. If the corresponding topic doesn't exist, returns `NOT_FOUND`.
       *
       * If the name is not provided in the request, the server will assign a random name for this
       * subscription on the same project as the topic, conforming to the [resource name
       * format](https://cloud.google.com/pubsub/docs/overview#names). The generated name is populated in
       * the returned Subscription object. Note that for REST API requests, you must specify a name in the
       * request.
       *
       * Create a request for the method "subscriptions.create".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The name of the subscription. It must have the format
       *        `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
      start with a
       *        letter, and contain only letters (`[A-Za-z]`), numbers
      (`[0-9]`), dashes (`-`),
       *        underscores (`_`), periods (`.`), tildes (`~`),
      plus (`+`) or percent signs (`%`). It must
       *        be between 3 and 255 characters
      in length, and it must not start with `"goog"`.
       * @param content the {@link com.google.api.services.pubsub.model.Subscription}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.pubsub.model.Subscription content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends PubsubRequest<com.google.api.services.pubsub.model.Subscription> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Creates a subscription to a given topic. If the subscription already exists, returns
         * `ALREADY_EXISTS`. If the corresponding topic doesn't exist, returns `NOT_FOUND`.
         *
         * If the name is not provided in the request, the server will assign a random name for this
         * subscription on the same project as the topic, conforming to the [resource name
         * format](https://cloud.google.com/pubsub/docs/overview#names). The generated name is populated
         * in the returned Subscription object. Note that for REST API requests, you must specify a name
         * in the request.
         *
         * Create a request for the method "subscriptions.create".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the subscription. It must have the format
       *        `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
      start with a
       *        letter, and contain only letters (`[A-Za-z]`), numbers
      (`[0-9]`), dashes (`-`),
       *        underscores (`_`), periods (`.`), tildes (`~`),
      plus (`+`) or percent signs (`%`). It must
       *        be between 3 and 255 characters
      in length, and it must not start with `"goog"`.
         * @param content the {@link com.google.api.services.pubsub.model.Subscription}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.pubsub.model.Subscription content) {
          super(Pubsub.this, "PUT", REST_PATH, content, com.google.api.services.pubsub.model.Subscription.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setBearerToken(java.lang.String bearerToken) {
          return (Create) super.setBearerToken(bearerToken);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPp(java.lang.Boolean pp) {
          return (Create) super.setPp(pp);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the subscription. It must have the format
         * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
         * letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
         * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
         * must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the subscription. It must have the format
       `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a letter, and
       contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`), underscores (`_`), periods
       (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters in
       length, and it must not start with `"goog"`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name of the subscription. It must have the format
         * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must start with a
         * letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
         * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It
         * must be between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an existing subscription. All messages retained in the subscription are immediately
       * dropped. Calls to `Pull` after deletion will return `NOT_FOUND`. After a subscription is deleted,
       * a new one may be created with the same name, but the new one has no association with the old
       * subscription or its topic unless the same topic is specified.
       *
       * Create a request for the method "subscriptions.delete".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param subscription The subscription to delete.
      Format is `projects/{project}/subscriptions/{sub}`.
       * @return the request
       */
      public Delete delete(java.lang.String subscription) throws java.io.IOException {
        Delete result = new Delete(subscription);
        initialize(result);
        return result;
      }

      public class Delete extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Deletes an existing subscription. All messages retained in the subscription are immediately
         * dropped. Calls to `Pull` after deletion will return `NOT_FOUND`. After a subscription is
         * deleted, a new one may be created with the same name, but the new one has no association with
         * the old subscription or its topic unless the same topic is specified.
         *
         * Create a request for the method "subscriptions.delete".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription The subscription to delete.
      Format is `projects/{project}/subscriptions/{sub}`.
         * @since 1.13
         */
        protected Delete(java.lang.String subscription) {
          super(Pubsub.this, "DELETE", REST_PATH, null, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setBearerToken(java.lang.String bearerToken) {
          return (Delete) super.setBearerToken(bearerToken);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPp(java.lang.Boolean pp) {
          return (Delete) super.setPp(pp);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * The subscription to delete. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public Delete setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the configuration details of a subscription.
       *
       * Create a request for the method "subscriptions.get".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param subscription The name of the subscription to get.
      Format is `projects/{project}/subscriptions/{sub}`.
       * @return the request
       */
      public Get get(java.lang.String subscription) throws java.io.IOException {
        Get result = new Get(subscription);
        initialize(result);
        return result;
      }

      public class Get extends PubsubRequest<com.google.api.services.pubsub.model.Subscription> {

        private static final String REST_PATH = "v1/{+subscription}";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Gets the configuration details of a subscription.
         *
         * Create a request for the method "subscriptions.get".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription The name of the subscription to get.
      Format is `projects/{project}/subscriptions/{sub}`.
         * @since 1.13
         */
        protected Get(java.lang.String subscription) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Subscription.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setBearerToken(java.lang.String bearerToken) {
          return (Get) super.setBearerToken(bearerToken);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPp(java.lang.Boolean pp) {
          return (Get) super.setPp(pp);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the subscription to get. Format is `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** The name of the subscription to get. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * The name of the subscription to get. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public Get setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "subscriptions.getIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "subscriptions.getIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (GetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPp(java.lang.Boolean pp) {
          return (GetIamPolicy) super.setPp(pp);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists matching subscriptions.
       *
       * Create a request for the method "subscriptions.list".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param project The name of the cloud project that subscriptions belong to.
      Format is `projects/{project}`.
       * @return the request
       */
      public List list(java.lang.String project) throws java.io.IOException {
        List result = new List(project);
        initialize(result);
        return result;
      }

      public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListSubscriptionsResponse> {

        private static final String REST_PATH = "v1/{+project}/subscriptions";

        private final java.util.regex.Pattern PROJECT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists matching subscriptions.
         *
         * Create a request for the method "subscriptions.list".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param project The name of the cloud project that subscriptions belong to.
      Format is `projects/{project}`.
         * @since 1.13
         */
        protected List(java.lang.String project) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListSubscriptionsResponse.class);
          this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setBearerToken(java.lang.String bearerToken) {
          return (List) super.setBearerToken(bearerToken);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPp(java.lang.Boolean pp) {
          return (List) super.setPp(pp);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the cloud project that subscriptions belong to. Format is
         * `projects/{project}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String project;

        /** The name of the cloud project that subscriptions belong to. Format is `projects/{project}`.
         */
        public java.lang.String getProject() {
          return project;
        }

        /**
         * The name of the cloud project that subscriptions belong to. Format is
         * `projects/{project}`.
         */
        public List setProject(java.lang.String project) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.project = project;
          return this;
        }

        /**
         * The value returned by the last `ListSubscriptionsResponse`; indicates that this is a
         * continuation of a prior `ListSubscriptions` call, and that the system should return the
         * next page of data.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The value returned by the last `ListSubscriptionsResponse`; indicates that this is a continuation
       of a prior `ListSubscriptions` call, and that the system should return the next page of data.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The value returned by the last `ListSubscriptionsResponse`; indicates that this is a
         * continuation of a prior `ListSubscriptions` call, and that the system should return the
         * next page of data.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** Maximum number of subscriptions to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Maximum number of subscriptions to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Maximum number of subscriptions to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Modifies the ack deadline for a specific message. This method is useful to indicate that more
       * time is needed to process a message by the subscriber, or to make the message available for
       * redelivery if the processing was interrupted. Note that this does not modify the subscription-
       * level `ackDeadlineSeconds` used for subsequent messages.
       *
       * Create a request for the method "subscriptions.modifyAckDeadline".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link ModifyAckDeadline#execute()} method to invoke the remote operation.
       *
       * @param subscription The name of the subscription.
      Format is `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.ModifyAckDeadlineRequest}
       * @return the request
       */
      public ModifyAckDeadline modifyAckDeadline(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyAckDeadlineRequest content) throws java.io.IOException {
        ModifyAckDeadline result = new ModifyAckDeadline(subscription, content);
        initialize(result);
        return result;
      }

      public class ModifyAckDeadline extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}:modifyAckDeadline";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Modifies the ack deadline for a specific message. This method is useful to indicate that more
         * time is needed to process a message by the subscriber, or to make the message available for
         * redelivery if the processing was interrupted. Note that this does not modify the subscription-
         * level `ackDeadlineSeconds` used for subsequent messages.
         *
         * Create a request for the method "subscriptions.modifyAckDeadline".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link ModifyAckDeadline#execute()} method to invoke the remote operation.
         * <p> {@link ModifyAckDeadline#initialize(com.google.api.client.googleapis.services.AbstractGoogl
         * eClientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param subscription The name of the subscription.
      Format is `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.ModifyAckDeadlineRequest}
         * @since 1.13
         */
        protected ModifyAckDeadline(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyAckDeadlineRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public ModifyAckDeadline set$Xgafv(java.lang.String $Xgafv) {
          return (ModifyAckDeadline) super.set$Xgafv($Xgafv);
        }

        @Override
        public ModifyAckDeadline setAccessToken(java.lang.String accessToken) {
          return (ModifyAckDeadline) super.setAccessToken(accessToken);
        }

        @Override
        public ModifyAckDeadline setAlt(java.lang.String alt) {
          return (ModifyAckDeadline) super.setAlt(alt);
        }

        @Override
        public ModifyAckDeadline setBearerToken(java.lang.String bearerToken) {
          return (ModifyAckDeadline) super.setBearerToken(bearerToken);
        }

        @Override
        public ModifyAckDeadline setCallback(java.lang.String callback) {
          return (ModifyAckDeadline) super.setCallback(callback);
        }

        @Override
        public ModifyAckDeadline setFields(java.lang.String fields) {
          return (ModifyAckDeadline) super.setFields(fields);
        }

        @Override
        public ModifyAckDeadline setKey(java.lang.String key) {
          return (ModifyAckDeadline) super.setKey(key);
        }

        @Override
        public ModifyAckDeadline setOauthToken(java.lang.String oauthToken) {
          return (ModifyAckDeadline) super.setOauthToken(oauthToken);
        }

        @Override
        public ModifyAckDeadline setPp(java.lang.Boolean pp) {
          return (ModifyAckDeadline) super.setPp(pp);
        }

        @Override
        public ModifyAckDeadline setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (ModifyAckDeadline) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public ModifyAckDeadline setQuotaUser(java.lang.String quotaUser) {
          return (ModifyAckDeadline) super.setQuotaUser(quotaUser);
        }

        @Override
        public ModifyAckDeadline setUploadType(java.lang.String uploadType) {
          return (ModifyAckDeadline) super.setUploadType(uploadType);
        }

        @Override
        public ModifyAckDeadline setUploadProtocol(java.lang.String uploadProtocol) {
          return (ModifyAckDeadline) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public ModifyAckDeadline setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public ModifyAckDeadline set(String parameterName, Object value) {
          return (ModifyAckDeadline) super.set(parameterName, value);
        }
      }
      /**
       * Modifies the `PushConfig` for a specified subscription.
       *
       * This may be used to change a push subscription to a pull one (signified by an empty `PushConfig`)
       * or vice versa, or change the endpoint URL and other attributes of a push subscription. Messages
       * will accumulate for delivery continuously through the call regardless of changes to the
       * `PushConfig`.
       *
       * Create a request for the method "subscriptions.modifyPushConfig".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link ModifyPushConfig#execute()} method to invoke the remote operation.
       *
       * @param subscription The name of the subscription.
      Format is `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.ModifyPushConfigRequest}
       * @return the request
       */
      public ModifyPushConfig modifyPushConfig(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyPushConfigRequest content) throws java.io.IOException {
        ModifyPushConfig result = new ModifyPushConfig(subscription, content);
        initialize(result);
        return result;
      }

      public class ModifyPushConfig extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+subscription}:modifyPushConfig";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Modifies the `PushConfig` for a specified subscription.
         *
         * This may be used to change a push subscription to a pull one (signified by an empty
         * `PushConfig`) or vice versa, or change the endpoint URL and other attributes of a push
         * subscription. Messages will accumulate for delivery continuously through the call regardless of
         * changes to the `PushConfig`.
         *
         * Create a request for the method "subscriptions.modifyPushConfig".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link ModifyPushConfig#execute()} method to invoke the remote operation.
         * <p> {@link ModifyPushConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogle
         * ClientRequest)} must be called to initialize this instance immediately after invoking the
         * constructor. </p>
         *
         * @param subscription The name of the subscription.
      Format is `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.ModifyPushConfigRequest}
         * @since 1.13
         */
        protected ModifyPushConfig(java.lang.String subscription, com.google.api.services.pubsub.model.ModifyPushConfigRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Empty.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public ModifyPushConfig set$Xgafv(java.lang.String $Xgafv) {
          return (ModifyPushConfig) super.set$Xgafv($Xgafv);
        }

        @Override
        public ModifyPushConfig setAccessToken(java.lang.String accessToken) {
          return (ModifyPushConfig) super.setAccessToken(accessToken);
        }

        @Override
        public ModifyPushConfig setAlt(java.lang.String alt) {
          return (ModifyPushConfig) super.setAlt(alt);
        }

        @Override
        public ModifyPushConfig setBearerToken(java.lang.String bearerToken) {
          return (ModifyPushConfig) super.setBearerToken(bearerToken);
        }

        @Override
        public ModifyPushConfig setCallback(java.lang.String callback) {
          return (ModifyPushConfig) super.setCallback(callback);
        }

        @Override
        public ModifyPushConfig setFields(java.lang.String fields) {
          return (ModifyPushConfig) super.setFields(fields);
        }

        @Override
        public ModifyPushConfig setKey(java.lang.String key) {
          return (ModifyPushConfig) super.setKey(key);
        }

        @Override
        public ModifyPushConfig setOauthToken(java.lang.String oauthToken) {
          return (ModifyPushConfig) super.setOauthToken(oauthToken);
        }

        @Override
        public ModifyPushConfig setPp(java.lang.Boolean pp) {
          return (ModifyPushConfig) super.setPp(pp);
        }

        @Override
        public ModifyPushConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (ModifyPushConfig) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public ModifyPushConfig setQuotaUser(java.lang.String quotaUser) {
          return (ModifyPushConfig) super.setQuotaUser(quotaUser);
        }

        @Override
        public ModifyPushConfig setUploadType(java.lang.String uploadType) {
          return (ModifyPushConfig) super.setUploadType(uploadType);
        }

        @Override
        public ModifyPushConfig setUploadProtocol(java.lang.String uploadProtocol) {
          return (ModifyPushConfig) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * The name of the subscription. Format is `projects/{project}/subscriptions/{sub}`.
         */
        public ModifyPushConfig setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public ModifyPushConfig set(String parameterName, Object value) {
          return (ModifyPushConfig) super.set(parameterName, value);
        }
      }
      /**
       * Pulls messages from the server. Returns an empty list if there are no messages available in the
       * backlog. The server may return `UNAVAILABLE` if there are too many concurrent pull requests
       * pending for the given subscription.
       *
       * Create a request for the method "subscriptions.pull".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Pull#execute()} method to invoke the remote operation.
       *
       * @param subscription The subscription from which messages should be pulled.
      Format is
       *        `projects/{project}/subscriptions/{sub}`.
       * @param content the {@link com.google.api.services.pubsub.model.PullRequest}
       * @return the request
       */
      public Pull pull(java.lang.String subscription, com.google.api.services.pubsub.model.PullRequest content) throws java.io.IOException {
        Pull result = new Pull(subscription, content);
        initialize(result);
        return result;
      }

      public class Pull extends PubsubRequest<com.google.api.services.pubsub.model.PullResponse> {

        private static final String REST_PATH = "v1/{+subscription}:pull";

        private final java.util.regex.Pattern SUBSCRIPTION_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Pulls messages from the server. Returns an empty list if there are no messages available in the
         * backlog. The server may return `UNAVAILABLE` if there are too many concurrent pull requests
         * pending for the given subscription.
         *
         * Create a request for the method "subscriptions.pull".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Pull#execute()} method to invoke the remote operation. <p> {@link
         * Pull#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param subscription The subscription from which messages should be pulled.
      Format is
       *        `projects/{project}/subscriptions/{sub}`.
         * @param content the {@link com.google.api.services.pubsub.model.PullRequest}
         * @since 1.13
         */
        protected Pull(java.lang.String subscription, com.google.api.services.pubsub.model.PullRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.PullResponse.class);
          this.subscription = com.google.api.client.util.Preconditions.checkNotNull(subscription, "Required parameter subscription must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public Pull set$Xgafv(java.lang.String $Xgafv) {
          return (Pull) super.set$Xgafv($Xgafv);
        }

        @Override
        public Pull setAccessToken(java.lang.String accessToken) {
          return (Pull) super.setAccessToken(accessToken);
        }

        @Override
        public Pull setAlt(java.lang.String alt) {
          return (Pull) super.setAlt(alt);
        }

        @Override
        public Pull setBearerToken(java.lang.String bearerToken) {
          return (Pull) super.setBearerToken(bearerToken);
        }

        @Override
        public Pull setCallback(java.lang.String callback) {
          return (Pull) super.setCallback(callback);
        }

        @Override
        public Pull setFields(java.lang.String fields) {
          return (Pull) super.setFields(fields);
        }

        @Override
        public Pull setKey(java.lang.String key) {
          return (Pull) super.setKey(key);
        }

        @Override
        public Pull setOauthToken(java.lang.String oauthToken) {
          return (Pull) super.setOauthToken(oauthToken);
        }

        @Override
        public Pull setPp(java.lang.Boolean pp) {
          return (Pull) super.setPp(pp);
        }

        @Override
        public Pull setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Pull) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Pull setQuotaUser(java.lang.String quotaUser) {
          return (Pull) super.setQuotaUser(quotaUser);
        }

        @Override
        public Pull setUploadType(java.lang.String uploadType) {
          return (Pull) super.setUploadType(uploadType);
        }

        @Override
        public Pull setUploadProtocol(java.lang.String uploadProtocol) {
          return (Pull) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The subscription from which messages should be pulled. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String subscription;

        /** The subscription from which messages should be pulled. Format is
       `projects/{project}/subscriptions/{sub}`.
         */
        public java.lang.String getSubscription() {
          return subscription;
        }

        /**
         * The subscription from which messages should be pulled. Format is
         * `projects/{project}/subscriptions/{sub}`.
         */
        public Pull setSubscription(java.lang.String subscription) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(SUBSCRIPTION_PATTERN.matcher(subscription).matches(),
                "Parameter subscription must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.subscription = subscription;
          return this;
        }

        @Override
        public Pull set(String parameterName, Object value) {
          return (Pull) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "subscriptions.setIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy.
         *
         * Create a request for the method "subscriptions.setIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (SetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPp(java.lang.Boolean pp) {
          return (SetIamPolicy) super.setPp(pp);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a NOT_FOUND error.
       *
       * Note: This operation is designed to be used for building permission-aware UIs and command-line
       * tools, not for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "subscriptions.testIamPermissions".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
       * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends PubsubRequest<com.google.api.services.pubsub.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a NOT_FOUND error.
         *
         * Note: This operation is designed to be used for building permission-aware UIs and command-line
         * tools, not for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "subscriptions.testIamPermissions".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setBearerToken(java.lang.String bearerToken) {
          return (TestIamPermissions) super.setBearerToken(bearerToken);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPp(java.lang.Boolean pp) {
          return (TestIamPermissions) super.setPp(pp);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See the operation
       documentation for the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/subscriptions/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Topics collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Pubsub pubsub = new Pubsub(...);}
     *   {@code Pubsub.Topics.List request = pubsub.topics().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Topics topics() {
      return new Topics();
    }

    /**
     * The "topics" collection of methods.
     */
    public class Topics {

      /**
       * Creates the given topic with the given name.
       *
       * Create a request for the method "topics.create".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param name The name of the topic. It must have the format
      `"projects/{project}/topics/{topic}"`. `{topic}` must
       *        start with a letter,
      and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes
       *        (`-`),
      underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
      signs (`%`).
       *        It must be between 3 and 255 characters in length, and it
      must not start with `"goog"`.
       * @param content the {@link com.google.api.services.pubsub.model.Topic}
       * @return the request
       */
      public Create create(java.lang.String name, com.google.api.services.pubsub.model.Topic content) throws java.io.IOException {
        Create result = new Create(name, content);
        initialize(result);
        return result;
      }

      public class Create extends PubsubRequest<com.google.api.services.pubsub.model.Topic> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Creates the given topic with the given name.
         *
         * Create a request for the method "topics.create".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the topic. It must have the format
      `"projects/{project}/topics/{topic}"`. `{topic}` must
       *        start with a letter,
      and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes
       *        (`-`),
      underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
      signs (`%`).
       *        It must be between 3 and 255 characters in length, and it
      must not start with `"goog"`.
         * @param content the {@link com.google.api.services.pubsub.model.Topic}
         * @since 1.13
         */
        protected Create(java.lang.String name, com.google.api.services.pubsub.model.Topic content) {
          super(Pubsub.this, "PUT", REST_PATH, content, com.google.api.services.pubsub.model.Topic.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setBearerToken(java.lang.String bearerToken) {
          return (Create) super.setBearerToken(bearerToken);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPp(java.lang.Boolean pp) {
          return (Create) super.setPp(pp);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
         * `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers
         * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or
         * percent signs (`%`). It must be between 3 and 255 characters in length, and it must not
         * start with `"goog"`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`. `{topic}`
       must start with a letter, and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
       underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent signs (`%`). It must be
       between 3 and 255 characters in length, and it must not start with `"goog"`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name of the topic. It must have the format `"projects/{project}/topics/{topic}"`.
         * `{topic}` must start with a letter, and contain only letters (`[A-Za-z]`), numbers
         * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or
         * percent signs (`%`). It must be between 3 and 255 characters in length, and it must not
         * start with `"goog"`.
         */
        public Create setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes the topic with the given name. Returns `NOT_FOUND` if the topic does not exist. After a
       * topic is deleted, a new topic may be created with the same name; this is an entirely new topic
       * with none of the old configuration or subscriptions. Existing subscriptions to this topic are not
       * deleted, but their `topic` field is set to `_deleted-topic_`.
       *
       * Create a request for the method "topics.delete".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param topic Name of the topic to delete.
      Format is `projects/{project}/topics/{topic}`.
       * @return the request
       */
      public Delete delete(java.lang.String topic) throws java.io.IOException {
        Delete result = new Delete(topic);
        initialize(result);
        return result;
      }

      public class Delete extends PubsubRequest<com.google.api.services.pubsub.model.Empty> {

        private static final String REST_PATH = "v1/{+topic}";

        private final java.util.regex.Pattern TOPIC_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Deletes the topic with the given name. Returns `NOT_FOUND` if the topic does not exist. After a
         * topic is deleted, a new topic may be created with the same name; this is an entirely new topic
         * with none of the old configuration or subscriptions. Existing subscriptions to this topic are
         * not deleted, but their `topic` field is set to `_deleted-topic_`.
         *
         * Create a request for the method "topics.delete".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param topic Name of the topic to delete.
      Format is `projects/{project}/topics/{topic}`.
         * @since 1.13
         */
        protected Delete(java.lang.String topic) {
          super(Pubsub.this, "DELETE", REST_PATH, null, com.google.api.services.pubsub.model.Empty.class);
          this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setBearerToken(java.lang.String bearerToken) {
          return (Delete) super.setBearerToken(bearerToken);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPp(java.lang.Boolean pp) {
          return (Delete) super.setPp(pp);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String topic;

        /** Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
         */
        public java.lang.String getTopic() {
          return topic;
        }

        /**
         * Name of the topic to delete. Format is `projects/{project}/topics/{topic}`.
         */
        public Delete setTopic(java.lang.String topic) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.topic = topic;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets the configuration of a topic.
       *
       * Create a request for the method "topics.get".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param topic The name of the topic to get.
      Format is `projects/{project}/topics/{topic}`.
       * @return the request
       */
      public Get get(java.lang.String topic) throws java.io.IOException {
        Get result = new Get(topic);
        initialize(result);
        return result;
      }

      public class Get extends PubsubRequest<com.google.api.services.pubsub.model.Topic> {

        private static final String REST_PATH = "v1/{+topic}";

        private final java.util.regex.Pattern TOPIC_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Gets the configuration of a topic.
         *
         * Create a request for the method "topics.get".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param topic The name of the topic to get.
      Format is `projects/{project}/topics/{topic}`.
         * @since 1.13
         */
        protected Get(java.lang.String topic) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Topic.class);
          this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setBearerToken(java.lang.String bearerToken) {
          return (Get) super.setBearerToken(bearerToken);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPp(java.lang.Boolean pp) {
          return (Get) super.setPp(pp);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String topic;

        /** The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
         */
        public java.lang.String getTopic() {
          return topic;
        }

        /**
         * The name of the topic to get. Format is `projects/{project}/topics/{topic}`.
         */
        public Get setTopic(java.lang.String topic) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.topic = topic;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
       * does not have a policy set.
       *
       * Create a request for the method "topics.getIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
       * @return the request
       */
      public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
        GetIamPolicy result = new GetIamPolicy(resource);
        initialize(result);
        return result;
      }

      public class GetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists
         * and does not have a policy set.
         *
         * Create a request for the method "topics.getIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for
       *        the appropriate value for this field.
         * @since 1.13
         */
        protected GetIamPolicy(java.lang.String resource) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (GetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (GetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public GetIamPolicy setAlt(java.lang.String alt) {
          return (GetIamPolicy) super.setAlt(alt);
        }

        @Override
        public GetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (GetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public GetIamPolicy setCallback(java.lang.String callback) {
          return (GetIamPolicy) super.setCallback(callback);
        }

        @Override
        public GetIamPolicy setFields(java.lang.String fields) {
          return (GetIamPolicy) super.setFields(fields);
        }

        @Override
        public GetIamPolicy setKey(java.lang.String key) {
          return (GetIamPolicy) super.setKey(key);
        }

        @Override
        public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (GetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public GetIamPolicy setPp(java.lang.Boolean pp) {
          return (GetIamPolicy) super.setPp(pp);
        }

        @Override
        public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (GetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetIamPolicy setUploadType(java.lang.String uploadType) {
          return (GetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public GetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public GetIamPolicy set(String parameterName, Object value) {
          return (GetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Lists matching topics.
       *
       * Create a request for the method "topics.list".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param project The name of the cloud project that topics belong to.
      Format is `projects/{project}`.
       * @return the request
       */
      public List list(java.lang.String project) throws java.io.IOException {
        List result = new List(project);
        initialize(result);
        return result;
      }

      public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListTopicsResponse> {

        private static final String REST_PATH = "v1/{+project}/topics";

        private final java.util.regex.Pattern PROJECT_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists matching topics.
         *
         * Create a request for the method "topics.list".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param project The name of the cloud project that topics belong to.
      Format is `projects/{project}`.
         * @since 1.13
         */
        protected List(java.lang.String project) {
          super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListTopicsResponse.class);
          this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setBearerToken(java.lang.String bearerToken) {
          return (List) super.setBearerToken(bearerToken);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPp(java.lang.Boolean pp) {
          return (List) super.setPp(pp);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the cloud project that topics belong to. Format is `projects/{project}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String project;

        /** The name of the cloud project that topics belong to. Format is `projects/{project}`.
         */
        public java.lang.String getProject() {
          return project;
        }

        /**
         * The name of the cloud project that topics belong to. Format is `projects/{project}`.
         */
        public List setProject(java.lang.String project) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
                "Parameter project must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.project = project;
          return this;
        }

        /**
         * The value returned by the last `ListTopicsResponse`; indicates that this is a
         * continuation of a prior `ListTopics` call, and that the system should return the next
         * page of data.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The value returned by the last `ListTopicsResponse`; indicates that this is a continuation of a
       prior `ListTopics` call, and that the system should return the next page of data.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The value returned by the last `ListTopicsResponse`; indicates that this is a
         * continuation of a prior `ListTopics` call, and that the system should return the next
         * page of data.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** Maximum number of topics to return. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Maximum number of topics to return.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** Maximum number of topics to return. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic does not exist. The
       * message payload must not be empty; it must contain  either a non-empty data field, or at least
       * one attribute.
       *
       * Create a request for the method "topics.publish".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link Publish#execute()} method to invoke the remote operation.
       *
       * @param topic The messages in the request will be published on this topic.
      Format is
       *        `projects/{project}/topics/{topic}`.
       * @param content the {@link com.google.api.services.pubsub.model.PublishRequest}
       * @return the request
       */
      public Publish publish(java.lang.String topic, com.google.api.services.pubsub.model.PublishRequest content) throws java.io.IOException {
        Publish result = new Publish(topic, content);
        initialize(result);
        return result;
      }

      public class Publish extends PubsubRequest<com.google.api.services.pubsub.model.PublishResponse> {

        private static final String REST_PATH = "v1/{+topic}:publish";

        private final java.util.regex.Pattern TOPIC_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic does not exist. The
         * message payload must not be empty; it must contain  either a non-empty data field, or at least
         * one attribute.
         *
         * Create a request for the method "topics.publish".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link Publish#execute()} method to invoke the remote operation. <p>
         * {@link
         * Publish#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param topic The messages in the request will be published on this topic.
      Format is
       *        `projects/{project}/topics/{topic}`.
         * @param content the {@link com.google.api.services.pubsub.model.PublishRequest}
         * @since 1.13
         */
        protected Publish(java.lang.String topic, com.google.api.services.pubsub.model.PublishRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.PublishResponse.class);
          this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public Publish set$Xgafv(java.lang.String $Xgafv) {
          return (Publish) super.set$Xgafv($Xgafv);
        }

        @Override
        public Publish setAccessToken(java.lang.String accessToken) {
          return (Publish) super.setAccessToken(accessToken);
        }

        @Override
        public Publish setAlt(java.lang.String alt) {
          return (Publish) super.setAlt(alt);
        }

        @Override
        public Publish setBearerToken(java.lang.String bearerToken) {
          return (Publish) super.setBearerToken(bearerToken);
        }

        @Override
        public Publish setCallback(java.lang.String callback) {
          return (Publish) super.setCallback(callback);
        }

        @Override
        public Publish setFields(java.lang.String fields) {
          return (Publish) super.setFields(fields);
        }

        @Override
        public Publish setKey(java.lang.String key) {
          return (Publish) super.setKey(key);
        }

        @Override
        public Publish setOauthToken(java.lang.String oauthToken) {
          return (Publish) super.setOauthToken(oauthToken);
        }

        @Override
        public Publish setPp(java.lang.Boolean pp) {
          return (Publish) super.setPp(pp);
        }

        @Override
        public Publish setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Publish) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Publish setQuotaUser(java.lang.String quotaUser) {
          return (Publish) super.setQuotaUser(quotaUser);
        }

        @Override
        public Publish setUploadType(java.lang.String uploadType) {
          return (Publish) super.setUploadType(uploadType);
        }

        @Override
        public Publish setUploadProtocol(java.lang.String uploadProtocol) {
          return (Publish) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The messages in the request will be published on this topic. Format is
         * `projects/{project}/topics/{topic}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String topic;

        /** The messages in the request will be published on this topic. Format is
       `projects/{project}/topics/{topic}`.
         */
        public java.lang.String getTopic() {
          return topic;
        }

        /**
         * The messages in the request will be published on this topic. Format is
         * `projects/{project}/topics/{topic}`.
         */
        public Publish setTopic(java.lang.String topic) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                "Parameter topic must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.topic = topic;
          return this;
        }

        @Override
        public Publish set(String parameterName, Object value) {
          return (Publish) super.set(parameterName, value);
        }
      }
      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "topics.setIamPolicy".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
       * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
       * @return the request
       */
      public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) throws java.io.IOException {
        SetIamPolicy result = new SetIamPolicy(resource, content);
        initialize(result);
        return result;
      }

      public class SetIamPolicy extends PubsubRequest<com.google.api.services.pubsub.model.Policy> {

        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy.
         *
         * Create a request for the method "topics.setIamPolicy".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
         * {@link
         * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for
       *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.pubsub.model.SetIamPolicyRequest}
         * @since 1.13
         */
        protected SetIamPolicy(java.lang.String resource, com.google.api.services.pubsub.model.SetIamPolicyRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.Policy.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
          return (SetIamPolicy) super.set$Xgafv($Xgafv);
        }

        @Override
        public SetIamPolicy setAccessToken(java.lang.String accessToken) {
          return (SetIamPolicy) super.setAccessToken(accessToken);
        }

        @Override
        public SetIamPolicy setAlt(java.lang.String alt) {
          return (SetIamPolicy) super.setAlt(alt);
        }

        @Override
        public SetIamPolicy setBearerToken(java.lang.String bearerToken) {
          return (SetIamPolicy) super.setBearerToken(bearerToken);
        }

        @Override
        public SetIamPolicy setCallback(java.lang.String callback) {
          return (SetIamPolicy) super.setCallback(callback);
        }

        @Override
        public SetIamPolicy setFields(java.lang.String fields) {
          return (SetIamPolicy) super.setFields(fields);
        }

        @Override
        public SetIamPolicy setKey(java.lang.String key) {
          return (SetIamPolicy) super.setKey(key);
        }

        @Override
        public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
          return (SetIamPolicy) super.setOauthToken(oauthToken);
        }

        @Override
        public SetIamPolicy setPp(java.lang.Boolean pp) {
          return (SetIamPolicy) super.setPp(pp);
        }

        @Override
        public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
          return (SetIamPolicy) super.setQuotaUser(quotaUser);
        }

        @Override
        public SetIamPolicy setUploadType(java.lang.String uploadType) {
          return (SetIamPolicy) super.setUploadType(uploadType);
        }

        @Override
        public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
          return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
       the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy is being specified. See the operation
         * documentation for the appropriate value for this field.
         */
        public SetIamPolicy setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public SetIamPolicy set(String parameterName, Object value) {
          return (SetIamPolicy) super.set(parameterName, value);
        }
      }
      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not exist,
       * this will return an empty set of permissions, not a NOT_FOUND error.
       *
       * Note: This operation is designed to be used for building permission-aware UIs and command-line
       * tools, not for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "topics.testIamPermissions".
       *
       * This request holds the parameters needed by the pubsub server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
       * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
       * @return the request
       */
      public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) throws java.io.IOException {
        TestIamPermissions result = new TestIamPermissions(resource, content);
        initialize(result);
        return result;
      }

      public class TestIamPermissions extends PubsubRequest<com.google.api.services.pubsub.model.TestIamPermissionsResponse> {

        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

        private final java.util.regex.Pattern RESOURCE_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not
         * exist, this will return an empty set of permissions, not a NOT_FOUND error.
         *
         * Note: This operation is designed to be used for building permission-aware UIs and command-line
         * tools, not for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "topics.testIamPermissions".
         *
         * This request holds the parameters needed by the the pubsub server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
         * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
         * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested.
      See the operation
       *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.pubsub.model.TestIamPermissionsRequest}
         * @since 1.13
         */
        protected TestIamPermissions(java.lang.String resource, com.google.api.services.pubsub.model.TestIamPermissionsRequest content) {
          super(Pubsub.this, "POST", REST_PATH, content, com.google.api.services.pubsub.model.TestIamPermissionsResponse.class);
          this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
        }

        @Override
        public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
          return (TestIamPermissions) super.set$Xgafv($Xgafv);
        }

        @Override
        public TestIamPermissions setAccessToken(java.lang.String accessToken) {
          return (TestIamPermissions) super.setAccessToken(accessToken);
        }

        @Override
        public TestIamPermissions setAlt(java.lang.String alt) {
          return (TestIamPermissions) super.setAlt(alt);
        }

        @Override
        public TestIamPermissions setBearerToken(java.lang.String bearerToken) {
          return (TestIamPermissions) super.setBearerToken(bearerToken);
        }

        @Override
        public TestIamPermissions setCallback(java.lang.String callback) {
          return (TestIamPermissions) super.setCallback(callback);
        }

        @Override
        public TestIamPermissions setFields(java.lang.String fields) {
          return (TestIamPermissions) super.setFields(fields);
        }

        @Override
        public TestIamPermissions setKey(java.lang.String key) {
          return (TestIamPermissions) super.setKey(key);
        }

        @Override
        public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
          return (TestIamPermissions) super.setOauthToken(oauthToken);
        }

        @Override
        public TestIamPermissions setPp(java.lang.Boolean pp) {
          return (TestIamPermissions) super.setPp(pp);
        }

        @Override
        public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
          return (TestIamPermissions) super.setQuotaUser(quotaUser);
        }

        @Override
        public TestIamPermissions setUploadType(java.lang.String uploadType) {
          return (TestIamPermissions) super.setUploadType(uploadType);
        }

        @Override
        public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
          return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        @com.google.api.client.util.Key
        private java.lang.String resource;

        /** REQUIRED: The resource for which the policy detail is being requested. See the operation
       documentation for the appropriate value for this field.
         */
        public java.lang.String getResource() {
          return resource;
        }

        /**
         * REQUIRED: The resource for which the policy detail is being requested. See the operation
         * documentation for the appropriate value for this field.
         */
        public TestIamPermissions setResource(java.lang.String resource) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                "Parameter resource must conform to the pattern " +
                "^projects/[^/]+/topics/[^/]+$");
          }
          this.resource = resource;
          return this;
        }

        @Override
        public TestIamPermissions set(String parameterName, Object value) {
          return (TestIamPermissions) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Subscriptions collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Pubsub pubsub = new Pubsub(...);}
       *   {@code Pubsub.Subscriptions.List request = pubsub.subscriptions().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Subscriptions subscriptions() {
        return new Subscriptions();
      }

      /**
       * The "subscriptions" collection of methods.
       */
      public class Subscriptions {

        /**
         * Lists the name of the subscriptions for this topic.
         *
         * Create a request for the method "subscriptions.list".
         *
         * This request holds the parameters needed by the pubsub server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param topic The name of the topic that subscriptions are attached to.
        Format is
         *        `projects/{project}/topics/{topic}`.
         * @return the request
         */
        public List list(java.lang.String topic) throws java.io.IOException {
          List result = new List(topic);
          initialize(result);
          return result;
        }

        public class List extends PubsubRequest<com.google.api.services.pubsub.model.ListTopicSubscriptionsResponse> {

          private static final String REST_PATH = "v1/{+topic}/subscriptions";

          private final java.util.regex.Pattern TOPIC_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/topics/[^/]+$");

          /**
           * Lists the name of the subscriptions for this topic.
           *
           * Create a request for the method "subscriptions.list".
           *
           * This request holds the parameters needed by the the pubsub server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param topic The name of the topic that subscriptions are attached to.
        Format is
         *        `projects/{project}/topics/{topic}`.
           * @since 1.13
           */
          protected List(java.lang.String topic) {
            super(Pubsub.this, "GET", REST_PATH, null, com.google.api.services.pubsub.model.ListTopicSubscriptionsResponse.class);
            this.topic = com.google.api.client.util.Preconditions.checkNotNull(topic, "Required parameter topic must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                  "Parameter topic must conform to the pattern " +
                  "^projects/[^/]+/topics/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setBearerToken(java.lang.String bearerToken) {
            return (List) super.setBearerToken(bearerToken);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPp(java.lang.Boolean pp) {
            return (List) super.setPp(pp);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name of the topic that subscriptions are attached to. Format is
           * `projects/{project}/topics/{topic}`.
           */
          @com.google.api.client.util.Key
          private java.lang.String topic;

          /** The name of the topic that subscriptions are attached to. Format is
         `projects/{project}/topics/{topic}`.
           */
          public java.lang.String getTopic() {
            return topic;
          }

          /**
           * The name of the topic that subscriptions are attached to. Format is
           * `projects/{project}/topics/{topic}`.
           */
          public List setTopic(java.lang.String topic) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(),
                  "Parameter topic must conform to the pattern " +
                  "^projects/[^/]+/topics/[^/]+$");
            }
            this.topic = topic;
            return this;
          }

          /**
           * The value returned by the last `ListTopicSubscriptionsResponse`; indicates that this is
           * a continuation of a prior `ListTopicSubscriptions` call, and that the system should
           * return the next page of data.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The value returned by the last `ListTopicSubscriptionsResponse`; indicates that this is a
         continuation of a prior `ListTopicSubscriptions` call, and that the system should return the next
         page of data.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * The value returned by the last `ListTopicSubscriptionsResponse`; indicates that this is
           * a continuation of a prior `ListTopicSubscriptions` call, and that the system should
           * return the next page of data.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** Maximum number of subscription names to return. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum number of subscription names to return.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum number of subscription names to return. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link Pubsub}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Pubsub}. */
    @Override
    public Pubsub build() {
      return new Pubsub(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link PubsubRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setPubsubRequestInitializer(
        PubsubRequestInitializer pubsubRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(pubsubRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
